/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ebpm.connectors.ftp;

import java.io.FileFilter;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Date;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.ebpm.connectors.ftp.FTPClientPool;
import org.eclipse.ebpm.connectors.ftp.FtpParameters;
import org.eclipse.ebpm.connectors.ftp.IFtpReader;
import org.eclipse.ebpm.connectors.ftp.PollingTask;
import org.eclipse.ebpm.connectors.ftp.marshaler.FileMarshaler;
import org.eclipse.ebpm.core.AbstractSpagicConnector;
import org.eclipse.ebpm.messaging.api.Exchange;
import org.eclipse.ebpm.messaging.api.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FtpPollerComponent
extends AbstractSpagicConnector
implements IFtpReader {
    protected Logger log = LoggerFactory.getLogger(FtpPollerComponent.class);
    public static final String PROPERTY_PASSIVEMODE = "passiveMode";
    public static final String PROPERTY_PERIOD = "period";
    private FtpParameters ftpParams;
    private Timer timerService;
    private PollingTask task;
    private FileFilter filter;
    private ConcurrentHashMap<String, FileMarshaler> marshalers = new ConcurrentHashMap();
    private String marshalerId;

    public void init() {
        this.ftpParams = new FtpParameters();
        FTPClientPool clientPool = null;
        this.marshalerId = this.propertyConfigurator.getString("marshaler", null);
        try {
            clientPool = this.createClientPool();
            clientPool.setBinaryMode(this.propertyConfigurator.getBoolean("binaryMode", Boolean.valueOf(true)));
            clientPool.setUsername(this.propertyConfigurator.getString("username", "anonymous"));
            clientPool.setPassword(this.propertyConfigurator.getString("password", null));
            if (this.propertyConfigurator.getBoolean(PROPERTY_PASSIVEMODE, null) != null) {
                clientPool.setPassiveMode(this.propertyConfigurator.getBoolean(PROPERTY_PASSIVEMODE));
            }
            clientPool.setHost(this.propertyConfigurator.getString("host"));
            clientPool.setPort(this.propertyConfigurator.getInteger("port", Integer.valueOf(21)));
            this.setClientPool(clientPool);
        }
        catch (Exception e) {
            this.log.error("Error creating FTPClientPool", (Throwable)e);
        }
        this.setDeleteFile(this.propertyConfigurator.getBoolean("deleteFile", Boolean.valueOf(true)));
        this.setRecursive(this.propertyConfigurator.getBoolean("recursive", Boolean.valueOf(true)));
        this.setChangeWorkingDirectory(this.propertyConfigurator.getBoolean("changeWorkingDirectory"));
        try {
            URI uri = this.createUri(clientPool, this.propertyConfigurator.getString("folder", ""));
            this.setUri(uri);
        }
        catch (URISyntaxException e) {
            this.log.error("Error creating URI", (Throwable)e);
        }
        this.setStateless(this.propertyConfigurator.getBoolean("stateless", Boolean.valueOf(true)));
        this.setPeriod(this.propertyConfigurator.getLong(PROPERTY_PERIOD, new Long(10000L)));
    }

    public void setMarshaler(FileMarshaler marshaler) {
        this.marshalers.put(marshaler.getMarshalerId(), marshaler);
    }

    public void unsetMarshaler(FileMarshaler marshaler) {
        this.marshalers.remove(marshaler.getMarshalerId());
    }

    private URI createUri(FTPClientPool clientPool, String folder) throws URISyntaxException {
        if (clientPool.getUsername().equalsIgnoreCase("anonymous")) {
            clientPool.setPassword("anonymous@anonymous.com");
        }
        String ftpUri = "ftp://" + clientPool.getUsername() + (clientPool.getPassword() != null ? ":" + clientPool.getPassword() : "") + "@" + clientPool.getHost() + ":" + clientPool.getPort() + "/" + folder;
        URI uri = new URI(ftpUri);
        return uri;
    }

    public void start() throws Exception {
        super.start();
        this.timerService = new Timer();
        this.task = new PollingTask(this, this.target);
        this.timerService.schedule((TimerTask)this.task, new Date(), this.getPeriod());
    }

    public void stop() throws Exception {
        super.stop();
        this.timerService.cancel();
        this.timerService = null;
    }

    @Override
    public FTPClientPool getClientPool() {
        return this.ftpParams.clientPool;
    }

    public void setClientPool(FTPClientPool clientPool) {
        this.ftpParams.clientPool = clientPool;
    }

    public long getPeriod() {
        return this.ftpParams.period;
    }

    public void setPeriod(long period) {
        this.ftpParams.period = period;
    }

    public URI getUri() {
        return this.ftpParams.uri;
    }

    public void setUri(URI uri) {
        this.ftpParams.uri = uri;
    }

    @Override
    public String getWorkingPath() {
        return this.ftpParams.uri != null && this.ftpParams.uri.getPath() != null ? this.ftpParams.uri.getPath() : ".";
    }

    @Override
    public FileFilter getFilter() {
        return this.filter;
    }

    public void setFilter(FileFilter filter) {
        this.filter = filter;
    }

    @Override
    public boolean isDeleteFile() {
        return this.ftpParams.deleteFile;
    }

    public void setDeleteFile(boolean deleteFile) {
        this.ftpParams.deleteFile = deleteFile;
    }

    @Override
    public boolean isRecursive() {
        return this.ftpParams.recursive;
    }

    public void setRecursive(boolean recursive) {
        this.ftpParams.recursive = recursive;
    }

    @Override
    public FileMarshaler getMarshaler() {
        boolean hasDefaultMarshaler = true;
        this.log.info(" Marshaller Dependencies inside :" + this.marshalers.size());
        Set keys = this.marshalers.keySet();
        for (String m : keys) {
            this.log.info(" Marshaller name : " + m);
        }
        if (!this.marshalers.containsKey("DEFAULT")) {
            this.log.warn("Default Marshaler not found");
            hasDefaultMarshaler = false;
        }
        if (this.marshalerId == null) {
            if (hasDefaultMarshaler) {
                this.log.info("Using Default Marshaler");
                return this.marshalers.get("DEFAULT");
            }
            return null;
        }
        if (!this.marshalers.containsKey(this.marshalerId)) {
            this.log.warn("Marshaler not found: it's not possible to poll, now .");
            return null;
        }
        return this.marshalers.get(this.marshalerId);
    }

    public void setChangeWorkingDirectory(boolean changeWorkingDirectory) {
        this.ftpParams.changeWorkingDirectory = changeWorkingDirectory;
    }

    @Override
    public boolean isChangeWorkingDirectory() {
        return this.ftpParams.changeWorkingDirectory;
    }

    @Override
    public boolean isStateless() {
        return false;
    }

    public void setStateless(boolean stateless) {
        this.ftpParams.stateless = stateless;
    }

    public String getLocationURI() {
        return this.getUri().toString();
    }

    public void process(Exchange exchange) {
        try {
            this.task.process(exchange);
        }
        catch (Exception e) {
            this.log.error("Error ", (Throwable)e);
        }
    }

    protected FTPClientPool createClientPool() throws Exception {
        FTPClientPool pool = new FTPClientPool();
        pool.afterPropertiesSet();
        return pool;
    }

    @Override
    public Exchange getFtpExchange() {
        return this.createInOnlyExchange();
    }

    @Override
    public Message getMessage(Exchange exchange) {
        Message message = exchange.getIn(true);
        return message;
    }

    @Override
    public void sendFtpExchange(Exchange exchange) {
        this.log.debug("Sending message ");
        this.send(exchange);
    }
}

