/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ebpm.graph.util;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.ebpm.graph.util.GraphNode;
import org.eclipse.ebpm.graph.util.IGraph;
import org.eclipse.ebpm.graph.util.Transition;

public class EBPMGraph
implements IGraph {
    private String graphId = null;
    private List<GraphNode> nodes = null;
    private List<Transition> transitions = null;

    public EBPMGraph(String graphId) {
        this(graphId, new ArrayList<GraphNode>(), new ArrayList<Transition>());
    }

    public EBPMGraph(String graphId, List<GraphNode> nodes, List<Transition> transitions) {
        this.graphId = graphId;
        this.nodes = nodes;
        this.transitions = transitions;
    }

    @Override
    public String getGraphId() {
        return this.graphId;
    }

    @Override
    public void setGraphId(String graphId) {
        this.graphId = graphId;
    }

    @Override
    public void addNode(GraphNode graphNode) {
        this.nodes.add(graphNode);
    }

    @Override
    public void addTransition(Transition transition) {
        this.transitions.add(transition);
    }

    @Override
    public List<GraphNode> getNodes() {
        return this.nodes;
    }

    @Override
    public void setNodes(List<GraphNode> nodes) {
        this.nodes = nodes;
    }

    @Override
    public List<Transition> getTransitions() {
        return this.transitions;
    }

    @Override
    public void setTransitions(List<Transition> transitions) {
        this.transitions = transitions;
    }

    public String toString() {
        StringBuffer dotSource = new StringBuffer();
        dotSource.append("digraph " + this.getGraphId() + " {\n");
        for (GraphNode n : this.nodes) {
            dotSource.append(n.toString());
            dotSource.append("\n");
        }
        for (Transition t : this.transitions) {
            dotSource.append(t.toString());
            dotSource.append("\n");
        }
        dotSource.append("}");
        return dotSource.toString();
    }
}

