/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ebpm.dirwatcher;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.eclipse.ebpm.constants.SpagicConstants;
import org.eclipse.ebpm.core.SpagicNode;
import org.eclipse.ebpm.deployer.IDeploymentService;
import org.eclipse.ebpm.dirwatcher.DirectoryPoller;
import org.eclipse.ebpm.dirwatcher.GenericDeploymentDescriptor;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirWatcherService {
    protected Logger logger = LoggerFactory.getLogger(DirWatcherService.class);
    private ConcurrentHashMap<String, String> servicesFileToIdMap = new ConcurrentHashMap();
    private ConcurrentHashMap<String, String> connectorsFileToIdMap = new ConcurrentHashMap();
    private ConcurrentHashMap<String, String> datasourcesFileToIdMap = new ConcurrentHashMap();
    private ConcurrentHashMap<String, String> connectionFactoriesFileToIdMap = new ConcurrentHashMap();
    private ConcurrentHashMap<String, List<String>> routesForFileMap = new ConcurrentHashMap();

    public void deployAdminService(IDeploymentService deploymentService, URL url, Element nodeSSL, Element adminElement) {
        try {
            SAXReader saxReader = new SAXReader();
            Document xmlDescriptor = null;
            xmlDescriptor = saxReader.read(url);
            String enableSSLOnServiceString = "false";
            boolean enableSSLOnService = false;
            String locURI = null;
            GenericDeploymentDescriptor cd = new GenericDeploymentDescriptor(xmlDescriptor);
            enableSSLOnServiceString = adminElement.attributeValue("ssl");
            if (enableSSLOnServiceString != null && enableSSLOnServiceString.trim().length() > 0) {
                enableSSLOnService = Boolean.valueOf(enableSSLOnServiceString);
            }
            locURI = enableSSLOnService ? "https://" + SpagicNode.host() + ":" + nodeSSL.attributeValue("port") + adminElement.attributeValue("ctx") + "/" : "http://" + SpagicNode.host() + ":" + SpagicNode.adminPort() + adminElement.attributeValue("ctx") + "/";
            cd.getProperties().put("locationURI", locURI);
            cd.getProperties().put("isSSL", enableSSLOnServiceString);
            cd.getProperties().put("clientAuthentication", nodeSSL.attributeValue("clientAuthentication"));
            cd.getProperties().put("truststore", nodeSSL.attributeValue("truststore"));
            cd.getProperties().put("truststorePassword", nodeSSL.attributeValue("truststorePassword"));
            cd.getProperties().put("truststoreType", nodeSSL.attributeValue("truststoreType"));
            cd.getProperties().put("keystore", nodeSSL.attributeValue("keystore"));
            cd.getProperties().put("keystorePassword", nodeSSL.attributeValue("keystorePassword"));
            cd.getProperties().put("keystoreType", nodeSSL.attributeValue("keystoreType"));
            deploymentService.deployConnector(cd.getSpagicId(), cd.getFactoryName(), cd.getProperties());
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
    }

    protected void deploySpagicAdminServices(IDeploymentService deploymentService, BundleContext bundleCtx) {
        try {
            Bundle aBundle = bundleCtx.getBundle();
            String nodeSSLConfig = System.getProperty("node_ssl_config");
            String nodeAdminServiceConfig = System.getProperty("node_admin_services_config");
            Document sslDoc = DocumentHelper.parseText((String)nodeSSLConfig);
            Document nodeAdminServiceDoc = DocumentHelper.parseText((String)nodeAdminServiceConfig);
            Element nodeSSL = sslDoc.getRootElement();
            Element nodeAdminServices = nodeAdminServiceDoc.getRootElement();
            List adminServiceElements = nodeAdminServices.elements();
            URL url = null;
            for (Element aAdminElement : adminServiceElements) {
                this.logger.info("Dynamically Deploying [" + aAdminElement.getName() + "]");
                url = aBundle.getEntry("/admin_services/" + aAdminElement.getName() + ".connector");
                this.deployAdminService(deploymentService, url, nodeSSL, aAdminElement);
            }
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
    }

    protected void activate(ComponentContext componentContext) {
        final IDeploymentService deploymentService = (IDeploymentService)componentContext.locateService("deploymentService");
        String spagicHome = System.getProperty("spagic.home");
        if (spagicHome == null) {
            this.logger.warn(" Spagic HOME NOT SETTED ");
            return;
        }
        String servicesHome = String.valueOf(spagicHome) + File.separator + "services";
        String connectorsHome = String.valueOf(spagicHome) + File.separator + "connectors";
        String dsHome = String.valueOf(spagicHome) + File.separator + "datasources";
        String cfHome = String.valueOf(spagicHome) + File.separator + "connectionfactories";
        String routesHome = String.valueOf(spagicHome) + File.separator + "routes";
        this.deploySpagicAdminServices(deploymentService, componentContext.getBundleContext());
        DirectoryPoller servicePollingTask = new DirectoryPoller(servicesHome, SpagicConstants.SERVICE_DEPLOYMENTS_EXTENSIONS){

            @Override
            public void fireEvent(File file, String action) {
                try {
                    String filePath = file.getCanonicalPath();
                    DirWatcherService.this.logger.info("DirWatcher Service File [" + filePath + "] --> Action [" + action + "]");
                    if (action.equalsIgnoreCase("delete")) {
                        String spagicId = (String)DirWatcherService.this.servicesFileToIdMap.get(filePath);
                        if (spagicId != null) {
                            DirWatcherService.this.logger.warn("DirWatcher -> No component deployed for this file");
                            deploymentService.undeployService(spagicId);
                        }
                        DirWatcherService.this.servicesFileToIdMap.remove(filePath);
                    } else if (action.equalsIgnoreCase("add")) {
                        SAXReader reader = new SAXReader();
                        Document doc = reader.read(file);
                        GenericDeploymentDescriptor cd = new GenericDeploymentDescriptor(doc);
                        deploymentService.deployService(cd.getSpagicId(), cd.getFactoryName(), cd.getProperties());
                        DirWatcherService.this.servicesFileToIdMap.put(filePath, cd.getSpagicId());
                    } else if (action.equalsIgnoreCase("modify")) {
                        SAXReader reader = new SAXReader();
                        Document doc = reader.read(file);
                        GenericDeploymentDescriptor cd = new GenericDeploymentDescriptor(doc);
                        deploymentService.undeployService(cd.getSpagicId());
                        deploymentService.deployService(cd.getSpagicId(), cd.getFactoryName(), cd.getProperties());
                    } else {
                        DirWatcherService.this.logger.warn("DirWatcher Service action [" + action + "] unknown");
                    }
                }
                catch (Exception e) {
                    DirWatcherService.this.logger.error(e.getMessage(), (Throwable)e);
                }
            }
        };
        DirectoryPoller connectorsPollingTask = new DirectoryPoller(connectorsHome, SpagicConstants.CONNECTOR_DEPLOYMENTS_EXTENSIONS){

            @Override
            public void fireEvent(File file, String action) {
                try {
                    String filePath = file.getCanonicalPath();
                    DirWatcherService.this.logger.info("DirWatcher Connector File [" + filePath + "] --> Action [" + action + "]");
                    if (action.equalsIgnoreCase("delete")) {
                        String spagicId = (String)DirWatcherService.this.connectorsFileToIdMap.get(filePath);
                        if (spagicId != null) {
                            DirWatcherService.this.logger.warn("DirWatcher -> No component deployed for this file");
                            deploymentService.undeployConnector(spagicId);
                        }
                        DirWatcherService.this.connectorsFileToIdMap.remove(filePath);
                    } else if (action.equalsIgnoreCase("add")) {
                        SAXReader reader = new SAXReader();
                        Document doc = reader.read(file);
                        GenericDeploymentDescriptor cd = new GenericDeploymentDescriptor(doc);
                        deploymentService.deployConnector(cd.getSpagicId(), cd.getFactoryName(), cd.getProperties());
                        DirWatcherService.this.connectorsFileToIdMap.put(filePath, cd.getSpagicId());
                    } else if (action.equalsIgnoreCase("modify")) {
                        SAXReader reader = new SAXReader();
                        Document doc = reader.read(file);
                        GenericDeploymentDescriptor cd = new GenericDeploymentDescriptor(doc);
                        deploymentService.undeployConnector(cd.getSpagicId());
                        deploymentService.deployConnector(cd.getSpagicId(), cd.getFactoryName(), cd.getProperties());
                    } else {
                        DirWatcherService.this.logger.warn("DirWatcher Service action [" + action + "] unknown");
                    }
                }
                catch (Exception e) {
                    DirWatcherService.this.logger.error(e.getMessage(), (Throwable)e);
                }
            }
        };
        DirectoryPoller dataSourcesPollingTask = new DirectoryPoller(dsHome, SpagicConstants.DATASOURCE_DEPLOYMENTS_EXTENSIONS){

            @Override
            public void fireEvent(File file, String action) {
                try {
                    String filePath = file.getCanonicalPath();
                    DirWatcherService.this.logger.info("DirWatcher Datasource File [" + filePath + "] --> Action [" + action + "]");
                    if (action.equalsIgnoreCase("delete")) {
                        String dataSourceId = (String)DirWatcherService.this.datasourcesFileToIdMap.get(filePath);
                        if (dataSourceId != null) {
                            DirWatcherService.this.logger.warn("DirWatcher -> No component deployed for this file");
                            deploymentService.undeployDatasource(dataSourceId);
                        }
                        DirWatcherService.this.datasourcesFileToIdMap.remove(filePath);
                    } else if (action.equalsIgnoreCase("add")) {
                        SAXReader reader = new SAXReader();
                        Document doc = reader.read(file);
                        GenericDeploymentDescriptor dsDesc = new GenericDeploymentDescriptor(doc);
                        deploymentService.deployDatasource(dsDesc.getId(), dsDesc.getProperties());
                        DirWatcherService.this.datasourcesFileToIdMap.put(filePath, dsDesc.getId());
                    } else if (action.equalsIgnoreCase("modify")) {
                        DirWatcherService.this.logger.warn("DirWatcher DataSource action [" + action + "] not supported");
                    } else {
                        DirWatcherService.this.logger.warn("DirWatcher DataSource action [" + action + "] unknown");
                    }
                }
                catch (Exception e) {
                    DirWatcherService.this.logger.error(e.getMessage(), (Throwable)e);
                }
            }
        };
        DirectoryPoller connectionFactoriesPollingTask = new DirectoryPoller(cfHome, SpagicConstants.CONNECTIONFACTORY_DEPLOYMENTS_EXTENSIONS){

            @Override
            public void fireEvent(File file, String action) {
                try {
                    String filePath = file.getCanonicalPath();
                    DirWatcherService.this.logger.info("DirWatcher JMS ConnectionFactory File [" + filePath + "] --> Action [" + action + "]");
                    if (action.equalsIgnoreCase("delete")) {
                        String connectionFactoryId = (String)DirWatcherService.this.connectionFactoriesFileToIdMap.get(filePath);
                        if (connectionFactoryId != null) {
                            DirWatcherService.this.logger.warn("DirWatcher -> No component deployed for this file");
                            deploymentService.undeployConnectionFactory(connectionFactoryId);
                        }
                        DirWatcherService.this.connectionFactoriesFileToIdMap.remove(filePath);
                    } else if (action.equalsIgnoreCase("add")) {
                        SAXReader reader = new SAXReader();
                        Document doc = reader.read(file);
                        GenericDeploymentDescriptor depDesc = new GenericDeploymentDescriptor(doc);
                        deploymentService.deployConnectionFactory(depDesc.getId(), depDesc.getFactoryName(), depDesc.getProperties());
                        DirWatcherService.this.connectionFactoriesFileToIdMap.put(filePath, depDesc.getId());
                    } else if (action.equalsIgnoreCase("modify")) {
                        DirWatcherService.this.logger.warn("DirWatcher ConnectionFactory action [" + action + "] not supported");
                    } else {
                        DirWatcherService.this.logger.warn("DirWatcher ConnectionFactory action [" + action + "] unknown");
                    }
                }
                catch (Exception e) {
                    DirWatcherService.this.logger.error(e.getMessage(), (Throwable)e);
                }
            }
        };
        DirectoryPoller routesPollingTask = new DirectoryPoller(routesHome, SpagicConstants.ROUTES_DEPLOYMENTS_EXTENSIONS){

            @Override
            public void fireEvent(File file, String action) {
                try {
                    String filePath = file.getCanonicalPath();
                    DirWatcherService.this.logger.info("DirWatcher Routes File [" + filePath + "] --> Action [" + action + "]");
                    if (action.equalsIgnoreCase("delete")) {
                        List routesForFile = (List)DirWatcherService.this.routesForFileMap.get(filePath);
                        deploymentService.deployRoutes(null, routesForFile);
                        DirWatcherService.this.routesForFileMap.remove(filePath);
                    } else {
                        SAXReader reader = new SAXReader();
                        Document doc = reader.read(file);
                        Element routesElement = doc.getRootElement();
                        List routesNode = routesElement.elements("spagic:route");
                        ArrayList<String> updateRoutesForFile = new ArrayList<String>();
                        Attribute fromAttribute = null;
                        Attribute toAttribute = null;
                        for (Element pn : routesNode) {
                            fromAttribute = pn.attribute("from");
                            toAttribute = pn.attribute("to");
                            updateRoutesForFile.add(String.valueOf(fromAttribute.getValue()) + ";" + toAttribute.getValue());
                        }
                        if (action.equalsIgnoreCase("add")) {
                            deploymentService.deployRoutes(updateRoutesForFile, null);
                        } else if (action.equalsIgnoreCase("modify")) {
                            List oldRoutes = (List)DirWatcherService.this.routesForFileMap.get(filePath);
                            deploymentService.deployRoutes(updateRoutesForFile, oldRoutes);
                        }
                        DirWatcherService.this.routesForFileMap.put(filePath, updateRoutesForFile);
                        DirWatcherService.this.logger.warn("DirWatcher Service action [" + action + "] ");
                    }
                }
                catch (Exception e) {
                    DirWatcherService.this.logger.error(e.getMessage(), (Throwable)e);
                }
            }
        };
        Timer timerService = new Timer();
        timerService.schedule((TimerTask)servicePollingTask, new Date(), 5000L);
        Timer timerConnectors = new Timer();
        timerConnectors.schedule((TimerTask)connectorsPollingTask, new Date(), 5000L);
        Timer timerDataSources = new Timer();
        timerDataSources.schedule((TimerTask)dataSourcesPollingTask, new Date(), 5000L);
        Timer timerConnectionFactories = new Timer();
        timerConnectionFactories.schedule((TimerTask)connectionFactoriesPollingTask, new Date(), 5000L);
        Timer timerRouterService = new Timer();
        timerRouterService.schedule((TimerTask)routesPollingTask, new Date(), 5000L);
    }

    protected void deactivate(ComponentContext componentContext) {
    }
}

