/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ebpm.soap.interceptors.mime;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.util.Properties;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.internet.ContentType;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.eclipse.ebpm.core.ExchangeUtils;
import org.eclipse.ebpm.messaging.api.Exchange;
import org.eclipse.ebpm.soap.api.Fault;
import org.eclipse.ebpm.soap.api.Message;
import org.eclipse.ebpm.soap.core.AbstractInterceptor;

public class AttachmentsInInterceptor
extends AbstractInterceptor {
    public static final String MULTIPART_CONTENT = "multipart/";

    @Override
    public void handleMessage(Message message) {
        String contentType;
        InputStream is = message.getContent(InputStream.class);
        if (is == null) {
            if (message.get("sendFaultsToTarget") != null && ((Boolean)message.get("sendFaultsToTarget")).booleanValue()) {
                Exchange exchange = message.getContent(Exchange.class);
                org.eclipse.ebpm.messaging.api.Message out = exchange.getOut(true);
                out.setBody("<ERROR>" + new String(ExchangeUtils.getStringFromException((Throwable)new NullPointerException("InputStream content not found"))) + "</ERROR>");
                exchange.setOut(out);
            } else {
                throw new NullPointerException("InputStream content not found");
            }
        }
        if ((contentType = (String)message.get("Content-Type")) != null && contentType.toLowerCase().startsWith(MULTIPART_CONTENT)) {
            try {
                Session session = Session.getDefaultInstance((Properties)new Properties());
                is = new SequenceInputStream(new ByteArrayInputStream(new byte[]{13, 10}), is);
                MimeMessage mime = new MimeMessage(session, is);
                mime.setHeader("Content-Type", contentType);
                this.read(message, mime);
            }
            catch (IOException e) {
                if (message.get("sendFaultsToTarget") != null && ((Boolean)message.get("sendFaultsToTarget")).booleanValue()) {
                    Exchange exchange = message.getContent(Exchange.class);
                    org.eclipse.ebpm.messaging.api.Message out = exchange.getOut(true);
                    out.setBody("<ERROR>" + new String(ExchangeUtils.getStringFromException((Throwable)e)) + "</ERROR>");
                    exchange.setOut(out);
                    message.setContent(Exchange.class, exchange);
                    return;
                }
                throw new Fault(e);
            }
            catch (MessagingException e) {
                if (message.get("sendFaultsToTarget") != null && ((Boolean)message.get("sendFaultsToTarget")).booleanValue()) {
                    Exchange exchange = message.getContent(Exchange.class);
                    org.eclipse.ebpm.messaging.api.Message out = exchange.getOut(true);
                    out.setBody("<ERROR>" + new String(ExchangeUtils.getStringFromException((Throwable)e)) + "</ERROR>");
                    exchange.setOut(out);
                    message.setContent(Exchange.class, exchange);
                    return;
                }
                throw new Fault(e);
            }
        }
    }

    public void read(Message message, MimeMessage mime) throws MessagingException, IOException {
        int i;
        Object content = mime.getContent();
        if (!(content instanceof MimeMultipart)) {
            if (message.get("sendFaultsToTarget") != null && ((Boolean)message.get("sendFaultsToTarget")).booleanValue()) {
                Exchange exchange = message.getContent(Exchange.class);
                org.eclipse.ebpm.messaging.api.Message out = exchange.getOut(true);
                out.setBody("<ERROR>" + new String(ExchangeUtils.getStringFromException((Throwable)new UnsupportedOperationException("Expected a javax.mail.internet.MimeMultipart object but found a " + content.getClass()))) + "</ERROR>");
                exchange.setOut(out);
                message.setContent(Exchange.class, exchange);
                return;
            }
            throw new UnsupportedOperationException("Expected a javax.mail.internet.MimeMultipart object but found a " + content.getClass());
        }
        MimeMultipart multipart = (MimeMultipart)content;
        ContentType type = new ContentType(mime.getContentType());
        String contentId = type.getParameter("start");
        MimeBodyPart contentPart = null;
        if (contentId != null) {
            contentPart = (MimeBodyPart)multipart.getBodyPart(contentId);
        } else {
            i = 0;
            while (i < multipart.getCount()) {
                MimeBodyPart contentPart2 = (MimeBodyPart)multipart.getBodyPart(i);
                String contentType = contentPart2.getContentType();
                if (contentType.indexOf("xml") >= 0) {
                    contentPart = contentPart2;
                    break;
                }
                ++i;
            }
        }
        message.setContent(InputStream.class, contentPart != null ? contentPart.getInputStream() : null);
        i = 0;
        while (i < multipart.getCount()) {
            MimeBodyPart part = (MimeBodyPart)multipart.getBodyPart(i);
            if (part != contentPart) {
                String id = part.getContentID();
                if (id == null) {
                    id = "Part" + i;
                } else if (id.startsWith("<")) {
                    id = id.substring(1, id.length() - 1);
                }
                message.getAttachments().put(id, part.getDataHandler());
            }
            ++i;
        }
    }
}

