/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ebpm.soap.bindings.soap.interceptors;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.eclipse.ebpm.soap.api.Fault;
import org.eclipse.ebpm.soap.api.InterceptorChain;
import org.eclipse.ebpm.soap.api.Message;
import org.eclipse.ebpm.soap.bindings.soap.SoapVersion;
import org.eclipse.ebpm.soap.core.AbstractInterceptor;
import org.eclipse.ebpm.soap.util.DomUtil;
import org.eclipse.ebpm.soap.util.stax.DOMStreamReader;
import org.eclipse.ebpm.soap.util.stax.StaxUtil;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;

public class SoapOutInterceptor
extends AbstractInterceptor {
    private final SoapVersion soapVersion;

    public SoapOutInterceptor() {
        this(null);
    }

    public SoapOutInterceptor(SoapVersion soapVersion) {
        this.soapVersion = soapVersion;
    }

    @Override
    public void handleMessage(Message message) {
        XMLStreamWriter writer = message.getContent(XMLStreamWriter.class);
        if (writer == null) {
            throw new NullPointerException("XMLStreamWriter content not found");
        }
        SoapVersion soapVersion = message.get(SoapVersion.class);
        if (soapVersion == null && (soapVersion = this.soapVersion) == null) {
            throw new IllegalStateException("No soap version specified");
        }
        try {
            StaxUtil.writeStartElement(writer, soapVersion.getEnvelope());
            if (message.getSoapHeaders().size() > 0) {
                StaxUtil.writeStartElement(writer, soapVersion.getHeader());
                for (DocumentFragment df : message.getSoapHeaders().values()) {
                    Element e = DomUtil.getFirstChildElement(df);
                    StaxUtil.copy(new DOMStreamReader(e), writer);
                }
                writer.writeEndElement();
            } else {
                String forceEmptySoapHeader = (String)message.get("forceEmptySoapHeader");
                if (forceEmptySoapHeader != null) {
                    StaxUtil.writeStartElement(writer, soapVersion.getHeader());
                    writer.writeEndElement();
                }
            }
            StaxUtil.writeStartElement(writer, soapVersion.getBody());
            InterceptorChain chain = message.get(InterceptorChain.class);
            chain.doIntercept(message);
            writer.writeEndElement();
            writer.writeEndElement();
        }
        catch (XMLStreamException e) {
            throw new Fault(e);
        }
    }
}

