/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ebpm.common.util;

import org.eclipse.ebpm.common.util.DOMUtil;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class URIResolver {
    private String uri;

    public URIResolver() {
    }

    public URIResolver(String uri) {
        this.uri = uri;
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public static DocumentFragment createWSAEPR(String uri) {
        Document doc;
        try {
            doc = DOMUtil.newDocument();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        DocumentFragment epr = doc.createDocumentFragment();
        Element root = doc.createElement("epr");
        Element address = doc.createElementNS("http://www.w3.org/2005/08/addressing", "wsa:Address");
        Text txt = doc.createTextNode(uri);
        address.appendChild(txt);
        root.appendChild(address);
        epr.appendChild(root);
        return epr;
    }

    public static String[] split3(String uri) {
        int sep = (uri = uri.trim()).indexOf(47) > 0 ? 47 : 58;
        int idx1 = uri.lastIndexOf(sep);
        int idx2 = uri.lastIndexOf(sep, idx1 - 1);
        if (idx1 < 0 || idx2 < 0) {
            throw new IllegalArgumentException("Bad syntax: expected [part0][sep][part1][sep][part2]");
        }
        String epName = uri.substring(idx1 + 1);
        String svcName = uri.substring(idx2 + 1, idx1);
        String nsUri = uri.substring(0, idx2);
        return new String[]{nsUri, svcName, epName};
    }

    public static String[] split2(String uri) {
        int sep = (uri = uri.trim()).indexOf(47) > 0 ? 47 : 58;
        int idx1 = uri.lastIndexOf(sep);
        if (idx1 < 0) {
            throw new IllegalArgumentException("Bad syntax: expected [part0][sep][part1]");
        }
        String svcName = uri.substring(idx1 + 1);
        String nsUri = uri.substring(0, idx1);
        return new String[]{nsUri, svcName};
    }
}

