/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.log.internal;

import org.eclipse.equinox.log.internal.EventAdminAdapter;
import org.eclipse.equinox.log.internal.ExtendedLogReaderServiceFactory;
import org.eclipse.equinox.log.internal.ExtendedLogServiceFactory;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;

public class Activator
implements BundleActivator,
BundleListener,
FrameworkListener,
ServiceListener {
    private static final String EVENT_ADMIN_CLASS = "org.osgi.service.event.EventAdmin";
    private static final String[] LOGSERVICE_CLASSES;
    private static final String[] LOGREADERSERVICE_CLASSES;
    private ServiceRegistration logReaderServiceRegistration;
    private ServiceRegistration logServiceRegistration;
    private EventAdminAdapter eventAdminAdapter;
    private volatile ExtendedLogReaderServiceFactory logReaderServiceFactory;
    private ExtendedLogServiceFactory logServiceFactory;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    static {
        String[] stringArray = new String[2];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.osgi.service.log.LogService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[0] = clazz.getName();
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.equinox.log.ExtendedLogService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[1] = clazz2.getName();
        LOGSERVICE_CLASSES = stringArray;
        String[] stringArray2 = new String[2];
        Class<?> clazz3 = class$2;
        if (clazz3 == null) {
            try {
                clazz3 = class$2 = Class.forName("org.osgi.service.log.LogReaderService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray2[0] = clazz3.getName();
        Class<?> clazz4 = class$3;
        if (clazz4 == null) {
            try {
                clazz4 = class$3 = Class.forName("org.eclipse.equinox.log.ExtendedLogReaderService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray2[1] = clazz4.getName();
        LOGREADERSERVICE_CLASSES = stringArray2;
    }

    public void start(BundleContext context) throws Exception {
        this.logReaderServiceFactory = new ExtendedLogReaderServiceFactory();
        context.addBundleListener((BundleListener)this);
        context.addServiceListener((ServiceListener)this);
        context.addFrameworkListener((FrameworkListener)this);
        if (Activator.checkEventAdmin()) {
            this.eventAdminAdapter = new EventAdminAdapter(context, this.logReaderServiceFactory);
            this.eventAdminAdapter.start();
        }
        this.logServiceFactory = new ExtendedLogServiceFactory(this.logReaderServiceFactory);
        context.addBundleListener((BundleListener)this.logServiceFactory);
        this.logReaderServiceRegistration = context.registerService(LOGREADERSERVICE_CLASSES, (Object)this.logReaderServiceFactory, null);
        this.logServiceRegistration = context.registerService(LOGSERVICE_CLASSES, (Object)this.logServiceFactory, null);
    }

    public void stop(BundleContext context) throws Exception {
        this.logServiceRegistration.unregister();
        this.logServiceRegistration = null;
        this.logReaderServiceRegistration.unregister();
        this.logReaderServiceRegistration = null;
        this.logServiceFactory.shutdown();
        this.logServiceFactory = null;
        if (this.eventAdminAdapter != null) {
            this.eventAdminAdapter.stop();
            this.eventAdminAdapter = null;
        }
        context.removeFrameworkListener((FrameworkListener)this);
        context.removeServiceListener((ServiceListener)this);
        context.removeBundleListener((BundleListener)this);
    }

    private static boolean checkEventAdmin() {
        try {
            Class.forName(EVENT_ADMIN_CLASS);
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    public void bundleChanged(BundleEvent event) {
        Bundle bundle = event.getBundle();
        if (this.logReaderServiceFactory.isLoggable(bundle, null, 3)) {
            this.logReaderServiceFactory.log(bundle, null, null, 3, Activator.getBundleEventTypeName(event.getType()), null);
        }
    }

    public void serviceChanged(ServiceEvent event) {
        int logType;
        ServiceReference reference = event.getServiceReference();
        Bundle bundle = reference.getBundle();
        int eventType = event.getType();
        int n = logType = eventType == 2 ? 4 : 3;
        if (this.logReaderServiceFactory.isLoggable(bundle, null, logType)) {
            this.logReaderServiceFactory.log(bundle, null, reference, logType, Activator.getServiceEventTypeName(eventType), null);
        }
    }

    public void frameworkEvent(FrameworkEvent event) {
        Throwable throwable;
        Bundle bundle = event.getBundle();
        int eventType = event.getType();
        int logType = eventType == 2 ? 1 : 3;
        Throwable throwable2 = throwable = eventType == 2 ? event.getThrowable() : null;
        if (this.logReaderServiceFactory.isLoggable(bundle, null, logType)) {
            this.logReaderServiceFactory.log(bundle, null, null, logType, Activator.getFrameworkEventTypeName(eventType), throwable);
        }
    }

    protected static String getBundleEventTypeName(int type) {
        switch (type) {
            case 1: {
                return "BundleEvent INSTALLED";
            }
            case 32: {
                return "BundleEvent RESOLVED";
            }
            case 2: {
                return "BundleEvent STARTED";
            }
            case 128: {
                return "BundleEvent STARTING";
            }
            case 4: {
                return "BundleEvent STOPPED";
            }
            case 256: {
                return "BundleEvent STOPPING";
            }
            case 16: {
                return "BundleEvent UNINSTALLED";
            }
            case 64: {
                return "BundleEvent UNRESOLVED";
            }
            case 8: {
                return "BundleEvent UPDATED";
            }
        }
        return "BundleEvent " + Integer.toHexString(type);
    }

    protected static String getServiceEventTypeName(int type) {
        switch (type) {
            case 1: {
                return "ServiceEvent REGISTERED";
            }
            case 2: {
                return "ServiceEvent MODIFIED";
            }
            case 4: {
                return "ServiceEvent UNREGISTERING";
            }
        }
        return "ServiceEvent " + Integer.toHexString(type);
    }

    protected static String getFrameworkEventTypeName(int type) {
        switch (type) {
            case 2: {
                return "FrameworkEvent ERROR";
            }
            case 32: {
                return "FrameworkEvent INFO";
            }
            case 4: {
                return "FrameworkEvent PACKAGES REFRESHED";
            }
            case 1: {
                return "FrameworkEvent STARTED";
            }
            case 8: {
                return "FrameworkEvent STARTLEVEL CHANGED";
            }
            case 16: {
                return "FrameworkEvent WARNING";
            }
        }
        return "FrameworkEvent " + Integer.toHexString(type);
    }
}

