/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.metatype;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.equinox.metatype.LocalizationElement;
import org.eclipse.equinox.metatype.Logging;
import org.eclipse.equinox.metatype.MetaTypeMsg;
import org.eclipse.equinox.metatype.ValueTokenizer;
import org.eclipse.osgi.util.NLS;
import org.osgi.service.metatype.AttributeDefinition;

public class AttributeDefinitionImpl
extends LocalizationElement
implements AttributeDefinition,
Cloneable {
    String _name;
    String _id;
    String _description;
    int _cardinality = 0;
    int _dataType;
    Object _minValue = null;
    Object _maxValue = null;
    boolean _isRequired = true;
    String[] _defaults = null;
    Vector _dfts_vector = new Vector(7);
    Vector _values = new Vector(7);
    Vector _labels = new Vector(7);
    static /* synthetic */ Class class$0;

    public AttributeDefinitionImpl(String id, String name, String description, int type, int cardinality, Object min, Object max, boolean isRequired, String localization) {
        this._id = id;
        this._name = name;
        this._description = description;
        this._dataType = type;
        this._cardinality = cardinality;
        this._minValue = min;
        this._maxValue = max;
        this._isRequired = isRequired;
        this._localization = localization;
    }

    public synchronized Object clone() {
        AttributeDefinitionImpl ad = new AttributeDefinitionImpl(this._id, this._name, this._description, this._dataType, this._cardinality, this._minValue, this._maxValue, this._isRequired, this._localization);
        if (this._defaults != null) {
            ad.setDefaultValue((String[])this._defaults.clone(), false);
        }
        if (this._labels != null && this._values != null) {
            ad.setOption((Vector)this._labels.clone(), (Vector)this._values.clone(), false);
        }
        return ad;
    }

    public String getName() {
        return this.getLocalized(this._name);
    }

    void setName(String name) {
        this._name = name;
    }

    public String getID() {
        return this._id;
    }

    void setID(String id) {
        this._id = id;
    }

    public String getDescription() {
        return this.getLocalized(this._description);
    }

    void setDescription(String description) {
        this._description = description;
    }

    public int getCardinality() {
        return this._cardinality;
    }

    void setCardinality(int cardinality) {
        this._cardinality = cardinality;
    }

    public int getType() {
        return this._dataType;
    }

    void setType(int type) {
        this._dataType = type;
    }

    boolean isRequired() {
        return this._isRequired;
    }

    void setRequired(boolean isRequired) {
        this._isRequired = isRequired;
    }

    public String[] getOptionLabels() {
        if (this._labels == null || this._labels.size() == 0) {
            return null;
        }
        String[] returnedLabels = new String[this._labels.size()];
        Enumeration labelKeys = this._labels.elements();
        int i = 0;
        while (labelKeys.hasMoreElements()) {
            String labelKey = (String)labelKeys.nextElement();
            returnedLabels[i] = this.getLocalized(labelKey);
            ++i;
        }
        return returnedLabels;
    }

    public String[] getOptionValues() {
        if (this._values == null || this._values.size() == 0) {
            return null;
        }
        String[] returnedValues = new String[this._values.size()];
        Enumeration valueKeys = this._values.elements();
        int i = 0;
        while (valueKeys.hasMoreElements()) {
            String valueKey = (String)valueKeys.nextElement();
            returnedValues[i] = this.getLocalized(valueKey);
            ++i;
        }
        return returnedValues;
    }

    void setOption(Vector labels, Vector values, boolean needValidation) {
        if (labels == null || values == null) {
            Logging.log(3, this, "setOption(Vector, Vector, boolean)", MetaTypeMsg.NULL_OPTIONS);
            return;
        }
        if (labels.size() != values.size()) {
            Logging.log(3, this, "setOption(Vector, Vector, boolean)", MetaTypeMsg.INCONSISTENT_OPTIONS);
            return;
        }
        this._labels = labels;
        this._values = values;
        if (needValidation) {
            int index = 0;
            while (index < this._labels.size()) {
                String reason = this.validate((String)this._values.get(index));
                if (reason != null && reason.length() > 0) {
                    Logging.log(2, NLS.bind((String)MetaTypeMsg.INVALID_OPTIONS, this._values.get(index), (Object)reason));
                    this._labels.remove(index);
                    this._values.remove(index);
                    --index;
                }
                ++index;
            }
        }
    }

    public String[] getDefaultValue() {
        return this._defaults;
    }

    void setDefaultValue(String defaults_str, boolean needValidation) {
        ValueTokenizer vt = new ValueTokenizer(defaults_str);
        this.setDefaultValue(vt.getValuesAsArray(), needValidation);
    }

    void setDefaultValue(String[] defaults, boolean needValidation) {
        this._defaults = defaults;
    }

    void setMinValue(Object minValue) {
        this._minValue = minValue;
    }

    void setMaxValue(Object maxValue) {
        this._maxValue = maxValue;
    }

    public String validate(String value) {
        block11: {
            if (value == null) {
                return MetaTypeMsg.NULL_IS_INVALID;
            }
            if (this._minValue == null && this._maxValue == null) {
                if (this._dataType != 1) {
                    return null;
                }
                if (this._values.size() < 1) {
                    return null;
                }
            }
            if (this._dataType == 1 && this._values.size() > 0 && !this._values.contains(value)) {
                return NLS.bind((String)MetaTypeMsg.VALUE_OUT_OF_OPTION, (Object)value);
            }
            try {
                if (this._cardinality == 0) break block11;
                ValueTokenizer vt = new ValueTokenizer(value);
                Vector value_vector = vt.getValuesAsVector();
                if (value_vector.size() > Math.abs(this._cardinality)) {
                    return NLS.bind((String)MetaTypeMsg.TOO_MANY_VALUES, (Object)value, (Object)new Integer(Math.abs(this._cardinality)));
                }
                int i = 0;
                while (i < value_vector.size()) {
                    String return_msg = this.validateRange((String)value_vector.get(i));
                    if (!"".equals(return_msg)) {
                        return return_msg;
                    }
                    ++i;
                }
                return "";
            }
            catch (Throwable t) {
                return NLS.bind((String)MetaTypeMsg.EXCEPTION_MESSAGE, (Object)t.getClass().getName(), (Object)t.getMessage());
            }
        }
        String return_msg = this.validateRange(value);
        return return_msg;
    }

    private String validateRange(String value) {
        boolean rangeError = false;
        switch (this._dataType) {
            case 1: {
                if (this._minValue == null || this._maxValue == null || value.length() <= (Integer)this._maxValue && value.length() >= (Integer)this._minValue) break;
                rangeError = true;
                break;
            }
            case 2: {
                Long longVal = new Long(value);
                if (this._minValue != null && longVal.compareTo((Long)this._minValue) < 0) {
                    rangeError = true;
                    break;
                }
                if (this._maxValue == null || longVal.compareTo((Long)this._maxValue) <= 0) break;
                rangeError = true;
                break;
            }
            case 3: {
                Integer intVal = new Integer(value);
                if (this._minValue != null && intVal.compareTo((Integer)this._minValue) < 0) {
                    rangeError = true;
                    break;
                }
                if (this._maxValue == null || intVal.compareTo((Integer)this._maxValue) <= 0) break;
                rangeError = true;
                break;
            }
            case 4: {
                Short shortVal = new Short(value);
                if (this._minValue != null && shortVal.compareTo((Short)this._minValue) < 0) {
                    rangeError = true;
                    break;
                }
                if (this._maxValue == null || shortVal.compareTo((Short)this._maxValue) <= 0) break;
                rangeError = true;
                break;
            }
            case 5: {
                Character charVal = new Character(value.charAt(0));
                if (this._minValue != null && charVal.compareTo((Character)this._minValue) < 0) {
                    rangeError = true;
                    break;
                }
                if (this._maxValue == null || charVal.compareTo((Character)this._maxValue) <= 0) break;
                rangeError = true;
                break;
            }
            case 6: {
                Byte byteVal = new Byte(value);
                if (this._minValue != null && byteVal.compareTo((Byte)this._minValue) < 0) {
                    rangeError = true;
                    break;
                }
                if (this._maxValue == null || byteVal.compareTo((Byte)this._maxValue) <= 0) break;
                rangeError = true;
                break;
            }
            case 7: {
                Double doubleVal = new Double(value);
                if (this._minValue != null && doubleVal.compareTo((Double)this._minValue) < 0) {
                    rangeError = true;
                    break;
                }
                if (this._maxValue == null || doubleVal.compareTo((Double)this._maxValue) <= 0) break;
                rangeError = true;
                break;
            }
            case 8: {
                Float floatVal = new Float(value);
                if (this._minValue != null && floatVal.compareTo((Float)this._minValue) < 0) {
                    rangeError = true;
                    break;
                }
                if (this._maxValue == null || floatVal.compareTo((Float)this._maxValue) <= 0) break;
                rangeError = true;
                break;
            }
            case 9: {
                try {
                    Class<?> bigIntClazz = Class.forName("java.math.BigInteger");
                    Class[] classArray = new Class[1];
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("java.lang.String");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    classArray[0] = clazz;
                    Constructor<?> bigIntConstructor = bigIntClazz.getConstructor(classArray);
                    Comparable bigIntObject = (Comparable)bigIntConstructor.newInstance(value);
                    if (this._minValue != null && bigIntObject.compareTo(this._minValue) < 0) {
                        rangeError = true;
                        break;
                    }
                    if (this._maxValue == null || bigIntObject.compareTo(this._maxValue) <= 0) break;
                    rangeError = true;
                    break;
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                    return null;
                }
                catch (SecurityException e) {
                    e.printStackTrace();
                    return null;
                }
                catch (NoSuchMethodException e) {
                    e.printStackTrace();
                    return null;
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                    return null;
                }
                catch (InstantiationException e) {
                    e.printStackTrace();
                    return null;
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                    return null;
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                    return null;
                }
            }
            case 10: {
                try {
                    Class<?> bigDecimalClazz = Class.forName("java.math.BigDecimal");
                    Class[] classArray = new Class[1];
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("java.lang.String");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    classArray[0] = clazz;
                    Constructor<?> bigDecimalConstructor = bigDecimalClazz.getConstructor(classArray);
                    Comparable bigDecimalObject = (Comparable)bigDecimalConstructor.newInstance(value);
                    if (this._minValue != null && bigDecimalObject.compareTo(this._minValue) < 0) {
                        rangeError = true;
                        break;
                    }
                    if (this._maxValue == null || bigDecimalObject.compareTo(this._maxValue) <= 0) break;
                    rangeError = true;
                    break;
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                    return null;
                }
                catch (SecurityException e) {
                    e.printStackTrace();
                    return null;
                }
                catch (NoSuchMethodException e) {
                    e.printStackTrace();
                    return null;
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                    return null;
                }
                catch (InstantiationException e) {
                    e.printStackTrace();
                    return null;
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                    return null;
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                    return null;
                }
            }
            default: {
                return null;
            }
        }
        if (rangeError) {
            return NLS.bind((String)MetaTypeMsg.VALUE_OUT_OF_RANGE, (Object)value);
        }
        return "";
    }
}

