/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ebpm.metadb.utils;

import com.thoughtworks.xstream.converters.ConversionException;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public class CalendarConverter
implements Converter {
    public boolean canConvert(Class clazz) {
        return Calendar.class.isAssignableFrom(clazz);
    }

    public void marshal(Object value, HierarchicalStreamWriter writer, MarshallingContext context) {
        Calendar calendar = (Calendar)value;
        Long millis = calendar.getTimeInMillis();
        String TzId = calendar.getTimeZone().getID();
        writer.setValue(String.valueOf(millis.toString()) + "#" + TzId);
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        GregorianCalendar calendar = new GregorianCalendar();
        try {
            String value = reader.getValue();
            String TzId = value.substring(value.indexOf("#") + 1);
            String strMillis = value.substring(0, value.indexOf("#"));
            calendar.setTimeZone(TimeZone.getTimeZone(TzId));
            calendar.setTimeInMillis(Long.parseLong(strMillis));
        }
        catch (Exception e) {
            throw new ConversionException(e.getMessage(), (Throwable)e);
        }
        return calendar;
    }
}

