/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ebpm.connectors.mail.security;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.net.SocketFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomSSLSocketFactory
extends SSLSocketFactory {
    public static final String PROPERTY_TRUSTMANAGERS = "custom-trust-managers";
    public static final String PROPERTY_SEPARATOR = ";";
    protected Logger log = LoggerFactory.getLogger(CustomSSLSocketFactory.class);
    private SSLSocketFactory factory;

    public CustomSSLSocketFactory() {
        try {
            SSLContext sslcontext = SSLContext.getInstance("TLS");
            if (System.getProperty(PROPERTY_TRUSTMANAGERS) != null && System.getProperty(PROPERTY_TRUSTMANAGERS).trim().length() > 0) {
                sslcontext.init(null, this.getTrustManagers(), new SecureRandom());
            } else {
                sslcontext.init(null, null, null);
            }
            this.factory = sslcontext.getSocketFactory();
        }
        catch (Exception ex) {
            this.log.error("Failed to create the dummy ssl socket factory.", (Throwable)ex);
        }
    }

    private TrustManager[] getTrustManagers() {
        ArrayList<TrustManager> managers = new ArrayList<TrustManager>();
        String managersString = System.getProperty(PROPERTY_TRUSTMANAGERS);
        if (managersString != null && managersString.trim().length() > 0) {
            StringTokenizer strTok = new StringTokenizer(managersString, PROPERTY_SEPARATOR);
            while (strTok.hasMoreTokens()) {
                String name = strTok.nextToken();
                try {
                    Object tm = Class.forName(name).newInstance();
                    if (tm instanceof TrustManager) {
                        managers.add((TrustManager)tm);
                        continue;
                    }
                    this.log.error("Customized trust manager " + name + " is not implementing TrustManager. Skipping...");
                }
                catch (IllegalAccessException iaex) {
                    this.log.error("Customized trust manager " + name + " is not accessable. Skipping...", (Throwable)iaex);
                }
                catch (InstantiationException iex) {
                    this.log.error("Customized trust manager " + name + " could not be instantiated. Skipping...", (Throwable)iex);
                }
                catch (ClassNotFoundException cnfex) {
                    this.log.error("Customized trust manager " + name + " was not found. Skipping...", (Throwable)cnfex);
                }
            }
        }
        return managers.toArray(new TrustManager[managers.size()]);
    }

    public static SocketFactory getDefault() {
        return new CustomSSLSocketFactory();
    }

    @Override
    public Socket createSocket(Socket socket, String s, int i, boolean flag) throws IOException {
        return this.factory.createSocket(socket, s, i, flag);
    }

    @Override
    public Socket createSocket() throws IOException {
        return this.factory.createSocket();
    }

    @Override
    public Socket createSocket(InetAddress inaddr, int i, InetAddress inaddr1, int j) throws IOException {
        return this.factory.createSocket(inaddr, i, inaddr1, j);
    }

    @Override
    public Socket createSocket(InetAddress inaddr, int i) throws IOException {
        return this.factory.createSocket(inaddr, i);
    }

    @Override
    public Socket createSocket(String s, int i, InetAddress inaddr, int j) throws IOException {
        return this.factory.createSocket(s, i, inaddr, j);
    }

    @Override
    public Socket createSocket(String s, int i) throws IOException {
        return this.factory.createSocket(s, i);
    }

    @Override
    public String[] getDefaultCipherSuites() {
        return this.factory.getSupportedCipherSuites();
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return this.factory.getSupportedCipherSuites();
    }
}

