/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ebpm.connectors.mail.marshaler;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.DateFormat;
import java.util.Enumeration;
import java.util.Iterator;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Header;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.util.ByteArrayDataSource;
import org.eclipse.ebpm.connectors.mail.marshaler.AbstractMailMarshaler;
import org.eclipse.ebpm.messaging.api.Exchange;
import org.eclipse.ebpm.messaging.api.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericTextMailMarshaler
extends AbstractMailMarshaler {
    protected Logger log = LoggerFactory.getLogger(GenericTextMailMarshaler.class);
    private static final String START_TEXT = "<BODY_TEXT>";
    private static final String END_TEXT = "</BODY_TEXT>";

    @Override
    public void convertMailToNormalizedMessage(Exchange exchange, Message msg, MimeMessage mailMsg) throws MessagingException {
        this.copyHeaders(exchange, msg, mailMsg);
        this.copyBodyAndAttachments(exchange, msg, mailMsg);
    }

    @Override
    public void convertNormalizedMessageToMail(MimeMessage mimeMessage, Exchange exchange, Message msg, String configuredSender, String configuredReceiver) throws MessagingException {
        try {
            this.fillMailHeaders(mimeMessage, exchange, msg, configuredSender, configuredReceiver);
            this.fillMailBodyAndAttachments(mimeMessage, exchange, msg);
        }
        catch (Exception ex) {
            throw new MessagingException(ex.getMessage(), ex);
        }
    }

    protected void fillMailBodyAndAttachments(MimeMessage mimeMessage, Exchange exchange, Message msg) throws Exception {
        if (msg.getAttachments().size() > 0) {
            Iterator itAttNames = msg.getAttachments().keySet().iterator();
            if (itAttNames.hasNext()) {
                MimeMultipart multipart = new MimeMultipart();
                this.fillMailBody(mimeMessage, exchange, msg, multipart);
                MimeBodyPart messageBodyPart = null;
                while (itAttNames.hasNext()) {
                    String oneAttachmentName = (String)itAttNames.next();
                    DataHandler dh = (DataHandler)msg.getAttachment(oneAttachmentName);
                    File f = File.createTempFile(System.currentTimeMillis() + "-", dh.getDataSource().getName());
                    BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(f));
                    GenericTextMailMarshaler.copyInputStream(dh.getInputStream(), bos);
                    bos.close();
                    this.log.debug("Saved temp file: " + f.getName() + " with length: " + f.length());
                    this.addTemporaryResource(exchange.getId(), f);
                    messageBodyPart = new MimeBodyPart();
                    messageBodyPart.setDataHandler(new DataHandler((DataSource)new FileDataSource(f)));
                    messageBodyPart.setFileName(dh.getDataSource().getName());
                    messageBodyPart.setDisposition("attachment");
                    multipart.addBodyPart((BodyPart)messageBodyPart);
                }
                mimeMessage.setContent((Multipart)multipart);
            }
        } else {
            this.fillMailBody(mimeMessage, exchange, msg, null);
        }
    }

    protected void fillMailBody(MimeMessage mimeMessage, Exchange exchange, Message msg, MimeMultipart content) throws Exception {
        block20: {
            boolean isHtmlMessage;
            boolean isPlainTextMessage = msg.getHeader("org.spagic3.mail.text") != null;
            boolean bl = isHtmlMessage = msg.getHeader("org.spagic3.mail.html") != null;
            if (isPlainTextMessage && !isHtmlMessage) {
                if (content != null) {
                    content.setSubType("mixed");
                    MimeBodyPart textBodyPart = new MimeBodyPart();
                    textBodyPart.setContent((Object)msg.getHeader("org.spagic3.mail.text").toString(), "text/plain");
                    content.addBodyPart((BodyPart)textBodyPart);
                } else {
                    mimeMessage.setText(msg.getHeader("org.spagic3.mail.text").toString());
                }
            } else if (isHtmlMessage && !isPlainTextMessage) {
                if (content != null) {
                    content.setSubType("mixed");
                    MimeBodyPart htmlBodyPart = new MimeBodyPart();
                    htmlBodyPart.setContent((Object)msg.getHeader("org.spagic3.mail.html").toString(), "text/html");
                    content.addBodyPart((BodyPart)htmlBodyPart);
                } else {
                    content = new MimeMultipart("mixed");
                    MimeBodyPart htmlBodyPart = new MimeBodyPart();
                    htmlBodyPart.setContent((Object)msg.getHeader("org.spagic3.mail.html").toString(), "text/html");
                    content.addBodyPart((BodyPart)htmlBodyPart);
                    mimeMessage.setContent((Multipart)content);
                }
            } else if (isHtmlMessage && isPlainTextMessage) {
                if (content != null) {
                    content.setSubType("mixed");
                    MimeBodyPart textBodyPart = new MimeBodyPart();
                    MimeBodyPart htmlBodyPart = new MimeBodyPart();
                    textBodyPart.setContent((Object)msg.getHeader("org.spagic3.mail.text").toString(), "text/plain");
                    htmlBodyPart.setContent((Object)msg.getHeader("org.spagic3.mail.html").toString(), "text/html");
                    content.addBodyPart((BodyPart)textBodyPart);
                    content.addBodyPart((BodyPart)htmlBodyPart);
                } else {
                    content = new MimeMultipart("mixed");
                    MimeBodyPart textBodyPart = new MimeBodyPart();
                    MimeBodyPart htmlBodyPart = new MimeBodyPart();
                    textBodyPart.setContent((Object)msg.getHeader("org.spagic3.mail.text").toString(), "text/plain");
                    htmlBodyPart.setContent((Object)msg.getHeader("org.spagic3.mail.html").toString(), "text/html");
                    content.addBodyPart((BodyPart)textBodyPart);
                    content.addBodyPart((BodyPart)htmlBodyPart);
                    mimeMessage.setContent((Multipart)content);
                }
            } else if (msg.getBody() != null) {
                try {
                    if (content != null) {
                        content.setSubType("mixed");
                        MimeBodyPart htmlBodyPart = new MimeBodyPart();
                        htmlBodyPart.setContent((Object)msg.getBodyText(), "text/html");
                        content.addBodyPart((BodyPart)htmlBodyPart);
                        break block20;
                    }
                    content = new MimeMultipart("mixed");
                    MimeBodyPart htmlBodyPart = new MimeBodyPart();
                    htmlBodyPart.setContent((Object)msg.getBodyText(), "text/html");
                    content.addBodyPart((BodyPart)htmlBodyPart);
                    mimeMessage.setContent((Multipart)content);
                }
                catch (Exception exception) {
                    if (content != null) {
                        content.setSubType("mixed");
                        MimeBodyPart textBodyPart = new MimeBodyPart();
                        textBodyPart.setContent((Object)msg.getBodyText(), "text/plain");
                        content.addBodyPart((BodyPart)textBodyPart);
                        break block20;
                    }
                    mimeMessage.setText(msg.getBodyText());
                }
            } else if (content != null) {
                content.setSubType("mixed");
                MimeBodyPart textBodyPart = new MimeBodyPart();
                textBodyPart.setContent((Object)"no content", "text/plain");
                content.addBodyPart((BodyPart)textBodyPart);
            } else {
                mimeMessage.setText("no content");
            }
        }
    }

    protected void fillMailHeaders(MimeMessage mimeMessage, Exchange exchange, Message msg, String configuredSender, String configuredReceiver) throws Exception {
        InternetAddress[] replyTo;
        String sentDate;
        InternetAddress from;
        InternetAddress[] bcc;
        InternetAddress[] cc;
        InternetAddress[] to;
        if (msg.getHeader("org.spagic3.mail.to") != null) {
            to = InternetAddress.parse((String)msg.getHeader("org.spagic3.mail.to").toString());
            if (to != null) {
                mimeMessage.setRecipients(Message.RecipientType.TO, (Address[])to);
            }
        } else if (configuredReceiver != null && (to = InternetAddress.parse((String)configuredReceiver)) != null) {
            mimeMessage.setRecipients(Message.RecipientType.TO, (Address[])to);
        }
        if (msg.getHeader("org.spagic3.mail.cc") != null && (cc = InternetAddress.parse((String)msg.getHeader("org.spagic3.mail.cc").toString())) != null) {
            mimeMessage.setRecipients(Message.RecipientType.CC, (Address[])cc);
        }
        if (msg.getHeader("org.spagic3.mail.bcc") != null && (bcc = InternetAddress.parse((String)msg.getHeader("org.spagic3.mail.bcc").toString())) != null) {
            mimeMessage.setRecipients(Message.RecipientType.BCC, (Address[])bcc);
        }
        if (configuredSender != null && configuredSender.trim().length() > 0) {
            from = InternetAddress.parse((String)configuredSender)[0];
            if (from != null) {
                mimeMessage.setFrom((Address)from);
            }
        } else if (msg.getHeader("org.spagic3.mail.from") != null) {
            from = InternetAddress.parse((String)msg.getHeader("org.spagic3.mail.from").toString())[0];
            if (from != null) {
                mimeMessage.setFrom((Address)from);
            }
        } else {
            from = InternetAddress.parse((String)this.getDefaultSenderForOutgoingMails())[0];
            if (from != null) {
                mimeMessage.setFrom((Address)from);
            }
        }
        if (msg.getHeader("org.spagic3.mail.subject") != null) {
            String subject = msg.getHeader("org.spagic3.mail.subject").toString();
            if (subject != null) {
                mimeMessage.setSubject(subject);
            } else {
                mimeMessage.setSubject("no subject");
            }
        } else {
            mimeMessage.setSubject("no subject");
        }
        if (msg.getHeader("org.spagic3.mail.sentdate") != null && (sentDate = msg.getHeader("org.spagic3.mail.sentdate").toString()) != null) {
            mimeMessage.setSentDate(DateFormat.getInstance().parse(sentDate));
        }
        if (msg.getHeader("org.spagic3.mail.replyto") != null && (replyTo = InternetAddress.parse((String)msg.getHeader("org.spagic3.mail.replyto").toString())) != null) {
            mimeMessage.setReplyTo((Address[])replyTo);
        }
    }

    protected void copyHeaders(Exchange exchange, Message msg, MimeMessage mailMsg) throws MessagingException {
        Enumeration headers = mailMsg.getAllHeaders();
        while (headers.hasMoreElements()) {
            Header header = (Header)headers.nextElement();
            if (msg.getHeader(header.getName()) != null) {
                msg.setHeader(header.getName(), msg.getHeader(String.valueOf(header.getName()) + ";" + header.getValue()));
            } else {
                msg.setHeader(header.getName(), (Object)header.getValue());
            }
            this.log.debug("Setting property: " + header.getName() + " = " + header.getValue());
        }
        if (msg.getHeader("Bcc") != null) {
            msg.setHeader("org.spagic3.mail.bcc", msg.getHeader("Bcc"));
        }
        if (msg.getHeader("Cc") != null) {
            msg.setHeader("org.spagic3.mail.cc", msg.getHeader("Cc"));
        }
        if (msg.getHeader("From") != null) {
            msg.setHeader("org.spagic3.mail.from", msg.getHeader("From"));
        }
        if (msg.getHeader("Reply-To") != null) {
            msg.setHeader("org.spagic3.mail.replyto", msg.getHeader("Reply-To"));
        }
        if (msg.getHeader("Date") != null) {
            msg.setHeader("org.spagic3.mail.sentdate", msg.getHeader("Date"));
        }
        if (msg.getHeader("Subject") != null) {
            msg.setHeader("org.spagic3.mail.subject", msg.getHeader("Subject"));
        }
        if (msg.getHeader("To") != null) {
            msg.setHeader("org.spagic3.mail.to", msg.getHeader("To"));
        }
    }

    protected String asString(Object value) {
        return value != null ? value.toString() : null;
    }

    protected void copyBodyAndAttachments(Exchange exchange, Message msg, MimeMessage mailMsg) throws MessagingException {
        String text = null;
        String html = null;
        try {
            Object content = mailMsg.getContent();
            if (content instanceof String) {
                text = this.asString(content);
            } else if (content instanceof Multipart) {
                Multipart mp = (Multipart)content;
                int nbMP = mp.getCount();
                this.log.debug("MultiPart count: " + nbMP);
                int i = 0;
                while (i < nbMP) {
                    BodyPart part = mp.getBodyPart(i);
                    String disposition = part.getDisposition();
                    this.log.debug("MultiPart " + i + ": " + part);
                    this.log.debug("Disposition: " + disposition);
                    if (disposition != null && (disposition.equalsIgnoreCase("attachment") || disposition.equalsIgnoreCase("inline"))) {
                        if (part.getFileName() != null) {
                            DataHandler att = part.getDataHandler();
                            msg.addAttachment(att.getName(), (Object)att);
                        } else {
                            text = part.getContent() != null ? part.getContent().toString() : "null";
                        }
                    } else if (disposition == null) {
                        MimeBodyPart mbp = (MimeBodyPart)part;
                        if (mbp.isMimeType("text/plain")) {
                            text = (String)mbp.getContent();
                        } else if (mbp.isMimeType("text/html")) {
                            html = (String)mbp.getContent();
                        } else if (mbp.getContent() instanceof MimeMultipart) {
                            MimeMultipart subMP = (MimeMultipart)mbp.getContent();
                            int nbsubMP = subMP.getCount();
                            int j = 0;
                            while (j < nbsubMP) {
                                MimeBodyPart subMBP = (MimeBodyPart)subMP.getBodyPart(j);
                                if (subMBP.getContent() instanceof InputStream) {
                                    this.parsePart(subMBP, msg);
                                } else if (subMBP.isMimeType("text/plain") && (text == null || text.length() <= 0)) {
                                    text = (String)subMBP.getContent();
                                } else if (subMBP.isMimeType("text/html") && (html == null || html.length() <= 0)) {
                                    html = (String)subMBP.getContent();
                                } else {
                                    msg.setHeader("org.spagic3.mail.alternativecontent" + j, subMBP.getContent());
                                }
                                ++j;
                            }
                        } else {
                            this.parsePart(mbp, msg);
                        }
                    }
                    ++i;
                }
            } else {
                this.log.warn("The content of the mail message is not supported by this component. (" + content.getClass().getName() + ")");
            }
        }
        catch (MessagingException e) {
            throw new MessagingException("Error while setting content on normalized message", (Exception)((Object)e));
        }
        catch (IOException e) {
            throw new MessagingException("Error while fetching content", (Exception)e);
        }
        String msgContent = null;
        if (text == null && html != null) {
            msgContent = this.normalizeMessage(html);
            msg.setHeader("org.spagic3.mail.html", html);
        } else if (text != null && html != null) {
            msgContent = this.normalizeMessage(text);
            msg.setHeader("org.spagic3.mail.html", html);
            msg.setHeader("org.spagic3.mail.text", (Object)text);
        } else {
            if (text == null) {
                this.log.debug("No content found! \n" + msg.toString());
            }
            msgContent = this.normalizeMessage(text);
            msg.setHeader("org.spagic3.mail.text", (Object)text);
        }
        try {
            msg.setBody(msgContent != null ? msgContent : "No mail content found!");
        }
        catch (Exception e) {
            throw new MessagingException("Error while setting message content", e);
        }
    }

    private String normalizeMessage(String text) {
        text = text.replaceAll("&", "&amp;");
        text = text.replaceAll("<", "&lt;");
        text = text.replaceAll(">", "&gt;");
        return START_TEXT + text + END_TEXT;
    }

    protected void parsePart(MimeBodyPart mbp, Message msg) throws MessagingException, MessagingException, IOException {
        Object subContent = mbp.getContent();
        this.log.debug("Parsing: " + subContent.getClass().getName());
        if (subContent instanceof InputStream) {
            String altName = String.valueOf(mbp.getContentID()) + "." + mbp.getContentType().substring(mbp.getContentType().lastIndexOf(47) + 1);
            altName = altName.replaceAll("<", "").replaceAll(">", "").toLowerCase();
            this.log.debug("Adding special attachment: " + (mbp.getFileName() != null ? mbp.getFileName() : altName));
            byte[] data = new byte[mbp.getSize()];
            InputStream stream = (InputStream)subContent;
            stream.read(data);
            ByteArrayDataSource bads = new ByteArrayDataSource(data, mbp.getContentType());
            bads.setName(mbp.getFileName() != null ? mbp.getFileName() : altName);
            msg.addAttachment(bads.getName(), (Object)new DataHandler((DataSource)bads));
        }
    }

    public static void copyInputStream(InputStream in, OutputStream out) throws IOException {
        byte[] buffer = new byte[8192];
        int len = in.read(buffer);
        while (len >= 0) {
            out.write(buffer, 0, len);
            len = in.read(buffer);
        }
        in.close();
        out.close();
    }
}

