/***********************************************************************
 * Copyright (c) 2004 Actuate Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * Actuate Corporation - initial API and implementation
 ***********************************************************************/

package org.eclipse.birt.chart.model.attribute;

import org.eclipse.birt.chart.model.IChartObject;

/**
 * <!-- begin-user-doc --> A representation of the model object '<em><b>Fill</b></em>'. <!-- end-user-doc -->
 *
 * <!-- begin-model-doc -->
 * 
 * 			This type holds background information for a chart element.
 * 			
 * <!-- end-model-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link org.eclipse.birt.chart.model.attribute.Fill#getType <em>Type</em>}</li>
 * </ul>
 * </p>
 *
 * @see org.eclipse.birt.chart.model.attribute.AttributePackage#getFill()
 * @model extendedMetaData="name='Fill' kind='elementOnly'"
 * @extends IChartObject
 * @generated
 */
public interface Fill extends IChartObject
{

	/**
	 * Returns the value of the '<em><b>Type</b></em>' attribute. <!-- begin-user-doc --> Gets the type of the
	 * background element. <!-- end-user-doc --> <!-- begin-model-doc -->
	 * 
	 * Specifies the type of the background element.
	 * 
	 * <!-- end-model-doc -->
	 * 
	 * @return the value of the '<em>Type</em>' attribute.
	 * @see #isSetType()
	 * @see #unsetType()
	 * @see #setType(int)
	 * @see org.eclipse.birt.chart.model.attribute.AttributePackage#getFill_Type()
	 * @model unique="false" unsettable="true" dataType="org.eclipse.emf.ecore.xml.type.Int" required="true"
	 * @generated
	 */
	int getType( );

	/**
	 * Sets the value of the '{@link org.eclipse.birt.chart.model.attribute.Fill#getType <em>Type</em>}' attribute.
	 * <!-- begin-user-doc --> Sets the type of the background element. <!-- end-user-doc -->
	 * @param value the new value of the '<em>Type</em>' attribute.
	 * @see #isSetType()
	 * @see #unsetType()
	 * @see #getType()
	 * @generated
	 */
	void setType( int value );

	/**
	 * Unsets the value of the '{@link org.eclipse.birt.chart.model.attribute.Fill#getType <em>Type</em>}' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see #isSetType()
	 * @see #getType()
	 * @see #setType(int)
	 * @generated
	 */
	void unsetType( );

	/**
	 * Returns whether the value of the '{@link org.eclipse.birt.chart.model.attribute.Fill#getType <em>Type</em>}' attribute is set.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @return whether the value of the '<em>Type</em>' attribute is set.
	 * @see #unsetType()
	 * @see #getType()
	 * @see #setType(int)
	 * @generated
	 */
	boolean isSetType( );

	/**
	 * @generated
	 */
	Fill copyInstance( );

} // Fill
