/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.css.ui.internal.contentassist;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.wst.css.core.internal.metamodel.CSSMetaModel;
import org.eclipse.wst.css.core.internal.metamodel.util.CSSMetaModelFinder;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSDocument;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSModel;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSNode;
import org.eclipse.wst.css.core.internal.util.CSSUtil;
import org.eclipse.wst.css.core.internal.util.RegionIterator;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;

class CSSContentAssistContext {
    private int fReplaceBegin = -1;
    private String fTextToReplace = null;
    private String fTextToCompare = null;
    private int fTargetPos = -1;
    private ICSSNode fTargetNode = null;
    private int fCursorPos = -1;
    private int fLength = -1;
    private IStructuredDocument fStructuredDocument = null;
    private int fDocumentOffset = 0;
    private char fQuote = '\u0000';
    private ICSSModel fModel = null;
    private boolean fSelected = false;

    private CSSContentAssistContext() {
    }

    CSSContentAssistContext(int documentPosition, ICSSNode node, int documentOffset, char quote) {
        this();
        this.fCursorPos = documentPosition;
        this.fDocumentOffset = documentOffset;
        this.fQuote = quote;
        this.initialize(node.getOwnerDocument());
    }

    CSSContentAssistContext(int documentPosition, ICSSNode node, int documentOffset, int length, char quote) {
        this();
        this.fCursorPos = documentPosition;
        this.fDocumentOffset = documentOffset;
        this.fQuote = quote;
        this.fLength = length;
        this.initialize(node.getOwnerDocument());
    }

    CSSContentAssistContext(int documentPosition, ICSSNode node, int documentOffset, char quote, boolean selected) {
        this();
        this.fCursorPos = documentPosition;
        this.fDocumentOffset = documentOffset;
        this.fQuote = quote;
        this.fSelected = selected;
        this.initialize(node.getOwnerDocument());
    }

    int getCursorPos() {
        return this.fCursorPos;
    }

    int getDocumentOffset() {
        return this.fDocumentOffset;
    }

    IStructuredDocument getStructuredDocument() {
        return this.fStructuredDocument;
    }

    ICSSModel getModel() {
        return this.fModel;
    }

    private ICSSNode getNodeAt(int offset) {
        return (ICSSNode)(this.fModel != null ? this.fModel.getIndexedRegion(offset) : null);
    }

    char getQuoteOfStyleAttribute() {
        return this.fQuote;
    }

    ITextRegion getRegionByOffset(int offset) {
        IStructuredDocumentRegion flatNode;
        ITextRegion region = null;
        if (this.fStructuredDocument != null && (flatNode = this.fStructuredDocument.getRegionAtCharacterOffset(offset)) != null) {
            if (offset == flatNode.getStartOffset() && this.fQuote != '\u0000') {
                flatNode = this.fStructuredDocument.getRegionAtCharacterOffset(offset - 1);
            }
            region = offset == flatNode.getEndOffset() ? flatNode.getRegionAtCharacterOffset(offset - 1) : flatNode.getRegionAtCharacterOffset(offset);
        }
        return region;
    }

    int getReplaceBegin() {
        return this.fReplaceBegin;
    }

    ICSSNode getTargetNode() {
        return this.fTargetNode;
    }

    private int getTargetPos() {
        return this.fTargetPos;
    }

    ITextRegion getTargetRegion() {
        return this.getRegionByOffset(this.getTargetPos());
    }

    private IStructuredDocumentRegion getTargetDocumentRegion() {
        return this.getDocumentRegionByOffset(this.getTargetPos());
    }

    private IStructuredDocumentRegion getDocumentRegionByOffset(int offset) {
        return this.fStructuredDocument != null ? this.fStructuredDocument.getRegionAtCharacterOffset(offset) : null;
    }

    ITextRegion getTargetRegionPrevious() {
        ITextRegion previousRegion = null;
        ITextRegion targetRegion = this.getTargetRegion();
        RegionIterator iterator = null;
        if (targetRegion == null) {
            if (this.fCursorPos > 0) {
                iterator = new RegionIterator(this.fStructuredDocument, this.fCursorPos - 1);
            }
        } else {
            iterator = this.getRegionIterator();
            if (iterator.hasPrev()) {
                iterator.prev();
            } else {
                iterator = null;
            }
        }
        if (iterator != null) {
            while (iterator.hasPrev()) {
                ITextRegion region = iterator.prev();
                String type = region.getType();
                if (type == "S" || type == "COMMENT" || type == "CDO" || type == "CDC") continue;
                previousRegion = region;
                break;
            }
        }
        return previousRegion;
    }

    String getTextToCompare() {
        return this.fTextToCompare;
    }

    String getTextToReplace() {
        return this.fTextToReplace;
    }

    private void initialize(ICSSDocument doc) {
        ICSSModel model;
        if (doc == null) {
            return;
        }
        this.fModel = model = doc.getModel();
        this.fStructuredDocument = model.getStructuredDocument();
        this.initializeTargetPos();
        this.initializeTargetText();
        this.initializeTargetNode();
    }

    private void initializeTargetNode() {
        String type;
        short nodeType;
        if (this.fCursorPos == 0) {
            this.fTargetNode = this.fModel.getDocument();
            return;
        }
        ICSSNode cursorNode = this.getNodeAt(this.fCursorPos);
        if (cursorNode == null) {
            cursorNode = this.fModel.getDocument();
        }
        ICSSNode node = null;
        IStructuredDocumentRegion flatNode = this.fStructuredDocument.getRegionAtCharacterOffset(this.fCursorPos - 1);
        while (flatNode != null && (node = this.getNodeAt(flatNode.getStartOffset())) == cursorNode && ((IndexedRegion)node).getStartOffset() != flatNode.getStartOffset()) {
            flatNode = flatNode.getPrevious();
        }
        if (flatNode == null) {
            this.fTargetNode = node == null ? this.fModel.getDocument() : node;
            return;
        }
        if (cursorNode != null) {
            ICSSNode parent = cursorNode.getParentNode();
            while (parent != null) {
                if (parent == cursorNode) {
                    this.fTargetNode = cursorNode;
                    return;
                }
                parent = parent.getParentNode();
            }
        }
        this.fTargetNode = (nodeType = node.getNodeType()) == 9 || nodeType == 2 || nodeType == 3 ? ((type = CSSUtil.getStructuredDocumentRegionType((IStructuredDocumentRegion)flatNode)) == "DELIMITER" || type == "DECLARATION_DELIMITER" ? node.getParentNode() : node) : (CSSUtil.getStructuredDocumentRegionType((IStructuredDocumentRegion)flatNode) == "RBRACE" ? node.getParentNode() : node);
    }

    private void initializeTargetPos() {
        this.fTargetPos = this.fCursorPos == 0 || this.isSpecialDelimiterRegion(this.fCursorPos - 1) ? this.fCursorPos : this.fCursorPos - 1;
        if (this.fQuote != '\u0000') {
            --this.fTargetPos;
        }
    }

    private void initializeTargetText() {
        ITextRegion targetRegion = this.getTargetRegion();
        IStructuredDocumentRegion documentRegion = this.getTargetDocumentRegion();
        if (targetRegion == null) {
            this.fReplaceBegin = this.fCursorPos;
            this.fTextToReplace = "";
            this.fTextToCompare = "";
        } else {
            String regionText = documentRegion.getText(targetRegion);
            int regionStart = documentRegion.getStartOffset(targetRegion);
            if (!(this.fSelected || regionStart != this.fCursorPos && regionText.trim().length() != 0 && regionStart + regionText.length() - 1 >= this.fTargetPos)) {
                this.fReplaceBegin = this.fCursorPos;
                this.fTextToReplace = "";
                this.fTextToCompare = "";
                try {
                    if (this.fLength > 0) {
                        this.fTextToReplace = this.fStructuredDocument.get(this.fReplaceBegin, this.fLength);
                    }
                }
                catch (BadLocationException badLocationException) {}
            } else {
                this.fReplaceBegin = regionStart;
                this.fTextToReplace = regionText;
                int matchLength = this.fCursorPos - this.fReplaceBegin;
                if (this.fQuote != '\u0000') {
                    --matchLength;
                    ++this.fReplaceBegin;
                }
                this.fTextToCompare = this.fCursorPos >= this.fReplaceBegin && regionText.trim().length() >= matchLength ? regionText.substring(0, matchLength) : "";
            }
        }
    }

    private boolean isSpecialDelimiterRegion(int pos) {
        ITextRegion region = this.getRegionByOffset(pos);
        String type = null;
        if (region != null) {
            type = region.getType();
        }
        return type != null && (type == "LBRACE" || type == "RBRACE" || type == "DELIMITER" || type == "DECLARATION_SEPARATOR" || type == "DECLARATION_DELIMITER" || type == "DECLARATION_VALUE_OPERATOR" || type == "S");
    }

    boolean isTargetPosAfterOf(String regionType) {
        int start = ((IndexedRegion)this.fTargetNode).getStartOffset();
        if (start < 0 || ((IndexedRegion)this.fTargetNode).getEndOffset() <= 0) {
            return false;
        }
        RegionIterator iRegion = new RegionIterator(this.fStructuredDocument, start);
        while (iRegion.hasNext()) {
            ITextRegion region = iRegion.next();
            if (this.fTargetPos < iRegion.getStructuredDocumentRegion().getTextEndOffset(region)) break;
            if (region.getType() != regionType) continue;
            return true;
        }
        return false;
    }

    boolean isTargetPosBeforeOf(String regionType) {
        return !this.isTargetPosAfterOf(regionType);
    }

    boolean targetFollows(String regionType) {
        RegionIterator iRegion;
        ITextRegion region = null;
        if (this.fStructuredDocument.getLength() <= this.fTargetPos) {
            iRegion = new RegionIterator(this.fStructuredDocument, this.fStructuredDocument.getLength() - 1);
        } else {
            iRegion = new RegionIterator(this.fStructuredDocument, this.fTargetPos);
            try {
                if (!Character.isWhitespace(this.fStructuredDocument.getChar(this.fTargetPos)) && iRegion.hasPrev()) {
                    region = iRegion.prev();
                }
            }
            catch (BadLocationException badLocationException) {
                iRegion = new RegionIterator(this.fStructuredDocument, this.fStructuredDocument.getLength() - 1);
            }
        }
        while (iRegion.hasPrev()) {
            region = iRegion.prev();
            String type = region.getType();
            if (type != "S" && type != "COMMENT") break;
        }
        return region != null && region.getType() == regionType;
    }

    boolean targetHas(String regionType) {
        int end = ((IndexedRegion)this.fTargetNode).getEndOffset();
        if (this.getTargetPos() < 0 || end <= 0) {
            return false;
        }
        RegionIterator iRegion = new RegionIterator(this.fStructuredDocument, this.getTargetPos());
        while (iRegion.hasNext()) {
            ITextRegion region = iRegion.next();
            if (end <= iRegion.getStructuredDocumentRegion().getStartOffset(region)) break;
            if (region.getType() != regionType) continue;
            return true;
        }
        return false;
    }

    RegionIterator getRegionIterator() {
        return new RegionIterator(this.getStructuredDocument(), this.getTargetPos());
    }

    CSSMetaModel getMetaModel() {
        CSSMetaModelFinder finder = CSSMetaModelFinder.getInstance();
        return finder.findMetaModelFor((IStructuredModel)this.getModel());
    }
}

