/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.jaxws.dom.integration.navigator;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.jst.ws.jaxws.dom.integration.internal.util.ProjectExplorerUtil;
import org.eclipse.jst.ws.jaxws.dom.integration.navigator.CustomDomItemProviderAdapterFactory;
import org.eclipse.jst.ws.jaxws.dom.integration.navigator.ILoadingWsProject;
import org.eclipse.jst.ws.jaxws.dom.integration.navigator.ISEIChildList;
import org.eclipse.jst.ws.jaxws.dom.integration.navigator.IWebServiceChildList;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.IDOM;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.IServiceEndpointInterface;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.IWebMethod;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.IWebParam;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.IWebService;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.IWebServiceProject;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.IWsDOMRuntimeExtension;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.IWsDomLoadListener;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.WsDOMLoadCanceledException;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.WsDOMRuntimeManager;
import org.eclipse.jst.ws.jaxws.dom.runtime.registry.IWsDOMRuntimeInfo;
import org.eclipse.jst.ws.jaxws.dom.runtime.registry.WsDOMRuntimeRegistry;
import org.eclipse.jst.ws.jaxws.utils.ContractChecker;
import org.eclipse.jst.ws.jaxws.utils.facets.FacetUtils;
import org.eclipse.jst.ws.jaxws.utils.logging.Logger;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.navigator.CommonNavigator;
import org.eclipse.ui.navigator.CommonViewer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DOMAdapterFactoryContentProvider
extends AdapterFactoryContentProvider {
    private Map<IWsDOMRuntimeExtension, IWsDomLoadListener> loadListeners = new HashMap<IWsDOMRuntimeExtension, IWsDomLoadListener>();

    public DOMAdapterFactoryContentProvider() {
        this((AdapterFactory)CustomDomItemProviderAdapterFactory.INSTANCE);
    }

    public DOMAdapterFactoryContentProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    public Object[] getChildren(Object context) {
        if (context instanceof IAdaptable) {
            return this.getWsProject((IProject)((IAdaptable)context).getAdapter(IProject.class));
        }
        if (context instanceof ILoadingWsProject) {
            return new Object[]{((ILoadingWsProject)context).isLoadCanceled() ? new ILoadingWsProject.ILoadingCanceled(){} : new ILoadingWsProject.ILoadingDummy(){}};
        }
        if (context instanceof IWebServiceProject) {
            return new Object[]{this.adapterFactory.adapt(context, ISEIChildList.class), this.adapterFactory.adapt(context, IWebServiceChildList.class)};
        }
        if (context instanceof IWebServiceChildList) {
            Object[] webServices = ((IWebServiceChildList)context).getWSChildList().toArray();
            int ii = 0;
            while (ii < webServices.length) {
                this.adapterFactory.adapt(webServices[ii], ITreeItemContentProvider.class);
                ++ii;
            }
            return webServices;
        }
        if (context instanceof ISEIChildList) {
            Object[] sEIs = ((ISEIChildList)context).getSEIChildList().toArray();
            int ii = 0;
            while (ii < sEIs.length) {
                this.adapterFactory.adapt(sEIs[ii], ITreeItemContentProvider.class);
                ++ii;
            }
            return sEIs;
        }
        if (context instanceof IWebService) {
            IServiceEndpointInterface sei = ((IWebService)context).getServiceEndpoint();
            if (sei == null) {
                return new Object[0];
            }
            this.adapterFactory.adapt((Notifier)sei, ITreeItemContentProvider.class);
            return new Object[]{sei};
        }
        if (context instanceof IServiceEndpointInterface) {
            return this.extractMethods((IServiceEndpointInterface)context);
        }
        if (context instanceof IWebMethod) {
            return this.extractParams((IWebMethod)context);
        }
        return new Object[0];
    }

    protected Object[] getWsProject(IProject project) {
        try {
            IWsDOMRuntimeExtension runtime = this.getSupportingRuntime(project);
            if (runtime == null) {
                return new Object[0];
            }
            IWebServiceProject wsProject = this.getWsProject(runtime.getDOM(), project);
            if (wsProject != null) {
                this.adapterFactory.adapt((Notifier)wsProject, ITreeItemContentProvider.class);
                return new Object[]{wsProject};
            }
            this.addRuntimeLoadListener(runtime);
            return new Object[]{new LoadingWsProject(project, false)};
        }
        catch (WsDOMLoadCanceledException wsDOMLoadCanceledException) {
            return new Object[]{new LoadingWsProject(project, true)};
        }
    }

    protected IWsDomLoadListener addRuntimeLoadListener(IWsDOMRuntimeExtension runtime) {
        IWsDomLoadListener loadListener = this.loadListeners.get(runtime);
        if (loadListener != null) {
            return loadListener;
        }
        loadListener = new LoadListener(runtime);
        this.loadListeners.put(runtime, loadListener);
        runtime.addLoadListener(loadListener);
        return loadListener;
    }

    protected Object[] extractMethods(IServiceEndpointInterface sei) {
        EList webMethods = sei.getWebMethods();
        for (IWebMethod webMethod : webMethods) {
            this.adapterFactory.adapt((Notifier)webMethod, ITreeItemContentProvider.class);
        }
        return webMethods.toArray();
    }

    protected Object[] extractParams(IWebMethod method) {
        EList params = method.getParameters();
        for (IWebParam webParam : params) {
            this.adapterFactory.adapt((Notifier)webParam, ITreeItemContentProvider.class);
        }
        return params.toArray();
    }

    public boolean hasChildren(Object element) {
        if (element instanceof IWebServiceProject) {
            return true;
        }
        if (element instanceof ILoadingWsProject) {
            return true;
        }
        if (element instanceof IWebServiceChildList) {
            return !((IWebServiceChildList)element).getWSChildList().isEmpty();
        }
        if (element instanceof ISEIChildList) {
            return !((ISEIChildList)element).getSEIChildList().isEmpty();
        }
        if (element instanceof IWebService) {
            return ((IWebService)element).getServiceEndpoint() != null;
        }
        if (element instanceof IServiceEndpointInterface) {
            return !((IServiceEndpointInterface)element).getWebMethods().isEmpty();
        }
        if (element instanceof IWebMethod) {
            return !((IWebMethod)element).getParameters().isEmpty();
        }
        return false;
    }

    protected IWebServiceProject getWsProject(IDOM dom, IProject project) {
        if (dom == null) {
            return null;
        }
        for (IWebServiceProject wsProject : dom.getWebServiceProjects()) {
            if (!wsProject.getName().equals(project.getName())) continue;
            return wsProject;
        }
        return null;
    }

    protected IWsDOMRuntimeExtension getSupportingRuntime(IProject project) {
        Collection domRuntimeInfos = WsDOMRuntimeRegistry.getRegisteredRuntimesInfo();
        for (IWsDOMRuntimeInfo domRuntimeInfo : domRuntimeInfos) {
            Map facets = domRuntimeInfo.getProjectFacets();
            if (!this.hasFacet(facets, project)) continue;
            return this.getDomRuntime(domRuntimeInfo.getId());
        }
        return null;
    }

    protected boolean hasFacet(Map<String, String> facets, IProject project) {
        for (String facetId : facets.keySet()) {
            if (facetId == null || facets.get(facetId) == null) continue;
            try {
                if (!new FacetUtils().hasFacetWithVersion(project, facets.get(facetId), facetId, true)) continue;
                return true;
            }
            catch (CoreException e) {
                new Logger().logError(e.getMessage(), (Throwable)e);
            }
        }
        return false;
    }

    protected IWsDOMRuntimeExtension getDomRuntime(String runtimeId) {
        return WsDOMRuntimeManager.instance().getDOMRuntime(runtimeId);
    }

    protected class LoadListener
    implements IWsDomLoadListener {
        private final IWsDOMRuntimeExtension runtime;

        public LoadListener(IWsDOMRuntimeExtension runtime) {
            ContractChecker.nullCheckParam((Object)runtime, (String)"runtime");
            this.runtime = runtime;
        }

        public void finished() {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    IViewPart viewPart = ProjectExplorerUtil.INSTANCE.findProjectExplorer();
                    if (viewPart instanceof CommonNavigator) {
                        CommonViewer commonViewer = ((CommonNavigator)viewPart).getCommonViewer();
                        TreeItem[] treeItemArray = commonViewer.getTree().getItems();
                        int n = treeItemArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            TreeItem item = treeItemArray[n2];
                            LoadListener.this.exchangeDummy(item, commonViewer);
                            ++n2;
                        }
                    }
                }
            });
        }

        protected void exchangeDummy(TreeItem treeItem, CommonViewer commonViewer) {
            if (treeItem == null || treeItem.getData() instanceof IWebServiceProject) {
                return;
            }
            if (treeItem.getData() instanceof ILoadingWsProject) {
                this.exchangeTreeItemData(treeItem, commonViewer);
            } else {
                TreeItem[] treeItemArray = treeItem.getItems();
                int n = treeItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TreeItem child = treeItemArray[n2];
                    this.exchangeDummy(child, commonViewer);
                    ++n2;
                }
            }
        }

        private void exchangeTreeItemData(TreeItem treeItem, CommonViewer commonViewer) {
            ILoadingWsProject loadingProject = (ILoadingWsProject)treeItem.getData();
            try {
                IWebServiceProject wsProject = DOMAdapterFactoryContentProvider.this.getWsProject(this.runtime.getDOM(), loadingProject.getProject());
                DOMAdapterFactoryContentProvider.this.adapterFactory.adapt((Notifier)wsProject, ITreeItemContentProvider.class);
                treeItem.setData((Object)wsProject);
            }
            catch (WsDOMLoadCanceledException wsDOMLoadCanceledException) {
                treeItem.setData((Object)new LoadingWsProject(loadingProject.getProject(), true));
            }
            commonViewer.refresh((Object)loadingProject.getProject());
        }

        public void started() {
        }
    }

    private class LoadingWsProject
    implements ILoadingWsProject {
        final IProject project;
        final boolean isCanceled;

        public LoadingWsProject(IProject project, boolean isCanceled) {
            ContractChecker.nullCheckParam((Object)project, (String)"project");
            this.project = project;
            this.isCanceled = isCanceled;
        }

        public IProject getProject() {
            return this.project;
        }

        public boolean isLoadCanceled() {
            return this.isCanceled;
        }
    }
}

