/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.provisional.commons.ui;

import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.forms.widgets.ImageHyperlink;

public class ScalingHyperlink
extends ImageHyperlink {
    private boolean strikeThrough;
    protected final MouseTrackListener MOUSE_TRACK_LISTENER = new MouseTrackListener(){

        public void mouseEnter(MouseEvent e) {
            ScalingHyperlink.this.setUnderlined(true);
        }

        public void mouseExit(MouseEvent e) {
            ScalingHyperlink.this.setUnderlined(false);
        }

        public void mouseHover(MouseEvent e) {
        }
    };

    public ScalingHyperlink(Composite parent, int style) {
        super(parent, style);
    }

    public void dispose() {
        this.removeMouseTrackListener(this.MOUSE_TRACK_LISTENER);
        super.dispose();
    }

    public boolean isStrikeThrough() {
        return this.strikeThrough;
    }

    protected void paintText(GC gc, Rectangle bounds) {
        super.paintText(gc, bounds);
        if (this.strikeThrough) {
            Point totalSize = this.computeTextSize(-1, -1);
            int textWidth = Math.min(bounds.width, totalSize.x);
            int textHeight = totalSize.y;
            int lineY = bounds.y + textHeight / 2;
            gc.drawLine(bounds.x, lineY, bounds.x + textWidth, lineY);
        }
    }

    public void setStrikeThrough(boolean strikethrough) {
        this.strikeThrough = strikethrough;
    }

    protected String shortenText(GC gc, String t, int width) {
        if (t == null) {
            return null;
        }
        if ((this.getStyle() & 0x8000) != 0) {
            return t;
        }
        String returnText = t;
        if (gc.textExtent((String)t).x > width) {
            int i = t.length();
            while (i > 0) {
                String test = t.substring(0, i);
                test = String.valueOf(test) + "...";
                if (gc.textExtent((String)test).x < width) {
                    returnText = test;
                    break;
                }
                --i;
            }
        }
        return returnText;
    }
}

