/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.widget;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class ComboBoxCellEditor
extends CellEditor {
    private String valueAuto = "";
    private boolean isAutoAdded = false;
    private CCombo comboBox;
    private String[] items;
    private Map itemKeyMap;
    private Map valueKeyMap;
    int selection;
    private Composite composite;
    private int inProcessing = 0;
    private Composite editor;
    private Object value = null;
    private static final int defaultStyle = 0;

    public ComboBoxCellEditor(Composite parent) {
        super(parent);
        this.setStyle(0);
    }

    public ComboBoxCellEditor(Composite parent, String[] items) {
        this(parent, items, 0);
    }

    public ComboBoxCellEditor(Composite parent, String[] items, String[] values) {
        this(parent, items, values, 0);
    }

    public ComboBoxCellEditor(Composite parent, String[] items, int style) {
        this(parent, items, null, style);
    }

    public ComboBoxCellEditor(Composite parent, String[] items, String[] values, int style) {
        super(parent, style);
        int i;
        if (items != null) {
            if (values != null) {
                assert (values.length == items.length);
                this.itemKeyMap = new HashMap();
                this.valueKeyMap = new HashMap();
                i = 0;
                while (i < items.length) {
                    this.itemKeyMap.put(items[i], values[i]);
                    this.valueKeyMap.put(values[i], items[i]);
                    ++i;
                }
            }
            Arrays.sort(items);
        }
        if ((style & 8) != 0) {
            i = 0;
            while (i < items.length) {
                String item = items[i];
                if (item.equalsIgnoreCase(this.valueAuto)) {
                    this.setItems(items);
                    return;
                }
                ++i;
            }
            List<String> aList = Arrays.asList(items);
            ArrayList<String> tmpList = new ArrayList<String>();
            tmpList.add(0, this.valueAuto);
            tmpList.addAll(aList);
            items = tmpList.toArray(new String[tmpList.size()]);
            this.isAutoAdded = true;
        }
        this.setItems(items);
    }

    public String[] getItems() {
        return this.items;
    }

    public void setItems(String[] items) {
        Assert.isNotNull((Object)items);
        this.items = items;
        this.populateComboBoxItems();
    }

    private void populateComboBoxItems() {
        if (this.comboBox != null && this.items != null) {
            this.comboBox.removeAll();
            int i = 0;
            while (i < this.items.length) {
                this.comboBox.add(this.items[i], i);
                ++i;
            }
            this.setValueValid(true);
            this.selection = 0;
        }
    }

    protected Control createContents(Composite cell) {
        Color bg = cell.getBackground();
        cell.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                ComboBoxCellEditor.this.focusLost();
            }
        });
        this.composite = new Composite(cell, this.getStyle());
        this.composite.setBackground(bg);
        this.composite.setLayout((Layout)new FillLayout());
        this.comboBox = new CCombo(this.composite, this.getStyle());
        this.comboBox.setVisibleItemCount(30);
        this.comboBox.setBackground(bg);
        this.comboBox.setFont(cell.getFont());
        this.comboBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent event) {
                ComboBoxCellEditor.this.applyEditorValueAndDeactivate();
            }

            public void widgetSelected(SelectionEvent event) {
                ComboBoxCellEditor.this.selection = ComboBoxCellEditor.this.comboBox.getSelectionIndex();
            }
        });
        this.comboBox.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                ComboBoxCellEditor.this.keyReleaseOccured(e);
            }
        });
        this.comboBox.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 2 || e.detail == 4) {
                    e.doit = false;
                }
            }
        });
        this.comboBox.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                ComboBoxCellEditor.this.focusLost();
            }
        });
        this.comboBox.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String valueText = ComboBoxCellEditor.this.comboBox.getText().trim();
                if (valueText.length() != 0 && !valueText.equals("NewParameter")) {
                    int i = 0;
                    ++i;
                }
                String typedValue = valueText;
                boolean oldValidState = ComboBoxCellEditor.this.isValueValid();
                boolean newValidState = ComboBoxCellEditor.this.isCorrect(typedValue);
                if (!newValidState) {
                    ComboBoxCellEditor.this.setErrorMessage(MessageFormat.format(ComboBoxCellEditor.this.getErrorMessage(), valueText));
                }
                String tmpValue = null;
                if (ComboBoxCellEditor.this.itemKeyMap != null) {
                    tmpValue = (String)ComboBoxCellEditor.this.itemKeyMap.get(valueText);
                }
                if (tmpValue == null) {
                    if (valueText.equals(ComboBoxCellEditor.this.valueAuto) && ComboBoxCellEditor.this.isAutoAdded) {
                        ComboBoxCellEditor.this.value = null;
                    } else {
                        ComboBoxCellEditor.this.value = valueText;
                    }
                } else {
                    ComboBoxCellEditor.this.value = tmpValue;
                }
                ComboBoxCellEditor.this.valueChanged(oldValidState, newValidState);
            }
        });
        return this.composite;
    }

    void applyEditorValueAndDeactivate() {
        this.inProcessing = 1;
        this.doValueChanged();
        this.fireApplyEditorValue();
        this.deactivate();
        this.inProcessing = 0;
    }

    protected void updateContents(Object value) {
        String item;
        if (this.comboBox == null) {
            return;
        }
        String text = "";
        if (value != null) {
            text = value.toString();
        }
        int index = -1;
        if (value == null && this.isAutoAdded) {
            index = this.comboBox.indexOf(this.valueAuto);
        } else if (this.valueKeyMap != null && (item = (String)this.valueKeyMap.get(value)) != null) {
            index = this.comboBox.indexOf(item);
        }
        if (index >= 0) {
            text = this.comboBox.getItem(index);
        }
        this.comboBox.setText(text);
    }

    protected void keyReleaseOccured(KeyEvent keyEvent) {
        if (keyEvent.character == '\u001b') {
            this.fireCancelEditor();
        } else if (keyEvent.character == '\t') {
            this.applyEditorValueAndDeactivate();
        } else if (keyEvent.character == '\r') {
            this.applyEditorValueAndDeactivate();
        }
    }

    protected void focusLost() {
        if (this.inProcessing == 1) {
            return;
        }
        super.focusLost();
    }

    protected void doSetFocus() {
        this.comboBox.setFocus();
    }

    protected void doValueChanged() {
        if (this.selection != this.comboBox.getSelectionIndex()) {
            this.markDirty();
        }
        this.selection = this.comboBox.getSelectionIndex();
        String newValue = null;
        if (this.selection == -1) {
            newValue = this.comboBox.getText();
        } else if (this.itemKeyMap != null) {
            newValue = this.itemKeyMap.get(this.comboBox.getItem(this.selection));
        } else {
            newValue = this.comboBox.getItem(this.selection);
            if (this.isAutoAdded && newValue.equals(this.valueAuto)) {
                newValue = null;
            }
        }
        boolean newValidState = this.isCorrect(newValue);
        if (newValidState) {
            this.doSetValue(newValue);
            this.markDirty();
        }
    }

    protected Control createControl(Composite parent) {
        Font font = parent.getFont();
        Color bg = parent.getBackground();
        this.editor = new Composite(parent, this.getStyle());
        this.editor.setFont(font);
        this.editor.setBackground(bg);
        this.editor.setLayout((Layout)new FillLayout());
        this.createContents(this.editor);
        this.updateContents(this.value);
        this.setValueValid(true);
        return this.editor;
    }

    protected Object doGetValue() {
        return this.value;
    }

    protected void doSetValue(Object value) {
        this.value = value;
        this.updateContents(value);
    }
}

