/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.property.widgets;

import com.ibm.icu.util.ULocale;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.util.NumberUtil;
import org.eclipse.birt.report.model.api.DesignEngine;
import org.eclipse.birt.report.model.api.metadata.IChoice;
import org.eclipse.birt.report.model.api.metadata.IChoiceSet;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.i18n.ThreadResources;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.SelectionStatusDialog;

public class DimensionBuilderDialog
extends SelectionStatusDialog {
    private static String TITLE = Messages.getString((String)"DimensionBuilderDialog.Title");
    private static String LABEL_MEASURE = Messages.getString((String)"DimensionBuilderDialog.LabelMeasure");
    private static String LABEL_UNIT = Messages.getString((String)"DimensionBuilderDialog.LabelUnit");
    private Button[] units = new Button[0];
    private String[] unitNames;
    private Text measure = null;
    private Object measureData = "";
    private String unitName;
    private int unitIndex = 0;

    public DimensionBuilderDialog(Shell parent) {
        super(parent);
        this.setTitle(TITLE);
    }

    protected void computeResult() {
        try {
            this.measureData = StringUtil.parseInput((String)this.measure.getText(), (ULocale)ThreadResources.getLocale());
        }
        catch (PropertyValueException propertyValueException) {}
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite.setLayout((Layout)gridLayout);
        this.createMeasureField(composite);
        this.createUnitGroup(composite);
        if (this.getUnitName() == null) {
            this.setUnitName(this.units[0].getData().toString());
            this.units[0].setSelection(true);
        }
        this.measure.setFocus();
        UIUtil.bindHelp((Control)parent, "org.eclipse.birt.cshelp.DimensionBuilderDialog_ID");
        return composite;
    }

    private void createMeasureField(Composite composite) {
        new Label(composite, 0).setText(LABEL_MEASURE);
        this.measure = new Text(composite, 2052);
        GridData gridData = new GridData(256);
        gridData.horizontalSpan = 2;
        this.measure.setLayoutData((Object)gridData);
        this.measure.setFont(composite.getFont());
        if (this.measureData != null && this.measureData != "") {
            this.measure.setText(NumberUtil.double2LocaleNum((double)((Double)this.measureData)));
        }
        this.measure.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                boolean doit = false;
                char eChar = e.character;
                System.out.print(eChar + '\u0000');
                String validChars = "0123456789,.\b";
                if (e.keyCode == 127 || validChars.indexOf(eChar) >= 0) {
                    doit = true;
                }
                e.doit = doit;
            }
        });
    }

    private void createUnitGroup(Composite composite) {
        Label unitLabel = new Label(composite, 0);
        unitLabel.setText(LABEL_UNIT);
        GridData gridData = new GridData(256);
        gridData.horizontalSpan = 2;
        unitLabel.setLayoutData((Object)gridData);
        IChoiceSet choiceSet = DesignEngine.getMetaDataDictionary().getChoiceSet("units");
        this.units = new Button[this.unitNames.length];
        int i = 0;
        while (i < this.units.length) {
            this.units[i] = new Button(composite, 16);
            IChoice choice = choiceSet.findChoice(this.unitNames[i]);
            if (choice != null) {
                this.units[i].setData((Object)choice.getName());
                this.units[i].setText(choice.getDisplayName());
            } else {
                this.units[i].setData((Object)this.unitNames[i]);
                this.units[i].setText(this.unitNames[i]);
            }
            if (this.units[i].getData().equals(this.getUnitName())) {
                this.units[i].setSelection(true);
                this.unitIndex = i;
            }
            final int currentUnitData = i;
            this.units[i].addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    DimensionBuilderDialog.this.setUnitName(DimensionBuilderDialog.this.units[currentUnitData].getData().toString());
                    DimensionBuilderDialog.this.unitIndex = currentUnitData;
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            ++i;
        }
        unitLabel.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 128 && e.doit) {
                    e.detail = 0;
                    DimensionBuilderDialog.this.units[DimensionBuilderDialog.this.unitIndex].setFocus();
                }
            }
        });
    }

    public void setMeasureData(Object measureData) {
        if (measureData != null) {
            this.measureData = measureData;
        }
    }

    public void setUnitNames(String[] unitNames) {
        this.unitNames = unitNames;
    }

    public Object getMeasureData() {
        return this.measureData;
    }

    public void setUnitName(String unitName) {
        this.unitName = unitName;
    }

    public String getUnitName() {
        return this.unitName;
    }
}

