/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.editors.schematic.extensions;

import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.ui.extensions.IPropertyValue;
import org.eclipse.birt.report.model.api.metadata.DimensionValue;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;

public class PropertyValue
implements IPropertyValue {
    private String stringValue;

    public PropertyValue(String stringValue) {
        this.stringValue = stringValue;
    }

    public String getStringValue() {
        return this.stringValue;
    }

    public String getUnit() {
        if (this.stringValue == null || this.stringValue.equals("")) {
            return this.stringValue;
        }
        try {
            DimensionValue dimensionValue = DimensionValue.parse((String)this.stringValue);
            return dimensionValue.getUnits();
        }
        catch (PropertyValueException e) {
            ExceptionHandler.handle(e);
            return "";
        }
    }

    public String getMeasureValue() {
        if (this.stringValue == null || this.stringValue.equals("")) {
            return this.stringValue;
        }
        try {
            DimensionValue dimensionValue = DimensionValue.parse((String)this.stringValue);
            return Double.toString(dimensionValue.getMeasure());
        }
        catch (PropertyValueException e) {
            ExceptionHandler.handle(e);
            return "";
        }
    }
}

