/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.importer.ui;

import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.emf.importer.ImporterPlugin;
import org.eclipse.emf.importer.ui.EMFModelWizard;
import org.eclipse.emf.importer.ui.contribution.IModelImporterWizard;
import org.eclipse.emf.importer.ui.contribution.ModelImporterDescriptor;
import org.eclipse.emf.importer.ui.contribution.ModelImporterManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EMFProjectWizard
extends EMFModelWizard {
    protected IPath projectLocation;
    protected IPath projectPath;

    public EMFProjectWizard() {
        this.setWindowTitle(ImporterPlugin.INSTANCE.getString("_UI_EMFProjectWizard_title"));
    }

    @Override
    protected ImageDescriptor getDefaultImageDescriptor() {
        return ExtendedImageRegistry.INSTANCE.getImageDescriptor(ImporterPlugin.INSTANCE.getImage("full/wizban/NewEMFProject"));
    }

    @Override
    public void addPages() {
        WizardNewProjectCreationPage page = new WizardNewProjectCreationPage("NewProjectCreationPage"){

            protected boolean validatePage() {
                if (super.validatePage()) {
                    IPath locationPath = this.getLocationPath();
                    EMFProjectWizard.this.projectLocation = Platform.getLocation().equals((Object)locationPath) ? null : locationPath;
                    EMFProjectWizard.this.projectPath = this.getProjectHandle().getFullPath();
                    return true;
                }
                return false;
            }
        };
        page.setTitle(ImporterPlugin.INSTANCE.getString("_UI_EMFProjectWizard_name"));
        page.setDescription(ImporterPlugin.INSTANCE.getString("_UI_CreateEMFProject_label"));
        this.addPage((IWizardPage)page);
        if (this.defaultPath != null) {
            String path = this.defaultPath.removeLastSegments(this.defaultPath.segmentCount() - 1).toString();
            page.setInitialProjectName(path.charAt(0) == '/' ? path.substring(1) : path);
            page.setPageComplete(page.isPageComplete());
        }
        this.addSelectionPage();
    }

    @Override
    protected List<ModelImporterDescriptor> getModelImporterDescriptors() {
        return ModelImporterManager.INSTANCE.filterModelImporterDescriptors(1);
    }

    @Override
    protected void adjustModelImporterWizard(IModelImporterWizard modelImporterWizard, ModelImporterDescriptor modelImporterDescriptor) {
        super.adjustModelImporterWizard(modelImporterWizard, modelImporterDescriptor);
        if (this.isValidNewValue(this.projectLocation, modelImporterWizard.getGenModelProjectLocation())) {
            modelImporterWizard.setGenModelProjectLocation(this.projectLocation);
        }
        if (this.isValidNewValue(this.projectPath, modelImporterWizard.getGenModelProjectPath())) {
            modelImporterWizard.setGenModelProjectPath(this.projectPath);
        }
    }
}

