/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.debug.internal.core.model;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IRegisterGroup;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.jsdt.debug.core.jsdi.Location;
import org.eclipse.wst.jsdt.debug.core.jsdi.ScriptReference;
import org.eclipse.wst.jsdt.debug.core.jsdi.StackFrame;
import org.eclipse.wst.jsdt.debug.core.jsdi.Variable;
import org.eclipse.wst.jsdt.debug.core.model.IJavaScriptStackFrame;
import org.eclipse.wst.jsdt.debug.core.model.IJavaScriptValue;
import org.eclipse.wst.jsdt.debug.internal.core.model.JavaScriptDebugElement;
import org.eclipse.wst.jsdt.debug.internal.core.model.JavaScriptThread;
import org.eclipse.wst.jsdt.debug.internal.core.model.JavaScriptVariable;
import org.eclipse.wst.jsdt.debug.internal.core.model.ModelMessages;

public final class JavaScriptStackFrame
extends JavaScriptDebugElement
implements IJavaScriptStackFrame {
    private JavaScriptThread thread;
    private StackFrame stackFrame = null;
    private String name = null;
    private ArrayList variables;

    public JavaScriptStackFrame(JavaScriptThread thread, StackFrame stackFrame) {
        super(thread.getJavaScriptDebugTarget());
        this.thread = thread;
        this.stackFrame = stackFrame;
    }

    StackFrame getUnderlyingStackFrame() {
        return this.stackFrame;
    }

    public int getCharEnd() throws DebugException {
        return -1;
    }

    public int getCharStart() throws DebugException {
        return -1;
    }

    public int getLineNumber() throws DebugException {
        return this.stackFrame.location() != null ? this.stackFrame.location().lineNumber() : -1;
    }

    public String getName() throws DebugException {
        if (this.name == null) {
            this.name = NLS.bind((String)ModelMessages.JSDIStackFrame_stackframe_name, (Object[])new String[]{this.stackFrame.location().scriptReference().sourceURI().toString(), Integer.toString(this.stackFrame.location().lineNumber())});
        }
        return this.name;
    }

    public IRegisterGroup[] getRegisterGroups() throws DebugException {
        return null;
    }

    public IThread getThread() {
        return this.thread;
    }

    public synchronized IVariable[] getVariables() throws DebugException {
        if (this.variables == null) {
            List underlyingVariables = this.stackFrame.variables();
            this.variables = new ArrayList(underlyingVariables.size() + 1);
            Iterator iterator = underlyingVariables.iterator();
            while (iterator.hasNext()) {
                Variable variable = (Variable)iterator.next();
                JavaScriptVariable jsdiVariable = new JavaScriptVariable(this, variable);
                this.variables.add(jsdiVariable);
            }
            Collections.sort(this.variables, new Comparator(){

                public int compare(Object arg0, Object arg1) {
                    IVariable var0 = (IVariable)arg0;
                    IVariable var1 = (IVariable)arg1;
                    try {
                        return var0.getName().compareToIgnoreCase(var1.getName());
                    }
                    catch (DebugException debugException) {
                        return 0;
                    }
                }
            });
            this.variables.add(0, new JavaScriptVariable(this, this.stackFrame.thisObject()));
        }
        return this.variables.toArray(new IVariable[this.variables.size()]);
    }

    public boolean hasRegisterGroups() throws DebugException {
        return false;
    }

    public boolean hasVariables() throws DebugException {
        return this.stackFrame.variables().size() > 0;
    }

    public boolean canStepInto() {
        return this.thread.canStepInto();
    }

    public boolean canStepOver() {
        return this.thread.canStepOver();
    }

    public boolean canStepReturn() {
        return this.thread.canStepReturn();
    }

    public boolean isStepping() {
        return this.thread.isStepping();
    }

    public void stepInto() throws DebugException {
        this.thread.stepInto();
    }

    public void stepOver() throws DebugException {
        this.thread.stepOver();
    }

    public void stepReturn() throws DebugException {
        this.thread.stepReturn();
    }

    public boolean canResume() {
        return this.thread.canResume();
    }

    public boolean canSuspend() {
        return this.thread.canSuspend();
    }

    public boolean isSuspended() {
        return this.thread.isSuspended();
    }

    public void resume() throws DebugException {
        this.thread.resume();
    }

    public void suspend() throws DebugException {
        this.thread.suspend();
    }

    public boolean canTerminate() {
        return this.thread.canTerminate();
    }

    public boolean isTerminated() {
        return this.thread.isTerminated();
    }

    public void terminate() throws DebugException {
        if (this.thread.canTerminate()) {
            this.thread.terminate();
        } else {
            this.getJavaScriptDebugTarget().terminate();
        }
    }

    public IJavaScriptValue evaluate(String expression) {
        return this.thread.evaluate(expression);
    }

    public String getSourceName() {
        ScriptReference script;
        Location loc = this.getUnderlyingStackFrame().location();
        if (loc != null && (script = loc.scriptReference()) != null) {
            return URIUtil.lastSegment((URI)script.sourceURI());
        }
        return null;
    }

    public String getSourcePath() {
        ScriptReference script;
        Location loc = this.getUnderlyingStackFrame().location();
        if (loc != null && (script = loc.scriptReference()) != null) {
            return script.sourceURI().toString();
        }
        return null;
    }

    public String getSource() {
        ScriptReference script;
        Location loc = this.getUnderlyingStackFrame().location();
        if (loc != null && (script = loc.scriptReference()) != null) {
            return script.source();
        }
        return null;
    }
}

