/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.mpc.ui.wizards;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.epp.internal.mpc.core.service.Node;
import org.eclipse.epp.internal.mpc.core.util.TextUtil;
import org.eclipse.epp.internal.mpc.ui.MarketplaceClientUiPlugin;
import org.eclipse.epp.internal.mpc.ui.util.Util;
import org.eclipse.epp.internal.mpc.ui.wizards.IMarketplaceWebBrowser;
import org.eclipse.epp.internal.mpc.ui.wizards.ItemButtonController;
import org.eclipse.epp.internal.mpc.ui.wizards.MarketplaceViewer;
import org.eclipse.epp.internal.mpc.ui.wizards.Messages;
import org.eclipse.epp.internal.mpc.ui.wizards.Operation;
import org.eclipse.epp.internal.mpc.ui.wizards.OverviewToolTip;
import org.eclipse.equinox.internal.p2.discovery.AbstractCatalogSource;
import org.eclipse.equinox.internal.p2.discovery.model.CatalogItem;
import org.eclipse.equinox.internal.p2.discovery.model.Overview;
import org.eclipse.equinox.internal.p2.ui.discovery.wizards.AbstractDiscoveryItem;
import org.eclipse.equinox.internal.p2.ui.discovery.wizards.DiscoveryResources;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiscoveryItem<T extends CatalogItem>
extends AbstractDiscoveryItem<T>
implements PropertyChangeListener {
    private static final int MAX_IMAGE_HEIGHT = 40;
    private static final int MAX_IMAGE_WIDTH = 55;
    private Composite checkboxContainer;
    private final CatalogItem connector;
    private Label description;
    private Label iconLabel;
    private ToolItem infoButton;
    private Label nameLabel;
    private Link providerLabel;
    private final IShellProvider shellProvider;
    private ToolItem updateButton;
    private final MarketplaceViewer viewer;
    private ItemButtonController buttonController;
    private Link installInfoLink;
    private final IMarketplaceWebBrowser browser;

    public DiscoveryItem(Composite parent, int style, DiscoveryResources resources, IShellProvider shellProvider, IMarketplaceWebBrowser browser, T connector, MarketplaceViewer viewer) {
        super(parent, style, resources, connector);
        this.shellProvider = shellProvider;
        this.browser = browser;
        this.connector = connector;
        this.viewer = viewer;
        connector.addPropertyChangeListener((PropertyChangeListener)this);
        this.addDisposeListener(new DisposeListener((CatalogItem)connector){
            private final /* synthetic */ CatalogItem val$connector;
            {
                this.val$connector = catalogItem;
            }

            public void widgetDisposed(DisposeEvent e) {
                this.val$connector.removePropertyChangeListener((PropertyChangeListener)DiscoveryItem.this);
            }
        });
        this.createContent();
    }

    private void createContent() {
        GridLayout layout = new GridLayout(3, false);
        layout.marginLeft = 7;
        layout.marginTop = 2;
        layout.marginBottom = 2;
        this.setLayout((Layout)layout);
        this.checkboxContainer = new Composite((Composite)this, 0);
        GridDataFactory.swtDefaults().align(0x1000000, 1).span(1, 2).applyTo((Control)this.checkboxContainer);
        GridLayoutFactory.fillDefaults().applyTo(this.checkboxContainer);
        this.iconLabel = new Label(this.checkboxContainer, 0);
        GridDataFactory.swtDefaults().align(0x1000000, 0x1000000).hint(55, 40).minSize(55, 40).applyTo((Control)this.iconLabel);
        if (this.connector.getIcon() != null) {
            try {
                Image image = this.resources.getIconImage(this.connector.getSource(), this.connector.getIcon(), 32, false);
                Rectangle bounds = image.getBounds();
                if (bounds.width > 55 || bounds.height > 40) {
                    Image scaledImage;
                    image = scaledImage = Util.scaleImage(image, 55, 40);
                    this.iconLabel.addDisposeListener(new DisposeListener(){

                        public void widgetDisposed(DisposeEvent e) {
                            scaledImage.dispose();
                        }
                    });
                }
                this.iconLabel.setImage(image);
            }
            catch (SWTException image) {
                // empty catch block
            }
        }
        if (this.iconLabel.getImage() == null) {
            this.iconLabel.setImage(MarketplaceClientUiPlugin.getInstance().getImageRegistry().get("NO_ICON_PROVIDED"));
        }
        this.nameLabel = new Label((Composite)this, 0);
        GridDataFactory.fillDefaults().grab(true, false).align(1, 0x1000000).applyTo((Control)this.nameLabel);
        this.nameLabel.setFont(this.resources.getSmallHeaderFont());
        this.nameLabel.setText(this.connector.getName());
        if (this.hasTooltip(this.connector) || this.connector.isInstalled()) {
            ToolBar toolBar = new ToolBar((Composite)this, 0x800000);
            GridDataFactory.fillDefaults().align(0x1000008, 0x1000000).applyTo((Control)toolBar);
            if (this.hasTooltip(this.connector)) {
                this.infoButton = new ToolItem(toolBar, 8);
                this.infoButton.setImage(this.resources.getInfoImage());
                this.infoButton.setToolTipText(Messages.DiscoveryItem_showOverview);
                this.hookTooltip((Control)toolBar, (Widget)this.infoButton, (Control)this, (Control)this.nameLabel, this.connector.getSource(), this.connector.getOverview(), null);
            }
        } else {
            Label label = new Label((Composite)this, 0);
            label.setText(" ");
        }
        this.description = new Label((Composite)this, 64);
        GridDataFactory.fillDefaults().grab(true, false).span(2, 1).hint(100, -1).applyTo((Control)this.description);
        String descriptionText = this.connector.getDescription();
        int maxDescriptionLength = 162;
        descriptionText = descriptionText == null ? "" : TextUtil.stripHtmlMarkup((String)descriptionText).trim();
        if (descriptionText.length() > maxDescriptionLength) {
            int truncationIndex;
            int x = truncationIndex = maxDescriptionLength;
            while (x > 0) {
                if (Character.isWhitespace(descriptionText.charAt(x))) {
                    truncationIndex = x;
                    break;
                }
                --x;
            }
            descriptionText = String.valueOf(descriptionText.substring(0, truncationIndex)) + Messages.DiscoveryItem_truncatedTextSuffix;
        }
        this.description.setText(descriptionText.replaceAll("(\\r\\n)|\\n|\\r|\\s{2,}", " "));
        new Label((Composite)this, 0).setText(" ");
        Composite composite = new Composite((Composite)this, 0);
        GridDataFactory.fillDefaults().span(2, 1).grab(true, false).applyTo((Control)composite);
        this.createProviderLabel(composite);
        if (this.hasInstallMetadata()) {
            Button button = new Button(composite, 0);
            Button secondaryButton = null;
            if (this.connector.isInstalled()) {
                secondaryButton = new Button(composite, 0);
            }
            this.buttonController = new ItemButtonController(this.viewer, this, button, secondaryButton);
            GridDataFactory.swtDefaults().align(0x1000008, 0x1000000).applyTo((Control)button);
            if (secondaryButton != null) {
                GridDataFactory.swtDefaults().align(0x1000008, 0x1000000).applyTo((Control)secondaryButton);
            }
        } else {
            this.installInfoLink = new Link(composite, 0);
            this.installInfoLink.setText(Messages.DiscoveryItem_installInstructions);
            this.installInfoLink.setToolTipText(Messages.DiscoveryItem_installInstructionsTooltip);
            this.installInfoLink.setBackground(null);
            this.installInfoLink.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    DiscoveryItem.this.browser.openUrl(((Node)DiscoveryItem.this.connector.getData()).getUrl());
                }
            });
            GridDataFactory.swtDefaults().align(0x1000008, 0x1000000).applyTo((Control)this.installInfoLink);
        }
        GridLayoutFactory.fillDefaults().numColumns(composite.getChildren().length).margins(0, 0).spacing(5, 0).applyTo(composite);
    }

    private boolean hasInstallMetadata() {
        return !this.connector.getInstallableUnits().isEmpty() && this.connector.getSiteUrl() != null;
    }

    protected void createProviderLabel(Composite parent) {
        this.providerLabel = new Link(parent, 131072);
        GridDataFactory.fillDefaults().span(1, 1).align(1, 0x1000000).grab(true, false).applyTo((Control)this.providerLabel);
        this.providerLabel.setForeground(this.resources.getColorDisabled());
        this.providerLabel.setText(NLS.bind((String)Messages.DiscoveryItem_byProviderLicense, (Object)this.connector.getProvider(), (Object)this.connector.getLicense()));
    }

    protected boolean hasTooltip(CatalogItem connector) {
        return connector.getOverview() != null && connector.getOverview().getSummary() != null && connector.getOverview().getSummary().length() > 0;
    }

    protected boolean maybeModifySelection(Operation operation) {
        this.viewer.modifySelection(this.connector, operation);
        return true;
    }

    public boolean isSelected() {
        return ((CatalogItem)this.getData()).isSelected();
    }

    public Operation getOperation() {
        return this.viewer.getSelectionModel().getOperation((CatalogItem)this.getData());
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (!this.isDisposed()) {
            this.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    if (!DiscoveryItem.this.isDisposed()) {
                        DiscoveryItem.this.refresh();
                    }
                }
            });
        }
    }

    protected void refresh() {
        Color foreground = this.getForeground();
        this.nameLabel.setForeground(foreground);
        this.description.setForeground(foreground);
        if (this.installInfoLink != null) {
            this.installInfoLink.setForeground(foreground);
        }
        if (this.buttonController != null) {
            this.buttonController.refresh();
        }
    }

    private void hookRecursively(Control control, Listener listener) {
        control.addListener(12, listener);
        control.addListener(32, listener);
        control.addListener(5, listener);
        control.addListener(7, listener);
        control.addListener(3, listener);
        control.addListener(37, listener);
        if (control instanceof Composite) {
            Control[] controlArray = ((Composite)control).getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                this.hookRecursively(child, listener);
                ++n2;
            }
        }
    }

    protected void hookTooltip(Control parent, Widget tipActivator, final Control exitControl, final Control titleControl, AbstractCatalogSource source, Overview overview, Image image) {
        final OverviewToolTip toolTip = new OverviewToolTip(parent, this.browser, source, overview, image);
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 32: {
                        toolTip.show(titleControl);
                        break;
                    }
                    case 12: 
                    case 37: {
                        toolTip.hide();
                    }
                }
            }
        };
        tipActivator.addListener(12, listener);
        tipActivator.addListener(37, listener);
        if (image != null) {
            tipActivator.addListener(32, listener);
        }
        Listener selectionListener = new Listener(){

            public void handleEvent(Event event) {
                toolTip.show(titleControl);
            }
        };
        tipActivator.addListener(13, selectionListener);
        Listener exitListener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 37: {
                        toolTip.hide();
                        break;
                    }
                    case 7: {
                        Rectangle containerBounds = exitControl.getBounds();
                        Point displayLocation = exitControl.getParent().toDisplay(containerBounds.x, containerBounds.y);
                        containerBounds.x = displayLocation.x;
                        containerBounds.y = displayLocation.y;
                        if (containerBounds.contains(Display.getCurrent().getCursorLocation())) break;
                        toolTip.hide();
                    }
                }
            }
        };
        this.hookRecursively(exitControl, exitListener);
    }
}

