/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.AutoKeyInfo;
import oracle.jdbc.driver.BaseResultSet;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.internal.OracleConnection;
import oracle.sql.ARRAY;
import oracle.sql.BFILE;
import oracle.sql.BLOB;
import oracle.sql.CHAR;
import oracle.sql.CLOB;
import oracle.sql.CustomDatum;
import oracle.sql.CustomDatumFactory;
import oracle.sql.DATE;
import oracle.sql.Datum;
import oracle.sql.INTERVALDS;
import oracle.sql.INTERVALYM;
import oracle.sql.NUMBER;
import oracle.sql.OPAQUE;
import oracle.sql.ORAData;
import oracle.sql.ORADataFactory;
import oracle.sql.RAW;
import oracle.sql.REF;
import oracle.sql.ROWID;
import oracle.sql.STRUCT;
import oracle.sql.TIMESTAMP;
import oracle.sql.TIMESTAMPLTZ;
import oracle.sql.TIMESTAMPTZ;

class OracleReturnResultSet
extends BaseResultSet {
    OracleStatement statement;
    Accessor[] returnAccessors;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Thu_Aug_28_17:36:11_PDT_2008";
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;

    OracleReturnResultSet(OracleStatement oracleStatement) throws SQLException {
        this.statement = oracleStatement;
        this.closed = false;
        this.returnAccessors = new Accessor[oracleStatement.numReturnParams];
        int n2 = 0;
        for (int i2 = 0; i2 < oracleStatement.numberOfBindPositions; ++i2) {
            Accessor accessor = oracleStatement.returnParamAccessors[i2];
            if (accessor == null) continue;
            this.returnAccessors[n2++] = accessor;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean next() throws SQLException {
        PhysicalConnection physicalConnection = this.statement.connection;
        synchronized (physicalConnection) {
            if (this.closed) {
                return false;
            }
            if (!this.statement.returnParamsFetched) {
                this.statement.fetchDmlReturnParams();
                this.statement.setupReturnParamAccessors();
            }
            ++this.statement.currentRow;
            ++this.statement.totalRowsVisited;
            return this.statement.currentRow < this.statement.rowsDmlReturned;
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws SQLException {
        PhysicalConnection physicalConnection = this.statement.connection;
        synchronized (physicalConnection) {
            super.close();
            this.statement.returnResultSet = null;
            this.statement.numReturnParams = 0;
            this.statement.totalRowsVisited = 0;
            this.statement.currentRow = -1;
            this.statement.returnParamsFetched = false;
            this.statement.rowsDmlReturned = 0;
            this.statement.returnParamBytes = null;
            this.statement.returnParamChars = null;
            this.statement.returnParamIndicators = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean wasNull() throws SQLException {
        PhysicalConnection physicalConnection = this.statement.connection;
        synchronized (physicalConnection) {
            if (this.closed) {
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 11);
            }
            if (this.statement.currentRow == -1 || this.statement.lastIndex == 0) {
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 24);
            }
            return this.returnAccessors[this.statement.lastIndex - 1].isNull(this.statement.currentRow);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSetMetaData getMetaData() throws SQLException {
        PhysicalConnection physicalConnection = this.statement.connection;
        synchronized (physicalConnection) {
            if (!this.statement.isAutoGeneratedKey) {
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 23);
            }
            if (this.closed) {
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 10);
            }
            if (this.statement.closed) {
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 9);
            }
            AutoKeyInfo autoKeyInfo = this.statement.autoKeyInfo;
            autoKeyInfo.statement = this.statement;
            autoKeyInfo.connection = this.statement.connection;
            autoKeyInfo.initMetaData(this);
            return autoKeyInfo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Statement getStatement() throws SQLException {
        PhysicalConnection physicalConnection = this.statement.connection;
        synchronized (physicalConnection) {
            return this.statement;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getString(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.statement.connection;
        synchronized (physicalConnection) {
            int n3;
            if (this.closed) {
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 11);
            }
            if (n2 <= 0 || n2 > this.statement.numReturnParams) {
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 3);
            }
            if ((n3 = this.statement.currentRow) < 0) {
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 14);
            }
            this.statement.lastIndex = n2;
            return this.returnAccessors[n2 - 1].getString(n3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getBoolean(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.statement.connection;
        synchronized (physicalConnection) {
            int n3;
            if (this.closed) {
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 11);
            }
            if (n2 <= 0 || n2 > this.statement.numReturnParams) {
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 3);
            }
            if ((n3 = this.statement.currentRow) < 0) {
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 14);
            }
            this.statement.lastIndex = n2;
            return this.returnAccessors[n2 - 1].getBoolean(n3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte getByte(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.statement.connection;
        synchronized (physicalConnection) {
            int n3;
            if (this.closed) {
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 11);
            }
            if (n2 <= 0 || n2 > this.statement.numReturnParams) {
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 3);
            }
            if ((n3 = this.statement.currentRow) < 0) {
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 14);
            }
            this.statement.lastIndex = n2;
            return this.returnAccessors[n2 - 1].getByte(n3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public short getShort(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.statement.connection;
        synchronized (physicalConnection) {
            int n3;
            if (this.closed) {
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 11);
            }
            if (n2 <= 0 || n2 > this.statement.numReturnParams) {
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 3);
            }
            if ((n3 = this.statement.currentRow) < 0) {
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 14);
            }
            this.statement.lastIndex = n2;
            return this.returnAccessors[n2 - 1].getShort(n3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getInt(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.statement.connection;
        synchronized (physicalConnection) {
            int n3;
            if (this.closed) {
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 11);
            }
            if (n2 <= 0 || n2 > this.statement.numReturnParams) {
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 3);
            }
            if ((n3 = this.statement.currentRow) < 0) {
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 14);
            }
            this.statement.lastIndex = n2;
            return this.returnAccessors[n2 - 1].getInt(n3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLong(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.statement.connection;
        synchronized (physicalConnection) {
            int n3;
            if (this.closed) {
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 11);
            }
            if (n2 <= 0 || n2 > this.statement.numReturnParams) {
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 3);
            }
            if ((n3 = this.statement.currentRow) < 0) {
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 14);
            }
            this.statement.lastIndex = n2;
            return this.returnAccessors[n2 - 1].getLong(n3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float getFloat(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.statement.connection;
        synchronized (physicalConnection) {
            int n3;
            if (this.closed) {
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 11);
            }
            if (n2 <= 0 || n2 > this.statement.numReturnParams) {
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 3);
            }
            if ((n3 = this.statement.currentRow) < 0) {
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 14);
            }
            this.statement.lastIndex = n2;
            return this.returnAccessors[n2 - 1].getFloat(n3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getDouble(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.statement.connection;
        synchronized (physicalConnection) {
            int n3;
            if (this.closed) {
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 11);
            }
            if (n2 <= 0 || n2 > this.statement.numReturnParams) {
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 3);
            }
            if ((n3 = this.statement.currentRow) < 0) {
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 14);
            }
            this.statement.lastIndex = n2;
            return this.returnAccessors[n2 - 1].getDouble(n3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BigDecimal getBigDecimal(int n2, int n3) throws SQLException {
        PhysicalConnection physicalConnection = this.statement.connection;
        synchronized (physicalConnection) {
            int n4;
            if (this.closed) {
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 11);
            }
            if (n2 <= 0 || n2 > this.statement.numReturnParams) {
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 3);
            }
            if ((n4 = this.statement.currentRow) < 0) {
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 14);
            }
            this.statement.lastIndex = n2;
            return this.returnAccessors[n2 - 1].getBigDecimal(n4, n3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getBytes(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.statement.connection;
        synchronized (physicalConnection) {
            int n3;
            if (this.closed) {
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 11);
            }
            if (n2 <= 0 || n2 > this.statement.numReturnParams) {
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 3);
            }
            if ((n3 = this.statement.currentRow) < 0) {
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 14);
            }
            this.statement.lastIndex = n2;
            return this.returnAccessors[n2 - 1].getBytes(n3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Date getDate(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.statement.connection;
        synchronized (physicalConnection) {
            int n3;
            if (this.closed) {
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 11);
            }
            if (n2 <= 0 || n2 > this.statement.numReturnParams) {
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 3);
            }
            if ((n3 = this.statement.currentRow) < 0) {
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 14);
            }
            this.statement.lastIndex = n2;
            return this.returnAccessors[n2 - 1].getDate(n3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Time getTime(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.statement.connection;
        synchronized (physicalConnection) {
            int n3;
            if (this.closed) {
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 11);
            }
            if (n2 <= 0 || n2 > this.statement.numReturnParams) {
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 3);
            }
            if ((n3 = this.statement.currentRow) < 0) {
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 14);
            }
            this.statement.lastIndex = n2;
            return this.returnAccessors[n2 - 1].getTime(n3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Timestamp getTimestamp(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.statement.connection;
        synchronized (physicalConnection) {
            int n3;
            if (this.closed) {
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 11);
            }
            if (n2 <= 0 || n2 > this.statement.numReturnParams) {
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 3);
            }
            if ((n3 = this.statement.currentRow) < 0) {
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 14);
            }
            this.statement.lastIndex = n2;
            return this.returnAccessors[n2 - 1].getTimestamp(n3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getAsciiStream(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.statement.connection;
        synchronized (physicalConnection) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 23);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getUnicodeStream(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.statement.connection;
        synchronized (physicalConnection) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 23);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getBinaryStream(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.statement.connection;
        synchronized (physicalConnection) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 23);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getObject(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.statement.connection;
        synchronized (physicalConnection) {
            int n3;
            if (this.closed) {
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 11);
            }
            if (n2 <= 0 || n2 > this.statement.numReturnParams) {
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 3);
            }
            if ((n3 = this.statement.currentRow) < 0) {
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 14);
            }
            this.statement.lastIndex = n2;
            return this.returnAccessors[n2 - 1].getObject(n3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet getCursor(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.statement.connection;
        synchronized (physicalConnection) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 23);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Datum getOracleObject(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.statement.connection;
        synchronized (physicalConnection) {
            int n3;
            if (this.closed) {
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 11);
            }
            if (n2 <= 0 || n2 > this.statement.numReturnParams) {
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 3);
            }
            if ((n3 = this.statement.currentRow) < 0) {
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 14);
            }
            this.statement.lastIndex = n2;
            return this.returnAccessors[n2 - 1].getOracleObject(n3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ROWID getROWID(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.statement.connection;
        synchronized (physicalConnection) {
            int n3;
            if (this.closed) {
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 11);
            }
            if (n2 <= 0 || n2 > this.statement.numReturnParams) {
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 3);
            }
            if ((n3 = this.statement.currentRow) < 0) {
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 14);
            }
            this.statement.lastIndex = n2;
            return this.returnAccessors[n2 - 1].getROWID(n3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NUMBER getNUMBER(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.statement.connection;
        synchronized (physicalConnection) {
            int n3;
            if (this.closed) {
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 11);
            }
            if (n2 <= 0 || n2 > this.statement.numReturnParams) {
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 3);
            }
            if ((n3 = this.statement.currentRow) < 0) {
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 14);
            }
            this.statement.lastIndex = n2;
            return this.returnAccessors[n2 - 1].getNUMBER(n3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DATE getDATE(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.statement.connection;
        synchronized (physicalConnection) {
            int n3;
            if (this.closed) {
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 11);
            }
            if (n2 <= 0 || n2 > this.statement.numReturnParams) {
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 3);
            }
            if ((n3 = this.statement.currentRow) < 0) {
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 14);
            }
            this.statement.lastIndex = n2;
            return this.returnAccessors[n2 - 1].getDATE(n3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ARRAY getARRAY(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.statement.connection;
        synchronized (physicalConnection) {
            int n3;
            if (this.closed) {
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 11);
            }
            if (n2 <= 0 || n2 > this.statement.numReturnParams) {
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 3);
            }
            if ((n3 = this.statement.currentRow) < 0) {
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 14);
            }
            this.statement.lastIndex = n2;
            return this.returnAccessors[n2 - 1].getARRAY(n3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public STRUCT getSTRUCT(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.statement.connection;
        synchronized (physicalConnection) {
            int n3;
            if (this.closed) {
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 11);
            }
            if (n2 <= 0 || n2 > this.statement.numReturnParams) {
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 3);
            }
            if ((n3 = this.statement.currentRow) < 0) {
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 14);
            }
            this.statement.lastIndex = n2;
            return this.returnAccessors[n2 - 1].getSTRUCT(n3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OPAQUE getOPAQUE(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.statement.connection;
        synchronized (physicalConnection) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 23);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public REF getREF(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.statement.connection;
        synchronized (physicalConnection) {
            int n3;
            if (this.closed) {
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 11);
            }
            if (n2 <= 0 || n2 > this.statement.numReturnParams) {
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 3);
            }
            if ((n3 = this.statement.currentRow) < 0) {
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 14);
            }
            this.statement.lastIndex = n2;
            return this.returnAccessors[n2 - 1].getREF(n3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CHAR getCHAR(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.statement.connection;
        synchronized (physicalConnection) {
            int n3;
            if (this.closed) {
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 11);
            }
            if (n2 <= 0 || n2 > this.statement.numReturnParams) {
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 3);
            }
            if ((n3 = this.statement.currentRow) < 0) {
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 14);
            }
            this.statement.lastIndex = n2;
            return this.returnAccessors[n2 - 1].getCHAR(n3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RAW getRAW(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.statement.connection;
        synchronized (physicalConnection) {
            int n3;
            if (this.closed) {
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 11);
            }
            if (n2 <= 0 || n2 > this.statement.numReturnParams) {
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 3);
            }
            if ((n3 = this.statement.currentRow) < 0) {
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 14);
            }
            this.statement.lastIndex = n2;
            return this.returnAccessors[n2 - 1].getRAW(n3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BLOB getBLOB(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.statement.connection;
        synchronized (physicalConnection) {
            int n3;
            if (this.closed) {
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 11);
            }
            if (n2 <= 0 || n2 > this.statement.numReturnParams) {
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 3);
            }
            if ((n3 = this.statement.currentRow) < 0) {
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 14);
            }
            this.statement.lastIndex = n2;
            return this.returnAccessors[n2 - 1].getBLOB(n3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CLOB getCLOB(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.statement.connection;
        synchronized (physicalConnection) {
            int n3;
            if (this.closed) {
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 11);
            }
            if (n2 <= 0 || n2 > this.statement.numReturnParams) {
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 3);
            }
            if ((n3 = this.statement.currentRow) < 0) {
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 14);
            }
            this.statement.lastIndex = n2;
            return this.returnAccessors[n2 - 1].getCLOB(n3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BFILE getBFILE(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.statement.connection;
        synchronized (physicalConnection) {
            int n3;
            if (this.closed) {
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 11);
            }
            if (n2 <= 0 || n2 > this.statement.numReturnParams) {
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 3);
            }
            if ((n3 = this.statement.currentRow) < 0) {
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 14);
            }
            this.statement.lastIndex = n2;
            return this.returnAccessors[n2 - 1].getBFILE(n3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BFILE getBfile(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.statement.connection;
        synchronized (physicalConnection) {
            return this.getBFILE(n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CustomDatum getCustomDatum(int n2, CustomDatumFactory customDatumFactory) throws SQLException {
        PhysicalConnection physicalConnection = this.statement.connection;
        synchronized (physicalConnection) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 23);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ORAData getORAData(int n2, ORADataFactory oRADataFactory) throws SQLException {
        PhysicalConnection physicalConnection = this.statement.connection;
        synchronized (physicalConnection) {
            int n3;
            if (this.closed) {
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 11);
            }
            if (n2 <= 0 || n2 > this.statement.numReturnParams) {
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 3);
            }
            if ((n3 = this.statement.currentRow) < 0) {
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 14);
            }
            this.statement.lastIndex = n2;
            return this.returnAccessors[n2 - 1].getORAData(n3, oRADataFactory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getObject(int n2, Map map) throws SQLException {
        PhysicalConnection physicalConnection = this.statement.connection;
        synchronized (physicalConnection) {
            int n3;
            if (this.closed) {
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 11);
            }
            if (n2 <= 0 || n2 > this.statement.numReturnParams) {
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 3);
            }
            if ((n3 = this.statement.currentRow) < 0) {
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 14);
            }
            this.statement.lastIndex = n2;
            return this.returnAccessors[n2 - 1].getObject(n3, map);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Ref getRef(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.statement.connection;
        synchronized (physicalConnection) {
            return this.getREF(n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Blob getBlob(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.statement.connection;
        synchronized (physicalConnection) {
            return this.getBLOB(n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Clob getClob(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.statement.connection;
        synchronized (physicalConnection) {
            return this.getCLOB(n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Array getArray(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.statement.connection;
        synchronized (physicalConnection) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 23);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Reader getCharacterStream(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.statement.connection;
        synchronized (physicalConnection) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 23);
            return null;
        }
    }

    public BigDecimal getBigDecimal(int n2) throws SQLException {
        int n3;
        if (this.closed) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 11);
        }
        if (n2 <= 0 || n2 > this.statement.numReturnParams) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 3);
        }
        if ((n3 = this.statement.currentRow) < 0) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 14);
        }
        this.statement.lastIndex = n2;
        return this.returnAccessors[n2 - 1].getBigDecimal(n3);
    }

    public Date getDate(int n2, Calendar calendar) throws SQLException {
        int n3;
        if (this.closed) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 11);
        }
        if (n2 <= 0 || n2 > this.statement.numReturnParams) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 3);
        }
        if ((n3 = this.statement.currentRow) < 0) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 14);
        }
        this.statement.lastIndex = n2;
        return this.returnAccessors[n2 - 1].getDate(n3, calendar);
    }

    public Time getTime(int n2, Calendar calendar) throws SQLException {
        int n3;
        if (this.closed) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 11);
        }
        if (n2 <= 0 || n2 > this.statement.numReturnParams) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 3);
        }
        if ((n3 = this.statement.currentRow) < 0) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 14);
        }
        this.statement.lastIndex = n2;
        return this.returnAccessors[n2 - 1].getTime(n3, calendar);
    }

    public Timestamp getTimestamp(int n2, Calendar calendar) throws SQLException {
        int n3;
        if (this.closed) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 11);
        }
        if (n2 <= 0 || n2 > this.statement.numReturnParams) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 3);
        }
        if ((n3 = this.statement.currentRow) < 0) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 14);
        }
        this.statement.lastIndex = n2;
        return this.returnAccessors[n2 - 1].getTimestamp(n3, calendar);
    }

    public INTERVALYM getINTERVALYM(int n2) throws SQLException {
        int n3;
        if (this.closed) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 11);
        }
        if (n2 <= 0 || n2 > this.statement.numReturnParams) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 3);
        }
        if ((n3 = this.statement.currentRow) < 0) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 14);
        }
        this.statement.lastIndex = n2;
        return this.returnAccessors[n2 - 1].getINTERVALYM(n3);
    }

    public INTERVALDS getINTERVALDS(int n2) throws SQLException {
        int n3;
        if (this.closed) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 11);
        }
        if (n2 <= 0 || n2 > this.statement.numReturnParams) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 3);
        }
        if ((n3 = this.statement.currentRow) < 0) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 14);
        }
        this.statement.lastIndex = n2;
        return this.returnAccessors[n2 - 1].getINTERVALDS(n3);
    }

    public TIMESTAMP getTIMESTAMP(int n2) throws SQLException {
        int n3;
        if (this.closed) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 11);
        }
        if (n2 <= 0 || n2 > this.statement.numReturnParams) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 3);
        }
        if ((n3 = this.statement.currentRow) < 0) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 14);
        }
        this.statement.lastIndex = n2;
        return this.returnAccessors[n2 - 1].getTIMESTAMP(n3);
    }

    public TIMESTAMPTZ getTIMESTAMPTZ(int n2) throws SQLException {
        int n3;
        if (this.closed) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 11);
        }
        if (n2 <= 0 || n2 > this.statement.numReturnParams) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 3);
        }
        if ((n3 = this.statement.currentRow) < 0) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 14);
        }
        this.statement.lastIndex = n2;
        return this.returnAccessors[n2 - 1].getTIMESTAMPTZ(n3);
    }

    public TIMESTAMPLTZ getTIMESTAMPLTZ(int n2) throws SQLException {
        int n3;
        if (this.closed) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 11);
        }
        if (n2 <= 0 || n2 > this.statement.numReturnParams) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 3);
        }
        if ((n3 = this.statement.currentRow) < 0) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 14);
        }
        this.statement.lastIndex = n2;
        return this.returnAccessors[n2 - 1].getTIMESTAMPLTZ(n3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URL getURL(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.statement.connection;
        synchronized (physicalConnection) {
            int n3;
            if (this.closed) {
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 11);
            }
            if (n2 <= 0 || n2 > this.statement.numReturnParams) {
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 3);
            }
            if ((n3 = this.statement.currentRow) < 0) {
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 14);
            }
            this.statement.lastIndex = n2;
            return this.returnAccessors[n2 - 1].getURL(n3);
        }
    }

    public boolean isBeforeFirst() throws SQLException {
        return !this.isEmptyResultSet() && this.statement.currentRow == -1 && !this.closed;
    }

    public boolean isAfterLast() throws SQLException {
        return !this.isEmptyResultSet() && this.closed;
    }

    public boolean isFirst() throws SQLException {
        return this.getRow() == 1;
    }

    public boolean isLast() throws SQLException {
        return this.getRow() == this.statement.rowsDmlReturned;
    }

    public int getRow() throws SQLException {
        return this.statement.totalRowsVisited;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int findColumn(String string) throws SQLException {
        PhysicalConnection physicalConnection = this.statement.connection;
        synchronized (physicalConnection) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 23);
            return -1;
        }
    }

    public void setFetchSize(int n2) throws SQLException {
        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 23);
    }

    public int getFetchSize() throws SQLException {
        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 23);
        return -1;
    }

    boolean isEmptyResultSet() {
        return this.statement.rowsDmlReturned == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getCursorName() throws SQLException {
        PhysicalConnection physicalConnection = this.statement.connection;
        synchronized (physicalConnection) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 23, "getCursorName");
            return null;
        }
    }

    protected OracleConnection getConnectionDuringExceptionHandling() {
        return this.statement.getConnectionDuringExceptionHandling();
    }
}

