/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanInfo;
import javax.management.NotCompliantMBeanException;
import javax.management.StandardMBean;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.DiagnosabilityMXBean;
import oracle.jdbc.driver.OracleLog;

public class OracleDiagnosabilityMBean
extends StandardMBean
implements DiagnosabilityMXBean {
    OracleDiagnosabilityMBean() throws NotCompliantMBeanException {
        super(DiagnosabilityMXBean.class);
    }

    public boolean getLoggingEnabled() {
        return OracleLog.isEnabled();
    }

    public void setLoggingEnabled(boolean bl) {
        OracleLog.setTrace(bl);
    }

    public boolean stateManageable() {
        return false;
    }

    public boolean statisticsProvider() {
        return false;
    }

    protected String getDescription(MBeanInfo mBeanInfo) {
        return DatabaseError.findMessage("DiagnosibilityMBeanDescription", (Object)this);
    }

    protected String getDescription(MBeanConstructorInfo mBeanConstructorInfo) {
        return DatabaseError.findMessage("DiagnosibilityMBeanConstructor()", (Object)this);
    }

    protected String getDescription(MBeanAttributeInfo mBeanAttributeInfo) {
        String string = mBeanAttributeInfo.getName();
        if (string.equals("LoggingEnabled")) {
            return DatabaseError.findMessage("DiagnosibilityMBeanLoggingEnabledDescription", (Object)this);
        }
        if (string.equals("stateManageable")) {
            return DatabaseError.findMessage("DiagnosibilityMBeanStateManageableDescription", (Object)this);
        }
        if (string.equals("statisticsProvider")) {
            return DatabaseError.findMessage("DiagnosibilityMBeanStatisticsProviderDescription", (Object)this);
        }
        Logger.getLogger("oracle.jdbc.driver").log(Level.SEVERE, "Got a request to describe an unexpected  Attribute: " + string);
        return super.getDescription(mBeanAttributeInfo);
    }
}

