/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.debug.internal.ui.actions;

import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.wst.jsdt.debug.core.breakpoints.IJavaScriptBreakpoint;
import org.eclipse.wst.jsdt.debug.internal.ui.JavaScriptDebugUIPlugin;
import org.eclipse.wst.jsdt.debug.internal.ui.Messages;
import org.eclipse.wst.jsdt.debug.internal.ui.actions.BreakpointToggleAction;

public class BreakpointSuspendPolicyToggleAction
extends BreakpointToggleAction {
    private int fCurrentPolicy = 1;

    public void doAction(IJavaScriptBreakpoint breakpoint) throws CoreException {
        if (breakpoint.getSuspendPolicy() != this.fCurrentPolicy) {
            breakpoint.setSuspendPolicy(this.fCurrentPolicy);
        }
    }

    protected boolean getToggleState(IJavaScriptBreakpoint breakpoint) {
        return false;
    }

    public boolean isEnabledFor(IStructuredSelection selection) {
        Iterator iter = selection.iterator();
        while (iter.hasNext()) {
            Object element = iter.next();
            if (element instanceof IJavaScriptBreakpoint) continue;
            return false;
        }
        return true;
    }

    public void selectionChanged(IAction action, ISelection selection) {
        super.selectionChanged(action, selection);
        if (action.isEnabled()) {
            IJavaScriptBreakpoint bp = (IJavaScriptBreakpoint)((IStructuredSelection)selection).getFirstElement();
            this.update(action, bp);
        }
    }

    protected boolean isToggleAction() {
        return false;
    }

    public void update(IAction action, IJavaScriptBreakpoint breakpoint) {
        try {
            if (breakpoint.getSuspendPolicy() == 1) {
                action.setText(Messages.suspend_target);
                this.fCurrentPolicy = 2;
            } else {
                action.setText(Messages.suspend_thread);
                this.fCurrentPolicy = 1;
            }
        }
        catch (CoreException e) {
            JavaScriptDebugUIPlugin.log(e);
        }
    }
}

