/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.commands;

import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.internal.tasks.ui.ITaskAttachmentViewer;
import org.eclipse.mylyn.internal.tasks.ui.TaskAttachmentViewerManager;
import org.eclipse.mylyn.internal.tasks.ui.commands.Messages;
import org.eclipse.mylyn.internal.tasks.ui.util.AttachmentUtil;
import org.eclipse.mylyn.internal.tasks.ui.util.TasksUiInternal;
import org.eclipse.mylyn.tasks.core.ITaskAttachment;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.handlers.HandlerUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpenTaskAttachmentHandler
extends AbstractHandler
implements IHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchPage page;
        IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event);
        if (window != null && (page = window.getActivePage()) != null) {
            List<ITaskAttachment> attachments = AttachmentUtil.getSelectedAttachments(event);
            OpenTaskAttachmentHandler.openAttachments(page, attachments);
        }
        return null;
    }

    public static void openAttachments(IWorkbenchPage page, List<ITaskAttachment> attachments) {
        TaskAttachmentViewerManager manager = new TaskAttachmentViewerManager();
        for (ITaskAttachment attachment : attachments) {
            ITaskAttachmentViewer viewer = manager.getPreferredViewer(attachment);
            if (viewer == null) {
                TasksUiInternal.logAndDisplayStatus(Messages.OpenTaskAttachmentHandler_failedToOpenViewer, (IStatus)new Status(2, "org.eclipse.mylyn.tasks.ui", Messages.OpenTaskAttachmentHandler_noAttachmentViewerFound));
                continue;
            }
            try {
                viewer.openAttachment(page, attachment);
            }
            catch (CoreException e) {
                TasksUiInternal.logAndDisplayStatus(Messages.OpenTaskAttachmentHandler_failedToOpenViewer, e.getStatus());
            }
        }
    }
}

