/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui;

import java.io.File;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.mylyn.context.core.AbstractContextListener;
import org.eclipse.mylyn.context.core.ContextChangeEvent;
import org.eclipse.mylyn.context.core.ContextCore;
import org.eclipse.mylyn.context.core.IInteractionContext;
import org.eclipse.mylyn.internal.context.core.ContextCorePlugin;
import org.eclipse.mylyn.internal.monitor.ui.MonitorUiPlugin;
import org.eclipse.mylyn.internal.tasks.core.ITasksCoreConstants;
import org.eclipse.mylyn.internal.tasks.core.externalization.AbstractExternalizationParticipant;
import org.eclipse.mylyn.internal.tasks.core.externalization.ExternalizationManager;
import org.eclipse.mylyn.internal.tasks.core.externalization.IExternalizationContext;
import org.eclipse.mylyn.internal.tasks.ui.Messages;
import org.eclipse.mylyn.monitor.ui.IUserAttentionListener;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.ITaskActivityListener;
import org.eclipse.mylyn.tasks.ui.TasksUi;

public class ActiveContextExternalizationParticipant
extends AbstractExternalizationParticipant
implements ITaskActivityListener,
IUserAttentionListener {
    private boolean isDirty = false;
    private final ExternalizationManager manager;
    private long lastUpdate;
    private IInteractionContext currentlyActiveContext;
    private final AbstractContextListener listener = new AbstractContextListener(){

        public void contextChanged(ContextChangeEvent event) {
            switch (event.getEventKind()) {
                case ACTIVATED: {
                    ActiveContextExternalizationParticipant.this.currentlyActiveContext = event.getContext();
                    break;
                }
                case DEACTIVATED: {
                    ActiveContextExternalizationParticipant.this.currentlyActiveContext = null;
                    ActiveContextExternalizationParticipant.this.setDirty(false);
                }
            }
        }
    };

    public ActiveContextExternalizationParticipant(ExternalizationManager manager) {
        this.manager = manager;
    }

    public void registerListeners() {
        ContextCore.getContextManager().addListener(this.listener);
        TasksUi.getTaskActivityManager().addActivityListener((ITaskActivityListener)this);
        MonitorUiPlugin.getDefault().getActivityContextManager().addListener((IUserAttentionListener)this);
        this.currentlyActiveContext = ContextCore.getContextManager().getActiveContext();
    }

    public void dispose() {
        ContextCore.getContextManager().removeListener(this.listener);
        TasksUi.getTaskActivityManager().removeActivityListener((ITaskActivityListener)this);
        if (MonitorUiPlugin.getDefault().getActivityContextManager() != null) {
            MonitorUiPlugin.getDefault().getActivityContextManager().removeListener((IUserAttentionListener)this);
        }
    }

    public void execute(IExternalizationContext context, IProgressMonitor monitor) throws CoreException {
        Assert.isNotNull((Object)context);
        switch (context.getKind()) {
            case SAVE: {
                if (!this.shouldWriteContext()) break;
                this.setDirty(false);
                ContextCorePlugin.getContextManager().saveContext(this.currentlyActiveContext);
                break;
            }
            case LOAD: {
                break;
            }
        }
    }

    public String getDescription() {
        return Messages.ActiveContextExternalizationParticipant_Active_Task_Context;
    }

    public ISchedulingRule getSchedulingRule() {
        return ITasksCoreConstants.ACTIVE_CONTEXT_SCHEDULING_RULE;
    }

    public boolean isDirty() {
        return this.isDirty(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDirty(boolean full) {
        ActiveContextExternalizationParticipant activeContextExternalizationParticipant = this;
        synchronized (activeContextExternalizationParticipant) {
            return this.isDirty || full && this.shouldWriteContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDirty(boolean dirty) {
        ActiveContextExternalizationParticipant activeContextExternalizationParticipant = this;
        synchronized (activeContextExternalizationParticipant) {
            this.isDirty = dirty;
        }
    }

    public String getFileName() {
        return null;
    }

    public void load(File sourceFile, IProgressMonitor monitor) throws CoreException {
    }

    public void save(File targetFile, IProgressMonitor monitor) throws CoreException {
    }

    public void elapsedTimeUpdated(ITask task, long newElapsedTime) {
        if (System.currentTimeMillis() - this.lastUpdate > 180000L) {
            this.setDirty(this.shouldWriteContext());
            if (this.isDirty()) {
                this.manager.requestSave();
            }
            this.lastUpdate = System.currentTimeMillis();
        }
    }

    private boolean shouldWriteContext() {
        return ContextCorePlugin.getContextManager() != null && this.currentlyActiveContext != null && this.currentlyActiveContext.getAllElements().size() > 0;
    }

    public void activityReset() {
    }

    public void userAttentionGained() {
    }

    public void userAttentionLost() {
        this.setDirty(this.shouldWriteContext());
        if (this.isDirty()) {
            this.manager.requestSave();
        }
        this.lastUpdate = System.currentTimeMillis();
    }
}

