/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core;

import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.AssertionFailedException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.wst.jsdt.core.IIncludePathEntry;
import org.eclipse.wst.jsdt.core.IJavaScriptModelStatus;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.JavaScriptCore;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.internal.core.ClasspathEntry;
import org.eclipse.wst.jsdt.internal.core.JavaModelOperation;
import org.eclipse.wst.jsdt.internal.core.JavaModelStatus;
import org.eclipse.wst.jsdt.internal.core.JavaProject;
import org.eclipse.wst.jsdt.internal.core.util.Messages;

public class CopyPackageFragmentRootOperation
extends JavaModelOperation {
    IPath destination;
    int updateResourceFlags;
    int updateModelFlags;
    IIncludePathEntry sibling;

    public CopyPackageFragmentRootOperation(IPackageFragmentRoot root, IPath destination, int updateResourceFlags, int updateModelFlags, IIncludePathEntry sibling) {
        super(root);
        this.destination = destination;
        this.updateResourceFlags = updateResourceFlags;
        this.updateModelFlags = updateModelFlags;
        this.sibling = sibling;
    }

    protected void executeOperation() throws JavaScriptModelException {
        IPackageFragmentRoot root = (IPackageFragmentRoot)this.getElementToProcess();
        IIncludePathEntry rootEntry = root.getRawIncludepathEntry();
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        if (!root.isExternal() && (this.updateModelFlags & 1) == 0) {
            this.copyResource(root, rootEntry, workspaceRoot);
        }
        if ((this.updateModelFlags & 8) != 0) {
            this.addEntryToClasspath(rootEntry, workspaceRoot);
        }
    }

    protected void copyResource(IPackageFragmentRoot root, IIncludePathEntry rootEntry, final IWorkspaceRoot workspaceRoot) throws JavaScriptModelException {
        char[][] exclusionPatterns = ((ClasspathEntry)rootEntry).fullExclusionPatternChars();
        IResource rootResource = root.getResource();
        if (root.getKind() == 2 || exclusionPatterns == null) {
            try {
                if ((this.updateModelFlags & 0x10) != 0) {
                    if (rootEntry.getPath().equals((Object)this.destination)) {
                        return;
                    }
                    IResource destRes = workspaceRoot.findMember(this.destination);
                    if (destRes != null) {
                        destRes.delete(this.updateResourceFlags, this.progressMonitor);
                    }
                }
                rootResource.copy(this.destination, this.updateResourceFlags, this.progressMonitor);
            }
            catch (CoreException e) {
                throw new JavaScriptModelException(e);
            }
        }
        final int sourceSegmentCount = rootEntry.getPath().segmentCount();
        final IFolder destFolder = workspaceRoot.getFolder(this.destination);
        final IPath[] nestedFolders = this.getNestedFolders(root);
        IResourceProxyVisitor visitor = new IResourceProxyVisitor(){

            public boolean visit(IResourceProxy proxy) throws CoreException {
                IResource destRes;
                if (proxy.getType() == 2) {
                    IResource destRes2;
                    IPath path = proxy.requestFullPath();
                    if (CopyPackageFragmentRootOperation.this.prefixesOneOf(path, nestedFolders)) {
                        if (CopyPackageFragmentRootOperation.this.equalsOneOf(path, nestedFolders)) {
                            return false;
                        }
                        IFolder folder = destFolder.getFolder(path.removeFirstSegments(sourceSegmentCount));
                        if ((CopyPackageFragmentRootOperation.this.updateModelFlags & 0x10) != 0 && folder.exists()) {
                            return true;
                        }
                        folder.create(CopyPackageFragmentRootOperation.this.updateResourceFlags, true, CopyPackageFragmentRootOperation.this.progressMonitor);
                        return true;
                    }
                    IPath destPath = CopyPackageFragmentRootOperation.this.destination.append(path.removeFirstSegments(sourceSegmentCount));
                    if ((CopyPackageFragmentRootOperation.this.updateModelFlags & 0x10) != 0 && (destRes2 = workspaceRoot.findMember(destPath)) != null) {
                        destRes2.delete(CopyPackageFragmentRootOperation.this.updateResourceFlags, CopyPackageFragmentRootOperation.this.progressMonitor);
                    }
                    proxy.requestResource().copy(destPath, CopyPackageFragmentRootOperation.this.updateResourceFlags, CopyPackageFragmentRootOperation.this.progressMonitor);
                    return false;
                }
                IPath path = proxy.requestFullPath();
                IPath destPath = CopyPackageFragmentRootOperation.this.destination.append(path.removeFirstSegments(sourceSegmentCount));
                if ((CopyPackageFragmentRootOperation.this.updateModelFlags & 0x10) != 0 && (destRes = workspaceRoot.findMember(destPath)) != null) {
                    destRes.delete(CopyPackageFragmentRootOperation.this.updateResourceFlags, CopyPackageFragmentRootOperation.this.progressMonitor);
                }
                proxy.requestResource().copy(destPath, CopyPackageFragmentRootOperation.this.updateResourceFlags, CopyPackageFragmentRootOperation.this.progressMonitor);
                return false;
            }
        };
        try {
            rootResource.accept(visitor, 0);
        }
        catch (CoreException e) {
            throw new JavaScriptModelException(e);
        }
        CopyPackageFragmentRootOperation.setAttribute("hasModifiedResource", "true");
    }

    protected void addEntryToClasspath(IIncludePathEntry rootEntry, IWorkspaceRoot workspaceRoot) throws JavaScriptModelException {
        IIncludePathEntry newEntry;
        int position;
        IProject destProject = workspaceRoot.getProject(this.destination.segment(0));
        IJavaScriptProject jProject = JavaScriptCore.create(destProject);
        IIncludePathEntry[] classpath = jProject.getRawIncludepath();
        int length = classpath.length;
        if ((this.updateModelFlags & 0x10) != 0) {
            int i = 0;
            while (i < length) {
                if (this.destination.equals((Object)classpath[i].getPath())) {
                    IIncludePathEntry[] newClasspath = new IIncludePathEntry[length];
                    System.arraycopy(classpath, 0, newClasspath, 0, length);
                    newClasspath[i] = this.copy(rootEntry);
                    jProject.setRawIncludepath(newClasspath, this.progressMonitor);
                    return;
                }
                ++i;
            }
        }
        if (this.sibling == null) {
            position = length;
        } else {
            position = -1;
            int i = 0;
            while (i < length) {
                if (this.sibling.equals(classpath[i])) {
                    position = i;
                    break;
                }
                ++i;
            }
        }
        if (position == -1) {
            throw new JavaScriptModelException(new JavaModelStatus(993, this.sibling.toString()));
        }
        IIncludePathEntry[] newClasspath = new IIncludePathEntry[length + 1];
        if (position != 0) {
            System.arraycopy(classpath, 0, newClasspath, 0, position);
        }
        if (position != length) {
            System.arraycopy(classpath, position, newClasspath, position + 1, length - position);
        }
        newClasspath[position] = newEntry = this.copy(rootEntry);
        jProject.setRawIncludepath(newClasspath, this.progressMonitor);
    }

    protected IIncludePathEntry copy(IIncludePathEntry entry) throws JavaScriptModelException {
        switch (entry.getEntryKind()) {
            case 5: {
                return JavaScriptCore.newContainerEntry(entry.getPath(), entry.getAccessRules(), entry.getExtraAttributes(), entry.isExported());
            }
            case 1: {
                try {
                    return JavaScriptCore.newLibraryEntry(this.destination, entry.getSourceAttachmentPath(), entry.getSourceAttachmentRootPath(), entry.getAccessRules(), entry.getExtraAttributes(), entry.isExported());
                }
                catch (AssertionFailedException e) {
                    JavaModelStatus status = new JavaModelStatus(979, e.getMessage());
                    throw new JavaScriptModelException(status);
                }
            }
            case 2: {
                return JavaScriptCore.newProjectEntry(entry.getPath(), entry.getAccessRules(), entry.combineAccessRules(), entry.getExtraAttributes(), entry.isExported());
            }
            case 3: {
                return JavaScriptCore.newSourceEntry(this.destination, entry.getInclusionPatterns(), entry.getExclusionPatterns(), null, entry.getExtraAttributes());
            }
            case 4: {
                try {
                    return JavaScriptCore.newVariableEntry(entry.getPath(), entry.getSourceAttachmentPath(), entry.getSourceAttachmentRootPath(), entry.getAccessRules(), entry.getExtraAttributes(), entry.isExported());
                }
                catch (AssertionFailedException e) {
                    JavaModelStatus status = new JavaModelStatus(979, e.getMessage());
                    throw new JavaScriptModelException(status);
                }
            }
        }
        throw new JavaScriptModelException(new JavaModelStatus(969, this.getElementToProcess()));
    }

    public IJavaScriptModelStatus verify() {
        IJavaScriptModelStatus status = super.verify();
        if (!status.isOK()) {
            return status;
        }
        IPackageFragmentRoot root = (IPackageFragmentRoot)this.getElementToProcess();
        if (root == null || !root.exists()) {
            return new JavaModelStatus(969, root);
        }
        IResource resource = root.getResource();
        if (resource instanceof IFolder && resource.isLinked()) {
            return new JavaModelStatus(995, root);
        }
        if ((this.updateModelFlags & 8) != 0) {
            String destProjectName = this.destination.segment(0);
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(destProjectName);
            if (JavaProject.hasJavaNature(project)) {
                try {
                    IJavaScriptProject destProject = JavaScriptCore.create(project);
                    IIncludePathEntry[] destClasspath = destProject.getRawIncludepath();
                    boolean foundSibling = false;
                    boolean foundExistingEntry = false;
                    int i = 0;
                    int length = destClasspath.length;
                    while (i < length) {
                        IIncludePathEntry entry = destClasspath[i];
                        if (entry.equals(this.sibling)) {
                            foundSibling = true;
                            break;
                        }
                        if (entry.getPath().equals((Object)this.destination)) {
                            foundExistingEntry = true;
                        }
                        ++i;
                    }
                    if (this.sibling != null && !foundSibling) {
                        return new JavaModelStatus(993, this.sibling.toString());
                    }
                    if (foundExistingEntry && (this.updateModelFlags & 0x10) == 0) {
                        return new JavaModelStatus(977, Messages.bind(Messages.status_nameCollision, new String[]{this.destination.toString()}));
                    }
                }
                catch (JavaScriptModelException e) {
                    return e.getJavaScriptModelStatus();
                }
            }
        }
        return JavaModelStatus.VERIFIED_OK;
    }
}

