/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.facelet.core.internal.facet;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.jsf.facelet.core.internal.FaceletCoreTraceOptions;
import org.eclipse.jst.jsf.facelet.core.internal.facet.FacetChangeModel;
import org.eclipse.jst.jsf.facelet.core.internal.facet.WebAppConfigurator;
import org.eclipse.jst.jsf.facesconfig.emf.ApplicationType;
import org.eclipse.jst.jsf.facesconfig.emf.FacesConfigType;
import org.eclipse.jst.jsf.facesconfig.emf.ViewHandlerType;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.common.project.facet.core.IDelegate;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;

public abstract class FaceletChangeDelegate
implements IDelegate {
    protected static final String RUNTIME_VIEWHANDLER_CLASS_NAME = "com.sun.facelets.FaceletViewHandler";

    public void execute(final IProject project, IProjectFacetVersion fv, final Object config, final IProgressMonitor monitor) throws CoreException {
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            public void run() {
                WebAppConfigurator configurator;
                FacetChangeModel model = (FacetChangeModel)config;
                FaceletChangeDelegate.this.handleDesignTimeViewHandler(project);
                if (model.isChgViewHandler()) {
                    FaceletChangeDelegate.this.maybeChangeFaceletViewHandler(project, monitor);
                }
                if ((configurator = WebAppConfigurator.getConfigurator(project)) != null) {
                    FaceletChangeDelegate.this.maybeChangeDefaultSuffix(model, configurator);
                    FaceletChangeDelegate.this.maybeChangeConfigureListener(model, configurator);
                    FaceletChangeDelegate.this.maybeChangeWebLifecycleListener(model, configurator);
                } else if (FaceletCoreTraceOptions.TRACE_FACETCHANGEDELEGATE) {
                    FaceletCoreTraceOptions.log("FaceletChangeDelegate: No web configurator");
                }
            }
        });
    }

    protected abstract void maybeChangeWebLifecycleListener(FacetChangeModel var1, WebAppConfigurator var2);

    protected abstract void maybeChangeConfigureListener(FacetChangeModel var1, WebAppConfigurator var2);

    protected abstract void maybeChangeDefaultSuffix(FacetChangeModel var1, WebAppConfigurator var2);

    protected abstract void maybeChangeFaceletViewHandler(IProject var1, IProgressMonitor var2);

    protected abstract void handleDesignTimeViewHandler(IProject var1);

    protected abstract String getDisplayName();

    protected final boolean isViewHandlerPresent(FacesConfigType root) {
        EList applications = root.getApplication();
        for (Object name : applications) {
            ApplicationType app = (ApplicationType)name;
            if (app == null) continue;
            for (ViewHandlerType viewHandler : app.getViewHandler()) {
                if (viewHandler == null || !RUNTIME_VIEWHANDLER_CLASS_NAME.equals(viewHandler.getTextContent().trim())) continue;
                return true;
            }
        }
        return false;
    }
}

