/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.html.core.internal.document;

import java.util.Iterator;
import org.eclipse.wst.html.core.internal.contentmodel.HTMLElementDeclaration;
import org.eclipse.wst.html.core.internal.document.MetaDataAdapter;
import org.eclipse.wst.html.core.internal.document.TagScanner;
import org.eclipse.wst.sse.core.internal.provisional.INodeAdapter;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.eclipse.wst.xml.core.internal.contentmodel.CMContent;
import org.eclipse.wst.xml.core.internal.contentmodel.CMElementDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMGroup;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNode;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNodeList;
import org.eclipse.wst.xml.core.internal.document.CMNodeUtil;
import org.eclipse.wst.xml.core.internal.document.ModelParserAdapter;
import org.eclipse.wst.xml.core.internal.document.TagAdapter;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMText;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class HTMLModelParserAdapter
implements ModelParserAdapter {
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    protected HTMLModelParserAdapter() {
    }

    private boolean shouldTerminateAt(CMElementDeclaration parent, CMElementDeclaration child) {
        if (!parent.supports("terminators")) {
            return false;
        }
        Iterator i = (Iterator)parent.getProperty("terminators");
        if (i == null) {
            return false;
        }
        String nextName = child.getElementName();
        while (i.hasNext()) {
            String terminator = (String)i.next();
            if (terminator == null || !nextName.equalsIgnoreCase(terminator)) continue;
            return true;
        }
        return false;
    }

    public boolean canContain(Element element, Node child) {
        IDOMText text;
        String tagName;
        if (element == null || child == null) {
            return false;
        }
        IDOMElement impl = (IDOMElement)element;
        if (child.getNodeType() == 1) {
            if (!impl.isGlobalTag()) {
                return true;
            }
            IDOMElement childElement = (IDOMElement)child;
            CMElementDeclaration myDec = CMNodeUtil.getElementDeclaration((Element)element);
            if (myDec == null) {
                return true;
            }
            if (myDec.getContentType() == 1) {
                return false;
            }
            if (!childElement.isGlobalTag()) {
                return true;
            }
            CMElementDeclaration childDec = CMNodeUtil.getElementDeclaration((Element)childElement);
            if (childDec == null) {
                return true;
            }
            if (myDec instanceof HTMLElementDeclaration && ((Boolean)((HTMLElementDeclaration)myDec).getProperty("isJSP")).booleanValue()) {
                return true;
            }
            if (this.shouldTerminateAt(myDec, childDec) && !HTMLModelParserAdapter.isValidChild(myDec, childDec)) {
                return false;
            }
            String tagName2 = impl.getTagName();
            if (tagName2 == null) {
                return true;
            }
            String childName = childElement.getTagName();
            if (childName == null) {
                return true;
            }
            if (!impl.hasStartTag() && !impl.hasEndTag()) {
                IDOMElement parentElement;
                if (tagName2.equalsIgnoreCase(childElement.getTagName())) {
                    return false;
                }
                if (!(!tagName2.equalsIgnoreCase("HEAD") || childName.equalsIgnoreCase("META") || childName.equalsIgnoreCase("TITLE") || childName.equalsIgnoreCase("LINK") || childName.equalsIgnoreCase("STYLE") || childName.equalsIgnoreCase("BASE") || childName.equalsIgnoreCase("ISINDEX"))) {
                    return false;
                }
                Node parent = element.getParentNode();
                return parent == null || parent.getNodeType() != 1 || (parentElement = (IDOMElement)parent).hasStartTag() || parentElement.hasEndTag() || this.canContain((Element)parentElement, child);
            }
            boolean isTableContent = false;
            if (childName.equalsIgnoreCase("TBODY") || childName.equalsIgnoreCase("THEAD") || childName.equalsIgnoreCase("TFOOT")) {
                if (tagName2.equalsIgnoreCase("TABLE")) {
                    return true;
                }
                isTableContent = true;
            } else if (childName.equalsIgnoreCase("TR")) {
                if (tagName2.equalsIgnoreCase("TBODY") || tagName2.equalsIgnoreCase("THEAD") || tagName2.equalsIgnoreCase("TFOOT") || tagName2.equalsIgnoreCase("TABLE")) {
                    return true;
                }
                isTableContent = true;
            } else if (childName.equalsIgnoreCase("TD") || childName.equalsIgnoreCase("TH")) {
                if (tagName2.equalsIgnoreCase("TR") || tagName2.equalsIgnoreCase("TBODY") || tagName2.equalsIgnoreCase("THEAD") || tagName2.equalsIgnoreCase("TFOOT") || tagName2.equalsIgnoreCase("TABLE")) {
                    return true;
                }
                isTableContent = true;
            }
            if (isTableContent) {
                Node parent = element.getParentNode();
                while (parent != null) {
                    if (parent.getNodeType() != 1) break;
                    IDOMElement parentElement = (IDOMElement)parent;
                    String parentName = parentElement.getTagName();
                    if (parentName != null && parentName.equalsIgnoreCase("TABLE")) {
                        return false;
                    }
                    parent = parent.getParentNode();
                }
            }
            if (tagName2.equalsIgnoreCase("EMBED") && !childName.equalsIgnoreCase("NOEMBED")) {
                return false;
            }
        } else if (child.getNodeType() == 3 ? (tagName = impl.getTagName()) != null && tagName.equalsIgnoreCase("EMBED") && !(text = (IDOMText)child).isElementContentWhitespace() : child.getNodeType() == 10 && impl.isImplicitTag()) {
            return false;
        }
        return true;
    }

    public boolean canBeImplicitTag(Element element) {
        return false;
    }

    public boolean canBeImplicitTag(Element element, Node child) {
        return false;
    }

    public Element createCommentElement(Document document, String data, boolean isJSPTag) {
        if (document == null || data == null || data.length() == 0) {
            return null;
        }
        return this.createMetaElement(document, data, isJSPTag);
    }

    public Element createImplicitElement(Document document, Node parent, Node child) {
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Element createMetaElement(Document document, String data, boolean isJSPTag) {
        if (data == null || data.length() == 0) {
            return null;
        }
        TagScanner scanner = new TagScanner(data, 0, true);
        String name = scanner.nextName();
        if (name == null || !name.equalsIgnoreCase("METADATA")) {
            return null;
        }
        String type = null;
        boolean isStartSpan = false;
        boolean isEndSpan = false;
        name = scanner.nextName();
        while (name != null) {
            String value = scanner.nextValue();
            if (name.equalsIgnoreCase("type")) {
                if (value == null) {
                    return null;
                }
                if (value.equalsIgnoreCase("DesignerControl")) {
                    type = "DesignerControl";
                } else if (value.equalsIgnoreCase("DynamicData")) {
                    type = "DynamicData";
                } else if (value.equalsIgnoreCase("AuthorTimeVisual")) {
                    type = "AuthorTimeVisual";
                } else {
                    if (!value.equalsIgnoreCase("Annotation")) return null;
                    type = "Annotation";
                }
            } else if (name.equalsIgnoreCase("startspan")) {
                isStartSpan = true;
            } else if (name.equalsIgnoreCase("endspan") && !isStartSpan) {
                isEndSpan = true;
            }
            name = scanner.nextName();
        }
        if (type == null) {
            return null;
        }
        if (!isStartSpan && !isEndSpan) {
            return null;
        }
        String metaData = null;
        int offset = scanner.getNextOffset();
        if (offset < data.length()) {
            metaData = data.substring(offset);
        }
        if (metaData == null) {
            metaData = new String();
        }
        IDOMElement element = (IDOMElement)document.createElement("METADATA:" + type);
        MetaDataAdapter adapter = new MetaDataAdapter(type);
        if (isStartSpan) {
            adapter.setData(metaData);
        } else {
            adapter.setEndData(metaData);
        }
        element.addAdapter((INodeAdapter)adapter);
        adapter.setElement(element);
        element.setJSPTag(isJSPTag);
        return element;
    }

    public String getFindRootName(String tagName) {
        if (tagName == null) {
            return null;
        }
        if (tagName.equalsIgnoreCase("BODY")) {
            return null;
        }
        return "TABLE";
    }

    public boolean isAdapterForType(Object type) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.xml.core.internal.document.ModelParserAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return type == clazz;
    }

    public boolean isEndTag(IDOMElement element) {
        TagAdapter adapter;
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.wst.xml.core.internal.document.TagAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((adapter = (TagAdapter)element.getExistingAdapter((Object)clazz)) != null) {
            return adapter.isEndTag();
        }
        return element.isEndTag();
    }

    public void notifyChanged(INodeNotifier notifier, int eventType, Object changedFeature, Object oldValue, Object newValue, int pos) {
    }

    private static boolean isValidChild(CMElementDeclaration parent, CMElementDeclaration child) {
        if (parent == null || child == null) {
            return false;
        }
        CMContent content = parent.getContent();
        if (content == null) {
            return false;
        }
        return HTMLModelParserAdapter.isChild(content, child);
    }

    private static boolean isChild(CMContent content, CMElementDeclaration target) {
        switch (content.getNodeType()) {
            case 5: {
                return HTMLModelParserAdapter.isSameDeclaration((CMElementDeclaration)content, target);
            }
            case 7: {
                CMNodeList children = ((CMGroup)content).getChildNodes();
                int i = 0;
                while (i < children.getLength()) {
                    CMNode child = children.item(i);
                    switch (child.getNodeType()) {
                        case 5: {
                            if (!HTMLModelParserAdapter.isSameDeclaration((CMElementDeclaration)child, target)) break;
                            return true;
                        }
                        case 7: {
                            if (!HTMLModelParserAdapter.isChild((CMContent)child, target)) break;
                            return true;
                        }
                    }
                    ++i;
                }
                break;
            }
        }
        return false;
    }

    private static boolean isSameDeclaration(CMElementDeclaration aDec, CMElementDeclaration otherDec) {
        return aDec.getElementName() == otherDec.getElementName();
    }
}

