/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.jaxrs.core.internal.jaxrslibraryproviderconfig;

import java.util.List;
import java.util.Vector;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jst.ws.jaxrs.core.internal.JAXRSCorePlugin;
import org.eclipse.jst.ws.jaxrs.core.internal.Messages;
import org.eclipse.jst.ws.jaxrs.core.internal.jaxrslibraryproviderconfig.JAXRSLibraryProvider;
import org.eclipse.jst.ws.jaxrs.core.internal.jaxrslibraryproviderconfig.JAXRSLibraryProviderCreationHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JAXRSLibraryProviderUtil {
    private static JAXRSLibraryProviderUtil instance = null;
    private static List<JAXRSLibraryProvider> libraryProviders = new Vector<JAXRSLibraryProvider>();
    private static final String JAXRS_LIBRARY_PROVIDER_EXT_PT = "jaxrsLibraryProvider";

    private JAXRSLibraryProviderUtil() {
    }

    public static boolean isUpdateDDCheckBoxSelectedByDefault(String libraryID) {
        if (libraryID == null) {
            return false;
        }
        JAXRSLibraryProviderUtil.getInstance();
        List<JAXRSLibraryProvider> libraryProviders = JAXRSLibraryProviderUtil.getLibraryProviders();
        for (JAXRSLibraryProvider thisLibraryProvider : libraryProviders) {
            if (!libraryID.equals(thisLibraryProvider.getLibraryProviderID())) continue;
            return thisLibraryProvider.getUpdateDDCheckBoxSelected();
        }
        return false;
    }

    public static boolean isUpdateDDCheckBoxSupportAvailable(String libraryID) {
        if (libraryID == null || libraryID.length() == 0) {
            return false;
        }
        JAXRSLibraryProviderUtil.getInstance();
        List<JAXRSLibraryProvider> libraryProviders = JAXRSLibraryProviderUtil.getLibraryProviders();
        for (JAXRSLibraryProvider thisLibraryProvider : libraryProviders) {
            if (!libraryID.equals(thisLibraryProvider.getLibraryProviderID()) || !thisLibraryProvider.getShowUpdateDDCheckBox()) continue;
            return true;
        }
        return false;
    }

    public static String getServletClassName(String libraryID) {
        String toReturn = "";
        if (libraryID == null || libraryID.length() == 0) {
            return toReturn;
        }
        JAXRSLibraryProviderUtil.getInstance();
        List<JAXRSLibraryProvider> libraryProviders = JAXRSLibraryProviderUtil.getLibraryProviders();
        for (JAXRSLibraryProvider thisLibraryProvider : libraryProviders) {
            if (!libraryID.equals(thisLibraryProvider.getLibraryProviderID())) continue;
            return thisLibraryProvider.getServletClassName() != null ? thisLibraryProvider.getServletClassName() : toReturn;
        }
        return toReturn;
    }

    public static synchronized JAXRSLibraryProviderUtil getInstance() {
        if (instance == null) {
            instance = new JAXRSLibraryProviderUtil();
            instance.loadLibraryProvidersExtensions();
        }
        return instance;
    }

    private void loadLibraryProvidersExtensions() {
        try {
            IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.jst.ws.jaxrs.core", JAXRS_LIBRARY_PROVIDER_EXT_PT);
            IExtension[] extensions = point.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IExtension ext = extensions[i];
                int j = 0;
                while (j < ext.getConfigurationElements().length) {
                    JAXRSLibraryProviderCreationHelper newLibCreator = new JAXRSLibraryProviderCreationHelper(ext.getConfigurationElements()[j]);
                    JAXRSLibraryProvider newLibraryProvider = newLibCreator.create();
                    if (newLibraryProvider != null) {
                        libraryProviders.add(newLibraryProvider);
                    }
                    ++j;
                }
                ++i;
            }
        }
        catch (InvalidRegistryObjectException e) {
            JAXRSCorePlugin.log(4, Messages.JAXRSLibraryProvider_ErrorLoadingFromExtPt, e);
        }
    }

    public static List<JAXRSLibraryProvider> getLibraryProviders() {
        return libraryProviders;
    }
}

