/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.core.internal.project.facet;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.j2ee.common.CommonFactory;
import org.eclipse.jst.j2ee.common.ParamValue;
import org.eclipse.jst.j2ee.model.IModelProvider;
import org.eclipse.jst.j2ee.webapplication.ContextParam;
import org.eclipse.jst.j2ee.webapplication.Servlet;
import org.eclipse.jst.j2ee.webapplication.ServletMapping;
import org.eclipse.jst.j2ee.webapplication.ServletType;
import org.eclipse.jst.j2ee.webapplication.WebApp;
import org.eclipse.jst.j2ee.webapplication.WebType;
import org.eclipse.jst.j2ee.webapplication.WebapplicationFactory;
import org.eclipse.jst.jsf.core.JSFVersion;
import org.eclipse.jst.jsf.core.internal.project.facet.JSFUtils;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class JSFUtils11
extends JSFUtils {
    protected JSFUtils11(IModelProvider modelProvider) {
        super(JSFVersion.V1_1, modelProvider);
    }

    private Servlet findJSFServlet(WebApp webApp) {
        if (webApp == null) {
            return null;
        }
        for (Servlet servlet : webApp.getServlets()) {
            if (servlet == null || servlet.getWebType() == null || !servlet.getWebType().isServletType() || ((ServletType)servlet.getWebType()).getClassName() == null || !((ServletType)servlet.getWebType()).getClassName().trim().equals("javax.faces.webapp.FacesServlet")) continue;
            return servlet;
        }
        return null;
    }

    @Override
    public void doVersionSpecificConfigFile(PrintWriter pw) {
        String QUOTE = new String(new char[]{'\"'});
        pw.write("<?xml version=" + QUOTE + "1.0" + QUOTE + " encoding=" + QUOTE + "UTF-8" + QUOTE + "?>\n\n");
        pw.write("<!DOCTYPE faces-config PUBLIC\n");
        pw.write("    " + QUOTE + "-//Sun Microsystems, Inc.//DTD JavaServer Faces Config 1.1//EN" + QUOTE + "\n");
        pw.write("    " + QUOTE + "http://java.sun.com/dtd/web-facesconfig_1_1.dtd" + QUOTE + ">\n\n");
        pw.write("<faces-config>\n\n");
        pw.write("</faces-config>\n");
    }

    private Servlet createOrUpdateServletRef(WebApp webApp, IDataModel config, Servlet servlet) {
        String displayName = this.getDisplayName(config);
        String className = this.getServletClassname(config);
        if (servlet == null) {
            servlet = WebapplicationFactory.eINSTANCE.createServlet();
            servlet.setServletName(displayName);
            ServletType servletType = WebapplicationFactory.eINSTANCE.createServletType();
            servletType.setClassName(className);
            servlet.setWebType((WebType)servletType);
            servlet.setLoadOnStartup(Integer.valueOf(1));
            webApp.getServlets().add((Object)servlet);
        } else {
            this.updateServletMappings(webApp, servlet, displayName);
            servlet.setServletName(displayName);
            servlet.setLoadOnStartup(Integer.valueOf(1));
        }
        return servlet;
    }

    private void updateServletMappings(WebApp webApp, Servlet servlet, String displayName) {
        List<ServletMapping> mappings = this.findServletMappings(webApp, servlet);
        for (ServletMapping map : mappings) {
            map.setName(displayName);
        }
    }

    private List<ServletMapping> findServletMappings(WebApp webApp, Servlet servlet) {
        String servletName = servlet.getServletName();
        servletName = servletName != null ? servletName.trim() : servletName;
        ArrayList<ServletMapping> mappings = new ArrayList<ServletMapping>();
        EList allMappings = webApp.getServletMappings();
        int i = allMappings.size() - 1;
        while (i >= 0) {
            ServletMapping mapping = (ServletMapping)allMappings.get(i);
            if (mapping != null && mapping.getServlet() != null && mapping.getServlet().getServletName() != null && mapping.getServlet().getServletName().trim().equals(servletName)) {
                mappings.add(mapping);
            }
            --i;
        }
        return mappings;
    }

    private void setUpURLMappings(WebApp webApp, List urlMappingList, Servlet servlet) {
        for (String pattern : urlMappingList) {
            if (this.doesServletMappingExist(webApp, servlet, pattern)) continue;
            ServletMapping mapping = WebapplicationFactory.eINSTANCE.createServletMapping();
            mapping.setServlet(servlet);
            mapping.setName(servlet.getServletName());
            mapping.setUrlPattern(pattern);
            webApp.getServletMappings().add((Object)mapping);
        }
    }

    private boolean doesServletMappingExist(WebApp webApp, Servlet servlet, String pattern) {
        EList mappings = webApp.getServletMappings();
        String servletName = servlet.getServletName();
        if (servletName != null) {
            for (ServletMapping mapping : mappings) {
                if (mapping == null || mapping.getServlet() == null || mapping.getServlet().getServletName() == null || !mapping.getServlet().getServletName().trim().equals(servletName) || mapping.getUrlPattern() == null || !mapping.getUrlPattern().trim().equals(pattern)) continue;
                return true;
            }
        }
        return false;
    }

    private void removeURLMappings(WebApp webApp, Servlet servlet) {
        EList mappings = webApp.getServletMappings();
        String servletName = servlet.getServletName();
        if (servletName != null) {
            int i = mappings.size() - 1;
            while (i >= 0) {
                ServletMapping mapping = (ServletMapping)mappings.get(i);
                if (mapping != null && mapping.getServlet() != null && mapping.getServlet().getServletName() != null && mapping.getServlet().getServletName().trim().equals(servletName)) {
                    mappings.remove(mapping);
                }
                --i;
            }
        }
    }

    private void setupConfigFileContextParamForV2_3(WebApp webApp, IDataModel config) {
        ContextParam cp2 = null;
        ContextParam foundCP = null;
        boolean found = false;
        String stringProperty = config.getStringProperty("IJSFFacetInstallDataModelProperties.CONFIG_PATH");
        if (stringProperty != null && !stringProperty.equals("/WEB-INF/faces-config.xml")) {
            for (ContextParam cp2 : webApp.getContexts()) {
                if (cp2 == null || cp2.getParamName() == null || !cp2.getParamName().equals("javax.faces.CONFIG_FILES")) continue;
                foundCP = cp2;
                found = true;
            }
            if (!found) {
                cp2 = WebapplicationFactory.eINSTANCE.createContextParam();
                cp2.setParamName("javax.faces.CONFIG_FILES");
                cp2.setParamValue(stringProperty);
                webApp.getContexts().add((Object)cp2);
            } else {
                cp2 = foundCP;
                if (cp2.getParamValue().indexOf(stringProperty) < 0) {
                    String curVal = cp2.getParamValue();
                    String val = stringProperty;
                    if (curVal != null && !"".equals(curVal.trim())) {
                        val = String.valueOf(curVal) + ",\n" + val;
                    }
                    cp2.setParamValue(val);
                }
            }
        }
    }

    private void setupConfigFileContextParamForV2_4(WebApp webApp, IDataModel config) {
        ParamValue foundCP = null;
        ParamValue cp2 = null;
        boolean found = false;
        String stringProperty = config.getStringProperty("IJSFFacetInstallDataModelProperties.CONFIG_PATH");
        if (stringProperty != null && !stringProperty.equals("/WEB-INF/faces-config.xml")) {
            for (ParamValue cp2 : webApp.getContextParams()) {
                if (cp2 == null || cp2.getName() == null || !cp2.getName().trim().equals("javax.faces.CONFIG_FILES")) continue;
                foundCP = cp2;
                found = true;
            }
            if (!found) {
                ParamValue pv = CommonFactory.eINSTANCE.createParamValue();
                pv.setName("javax.faces.CONFIG_FILES");
                pv.setValue(stringProperty);
                webApp.getContextParams().add((Object)pv);
            } else {
                cp2 = foundCP;
                if (cp2.getValue().indexOf(stringProperty) < 0) {
                    String curVal = cp2.getValue();
                    String val = stringProperty;
                    if (curVal != null && !"".equals(curVal.trim())) {
                        val = String.valueOf(curVal) + ",\n" + val;
                    }
                    cp2.setValue(val);
                }
            }
        }
    }

    private String getDefaultSuffix(WebApp webApp) {
        String defaultSuffix;
        block3: {
            block2: {
                defaultSuffix = this.getDefaultDefaultSuffix();
                if (!"2.3".equals(webApp.getVersion())) break block2;
                for (ContextParam cp : webApp.getContexts()) {
                    String paramName;
                    String suffix;
                    if (cp == null || (suffix = this.calculateSuffix(paramName = cp.getParamName(), cp.getParamValue())) == null) continue;
                    return suffix;
                }
                break block3;
            }
            if (!"2.4".equals(webApp.getVersion())) break block3;
            for (ParamValue cp : webApp.getContextParams()) {
                String paramName;
                String suffix;
                if (cp == null || (suffix = this.calculateSuffix(paramName = cp.getName(), cp.getValue())) == null) continue;
                return suffix;
            }
        }
        return defaultSuffix;
    }

    private String getPrefixMapping(ServletMapping map) {
        Path extPath;
        String ext;
        String urlPattern = map.getUrlPattern();
        if (urlPattern != null && urlPattern.trim().length() != 0 && (ext = (extPath = new Path(urlPattern)).getFileExtension()) == null) {
            String lastSeg = extPath.lastSegment();
            if (lastSeg != null && lastSeg.equals("*")) {
                return extPath.removeLastSegments(1).toString();
            }
            return extPath.toString();
        }
        return null;
    }

    private String getFileExtensionFromMap(ServletMapping map) {
        Path extPath;
        String ext;
        String urlPattern = map.getUrlPattern();
        if (urlPattern != null && urlPattern.trim().length() != 0 && (ext = (extPath = new Path(map.getUrlPattern())).getFileExtension()) != null && ext.trim().length() != 0) {
            return ext;
        }
        return null;
    }

    @Override
    public void updateWebApp(Object webApp, IDataModel config) {
        Servlet servlet = this.findJSFServlet((WebApp)webApp);
        servlet = this.createOrUpdateServletRef((WebApp)webApp, config, servlet);
        List<String> listOfMappings = this.getServletMappings(config);
        this.setUpURLMappings((WebApp)webApp, listOfMappings, servlet);
        this.setupContextParams((WebApp)webApp, config);
    }

    private void setupContextParams(WebApp webApp, IDataModel config) {
        if (webApp.getVersionID() == 23) {
            this.setupConfigFileContextParamForV2_3(webApp, config);
        } else if (webApp.getVersionID() == 24) {
            this.setupConfigFileContextParamForV2_4(webApp, config);
        } else {
            throw new IllegalArgumentException("Invalid argument: " + webApp.getVersionID());
        }
    }

    @Override
    public void rollbackWebApp(Object webApp) {
        Servlet servlet = this.findJSFServlet((WebApp)webApp);
        if (servlet == null) {
            return;
        }
        this.removeURLMappings((WebApp)webApp, servlet);
        this.removeJSFContextParams((WebApp)webApp, servlet);
        this.removeJSFServlet((WebApp)webApp, servlet);
    }

    private void removeJSFContextParams(WebApp webApp, Servlet servlet) {
        block2: {
            block3: {
                if (!"2.3".equals(webApp.getVersion())) break block3;
                for (ContextParam cp : webApp.getContexts()) {
                    if (!"javax.faces.CONFIG_FILES".equals(cp.getParamName())) continue;
                    webApp.getContexts().remove((Object)cp);
                    break block2;
                }
                break block2;
            }
            if (!"2.4".equals(webApp.getVersion())) break block2;
            for (ParamValue cp : webApp.getContextParams()) {
                if (!cp.getName().equals("javax.faces.CONFIG_FILES")) continue;
                webApp.getContextParams().remove((Object)cp);
                break;
            }
        }
    }

    private void removeJSFServlet(WebApp webApp, Servlet servlet) {
        webApp.getServlets().remove((Object)servlet);
    }

    @Override
    public IPath getFileUrlPath(Object webAppObj, IResource resource, IPath existingURL) {
        if (webAppObj instanceof WebApp) {
            boolean canUseExtensionMapping;
            WebApp webApp = (WebApp)webAppObj;
            Servlet servlet = this.findJSFServlet(webApp);
            if (servlet == null) {
                return null;
            }
            if (!this.isJSFPage(resource)) {
                return null;
            }
            String defaultSuffix = this.getDefaultSuffix(webApp);
            String fileExtension = resource.getFileExtension();
            boolean bl = canUseExtensionMapping = fileExtension != null && fileExtension.equalsIgnoreCase(defaultSuffix);
            if (!canUseExtensionMapping && !this.isValidKnownExtension(fileExtension)) {
                return null;
            }
            Iterator mappings = servlet.getMappings().iterator();
            ServletMapping map = null;
            String foundFileExtension = null;
            String foundPrefixMapping = null;
            while (mappings.hasNext()) {
                map = (ServletMapping)mappings.next();
                foundFileExtension = this.getFileExtensionFromMap(map);
                if (foundFileExtension != null && canUseExtensionMapping) {
                    return existingURL.removeFileExtension().addFileExtension(foundFileExtension);
                }
                if (foundPrefixMapping != null) continue;
                foundPrefixMapping = this.getPrefixMapping(map);
            }
            if (foundPrefixMapping != null) {
                return new Path(foundPrefixMapping).append(existingURL);
            }
            if (!canUseExtensionMapping && foundFileExtension != null) {
                return existingURL.removeFileExtension().addFileExtension(foundFileExtension);
            }
        }
        return null;
    }
}

