/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.adapter.oda.impl;

import org.eclipse.birt.report.model.adapter.oda.impl.AbstractDataAdapter;
import org.eclipse.birt.report.model.api.CommandStack;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.OdaDataSourceHandle;
import org.eclipse.birt.report.model.api.ReportElementHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.util.PropertyValueValidationUtil;
import org.eclipse.datatools.connectivity.oda.design.DataSourceDesign;
import org.eclipse.datatools.connectivity.oda.design.Properties;
import org.eclipse.datatools.connectivity.oda.design.Property;
import org.eclipse.datatools.connectivity.oda.design.util.DesignUtil;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class DataSourceAdapter
extends AbstractDataAdapter {
    DataSourceAdapter() {
    }

    public DataSourceDesign createDataSourceDesign(OdaDataSourceHandle sourceHandle) {
        if (sourceHandle == null) {
            return null;
        }
        DataSourceDesign sourceDesign = this.designFactory.createDataSourceDesign();
        this.updateDataSourceDesign(sourceHandle, sourceDesign);
        return sourceDesign;
    }

    public void updateDataSourceDesign(OdaDataSourceHandle sourceHandle, DataSourceDesign sourceDesign) {
        sourceDesign.setName(sourceHandle.getName());
        String displayName = sourceHandle.getDisplayName();
        String displayNameKey = sourceHandle.getDisplayNameKey();
        if (displayName != null || displayNameKey != null) {
            sourceDesign.setDisplayName(displayName);
            sourceDesign.setDisplayNameKey(displayNameKey);
        }
        sourceDesign.setOdaExtensionId(sourceHandle.getExtensionID());
        sourceDesign.setPrivateProperties(this.newOdaPrivateProperties(sourceHandle.privateDriverPropertiesIterator()));
        sourceDesign.setPublicProperties(this.newOdaPublicProperties(sourceHandle.getExtensionPropertyDefinitionList(), (ReportElementHandle)sourceHandle));
        this.updateODAMessageFile(sourceDesign, sourceHandle.getModuleHandle());
    }

    public OdaDataSourceHandle createDataSourceHandle(DataSourceDesign sourceDesign, ModuleHandle module) throws SemanticException, IllegalStateException {
        if (sourceDesign == null) {
            return null;
        }
        DesignUtil.validateObject((EObject)sourceDesign);
        OdaDataSourceHandle sourceHandle = module.getElementFactory().newOdaDataSource(sourceDesign.getName(), sourceDesign.getOdaExtensionId());
        if (sourceHandle == null) {
            return null;
        }
        this.adaptDataSourceDesign(sourceDesign, sourceHandle);
        return sourceHandle;
    }

    public void updateDataSourceHandle(DataSourceDesign sourceDesign, OdaDataSourceHandle sourceHandle) throws SemanticException {
        if (sourceDesign == null || sourceHandle == null) {
            return;
        }
        DesignUtil.validateObject((EObject)sourceDesign);
        CommandStack stack = sourceHandle.getModuleHandle().getCommandStack();
        stack.startTrans(null);
        try {
            Property prop;
            int i;
            EList propList;
            sourceHandle.getElement().setProperty("extensionID", (Object)sourceDesign.getOdaExtensionId());
            sourceHandle.setName(sourceDesign.getName());
            sourceHandle.setDisplayName(sourceDesign.getDisplayName());
            sourceHandle.setDisplayNameKey(sourceDesign.getDisplayNameKey());
            Properties props = sourceDesign.getPublicProperties();
            if (props != null) {
                propList = props.getProperties();
                i = 0;
                while (i < propList.size()) {
                    prop = (Property)propList.get(i);
                    sourceHandle.setProperty(prop.getName(), (Object)prop.getValue());
                    ++i;
                }
            }
            if ((props = sourceDesign.getPrivateProperties()) != null) {
                propList = props.getProperties();
                i = 0;
                while (i < propList.size()) {
                    prop = (Property)propList.get(i);
                    sourceHandle.setPrivateDriverProperty(prop.getName(), prop.getValue());
                    ++i;
                }
            }
            this.updateROMMessageFile(sourceDesign, sourceHandle.getModuleHandle());
        }
        catch (SemanticException e) {
            stack.rollback();
            throw e;
        }
        stack.commit();
    }

    public boolean isEqualDataSourceDesign(DataSourceDesign designFromHandle, DataSourceDesign design) {
        if (designFromHandle == null && design == null) {
            return true;
        }
        if (designFromHandle != null && design == null) {
            return false;
        }
        if (designFromHandle == null && design != null) {
            return false;
        }
        assert (designFromHandle != null);
        Properties handleProps = designFromHandle.getPublicProperties();
        Properties props = design.getPublicProperties();
        if (handleProps == null && props == null) {
            return true;
        }
        if (handleProps != null && props == null) {
            return false;
        }
        if (handleProps == null && props != null) {
            return false;
        }
        assert (handleProps != null);
        assert (props != null);
        EList publicProps = handleProps.getProperties();
        int i = 0;
        while (i < publicProps.size()) {
            String value;
            Property prop = (Property)publicProps.get(i);
            String propValue = prop.getValue();
            String propName = prop.getName();
            if (propValue == null && (value = props.getProperty(propName)) != null && value.trim().equals("")) {
                prop.setNameValue(prop.getName(), "");
            }
            ++i;
        }
        DataSourceDesign tmpDesign = (DataSourceDesign)EcoreUtil.copy((EObject)design);
        tmpDesign.setHostResourceIdentifiers(null);
        return new EcoreUtil.EqualityHelper().equals((EObject)designFromHandle, (EObject)tmpDesign);
    }

    private void adaptDataSourceDesign(DataSourceDesign sourceDesign, OdaDataSourceHandle sourceHandle) throws SemanticException {
        Object value = null;
        value = sourceDesign.getName();
        PropertyValueValidationUtil.validateProperty((DesignElementHandle)sourceHandle, (String)"name", (Object)value);
        sourceHandle.getElement().setName(sourceDesign.getName());
        value = sourceDesign.getDisplayName();
        PropertyValueValidationUtil.validateProperty((DesignElementHandle)sourceHandle, (String)"displayName", (Object)value);
        sourceHandle.getElement().setProperty("displayName", (Object)sourceDesign.getDisplayName());
        value = sourceDesign.getDisplayNameKey();
        PropertyValueValidationUtil.validateProperty((DesignElementHandle)sourceHandle, (String)"displayNameID", (Object)value);
        sourceHandle.getElement().setProperty("displayNameID", (Object)sourceDesign.getDisplayNameKey());
        value = this.newROMPrivateProperties(sourceDesign.getPrivateProperties());
        PropertyValueValidationUtil.validateProperty((DesignElementHandle)sourceHandle, (String)"privateDriverProperties", (Object)value);
        sourceHandle.getElement().setProperty("privateDriverProperties", value);
        this.updateROMPublicProperties(sourceDesign.getPublicProperties(), (ReportElementHandle)sourceHandle);
        this.updateROMMessageFile(sourceDesign, sourceHandle.getModuleHandle());
    }
}

