/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.toolbox.plugins;

import com.lowagie.text.Document;
import com.lowagie.text.Image;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfWriter;
import com.lowagie.text.pdf.RandomAccessFileOrArray;
import com.lowagie.text.pdf.codec.TiffImage;
import com.lowagie.toolbox.AbstractTool;
import com.lowagie.toolbox.arguments.AbstractArgument;
import com.lowagie.toolbox.arguments.FileArgument;
import com.lowagie.toolbox.arguments.filters.ImageFilter;
import com.lowagie.toolbox.arguments.filters.PdfFilter;
import java.io.File;
import java.io.FileOutputStream;
import javax.swing.JInternalFrame;

public class KnitTiff
extends AbstractTool {
    public KnitTiff() {
        this.menuoptions = 3;
        this.arguments.add(new FileArgument(this, "odd", "The tiff file with the odd pages", false, new ImageFilter(false, false, false, false, false, true)));
        this.arguments.add(new FileArgument(this, "even", "The tiff file with the even pages", false, new ImageFilter(false, false, false, false, false, true)));
        this.arguments.add(new FileArgument(this, "destfile", "The file to which the converted TIFF has to be written", true, new PdfFilter()));
    }

    protected void createFrame() {
        this.internalFrame = new JInternalFrame("KnitTiff", true, false, true);
        this.internalFrame.setSize(300, 80);
        this.internalFrame.setJMenuBar(this.getMenubar());
        System.out.println("=== KnitTiff OPENED ===");
    }

    public void execute() {
        try {
            if (this.getValue("odd") == null) {
                throw new InstantiationException("You need to choose a sourcefile for the odd pages");
            }
            File file = (File)this.getValue("odd");
            if (this.getValue("even") == null) {
                throw new InstantiationException("You need to choose a sourcefile for the even pages");
            }
            File file2 = (File)this.getValue("even");
            if (this.getValue("destfile") == null) {
                throw new InstantiationException("You need to choose a destination file");
            }
            File file3 = (File)this.getValue("destfile");
            RandomAccessFileOrArray randomAccessFileOrArray = new RandomAccessFileOrArray(file.getAbsolutePath());
            RandomAccessFileOrArray randomAccessFileOrArray2 = new RandomAccessFileOrArray(file2.getAbsolutePath());
            Image image = TiffImage.getTiffImage(randomAccessFileOrArray, 1);
            Document document = new Document(new Rectangle(image.getScaledWidth(), image.getScaledHeight()));
            PdfWriter pdfWriter = PdfWriter.getInstance(document, new FileOutputStream(file3));
            document.open();
            PdfContentByte pdfContentByte = pdfWriter.getDirectContent();
            int n = Math.max(TiffImage.getNumberOfPages(randomAccessFileOrArray), TiffImage.getNumberOfPages(randomAccessFileOrArray2));
            for (int i = 0; i < n; ++i) {
                try {
                    Image image2 = TiffImage.getTiffImage(randomAccessFileOrArray, i + 1);
                    Image image3 = TiffImage.getTiffImage(randomAccessFileOrArray2, n - i);
                    document.setPageSize(new Rectangle(image2.getScaledWidth(), image2.getScaledHeight()));
                    document.newPage();
                    image2.setAbsolutePosition(0.0f, 0.0f);
                    pdfContentByte.addImage(image2);
                    document.setPageSize(new Rectangle(image3.getScaledWidth(), image3.getScaledHeight()));
                    document.newPage();
                    image3.setAbsolutePosition(0.0f, 0.0f);
                    pdfContentByte.addImage(image3);
                    continue;
                }
                catch (Exception exception) {
                    System.out.println("Exception page " + (i + 1) + " " + exception.getMessage());
                }
            }
            randomAccessFileOrArray.close();
            randomAccessFileOrArray2.close();
            document.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void valueHasChanged(AbstractArgument abstractArgument) {
        if (this.internalFrame == null) {
            return;
        }
    }

    public static void main(String[] stringArray) {
        KnitTiff knitTiff = new KnitTiff();
        if (stringArray.length < 3) {
            System.err.println(knitTiff.getUsage());
        }
        knitTiff.setMainArguments(stringArray);
        knitTiff.execute();
    }

    protected File getDestPathPDF() throws InstantiationException {
        return (File)this.getValue("destfile");
    }

    static {
        KnitTiff.addVersion("$Id: KnitTiff.java 3271 2008-04-18 20:39:42Z xlv $");
    }
}

