/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.core.data;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.content.IContentTypeManager;
import org.eclipse.mylyn.tasks.core.data.AbstractTaskAttachmentSource;

public class FileTaskAttachmentSource
extends AbstractTaskAttachmentSource {
    private static final String TEXT_PLAIN = "text/plain";
    private static final String APPLICATION_XML = "application/xml";
    public static final String APPLICATION_OCTET_STREAM = "application/octet-stream";
    private static Map<String, String> extensions2Types = new HashMap<String, String>();
    private String contentType;
    private String description;
    private final File file;
    private String name;

    static {
        extensions2Types.put("txt", TEXT_PLAIN);
        extensions2Types.put("html", "text/html");
        extensions2Types.put("htm", "text/html");
        extensions2Types.put("xhtml", "application/xhtml+xml");
        extensions2Types.put("jpe", "image/jpeg");
        extensions2Types.put("jpg", "image/jpeg");
        extensions2Types.put("jpeg", "image/jpeg");
        extensions2Types.put("gif", "image/gif");
        extensions2Types.put("png", "image/png");
        extensions2Types.put("tif", "image/tiff");
        extensions2Types.put("tiff", "image/tiff");
        extensions2Types.put("xml", APPLICATION_XML);
        extensions2Types.put("zip", APPLICATION_OCTET_STREAM);
        extensions2Types.put("tar", APPLICATION_OCTET_STREAM);
        extensions2Types.put("gz", APPLICATION_OCTET_STREAM);
    }

    public static String getContentTypeFromFilename(String fileName) {
        int index = fileName.lastIndexOf(".");
        if (index > 0 && index < fileName.length()) {
            String ext = fileName.substring(index + 1);
            String type = extensions2Types.get(ext.toLowerCase(Locale.ENGLISH));
            if (type != null) {
                return type;
            }
            IContentTypeManager contentTypeManager = Platform.getContentTypeManager();
            if (contentTypeManager != null) {
                IContentType contentType = contentTypeManager.findContentTypeFor(fileName);
                while (contentType != null) {
                    if ("org.eclipse.core.runtime.text".equals(contentType.getId())) {
                        return TEXT_PLAIN;
                    }
                    if ("org.eclipse.core.runtime.xml".equals(contentType.getId())) {
                        return APPLICATION_XML;
                    }
                    contentType = contentType.getBaseType();
                }
            }
        }
        return APPLICATION_OCTET_STREAM;
    }

    public static String[] getContentTypes() {
        HashSet<String> types = new HashSet<String>(extensions2Types.values());
        Object[] array = types.toArray(new String[0]);
        Arrays.sort(array);
        return array;
    }

    public FileTaskAttachmentSource(File file) {
        this.file = file;
        this.name = file.getName();
        this.contentType = FileTaskAttachmentSource.getContentTypeFromFilename(this.name);
    }

    public InputStream createInputStream(IProgressMonitor monitor) throws CoreException {
        try {
            return new FileInputStream(this.file);
        }
        catch (FileNotFoundException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.mylyn.tasks.core", e.getMessage(), (Throwable)e));
        }
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getDescription() {
        return this.description;
    }

    public long getLength() {
        return this.file.length();
    }

    public String getName() {
        return this.name;
    }

    public boolean isLocal() {
        return true;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setName(String name) {
        this.name = name;
    }
}

