/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.script.internal.instance;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.engine.api.script.ScriptException;
import org.eclipse.birt.report.engine.api.script.instance.IPageInstance;
import org.eclipse.birt.report.engine.api.script.instance.IReportItemInstance;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.impl.PageContent;
import org.eclipse.birt.report.engine.executor.ExecutionContext;
import org.eclipse.birt.report.engine.ir.ReportElementDesign;
import org.eclipse.birt.report.engine.script.internal.ElementUtil;
import org.eclipse.birt.report.engine.script.internal.instance.ReportItemInstance;
import org.eclipse.birt.report.engine.script.internal.instance.RunningState;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PageInstance
implements IPageInstance {
    ExecutionContext context;
    PageContent pageContent;
    Collection<IContent> contents;

    public PageInstance(ExecutionContext context, PageContent pageContent, Collection<IContent> contents) {
        this.context = context;
        this.pageContent = pageContent;
        this.contents = contents;
    }

    @Override
    public IReportItemInstance[] getInstancesByElementId(int elementId) throws ScriptException {
        ArrayList<ReportItemInstance> instances = new ArrayList<ReportItemInstance>();
        for (IContent content : this.contents) {
            ReportElementDesign design;
            Object generateBy = content.getGenerateBy();
            if (!(generateBy instanceof ReportElementDesign) || (design = (ReportElementDesign)generateBy).getID() != (long)elementId) continue;
            try {
                ReportItemInstance instance = (ReportItemInstance)ElementUtil.getInstance(content, this.context, RunningState.PAGEBREAK);
                instances.add(instance);
            }
            catch (BirtException ex) {
                throw new ScriptException(ex);
            }
        }
        if (!instances.isEmpty()) {
            return instances.toArray(new IReportItemInstance[instances.size()]);
        }
        return null;
    }

    @Override
    public IReportItemInstance[] getInstancesByElementName(String elementName) throws ScriptException {
        ArrayList<ReportItemInstance> instances = new ArrayList<ReportItemInstance>();
        for (IContent content : this.contents) {
            ReportElementDesign design;
            Object generateBy = content.getGenerateBy();
            if (!(generateBy instanceof ReportElementDesign) || !elementName.equals((design = (ReportElementDesign)generateBy).getName())) continue;
            try {
                ReportItemInstance instance = (ReportItemInstance)ElementUtil.getInstance(content, this.context, RunningState.PAGEBREAK);
                instances.add(instance);
            }
            catch (BirtException ex) {
                throw new ScriptException(ex);
            }
        }
        if (!instances.isEmpty()) {
            return instances.toArray(new IReportItemInstance[instances.size()]);
        }
        return null;
    }
}

