/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.script.internal.instance;

import java.util.Map;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.script.IDataSetInstanceHandle;
import org.eclipse.birt.report.engine.api.script.IColumnMetaData;
import org.eclipse.birt.report.engine.api.script.ScriptException;
import org.eclipse.birt.report.engine.api.script.instance.IDataSetInstance;
import org.eclipse.birt.report.engine.api.script.instance.IDataSourceInstance;
import org.eclipse.birt.report.engine.script.internal.ColumnMetaData;
import org.eclipse.birt.report.engine.script.internal.instance.DataSourceInstance;

public class DataSetInstance
implements IDataSetInstance {
    private IDataSetInstanceHandle dataSet;

    public DataSetInstance(IDataSetInstanceHandle dataSet) {
        this.dataSet = dataSet;
    }

    public String getName() {
        return this.dataSet.getName();
    }

    public IDataSourceInstance getDataSource() {
        return new DataSourceInstance(this.dataSet.getDataSource());
    }

    public String getExtensionID() {
        return this.dataSet.getExtensionID();
    }

    public String getQueryText() throws ScriptException {
        try {
            return this.dataSet.getQueryText();
        }
        catch (BirtException e) {
            throw new ScriptException(e.getLocalizedMessage());
        }
    }

    public void setQueryText(String queryText) throws ScriptException {
        try {
            this.dataSet.setQueryText(queryText);
        }
        catch (BirtException e) {
            throw new ScriptException(e.getLocalizedMessage());
        }
    }

    public IColumnMetaData getColumnMetaData() throws ScriptException {
        try {
            return new ColumnMetaData(this.dataSet.getResultMetaData());
        }
        catch (BirtException e) {
            throw new ScriptException(e.getLocalizedMessage());
        }
    }

    public Map getAllExtensionProperties() {
        return this.dataSet.getAllExtensionProperties();
    }

    public String getExtensionProperty(String name) {
        return this.dataSet.getExtensionProperty(name);
    }

    public void setExtensionProperty(String name, String value) {
        this.dataSet.setExtensionProperty(name, value);
    }

    public Object getInputParameterValue(String paramName) throws ScriptException {
        try {
            return this.dataSet.getInputParameterValue(paramName);
        }
        catch (BirtException e) {
            throw new ScriptException(e.getLocalizedMessage());
        }
    }

    public Object getOutputParameterValue(String paramName) throws ScriptException {
        try {
            return this.dataSet.getOutputParameterValue(paramName);
        }
        catch (BirtException e) {
            throw new ScriptException(e.getLocalizedMessage());
        }
    }

    public void setInputParameterValue(String paramName, Object paramValue) throws ScriptException {
        try {
            this.dataSet.setInputParameterValue(paramName, paramValue);
        }
        catch (BirtException e) {
            throw new ScriptException(e.getLocalizedMessage());
        }
    }

    public void setOutputParameterValue(String paramName, Object paramValue) throws ScriptException {
        try {
            this.dataSet.setOutputParameterValue(paramName, paramValue);
        }
        catch (BirtException e) {
            throw new ScriptException(e.getLocalizedMessage());
        }
    }

    public Map getInputParameters() {
        return this.dataSet.getInputParameters();
    }

    public Map getOutputParameters() {
        return this.dataSet.getOutputParameters();
    }
}

