/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.api.impl;

import java.util.List;
import java.util.logging.Level;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.DataEngineContext;
import org.eclipse.birt.data.engine.api.IBaseDataSetDesign;
import org.eclipse.birt.data.engine.api.IBaseDataSourceDesign;
import org.eclipse.birt.data.engine.api.IBasePreparedQuery;
import org.eclipse.birt.data.engine.api.IDataQueryDefinition;
import org.eclipse.birt.data.engine.api.IPreparedQuery;
import org.eclipse.birt.data.engine.api.IQueryDefinition;
import org.eclipse.birt.data.engine.api.IQueryResults;
import org.eclipse.birt.data.engine.api.querydefn.BaseDataSetDesign;
import org.eclipse.birt.data.engine.api.querydefn.BaseDataSourceDesign;
import org.eclipse.birt.data.engine.api.querydefn.QueryDefinition;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.report.data.adapter.api.DataRequestSession;
import org.eclipse.birt.report.data.adapter.api.DataSessionContext;
import org.eclipse.birt.report.data.adapter.api.IModelAdapter;
import org.eclipse.birt.report.engine.api.DataExtractionOption;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.IDatasetPreviewTask;
import org.eclipse.birt.report.engine.api.IExtractionOption;
import org.eclipse.birt.report.engine.api.IExtractionResults;
import org.eclipse.birt.report.engine.api.IResultMetaData;
import org.eclipse.birt.report.engine.api.IRunnable;
import org.eclipse.birt.report.engine.api.impl.EngineTask;
import org.eclipse.birt.report.engine.api.impl.ExtractionResults;
import org.eclipse.birt.report.engine.api.impl.ReportEngine;
import org.eclipse.birt.report.engine.api.impl.ReportRunnable;
import org.eclipse.birt.report.engine.api.impl.ResultMetaData;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DataSourceHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;

public class DatasetPreviewTask
extends EngineTask
implements IDatasetPreviewTask {
    protected IRunnable runnable;
    protected String datasetName;
    protected int maxRow;
    protected DataRequestSession dteSession;

    protected DatasetPreviewTask(ReportEngine engine) {
        super(engine, 5);
    }

    public IExtractionResults execute() throws EngineException {
        if (this.datasetName == null || this.datasetName.length() == 0) {
            throw new IllegalArgumentException("datasetName can not be null or emtpy!");
        }
        return this.runDataset();
    }

    public void setMaxRow(int maxRow) {
        this.maxRow = maxRow;
    }

    public void execute(IExtractionOption options) throws EngineException {
        if (options == null) {
            new DataExtractionOption();
        } else {
            new DataExtractionOption(options.getOptions());
        }
    }

    public void setDataSet(String dataset) {
        if (dataset == null || dataset.length() == 0) {
            throw new IllegalArgumentException("datasetName can not be null or emtpy!");
        }
        this.datasetName = dataset;
    }

    public void setRunnable(IRunnable runnable) {
        this.runnable = runnable;
        this.setReportRunnable((ReportRunnable)runnable);
    }

    protected ModuleHandle getHandle() {
        return ((ReportRunnable)this.runnable).getModuleHandle();
    }

    protected IExtractionResults runDataset() throws EngineException {
        IExtractionResults resultset = null;
        try {
            this.switchToOsgiClassLoader();
            this.changeStatusToRunning();
            if (this.runnable == null) {
                throw new EngineException("report runnable is not set");
            }
            resultset = this.doRun();
        }
        finally {
            this.changeStatusToStopped();
            this.switchClassLoaderBack();
        }
        return resultset;
    }

    protected IExtractionResults doRun() throws EngineException {
        IExtractionResults result = null;
        this.doValidateParameters();
        this.executionContext.getReportDesign();
        this.loadDesign();
        this.prepareDesign();
        this.startFactory();
        try {
            try {
                this.executionContext.openDataEngine();
                ModuleHandle handle = this.getHandle();
                List ds = handle.getAllDataSets();
                for (Object obj : ds) {
                    DataSetHandle dataset = (DataSetHandle)obj;
                    if (!this.datasetName.equals(dataset.getQualifiedName())) continue;
                    result = this.extractQuery(dataset);
                }
            }
            catch (Exception ex) {
                this.log.log(Level.SEVERE, "An error happened while extracting data the report. Cause:", ex);
                throw new EngineException("Error.ReportRunError", ex);
            }
            catch (OutOfMemoryError err) {
                this.log.log(Level.SEVERE, "There is insufficient memory to extract data from this report.");
                throw err;
            }
            catch (Throwable t) {
                this.log.log(Level.SEVERE, "Error happened while running the report.", t);
                throw new EngineException("Error.ReportRunError", t);
            }
        }
        finally {
            this.closeFactory();
        }
        return result;
    }

    protected IExtractionResults extractQuery(DataSetHandle dataset) throws BirtException {
        QueryDefinition newQuery = this.constructQuery(dataset);
        DataRequestSession session = this.getDataRequestSession();
        IModelAdapter adapter = session.getModelAdaptor();
        if (adapter != null) {
            DataSourceHandle datasource = dataset.getDataSource();
            BaseDataSourceDesign datasourceDesign = adapter.adaptDataSource(datasource);
            session.defineDataSource((IBaseDataSourceDesign)datasourceDesign);
            BaseDataSetDesign datasetDesign = adapter.adaptDataSet(dataset);
            session.defineDataSet((IBaseDataSetDesign)datasetDesign);
            session.registerQueries((IDataQueryDefinition[])new IQueryDefinition[]{newQuery});
            IPreparedQuery preparedQuery = session.prepare((IQueryDefinition)newQuery);
            IQueryResults result = (IQueryResults)session.execute((IBasePreparedQuery)preparedQuery, null, this.executionContext.getScriptContext());
            ResultMetaData metadata = new ResultMetaData(result.getResultMetaData());
            return new ExtractionResults(result, (IResultMetaData)metadata, null, 0, this.maxRow);
        }
        return null;
    }

    protected DataRequestSession getDataRequestSession() throws BirtException {
        if (this.dteSession == null) {
            DataSessionContext dteSessionContext = new DataSessionContext(3, ((ReportRunnable)this.runnable).getModuleHandle(), this.executionContext.getScriptContext(), this.executionContext.getApplicationClassLoader());
            dteSessionContext.setAppContext(this.executionContext.getAppContext());
            DataEngineContext dteEngineContext = dteSessionContext.getDataEngineContext();
            dteEngineContext.setLocale(this.executionContext.getLocale());
            dteEngineContext.setTimeZone(this.executionContext.getTimeZone());
            dteEngineContext.setTmpdir(this.engine.getConfig().getTempDir());
            this.dteSession = DataRequestSession.newSession((DataSessionContext)dteSessionContext);
        }
        return this.dteSession;
    }

    protected QueryDefinition constructQuery(DataSetHandle dataset) throws DataException {
        QueryDefinition query = new QueryDefinition();
        query.setDataSetName(dataset.getQualifiedName());
        query.setAutoBinding(true);
        if (this.maxRow > 0) {
            query.setMaxRows(this.maxRow);
        }
        return query;
    }
}

