/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.utility;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class UrlUtility {
    public static final String QUERY_CHAR = "?";
    public static final String ANCHOR_CHAR = "#";
    public static final String PARAM_SEPARATOR = "&";
    public static final String PARAM_EQUALS = "=";
    public static final String UTF_8_ENCODING = "UTF-8";

    public static String makeUriString(Map parameters) {
        StringBuffer output = new StringBuffer();
        Iterator i = parameters.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            Object value = entry.getValue();
            output.append(UrlUtility.urlParamValueEncode(entry.getKey()));
            if (value != null) {
                output.append(PARAM_EQUALS);
                output.append(UrlUtility.urlParamValueEncode(value));
            }
            if (!i.hasNext()) continue;
            output.append(PARAM_SEPARATOR);
        }
        return output.toString();
    }

    public static Map extractUriParameters(String uriString) {
        HashMap<String, String> params = new HashMap<String, String>();
        if (uriString != null) {
            int queryPosition;
            int anchorPosition = uriString.indexOf(ANCHOR_CHAR);
            if (anchorPosition >= 0) {
                uriString = uriString.substring(0, anchorPosition);
            }
            if ((queryPosition = uriString.indexOf(QUERY_CHAR)) >= 0) {
                uriString = uriString.substring(queryPosition + 1);
            }
            String[] uriParts = uriString.split("\\&");
            int i = 0;
            while (i < uriParts.length) {
                String param = uriParts[i];
                String[] paramParts = param.split(PARAM_EQUALS);
                if (paramParts.length > 0) {
                    String paramName = UrlUtility.urlParamValueDecode(paramParts[0]);
                    String paramValue = null;
                    if (paramParts.length > 1) {
                        paramValue = UrlUtility.urlParamValueDecode(paramParts[1]);
                    }
                    if (paramName != null && paramName.length() > 0) {
                        params.put(paramName, paramValue);
                    }
                }
                ++i;
            }
        }
        return params;
    }

    public static String urlParamValueDecode(String s) {
        if (s != null) {
            try {
                return URLDecoder.decode(s, UTF_8_ENCODING);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {}
        }
        return s;
    }

    public static String urlParamValueEncode(String s) {
        if (s != null) {
            try {
                return URLEncoder.encode(s, UTF_8_ENCODING);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {}
        }
        return s;
    }

    public static String urlParamValueEncode(Object value) {
        if (!(value instanceof String)) {
            value = value.toString();
        }
        return UrlUtility.urlParamValueEncode((String)value);
    }

    public static String extractBaseUrl(String url) {
        if (url != null) {
            int queryPosition = url.indexOf(QUERY_CHAR);
            if (queryPosition <= 0) {
                queryPosition = url.indexOf(ANCHOR_CHAR);
            }
            if (queryPosition >= 0) {
                url = url.substring(0, queryPosition);
            }
        }
        return url;
    }

    public static String getAnchor(String url) {
        int anchorPosition;
        if (url != null && (anchorPosition = url.indexOf(ANCHOR_CHAR)) >= 0) {
            return url.substring(anchorPosition + 1);
        }
        return null;
    }

    public static String buildUrl(String baseUrl, Map queryParams, String anchor) {
        StringBuffer url = new StringBuffer();
        url.append(baseUrl);
        if (queryParams != null && !queryParams.isEmpty()) {
            url.append(QUERY_CHAR);
            url.append(UrlUtility.makeUriString(queryParams));
        }
        if (anchor != null) {
            url.append(ANCHOR_CHAR);
            url.append(anchor);
        }
        return url.toString();
    }
}

