/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.internal.model.value;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.eclipse.jpt.utility.internal.IdentityHashBag;
import org.eclipse.jpt.utility.internal.model.value.CollectionPropertyValueModelAdapter;
import org.eclipse.jpt.utility.internal.model.value.StaticCollectionValueModel;
import org.eclipse.jpt.utility.model.event.CollectionAddEvent;
import org.eclipse.jpt.utility.model.event.CollectionChangeEvent;
import org.eclipse.jpt.utility.model.event.CollectionClearEvent;
import org.eclipse.jpt.utility.model.event.CollectionRemoveEvent;
import org.eclipse.jpt.utility.model.event.PropertyChangeEvent;
import org.eclipse.jpt.utility.model.listener.PropertyChangeListener;
import org.eclipse.jpt.utility.model.value.CollectionValueModel;
import org.eclipse.jpt.utility.model.value.PropertyValueModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CompositePropertyValueModel<V>
extends CollectionPropertyValueModelAdapter<V> {
    protected final IdentityHashBag<PropertyValueModel<?>> componentPVMs = new IdentityHashBag();
    protected final PropertyChangeListener propertyChangeListener = this.buildPropertyChangeListener();

    public CompositePropertyValueModel(PropertyValueModel<?> ... collection) {
        this(Arrays.asList(collection));
    }

    public <E extends PropertyValueModel<?>> CompositePropertyValueModel(Collection<E> collection) {
        this((CollectionValueModel<PropertyValueModel<?>>)new StaticCollectionValueModel<E>(collection));
    }

    public CompositePropertyValueModel(CollectionValueModel<? extends PropertyValueModel<?>> collectionModel) {
        super(collectionModel);
    }

    protected PropertyChangeListener buildPropertyChangeListener() {
        return new PropertyChangeListener(){

            public void propertyChanged(PropertyChangeEvent event) {
                CompositePropertyValueModel.this.propertyChanged(event);
            }

            public String toString() {
                return "property change listener";
            }
        };
    }

    protected void propertyChanged(PropertyChangeEvent event) {
        this.propertyChanged();
    }

    @Override
    protected void engageModel_() {
        super.engageModel_();
        this.addComponentPVMs(this.getCollectionModel());
    }

    protected <E extends PropertyValueModel<?>> void addComponentPVMs(Iterable<E> pvms) {
        for (PropertyValueModel each : pvms) {
            this.componentPVMs.add(each);
            each.addPropertyChangeListener("value", this.propertyChangeListener);
        }
    }

    @Override
    protected void disengageModel_() {
        this.removeComponentPVMs(this.getCollectionModel());
        super.disengageModel_();
    }

    protected <E extends PropertyValueModel<?>> void removeComponentPVMs(Iterable<E> pvms) {
        for (PropertyValueModel each : pvms) {
            each.removePropertyChangeListener("value", this.propertyChangeListener);
            this.componentPVMs.remove(each);
        }
    }

    @Override
    protected void itemsAdded(CollectionAddEvent event) {
        this.addComponentPVMs(this.getItems(event));
        super.itemsAdded(event);
    }

    @Override
    protected void itemsRemoved(CollectionRemoveEvent event) {
        this.removeComponentPVMs(this.getItems(event));
        super.itemsRemoved(event);
    }

    @Override
    protected void collectionCleared(CollectionClearEvent event) {
        this.removeAllComponentPVMs();
        super.collectionCleared(event);
    }

    protected void removeAllComponentPVMs() {
        ArrayList copy = new ArrayList(this.componentPVMs);
        this.removeComponentPVMs(copy);
    }

    @Override
    protected void collectionChanged(CollectionChangeEvent event) {
        this.removeAllComponentPVMs();
        this.addComponentPVMs(this.getCollectionModel());
        super.collectionChanged(event);
    }

    protected CollectionValueModel<? extends PropertyValueModel<?>> getCollectionModel() {
        return this.collectionModel;
    }

    protected Iterable<? extends PropertyValueModel<?>> getItems(CollectionAddEvent event) {
        return event.getItems();
    }

    protected Iterable<? extends PropertyValueModel<?>> getItems(CollectionRemoveEvent event) {
        return event.getItems();
    }
}

