/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.eclipselink.core.internal.context.java;

import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.context.JpaContextNode;
import org.eclipse.jpt.core.context.java.JavaAttributeMapping;
import org.eclipse.jpt.core.internal.context.java.AbstractJavaJpaContextNode;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentAttribute;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.eclipselink.core.context.EclipseLinkMutable;
import org.eclipse.jpt.eclipselink.core.internal.context.java.JavaEclipseLinkPersistentAttribute;
import org.eclipse.jpt.eclipselink.core.internal.context.persistence.EclipseLinkPersistenceUnit;
import org.eclipse.jpt.eclipselink.core.resource.java.EclipseLinkMutableAnnotation;

public class JavaEclipseLinkMutable
extends AbstractJavaJpaContextNode
implements EclipseLinkMutable {
    protected boolean defaultMutable;
    protected Boolean specifiedMutable;
    protected JavaResourcePersistentAttribute resourcePersistentAttribute;

    public JavaEclipseLinkMutable(JavaAttributeMapping parent) {
        super((JpaContextNode)parent);
    }

    protected JavaAttributeMapping getAttributeMapping() {
        return (JavaAttributeMapping)this.getParent();
    }

    public EclipseLinkPersistenceUnit getPersistenceUnit() {
        return (EclipseLinkPersistenceUnit)super.getPersistenceUnit();
    }

    protected String getMutableAnnotationName() {
        return "org.eclipse.persistence.annotations.Mutable";
    }

    protected EclipseLinkMutableAnnotation getResourceMutable() {
        return (EclipseLinkMutableAnnotation)this.resourcePersistentAttribute.getAnnotation(this.getMutableAnnotationName());
    }

    protected void addResourceMutable() {
        this.resourcePersistentAttribute.addAnnotation(this.getMutableAnnotationName());
    }

    protected void removeResourceMutable() {
        this.resourcePersistentAttribute.removeAnnotation(this.getMutableAnnotationName());
    }

    protected boolean calculateDefaultMutable() {
        JavaEclipseLinkPersistentAttribute javaAttribute = (JavaEclipseLinkPersistentAttribute)this.getAttributeMapping().getPersistentAttribute();
        if (javaAttribute.typeIsDateOrCalendar()) {
            Boolean persistenceUnitDefaultMutable = this.getPersistenceUnit().getOptions().getTemporalMutable();
            return persistenceUnitDefaultMutable == null ? false : persistenceUnitDefaultMutable;
        }
        return javaAttribute.typeIsSerializable();
    }

    public boolean isMutable() {
        return this.specifiedMutable != null ? this.specifiedMutable : this.defaultMutable;
    }

    public boolean isDefaultMutable() {
        return this.defaultMutable;
    }

    protected void setDefaultMutable(boolean newDefaultMutable) {
        boolean oldDefaultMutable = this.defaultMutable;
        this.defaultMutable = newDefaultMutable;
        this.firePropertyChanged("defaultMutable", oldDefaultMutable, newDefaultMutable);
    }

    public Boolean getSpecifiedMutable() {
        return this.specifiedMutable;
    }

    public void setSpecifiedMutable(Boolean newSpecifiedMutable) {
        if (this.specifiedMutable == newSpecifiedMutable) {
            return;
        }
        Boolean oldSpecifiedMutable = this.specifiedMutable;
        this.specifiedMutable = newSpecifiedMutable;
        if (newSpecifiedMutable != null) {
            if (this.getResourceMutable() == null) {
                this.addResourceMutable();
            }
            if (newSpecifiedMutable.booleanValue()) {
                if (this.getResourceMutable().getValue() == Boolean.FALSE) {
                    this.getResourceMutable().setValue(null);
                }
            } else {
                this.getResourceMutable().setValue(Boolean.FALSE);
            }
        } else {
            this.removeResourceMutable();
        }
        this.firePropertyChanged("specifiedMutable", oldSpecifiedMutable, newSpecifiedMutable);
    }

    protected void setSpecifiedMutable_(Boolean newSpecifiedMutable) {
        Boolean oldSpecifiedMutable = this.specifiedMutable;
        this.specifiedMutable = newSpecifiedMutable;
        this.firePropertyChanged("specifiedMutable", oldSpecifiedMutable, newSpecifiedMutable);
    }

    public void initialize(JavaResourcePersistentAttribute jrpa) {
        this.resourcePersistentAttribute = jrpa;
        EclipseLinkMutableAnnotation resourceMutable = this.getResourceMutable();
        this.specifiedMutable = this.specifiedMutable(resourceMutable);
        this.defaultMutable = this.calculateDefaultMutable();
    }

    public void update(JavaResourcePersistentAttribute jrpa) {
        this.resourcePersistentAttribute = jrpa;
        EclipseLinkMutableAnnotation resourceMutable = this.getResourceMutable();
        this.setSpecifiedMutable_(this.specifiedMutable(resourceMutable));
        this.setDefaultMutable(this.calculateDefaultMutable());
    }

    private Boolean specifiedMutable(EclipseLinkMutableAnnotation resourceMutable) {
        if (resourceMutable == null) {
            return null;
        }
        if (resourceMutable.getValue() == null) {
            return Boolean.TRUE;
        }
        return resourceMutable.getValue();
    }

    public TextRange getValidationTextRange(CompilationUnit astRoot) {
        EclipseLinkMutableAnnotation resourceMutable = this.getResourceMutable();
        return resourceMutable == null ? null : resourceMutable.getTextRange(astRoot);
    }
}

