/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.ui.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.jsdt.core.IClassFile;
import org.eclipse.wst.jsdt.core.IImportDeclaration;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.Signature;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.internal.ui.actions.ActionMessages;
import org.eclipse.wst.jsdt.internal.ui.actions.ActionUtil;
import org.eclipse.wst.jsdt.internal.ui.actions.SelectionConverter;
import org.eclipse.wst.jsdt.internal.ui.browsing.LogicalPackage;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.wst.jsdt.internal.ui.util.ExceptionHandler;
import org.eclipse.wst.jsdt.internal.ui.util.OpenTypeHierarchyUtil;
import org.eclipse.wst.jsdt.ui.actions.SelectionDispatchAction;

public class OpenTypeHierarchyAction
extends SelectionDispatchAction {
    private JavaEditor fEditor;

    public OpenTypeHierarchyAction(IWorkbenchSite site) {
        super(site);
        this.setText(ActionMessages.OpenTypeHierarchyAction_label);
        this.setToolTipText(ActionMessages.OpenTypeHierarchyAction_tooltip);
        this.setDescription(ActionMessages.OpenTypeHierarchyAction_description);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.wst.jsdt.ui.open_type_hierarchy_action");
    }

    public OpenTypeHierarchyAction(JavaEditor editor) {
        this((IWorkbenchSite)editor.getEditorSite());
        this.fEditor = editor;
        this.setEnabled(SelectionConverter.canOperateOn(this.fEditor));
    }

    public void selectionChanged(ITextSelection selection) {
    }

    public void selectionChanged(IStructuredSelection selection) {
        this.setEnabled(this.isEnabled(selection));
    }

    private boolean isEnabled(IStructuredSelection selection) {
        if (selection.size() != 1) {
            return false;
        }
        Object input = selection.getFirstElement();
        if (input instanceof LogicalPackage) {
            return true;
        }
        if (!(input instanceof IJavaScriptElement)) {
            return false;
        }
        switch (((IJavaScriptElement)input).getElementType()) {
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                return true;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 13: {
                return true;
            }
        }
        return false;
    }

    public void run(ITextSelection selection) {
        IJavaScriptElement input = SelectionConverter.getInput(this.fEditor);
        if (!ActionUtil.isProcessable(this.getShell(), input)) {
            return;
        }
        try {
            IJavaScriptElement[] elements = SelectionConverter.codeResolveOrInputForked(this.fEditor);
            if (elements == null) {
                return;
            }
            ArrayList<IJavaScriptElement> candidates = new ArrayList<IJavaScriptElement>(elements.length);
            int i = 0;
            while (i < elements.length) {
                IJavaScriptElement[] resolvedElements = OpenTypeHierarchyUtil.getCandidates(elements[i]);
                if (resolvedElements != null) {
                    candidates.addAll(Arrays.asList(resolvedElements));
                }
                ++i;
            }
            this.run(candidates.toArray(new IJavaScriptElement[candidates.size()]));
        }
        catch (InvocationTargetException e) {
            ExceptionHandler.handle(e, this.getShell(), OpenTypeHierarchyAction.getDialogTitle(), ActionMessages.SelectionConverter_codeResolve_failed);
        }
        catch (InterruptedException interruptedException) {}
    }

    public void run(IStructuredSelection selection) {
        if (selection.size() != 1) {
            return;
        }
        Object input = selection.getFirstElement();
        if (input instanceof LogicalPackage) {
            IPackageFragment[] fragments = ((LogicalPackage)((Object)input)).getFragments();
            if (fragments.length == 0) {
                return;
            }
            input = fragments[0];
        }
        if (!(input instanceof IJavaScriptElement)) {
            IStatus status = OpenTypeHierarchyAction.createStatus(ActionMessages.OpenTypeHierarchyAction_messages_no_java_element);
            ErrorDialog.openError((Shell)this.getShell(), (String)OpenTypeHierarchyAction.getDialogTitle(), (String)ActionMessages.OpenTypeHierarchyAction_messages_title, (IStatus)status);
            return;
        }
        IJavaScriptElement element = (IJavaScriptElement)input;
        if (!ActionUtil.isProcessable(this.getShell(), element)) {
            return;
        }
        ArrayList result = new ArrayList(1);
        IStatus status = OpenTypeHierarchyAction.compileCandidates(result, element);
        if (status.isOK()) {
            this.run(result.toArray(new IJavaScriptElement[result.size()]));
        } else {
            ErrorDialog.openError((Shell)this.getShell(), (String)OpenTypeHierarchyAction.getDialogTitle(), (String)ActionMessages.OpenTypeHierarchyAction_messages_title, (IStatus)status);
        }
    }

    public void run(IJavaScriptElement[] elements) {
        if (elements.length == 0) {
            this.getShell().getDisplay().beep();
            return;
        }
        OpenTypeHierarchyUtil.open(elements, this.getSite().getWorkbenchWindow());
    }

    private static String getDialogTitle() {
        return ActionMessages.OpenTypeHierarchyAction_dialog_title;
    }

    private static IStatus compileCandidates(List result, IJavaScriptElement elem) {
        Status ok = new Status(0, JavaScriptPlugin.getPluginId(), 0, "", null);
        try {
            switch (elem.getElementType()) {
                case 2: 
                case 3: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    result.add(elem);
                    return ok;
                }
                case 4: {
                    if (((IPackageFragment)elem).containsJavaResources()) {
                        result.add(elem);
                        return ok;
                    }
                    return OpenTypeHierarchyAction.createStatus(ActionMessages.OpenTypeHierarchyAction_messages_no_java_resources);
                }
                case 13: {
                    IImportDeclaration decl = (IImportDeclaration)elem;
                    elem = decl.isOnDemand() ? JavaModelUtil.findTypeContainer(elem.getJavaScriptProject(), Signature.getQualifier((String)elem.getElementName())) : elem.getJavaScriptProject().findType(elem.getElementName());
                    if (elem != null) {
                        result.add(elem);
                        return ok;
                    }
                    return OpenTypeHierarchyAction.createStatus(ActionMessages.OpenTypeHierarchyAction_messages_unknown_import_decl);
                }
                case 6: {
                    result.add(((IClassFile)elem).getType());
                    return ok;
                }
                case 5: {
                    IJavaScriptUnit cu = (IJavaScriptUnit)elem;
                    IType[] types = cu.getTypes();
                    if (types.length > 0) {
                        result.addAll(Arrays.asList(types));
                        return ok;
                    }
                    return OpenTypeHierarchyAction.createStatus(ActionMessages.OpenTypeHierarchyAction_messages_no_types);
                }
            }
        }
        catch (JavaScriptModelException e) {
            return e.getStatus();
        }
        return OpenTypeHierarchyAction.createStatus(ActionMessages.OpenTypeHierarchyAction_messages_no_valid_java_element);
    }

    private static IStatus createStatus(String message) {
        return new Status(1, JavaScriptPlugin.getPluginId(), 10001, message, null);
    }
}

