/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.fix;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.text.edits.TextEditGroup;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.compiler.IProblem;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTVisitor;
import org.eclipse.wst.jsdt.core.dom.Assignment;
import org.eclipse.wst.jsdt.core.dom.Expression;
import org.eclipse.wst.jsdt.core.dom.FieldAccess;
import org.eclipse.wst.jsdt.core.dom.FunctionInvocation;
import org.eclipse.wst.jsdt.core.dom.IBinding;
import org.eclipse.wst.jsdt.core.dom.IFunctionBinding;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.IVariableBinding;
import org.eclipse.wst.jsdt.core.dom.Initializer;
import org.eclipse.wst.jsdt.core.dom.JavaScriptUnit;
import org.eclipse.wst.jsdt.core.dom.Modifier;
import org.eclipse.wst.jsdt.core.dom.Name;
import org.eclipse.wst.jsdt.core.dom.QualifiedName;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.wst.jsdt.core.dom.SuperFieldAccess;
import org.eclipse.wst.jsdt.core.dom.SwitchCase;
import org.eclipse.wst.jsdt.core.dom.Type;
import org.eclipse.wst.jsdt.core.dom.TypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationFragment;
import org.eclipse.wst.jsdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.wst.jsdt.internal.corext.dom.ASTNodes;
import org.eclipse.wst.jsdt.internal.corext.dom.Bindings;
import org.eclipse.wst.jsdt.internal.corext.dom.GenericVisitor;
import org.eclipse.wst.jsdt.internal.corext.fix.AbstractFix;
import org.eclipse.wst.jsdt.internal.corext.fix.FixMessages;
import org.eclipse.wst.jsdt.internal.corext.fix.IFixRewriteOperation;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.text.correction.ProblemLocation;
import org.eclipse.wst.jsdt.ui.text.java.IProblemLocation;

public class CodeStyleFix
extends AbstractFix {
    static /* synthetic */ Class class$0;

    public static CodeStyleFix[] createNonStaticAccessFixes(JavaScriptUnit compilationUnit, IProblemLocation problem) throws CoreException {
        if (!CodeStyleFix.isNonStaticAccess(problem)) {
            return null;
        }
        ToStaticAccessOperation[] operations = CodeStyleFix.createToStaticAccessOperations(compilationUnit, problem);
        if (operations == null) {
            return null;
        }
        String label1 = Messages.format(FixMessages.CodeStyleFix_ChangeAccessToStatic_description, operations[0].getAccessorName());
        CodeStyleFix fix1 = new CodeStyleFix(label1, compilationUnit, new IFixRewriteOperation[]{operations[0]});
        if (operations.length > 1) {
            String label2 = Messages.format(FixMessages.CodeStyleFix_ChangeAccessToStaticUsingInstanceType_description, operations[1].getAccessorName());
            CodeStyleFix fix2 = new CodeStyleFix(label2, compilationUnit, new IFixRewriteOperation[]{operations[1]});
            return new CodeStyleFix[]{fix1, fix2};
        }
        return new CodeStyleFix[]{fix1};
    }

    public static CodeStyleFix createIndirectAccessToStaticFix(JavaScriptUnit compilationUnit, IProblemLocation problem) throws CoreException {
        if (!CodeStyleFix.isIndirectStaticAccess(problem)) {
            return null;
        }
        ToStaticAccessOperation[] operations = CodeStyleFix.createToStaticAccessOperations(compilationUnit, problem);
        if (operations == null) {
            return null;
        }
        String label = Messages.format(FixMessages.CodeStyleFix_ChangeStaticAccess_description, operations[0].getAccessorName());
        return new CodeStyleFix(label, compilationUnit, new IFixRewriteOperation[]{operations[0]});
    }

    public static CodeStyleFix createCleanUp(JavaScriptUnit compilationUnit, boolean addThisQualifier, boolean changeNonStaticAccessToStatic, boolean qualifyStaticFieldAccess, boolean changeIndirectStaticAccessToDirect, boolean qualifyMethodAccess, boolean qualifyStaticMethodAccess, boolean removeFieldQualifier, boolean removeMethodQualifier) throws CoreException {
        if (!(addThisQualifier || changeNonStaticAccessToStatic || qualifyStaticFieldAccess || changeIndirectStaticAccessToDirect || qualifyMethodAccess || qualifyStaticMethodAccess || removeFieldQualifier || removeMethodQualifier)) {
            return null;
        }
        ArrayList operations = new ArrayList();
        if (addThisQualifier || qualifyStaticFieldAccess || qualifyMethodAccess || qualifyStaticMethodAccess) {
            CodeStyleVisitor codeStyleVisitor = new CodeStyleVisitor(compilationUnit, addThisQualifier, qualifyStaticFieldAccess, qualifyMethodAccess, qualifyStaticMethodAccess, operations);
            compilationUnit.accept((ASTVisitor)codeStyleVisitor);
        }
        IProblem[] problems = compilationUnit.getProblems();
        IProblemLocation[] locations = new IProblemLocation[problems.length];
        int i = 0;
        while (i < problems.length) {
            locations[i] = new ProblemLocation(problems[i]);
            ++i;
        }
        CodeStyleFix.addToStaticAccessOperations(compilationUnit, locations, changeNonStaticAccessToStatic, changeIndirectStaticAccessToDirect, operations);
        if (operations.isEmpty()) {
            return null;
        }
        IFixRewriteOperation[] operationsArray = operations.toArray(new IFixRewriteOperation[operations.size()]);
        return new CodeStyleFix(FixMessages.CodeStyleFix_change_name, compilationUnit, operationsArray);
    }

    public static CodeStyleFix createCleanUp(JavaScriptUnit compilationUnit, IProblemLocation[] problems, boolean addThisQualifier, boolean changeNonStaticAccessToStatic, boolean changeIndirectStaticAccessToDirect) throws CoreException {
        if (!(addThisQualifier || changeNonStaticAccessToStatic || changeIndirectStaticAccessToDirect)) {
            return null;
        }
        ArrayList operations = new ArrayList();
        CodeStyleFix.addToStaticAccessOperations(compilationUnit, problems, changeNonStaticAccessToStatic, changeIndirectStaticAccessToDirect, operations);
        if (operations.isEmpty()) {
            return null;
        }
        IFixRewriteOperation[] operationsArray = operations.toArray(new IFixRewriteOperation[operations.size()]);
        return new CodeStyleFix(FixMessages.CodeStyleFix_change_name, compilationUnit, operationsArray);
    }

    private static void addToStaticAccessOperations(JavaScriptUnit compilationUnit, IProblemLocation[] problems, boolean changeNonStaticAccessToStatic, boolean changeIndirectStaticAccessToDirect, List result) {
        Hashtable<Expression, ToStaticAccessOperation> nonStaticAccessOps = new Hashtable<Expression, ToStaticAccessOperation>();
        if (changeNonStaticAccessToStatic || changeIndirectStaticAccessToDirect) {
            int i = 0;
            while (i < problems.length) {
                ToStaticAccessOperation[] nonStaticAccessInformation;
                boolean isIndirectStaticAccess;
                IProblemLocation problem = problems[i];
                boolean isNonStaticAccess = changeNonStaticAccessToStatic && CodeStyleFix.isNonStaticAccess(problem);
                boolean bl = isIndirectStaticAccess = changeIndirectStaticAccessToDirect && CodeStyleFix.isIndirectStaticAccess(problem);
                if ((isNonStaticAccess || isIndirectStaticAccess) && (nonStaticAccessInformation = CodeStyleFix.createToStaticAccessOperations(compilationUnit, problem)) != null) {
                    ToStaticAccessOperation op = nonStaticAccessInformation[0];
                    nonStaticAccessOps.put(op.fQualifier, op);
                }
                ++i;
            }
        }
        Iterator iter = nonStaticAccessOps.values().iterator();
        while (iter.hasNext()) {
            ToStaticAccessOperation op = (ToStaticAccessOperation)iter.next();
            if (nonStaticAccessOps.containsKey(op.fQualifier.getParent())) continue;
            result.add(op);
        }
    }

    private static boolean isIndirectStaticAccess(IProblemLocation problem) {
        return problem.getProblemId() == 570425422 || problem.getProblemId() == 603979895;
    }

    private static boolean isNonStaticAccess(IProblemLocation problem) {
        return problem.getProblemId() == 570425420 || problem.getProblemId() == 603979893;
    }

    private static ToStaticAccessOperation[] createToStaticAccessOperations(JavaScriptUnit astRoot, IProblemLocation problem) {
        ASTNode selectedNode = problem.getCoveringNode(astRoot);
        if (selectedNode == null) {
            return null;
        }
        Name qualifier = null;
        IBinding accessBinding = null;
        if (selectedNode instanceof QualifiedName) {
            QualifiedName name = (QualifiedName)selectedNode;
            qualifier = name.getQualifier();
            accessBinding = name.resolveBinding();
        } else if (selectedNode instanceof SimpleName) {
            ASTNode parent = selectedNode.getParent();
            if (parent instanceof FieldAccess) {
                FieldAccess fieldAccess = (FieldAccess)parent;
                qualifier = fieldAccess.getExpression();
                accessBinding = fieldAccess.getName().resolveBinding();
            } else if (parent instanceof QualifiedName) {
                QualifiedName qualifiedName = (QualifiedName)parent;
                qualifier = qualifiedName.getQualifier();
                accessBinding = qualifiedName.getName().resolveBinding();
            }
        } else if (selectedNode instanceof FunctionInvocation) {
            FunctionInvocation methodInvocation = (FunctionInvocation)selectedNode;
            qualifier = methodInvocation.getExpression();
            SimpleName name = methodInvocation.getName();
            if (name != null) {
                accessBinding = name.resolveBinding();
            }
        } else if (selectedNode instanceof FieldAccess) {
            FieldAccess fieldAccess = (FieldAccess)selectedNode;
            qualifier = fieldAccess.getExpression();
            accessBinding = fieldAccess.getName().resolveBinding();
        }
        if (accessBinding != null && qualifier != null) {
            ToStaticAccessOperation declaring = null;
            ITypeBinding declaringTypeBinding = CodeStyleFix.getDeclaringTypeBinding(accessBinding);
            if (declaringTypeBinding != null) {
                declaringTypeBinding = declaringTypeBinding.getTypeDeclaration();
                declaring = new ToStaticAccessOperation(declaringTypeBinding, (Expression)qualifier);
            }
            ToStaticAccessOperation instance = null;
            ITypeBinding instanceTypeBinding = Bindings.normalizeTypeBinding(qualifier.resolveTypeBinding());
            if (instanceTypeBinding != null && (instanceTypeBinding = instanceTypeBinding.getTypeDeclaration()).getTypeDeclaration() != declaringTypeBinding) {
                instance = new ToStaticAccessOperation(instanceTypeBinding, (Expression)qualifier);
            }
            if (declaring != null && instance != null) {
                return new ToStaticAccessOperation[]{declaring, instance};
            }
            return new ToStaticAccessOperation[]{declaring};
        }
        return null;
    }

    private static ITypeBinding getDeclaringTypeBinding(IBinding accessBinding) {
        if (accessBinding instanceof IFunctionBinding) {
            return ((IFunctionBinding)accessBinding).getDeclaringClass();
        }
        if (accessBinding instanceof IVariableBinding) {
            return ((IVariableBinding)accessBinding).getDeclaringClass();
        }
        return null;
    }

    private CodeStyleFix(String name, JavaScriptUnit compilationUnit, IFixRewriteOperation[] fixRewriteOperations) {
        super(name, compilationUnit, fixRewriteOperations);
    }

    private static final class AddStaticQualifierOperation
    extends AbstractFix.AbstractFixRewriteOperation {
        private final SimpleName fName;
        private final ITypeBinding fDeclaringClass;

        public AddStaticQualifierOperation(ITypeBinding declaringClass, SimpleName name) {
            this.fDeclaringClass = declaringClass;
            this.fName = name;
        }

        public void rewriteAST(CompilationUnitRewrite cuRewrite, List textEditGroups) throws CoreException {
            ASTRewrite rewrite = cuRewrite.getASTRewrite();
            JavaScriptUnit compilationUnit = cuRewrite.getRoot();
            this.importType(this.fDeclaringClass, (ASTNode)this.fName, cuRewrite.getImportRewrite(), compilationUnit);
            TextEditGroup group = this.fName.resolveBinding() instanceof IFunctionBinding ? this.createTextEditGroup(FixMessages.CodeStyleFix_QualifyMethodWithDeclClass_description) : this.createTextEditGroup(FixMessages.CodeStyleFix_QualifyFieldWithDeclClass_description);
            textEditGroups.add(group);
            IJavaScriptElement javaElement = this.fDeclaringClass.getJavaElement();
            if (javaElement instanceof IType) {
                Name qualifierName = compilationUnit.getAST().newName(((IType)javaElement).getElementName());
                SimpleName simpleName = (SimpleName)rewrite.createMoveTarget((ASTNode)this.fName);
                QualifiedName qualifiedName = compilationUnit.getAST().newQualifiedName(qualifierName, simpleName);
                rewrite.replace((ASTNode)this.fName, (ASTNode)qualifiedName, group);
            }
        }
    }

    private static final class CodeStyleVisitor
    extends GenericVisitor {
        private final List fResult;
        private final boolean fFindUnqualifiedAccesses;
        private final boolean fFindUnqualifiedStaticAccesses;
        private final boolean fFindUnqualifiedMethodAccesses;
        private final boolean fFindUnqualifiedStaticMethodAccesses;

        public CodeStyleVisitor(JavaScriptUnit compilationUnit, boolean findUnqualifiedAccesses, boolean findUnqualifiedStaticAccesses, boolean findUnqualifiedMethodAccesses, boolean findUnqualifiedStaticMethodAccesses, List resultingCollection) throws CoreException {
            this.fFindUnqualifiedAccesses = findUnqualifiedAccesses;
            this.fFindUnqualifiedStaticAccesses = findUnqualifiedStaticAccesses;
            this.fFindUnqualifiedMethodAccesses = findUnqualifiedMethodAccesses;
            this.fFindUnqualifiedStaticMethodAccesses = findUnqualifiedStaticMethodAccesses;
            this.fResult = resultingCollection;
        }

        public boolean visit(TypeDeclaration node) {
            return super.visit(node);
        }

        public boolean visit(QualifiedName node) {
            if (this.fFindUnqualifiedAccesses || this.fFindUnqualifiedStaticAccesses) {
                QualifiedName simpleName = node;
                while (simpleName instanceof QualifiedName) {
                    simpleName = simpleName.getQualifier();
                }
                if (simpleName instanceof SimpleName) {
                    this.handleSimpleName((SimpleName)simpleName);
                }
            }
            return false;
        }

        public boolean visit(SimpleName node) {
            if (this.fFindUnqualifiedAccesses || this.fFindUnqualifiedStaticAccesses) {
                this.handleSimpleName(node);
            }
            return false;
        }

        public boolean visit(FunctionInvocation node) {
            if (!this.fFindUnqualifiedMethodAccesses && !this.fFindUnqualifiedStaticMethodAccesses) {
                return true;
            }
            if (node.getExpression() != null) {
                return true;
            }
            SimpleName name = node.getName();
            if (name != null) {
                IBinding binding = name.resolveBinding();
                if (!(binding instanceof IFunctionBinding)) {
                    return true;
                }
                this.handleMethod(name, (IFunctionBinding)binding);
            }
            return true;
        }

        private void handleSimpleName(SimpleName node) {
            ASTNode firstExpression = node.getParent();
            if (firstExpression instanceof FieldAccess) {
                while (firstExpression instanceof FieldAccess) {
                    firstExpression = ((FieldAccess)firstExpression).getExpression();
                }
                if (!(firstExpression instanceof SimpleName)) {
                    return;
                }
                node = (SimpleName)firstExpression;
            } else if (firstExpression instanceof SuperFieldAccess) {
                return;
            }
            StructuralPropertyDescriptor parentDescription = node.getLocationInParent();
            if (parentDescription == VariableDeclarationFragment.NAME_PROPERTY || parentDescription == SwitchCase.EXPRESSION_PROPERTY) {
                return;
            }
            IBinding binding = node.resolveBinding();
            if (!(binding instanceof IVariableBinding)) {
                return;
            }
            this.handleVariable(node, (IVariableBinding)binding);
        }

        private void handleVariable(SimpleName node, IVariableBinding varbinding) {
            if (!varbinding.isField()) {
                return;
            }
            ITypeBinding declaringClass = varbinding.getDeclaringClass();
            if (Modifier.isStatic((int)varbinding.getModifiers()) && this.fFindUnqualifiedStaticAccesses) {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.core.dom.Initializer");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                Initializer initializer = (Initializer)ASTNodes.getParent((ASTNode)node, clazz);
                StructuralPropertyDescriptor parentDescription = node.getLocationInParent();
                if (initializer != null && Modifier.isStatic((int)initializer.getModifiers()) && Modifier.isFinal((int)varbinding.getModifiers()) && parentDescription == Assignment.LEFT_HAND_SIDE_PROPERTY) {
                    return;
                }
                if (declaringClass.isAnonymous()) {
                    return;
                }
                this.fResult.add(new AddStaticQualifierOperation(declaringClass, node));
            }
        }

        private void handleMethod(SimpleName node, IFunctionBinding binding) {
            ITypeBinding declaringClass = binding.getDeclaringClass();
            if (Modifier.isStatic((int)binding.getModifiers()) && this.fFindUnqualifiedStaticMethodAccesses) {
                if (declaringClass.isAnonymous()) {
                    return;
                }
                this.fResult.add(new AddStaticQualifierOperation(declaringClass, node));
            }
        }
    }

    private static final class ToStaticAccessOperation
    extends AbstractFix.AbstractFixRewriteOperation {
        private final ITypeBinding fDeclaringTypeBinding;
        private final Expression fQualifier;

        public ToStaticAccessOperation(ITypeBinding declaringTypeBinding, Expression qualifier) {
            this.fDeclaringTypeBinding = declaringTypeBinding;
            this.fQualifier = qualifier;
        }

        public String getAccessorName() {
            return this.fDeclaringTypeBinding.getName();
        }

        public void rewriteAST(CompilationUnitRewrite cuRewrite, List textEditGroups) throws CoreException {
            Type type = this.importType(this.fDeclaringTypeBinding, (ASTNode)this.fQualifier, cuRewrite.getImportRewrite(), cuRewrite.getRoot());
            TextEditGroup group = this.createTextEditGroup(FixMessages.CodeStyleFix_ChangeAccessUsingDeclaring_description);
            textEditGroups.add(group);
            cuRewrite.getASTRewrite().replace((ASTNode)this.fQualifier, (ASTNode)type, group);
        }
    }
}

