/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.eclipse.ant.core.AntSecurityException;
import org.eclipse.ant.internal.ui.AntUIImages;
import org.eclipse.ant.internal.ui.editor.AntEditorCompletionProcessor;
import org.eclipse.ant.internal.ui.model.AntModelMessages;
import org.eclipse.ant.internal.ui.model.AntTaskNode;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.IRegion;
import org.xml.sax.Attributes;

public class AntPropertyNode
extends AntTaskNode {
    private String fValue = null;
    private String fReferencedName;
    private String fOccurrencesStartingPoint = "value";
    private String fOccurrencesIdentifier;
    private Map fProperties = null;

    public AntPropertyNode(Task task, Attributes attributes) {
        super(task);
        String label = attributes.getValue("name");
        if (label == null) {
            label = attributes.getValue("file");
            if (label != null) {
                this.fReferencedName = label;
                label = "file=" + label;
            } else {
                label = attributes.getValue("resource");
                if (label != null) {
                    this.fReferencedName = label;
                    label = "resource=" + label;
                } else {
                    label = attributes.getValue("environment");
                    if (label != null) {
                        label = "environment=" + label;
                    } else {
                        label = attributes.getValue("srcFile");
                        if (label != null) {
                            this.fReferencedName = label;
                            label = "srcFile=" + label;
                        }
                    }
                }
            }
        } else {
            this.fValue = attributes.getValue("value");
            if (this.fValue == null) {
                this.fOccurrencesStartingPoint = "location";
                this.fValue = attributes.getValue(this.fOccurrencesStartingPoint);
            }
        }
        this.setBaseLabel(label);
    }

    public String getProperty(String propertyName) {
        if (this.fProperties != null) {
            return (String)this.fProperties.get(propertyName);
        }
        return null;
    }

    protected ImageDescriptor getBaseImageDescriptor() {
        return AntUIImages.getImageDescriptor("org.eclipse.ant.ui.IMG_PROPERTY");
    }

    /*
     * Loose catch block
     */
    public boolean configure(boolean validateFully) {
        block10: {
            if (this.fConfigured) {
                return false;
            }
            try {
                try {
                    this.getProjectNode().setCurrentConfiguringProperty(this);
                    this.getTask().maybeConfigure();
                    this.getTask().execute();
                    this.fConfigured = true;
                }
                catch (BuildException be) {
                    this.handleBuildException(be, "problem_properties");
                    this.getProjectNode().setCurrentConfiguringProperty(null);
                }
                catch (LinkageError linkageError) {
                    this.handleBuildException(new BuildException(AntModelMessages.AntPropertyNode_0), "problem_properties");
                    this.getProjectNode().setCurrentConfiguringProperty(null);
                }
                catch (AntSecurityException antSecurityException) {
                    this.handleBuildException(new BuildException(AntModelMessages.AntPropertyNode_1), "problem_security");
                    this.getProjectNode().setCurrentConfiguringProperty(null);
                    break block10;
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                }
            }
            finally {
                this.getProjectNode().setCurrentConfiguringProperty(null);
            }
        }
        return false;
    }

    public void addProperty(String propertyName, String value) {
        if (this.fProperties == null) {
            this.fProperties = new HashMap(1);
        }
        this.fProperties.put(propertyName, value);
    }

    public String getReferencedElement(int offset) {
        String attributeString;
        String textToSearch;
        if (this.fReferencedName != null && (textToSearch = this.getAntModel().getText(this.getOffset(), offset - this.getOffset())) != null && textToSearch.length() != 0 && ("file".equals(attributeString = AntEditorCompletionProcessor.getAttributeStringFromDocumentStringToPrefix(textToSearch)) || "resource".equals(attributeString) || "srcFile".equals(attributeString))) {
            return this.fReferencedName;
        }
        return null;
    }

    public boolean containsOccurrence(String identifier) {
        if (!this.getTask().getTaskName().equals("property")) {
            return super.containsOccurrence(identifier);
        }
        if (this.fValue != null) {
            return this.fValue.indexOf(identifier) != -1;
        }
        return false;
    }

    public String getOccurrencesIdentifier() {
        if (this.fOccurrencesIdentifier == null) {
            this.fOccurrencesIdentifier = "${" + this.fBaseLabel + '}';
        }
        return this.fOccurrencesIdentifier;
    }

    public boolean isRegionPotentialReference(IRegion region) {
        boolean superOK = super.isRegionPotentialReference(region);
        if (!this.getTask().getTaskName().equals("property") || !superOK) {
            return superOK;
        }
        String textToSearch = this.getAntModel().getText(this.getOffset(), this.getLength());
        if (textToSearch == null) {
            return false;
        }
        int valueOffset = textToSearch.indexOf(this.fOccurrencesStartingPoint);
        if (valueOffset > -1 && (valueOffset = textToSearch.indexOf(34, valueOffset)) > -1) {
            boolean inValue;
            boolean bl = inValue = region.getOffset() >= this.getOffset() + valueOffset;
            if (inValue) {
                return "{".equals(this.getAntModel().getText(region.getOffset() - 1, 1)) || "}".equals(this.getAntModel().getText(region.getOffset() + region.getLength(), 1));
            }
            return true;
        }
        return false;
    }

    public List computeIdentifierOffsets(String identifier) {
        if (!this.getTask().getTaskName().equals("property")) {
            return super.computeIdentifierOffsets(identifier);
        }
        String textToSearch = this.getAntModel().getText(this.getOffset(), this.getLength());
        if (textToSearch == null || textToSearch.length() == 0 || identifier.length() == 0) {
            return null;
        }
        ArrayList<Integer> results = new ArrayList<Integer>();
        if (this.fBaseLabel != null && this.fBaseLabel.equals(identifier)) {
            int nameOffset = textToSearch.indexOf("name");
            nameOffset = textToSearch.indexOf(identifier, nameOffset + 1);
            results.add(new Integer(this.getOffset() + nameOffset));
        }
        if (this.fValue != null) {
            int valueOffset = textToSearch.indexOf(this.fOccurrencesStartingPoint);
            int endOffset = this.getOffset() + this.getLength();
            while (valueOffset < endOffset) {
                if ((valueOffset = textToSearch.indexOf(identifier, valueOffset)) == -1 || valueOffset > endOffset) break;
                results.add(new Integer(this.getOffset() + valueOffset));
                valueOffset += identifier.length();
            }
        }
        return results;
    }

    public boolean isFromDeclaration(IRegion region) {
        if (this.fBaseLabel == null) {
            return false;
        }
        if (this.fBaseLabel.length() != region.getLength()) {
            return false;
        }
        int offset = this.getOffset();
        String textToSearch = this.getAntModel().getText(this.getOffset(), this.getLength());
        if (textToSearch == null || textToSearch.length() == 0) {
            return false;
        }
        int nameStartOffset = textToSearch.indexOf("name");
        nameStartOffset = textToSearch.indexOf("\"", nameStartOffset);
        int nameEndOffset = textToSearch.indexOf("\"", nameStartOffset + 1);
        return (nameStartOffset += offset) <= region.getOffset() && region.getOffset() + region.getLength() <= (nameEndOffset += offset);
    }
}

