/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.ui.views.contentoutline;

import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.util.TransferDragSourceListener;
import org.eclipse.jface.util.TransferDropTargetListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.ui.internal.IReleasable;
import org.eclipse.wst.sse.ui.views.contentoutline.ContentOutlineConfiguration;
import org.eclipse.wst.xml.ui.internal.XMLUIPlugin;
import org.eclipse.wst.xml.ui.internal.contentoutline.JFaceNodeContentProvider;
import org.eclipse.wst.xml.ui.internal.contentoutline.JFaceNodeLabelProvider;
import org.eclipse.wst.xml.ui.internal.contentoutline.XMLNodeActionManager;
import org.eclipse.wst.xml.ui.internal.dnd.DragNodeCommand;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;

public abstract class AbstractXMLContentOutlineConfiguration
extends ContentOutlineConfiguration {
    private IContentProvider fContentProvider = null;
    private ActionManagerMenuListener fContextMenuFiller = null;
    private ILabelProvider fLabelProvider = null;
    boolean fShowAttributes = false;
    private ILabelProvider fSimpleLabelProvider;
    private TransferDragSourceListener[] fTransferDragSourceListeners;
    private TransferDropTargetListener[] fTransferDropTargetListeners;

    protected XMLNodeActionManager createNodeActionManager(TreeViewer treeViewer) {
        return new XMLNodeActionManager((IStructuredModel)treeViewer.getInput(), (Viewer)treeViewer);
    }

    public IContentProvider getContentProvider(TreeViewer viewer) {
        if (this.fContentProvider == null) {
            this.fContentProvider = new JFaceNodeContentProvider();
        }
        return this.fContentProvider;
    }

    public ILabelProvider getLabelProvider(TreeViewer viewer) {
        if (this.fLabelProvider == null) {
            this.fLabelProvider = new JFaceNodeLabelProvider();
        }
        return this.fLabelProvider;
    }

    public IMenuListener getMenuListener(TreeViewer viewer) {
        if (this.fContextMenuFiller == null) {
            this.fContextMenuFiller = new ActionManagerMenuListener(viewer);
        }
        return this.fContextMenuFiller;
    }

    protected IPreferenceStore getPreferenceStore() {
        return XMLUIPlugin.getDefault().getPreferenceStore();
    }

    public ILabelProvider getStatusLineLabelProvider(TreeViewer treeViewer) {
        if (this.fSimpleLabelProvider == null) {
            this.fSimpleLabelProvider = new StatusLineLabelProvider();
        }
        return this.fSimpleLabelProvider;
    }

    public TransferDragSourceListener[] getTransferDragSourceListeners(final TreeViewer treeViewer) {
        if (this.fTransferDragSourceListeners == null) {
            this.fTransferDragSourceListeners = new TransferDragSourceListener[]{new TransferDragSourceListener(){

                public void dragFinished(DragSourceEvent event) {
                    LocalSelectionTransfer.getTransfer().setSelection(null);
                }

                public void dragSetData(DragSourceEvent event) {
                }

                public void dragStart(DragSourceEvent event) {
                    LocalSelectionTransfer.getTransfer().setSelection(treeViewer.getSelection());
                }

                public Transfer getTransfer() {
                    return LocalSelectionTransfer.getTransfer();
                }
            }};
        }
        return this.fTransferDragSourceListeners;
    }

    public TransferDropTargetListener[] getTransferDropTargetListeners(final TreeViewer treeViewer) {
        if (this.fTransferDropTargetListeners == null) {
            this.fTransferDropTargetListeners = new TransferDropTargetListener[]{new TransferDropTargetListener(){

                public void dragEnter(DropTargetEvent event) {
                }

                public void dragLeave(DropTargetEvent event) {
                }

                public void dragOperationChanged(DropTargetEvent event) {
                }

                public void dragOver(DropTargetEvent event) {
                    event.feedback = 1;
                    float feedbackFloat = this.getHeightInItem(event);
                    if ((double)feedbackFloat > 0.75) {
                        event.feedback = 4;
                    } else if ((double)feedbackFloat < 0.25) {
                        event.feedback = 2;
                    }
                    event.feedback |= 0x18;
                }

                public void drop(DropTargetEvent event) {
                    IStructuredSelection selection;
                    if (event.operations != 0 && LocalSelectionTransfer.getTransfer().getSelection() != null && !LocalSelectionTransfer.getTransfer().getSelection().isEmpty() && (selection = (IStructuredSelection)LocalSelectionTransfer.getTransfer().getSelection()) != null && !selection.isEmpty() && event.item != null && event.item.getData() != null) {
                        float feedbackFloat = this.getHeightInItem(event);
                        DragNodeCommand command = new DragNodeCommand(event.item.getData(), feedbackFloat, event.operations, event.detail, selection.toList(), treeViewer);
                        if (command != null && command.canExecute()) {
                            SafeRunnable.run((ISafeRunnable)new SafeRunnable(this, command){
                                final /* synthetic */ 2 this$1;
                                private final /* synthetic */ DragNodeCommand val$command;
                                {
                                    this.this$1 = var1_1;
                                    this.val$command = dragNodeCommand;
                                }

                                public void run() throws Exception {
                                    this.val$command.execute();
                                }
                            });
                        }
                    }
                }

                public void dropAccept(DropTargetEvent event) {
                }

                private float getHeightInItem(DropTargetEvent event) {
                    if (event.item == null) {
                        return 0.5f;
                    }
                    if (event.item instanceof TreeItem) {
                        TreeItem treeItem = (TreeItem)event.item;
                        Tree control = treeItem.getParent();
                        Point point = control.toControl(new Point(event.x, event.y));
                        Rectangle bounds = treeItem.getBounds();
                        return (float)(point.y - bounds.y) / (float)bounds.height;
                    }
                    if (event.item instanceof TableItem) {
                        TableItem tableItem = (TableItem)event.item;
                        Table control = tableItem.getParent();
                        Point point = control.toControl(new Point(event.x, event.y));
                        Rectangle bounds = tableItem.getBounds(0);
                        return (float)(point.y - bounds.y) / (float)bounds.height;
                    }
                    return 0.0f;
                }

                public Transfer getTransfer() {
                    return LocalSelectionTransfer.getTransfer();
                }

                public boolean isEnabled(DropTargetEvent event) {
                    return this.getTransfer().isSupportedType(event.currentDataType);
                }
            }};
        }
        return this.fTransferDropTargetListeners;
    }

    public void unconfigure(TreeViewer viewer) {
        super.unconfigure(viewer);
        this.fTransferDragSourceListeners = null;
        this.fTransferDropTargetListeners = null;
        if (this.fContextMenuFiller != null) {
            this.fContextMenuFiller.release();
            this.fContextMenuFiller = null;
        }
    }

    private class ActionManagerMenuListener
    implements IMenuListener,
    IReleasable {
        private XMLNodeActionManager fActionManager;
        private TreeViewer fTreeViewer;

        public ActionManagerMenuListener(TreeViewer viewer) {
            this.fTreeViewer = viewer;
        }

        public void menuAboutToShow(IMenuManager manager) {
            if (this.fActionManager == null) {
                this.fActionManager = AbstractXMLContentOutlineConfiguration.this.createNodeActionManager(this.fTreeViewer);
            }
            if (this.fActionManager != null) {
                this.fActionManager.fillContextMenu(manager, this.fTreeViewer.getSelection());
            }
        }

        public void release() {
            this.fTreeViewer = null;
            if (this.fActionManager != null) {
                this.fActionManager.setModel(null);
            }
        }
    }

    private static class StatusLineLabelProvider
    extends JFaceNodeLabelProvider {
        public String getText(Object element) {
            if (element == null) {
                return null;
            }
            if (!(element instanceof Node)) {
                return super.getText(element);
            }
            StringBuffer s = new StringBuffer();
            Node node = (Node)element;
            while (node != null) {
                if (node.getNodeType() != 9) {
                    s.insert(0, super.getText(node));
                }
                if ((node = node.getNodeType() == 2 ? ((Attr)node).getOwnerElement() : node.getParentNode()) == null || node.getNodeType() == 9) continue;
                s.insert(0, '/');
            }
            return s.toString();
        }
    }
}

