/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.jpa1.context;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jpt.core.JpaProject;
import org.eclipse.jpt.core.JpaResourceType;
import org.eclipse.jpt.core.context.MappingFileRoot;
import org.eclipse.jpt.core.context.persistence.Persistence;
import org.eclipse.jpt.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.core.context.persistence.PersistenceXml;
import org.eclipse.jpt.core.internal.context.AbstractJpaContextNode;
import org.eclipse.jpt.core.internal.validation.DefaultJpaValidationMessages;
import org.eclipse.jpt.core.jpa2.context.JpaRootContextNode2_0;
import org.eclipse.jpt.core.jpa2.context.persistence.PersistenceXml2_0;
import org.eclipse.jpt.core.resource.java.JavaResourceCompilationUnit;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.core.resource.xml.JpaXmlResource;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.HashBag;
import org.eclipse.jst.j2ee.model.internal.validation.ValidationCancelledException;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericRootContextNode
extends AbstractJpaContextNode
implements JpaRootContextNode2_0 {
    protected final JpaProject jpaProject;
    protected PersistenceXml persistenceXml;

    public GenericRootContextNode(JpaProject jpaProject) {
        super(null);
        if (jpaProject == null) {
            throw new NullPointerException();
        }
        this.jpaProject = jpaProject;
        this.initialize();
    }

    @Override
    protected boolean requiresParent() {
        return false;
    }

    protected void initialize() {
        JpaXmlResource resource = this.resolvePersistenceXmlResource();
        if (resource != null) {
            this.persistenceXml = this.buildPersistenceXml(resource);
        }
    }

    @Override
    public void update(IProgressMonitor monitor) {
        JpaXmlResource xmlResource = this.resolvePersistenceXmlResource();
        if (xmlResource == null) {
            if (this.persistenceXml != null) {
                this.persistenceXml.dispose();
                this.setPersistenceXml(null);
            }
        } else if (this.persistenceXml == null) {
            this.setPersistenceXml(this.buildPersistenceXml(xmlResource));
        } else {
            this.persistenceXml.update();
        }
    }

    @Override
    public void postUpdate() {
        super.postUpdate();
        if (this.persistenceXml != null) {
            this.persistenceXml.postUpdate();
        }
    }

    @Override
    public JpaProject getJpaProject() {
        return this.jpaProject;
    }

    @Override
    public IResource getResource() {
        return this.getProject();
    }

    protected IProject getProject() {
        return this.jpaProject.getProject();
    }

    @Override
    public PersistenceUnit getPersistenceUnit() {
        return null;
    }

    @Override
    public MappingFileRoot getMappingFileRoot() {
        return null;
    }

    @Override
    public PersistenceXml getPersistenceXml() {
        return this.persistenceXml;
    }

    protected void setPersistenceXml(PersistenceXml persistenceXml) {
        PersistenceXml old = this.persistenceXml;
        this.persistenceXml = persistenceXml;
        this.firePropertyChanged("persistenceXml", old, persistenceXml);
    }

    protected JpaXmlResource resolvePersistenceXmlResource() {
        JpaXmlResource xmlResource = this.jpaProject.getPersistenceXmlResource();
        if (xmlResource == null) {
            return null;
        }
        if (xmlResource.isReverting()) {
            return null;
        }
        JpaResourceType resourceType = xmlResource.getResourceType();
        if (resourceType == null) {
            return null;
        }
        if (!this.getJpaPlatform().supportsResourceType(resourceType)) {
            return null;
        }
        return xmlResource;
    }

    protected PersistenceXml buildPersistenceXml(JpaXmlResource resource) {
        return this.getJpaFactory().buildPersistenceXml(this, resource);
    }

    @Override
    public void initializeMetamodel() {
        if (this.persistenceXml != null) {
            ((PersistenceXml2_0)this.persistenceXml).initializeMetamodel();
        }
    }

    @Override
    public void synchronizeMetamodel() {
        if (this.persistenceXml != null) {
            ((PersistenceXml2_0)this.persistenceXml).synchronizeMetamodel();
        }
    }

    @Override
    public void disposeMetamodel() {
        if (this.persistenceXml != null) {
            ((PersistenceXml2_0)this.persistenceXml).disposeMetamodel();
        }
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter) {
        if (reporter.isCancelled()) {
            throw new ValidationCancelledException();
        }
        if (this.persistenceXml == null) {
            messages.add(this.buildPersistenceXmlValidationMessage());
            return;
        }
        if (!this.jpaProject.discoversAnnotatedClasses()) {
            this.validateOrphanClasses(messages);
        }
        this.persistenceXml.validate(messages, reporter);
    }

    protected IMessage buildPersistenceXmlValidationMessage() {
        int severity = 1;
        IFile file = this.getPlatformFile();
        if (file.exists()) {
            JpaXmlResource xmlResource = this.jpaProject.getPersistenceXmlResource();
            if (xmlResource != null && !this.getJpaPlatform().supportsResourceType(xmlResource.getResourceType())) {
                return DefaultJpaValidationMessages.buildMessage(severity, "PERSISTENCE_XML_UNSUPPORTED_CONTENT", file);
            }
            return DefaultJpaValidationMessages.buildMessage(severity, "PERSISTENCE_XML_INVALID_CONTENT", file);
        }
        return DefaultJpaValidationMessages.buildMessage(severity, "PROJECT_NO_PERSISTENCE_XML", this);
    }

    protected IFile getPlatformFile() {
        return this.jpaProject.convertToPlatformFile("META-INF/persistence.xml");
    }

    protected void validateOrphanClasses(List<IMessage> messages) {
        Persistence persistence = this.persistenceXml.getPersistence();
        if (persistence == null) {
            return;
        }
        if (persistence.persistenceUnitsSize() != 1) {
            return;
        }
        PersistenceUnit persistenceUnit = persistence.persistenceUnits().next();
        HashBag annotatedClassNames = CollectionTools.bag(this.jpaProject.annotatedJavaSourceClassNames());
        HashBag orphans = annotatedClassNames.clone();
        for (String annotatedClassName : annotatedClassNames) {
            if (!persistenceUnit.specifiesPersistentType(annotatedClassName)) continue;
            orphans.remove((Object)annotatedClassName);
        }
        for (String orphan : orphans) {
            JavaResourcePersistentType jrpt = this.jpaProject.getJavaResourcePersistentType(orphan);
            JavaResourceCompilationUnit jrcu = jrpt.getJavaResourceCompilationUnit();
            if (jrpt.isMapped()) {
                messages.add(DefaultJpaValidationMessages.buildMessage(1, "PERSISTENT_TYPE_MAPPED_BUT_NOT_INCLUDED_IN_PERSISTENCE_UNIT", new String[]{jrpt.getName()}, jrpt.getFile(), jrpt.getNameTextRange(jrcu.buildASTRoot())));
                continue;
            }
            messages.add(DefaultJpaValidationMessages.buildMessage(2, "PERSISTENT_TYPE_ANNOTATED_BUT_NOT_INCLUDED_IN_PERSISTENCE_UNIT", new String[]{jrpt.getName()}, jrpt.getFile(), jrpt.getNameTextRange(jrcu.buildASTRoot())));
        }
    }
}

