/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.modules.unittest.components;

import java.io.File;
import java.util.Collection;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.ease.ExitException;
import org.eclipse.ease.IExecutionListener;
import org.eclipse.ease.IScriptEngine;
import org.eclipse.ease.ScriptResult;
import org.eclipse.ease.modules.unittest.components.Test;
import org.eclipse.ease.modules.unittest.components.TestComposite;
import org.eclipse.ease.modules.unittest.components.TestEntity;
import org.eclipse.ease.modules.unittest.components.TestStatus;
import org.eclipse.ease.modules.unittest.components.TestSuite;
import org.eclipse.ease.tools.ResourceTools;

public class TestFile
extends TestComposite
implements Comparable<TestFile> {
    private TestFileJob fJob;
    private final String fFileLocation;

    public TestFile(TestSuite suite, String fileLocation) {
        super(suite);
        this.fFileLocation = fileLocation;
    }

    public void execute() {
        this.fJob = new TestFileJob("TestFile: " + this.toString());
        this.fJob.schedule();
    }

    public String getCodeFragment(String identifier) {
        return this.getTestSuite().getModel().getCodeFragment(identifier);
    }

    public void terminate() {
        if (this.fJob != null) {
            this.fJob.cancel();
            IScriptEngine engine = this.getScriptEngine();
            if (engine != null) {
                engine.terminateCurrent();
            }
        }
    }

    public TestSuite getTestSuite() {
        return (TestSuite)this.getParent();
    }

    @Override
    public Collection<? extends TestEntity> getChildren() {
        return this.getTests();
    }

    @Override
    public void reset() {
        IFile parent = this.getTestSuite() != null ? this.getTestSuite().getModel().getFile() : null;
        Object file = ResourceTools.resolveFile((Object)this.fFileLocation, (Object)parent, (boolean)true);
        if (file instanceof IFile) {
            try {
                ((IFile)file).deleteMarkers("org.eclipse.ease.modules.unittest.scriptassertion", false, 0);
            }
            catch (CoreException e) {
                throw new RuntimeException(e);
            }
        }
        super.reset();
    }

    @Override
    public int compareTo(TestFile o) {
        return this.fFileLocation.compareTo(o.fFileLocation);
    }

    @Override
    public Object getFile() {
        return ResourceTools.resolveFile((Object)this.fFileLocation, (Object)this.getTestSuite().getModel().getFile(), (boolean)true);
    }

    public String toString() {
        Object file = this.getFile();
        if (file instanceof IFile) {
            return ((IFile)file).getName();
        }
        if (file instanceof File) {
            return ((File)file).getName();
        }
        return super.toString();
    }

    static /* synthetic */ String access$1(TestFile testFile) {
        return testFile.fFileLocation;
    }

    private class TestFileJob
    extends Job {
        public TestFileJob(String name) {
            super(name);
        }

        /*
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected IStatus run(IProgressMonitor monitor) {
            TestFile.this.reset();
            TestFile.this.setStatus(TestStatus.RUNNING);
            TestFile.this.setScriptEngine(TestFile.this.getTestSuite().createScriptEngine());
            TestFile.this.getScriptEngine().setOutputStream(TestFile.this.getTestSuite().getOutputStream());
            TestFile.this.getScriptEngine().setErrorStream(TestFile.this.getTestSuite().getErrorStream());
            TestFile.this.getScriptEngine().addExecutionListener((IExecutionListener)TestFile.this);
            TestFile.this.getScriptEngine().setTerminateOnIdle(false);
            for (Map.Entry<String, Object> entry : TestFile.this.getTestSuite().getVariables().entrySet()) {
                if (entry.getKey().startsWith("__MOD_")) continue;
                TestFile.this.getScriptEngine().setVariable(entry.getKey(), entry.getValue());
            }
            TestFile.this.getScriptEngine().setVariable("__internal_testObject", (Object)TestFile.this);
            TestFile.this.getScriptEngine().executeAsync((Object)"loadModule('Unittest')");
            TestFile.this.getScriptEngine().schedule();
            runTeardown = true;
            try {
                if (monitor.isCanceled()) {
                    TestFile.this.addTestResult(TestStatus.FAILURE, "Test aborted by user");
                    var5_5 = Status.CANCEL_STATUS;
                    return var5_5;
                }
                if (!this.runCodeFragment("TestFile Setup", monitor)) {
                    var5_6 = Status.OK_STATUS;
                    return var5_6;
                }
                if (monitor.isCanceled()) {
                    TestFile.this.addTestResult(TestStatus.FAILURE, "Test aborted by user");
                    var5_7 = Status.CANCEL_STATUS;
                    return var5_7;
                }
                testFileResult = TestFile.this.getScriptEngine().executeSync(ResourceTools.resolveFile((Object)TestFile.access$1(TestFile.this), (Object)TestFile.this.getTestSuite().getModel().getFile(), (boolean)true));
                if (testFileResult.hasException() && !(testFileResult.getException() instanceof ExitException)) {
                    TestFile.this.addTestResult(TestStatus.FAILURE, TestSuite.getExceptionMessage(testFileResult.getException()));
                    runTeardown = TestFile.this.getTestSuite().getModel().getFlag("execute teardown on failure", true);
                    var5_8 = Status.OK_STATUS;
                    return var5_8;
                }
                if (monitor.isCanceled()) {
                    TestFile.this.addTestResult(TestStatus.FAILURE, "Test aborted by user");
                    var5_9 = Status.CANCEL_STATUS;
                    return var5_9;
                }
            }
            catch (InterruptedException v0) {
                runTeardown = TestFile.this.getTestSuite().getModel().getFlag("execute teardown on failure", true);
                var5_10 = Status.CANCEL_STATUS;
                return var5_10;
            }
            finally {
                if (runTeardown) {
                    try {
                        this.runCodeFragment("TestFile Teardown", monitor);
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                }
                ** for (test : TestFile.this.getTests())
            }
lbl-1000:
            // 1 sources

            {
                test.setStatus(TestStatus.PASS);
                continue;
            }
lbl56:
            // 1 sources

            TestFile.this.getScriptEngine().terminate();
            TestFile.this.setScriptEngine(null);
            TestFile.this.setStatus(TestStatus.PASS);
            return var5_10;
        }

        private boolean runCodeFragment(String fragmentID, IProgressMonitor monitor) throws InterruptedException {
            String fragmentCode = TestFile.this.getCodeFragment(fragmentID);
            if (fragmentCode != null && !fragmentCode.trim().isEmpty()) {
                TestFile.this.addTest(new Test((TestComposite)TestFile.this, "[" + fragmentID + "]", true));
                ScriptResult setupResult = TestFile.this.getScriptEngine().executeSync((Object)fragmentCode);
                if (setupResult.hasException()) {
                    TestFile.this.addTestResult(TestStatus.FAILURE, TestSuite.getExceptionMessage(setupResult.getException()));
                    TestFile.this.endTest();
                    return false;
                }
                TestFile.this.endTest();
            }
            return true;
        }
    }
}

