/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.ui.internal.views;

import org.eclipse.codewind.core.internal.CodewindApplication;
import org.eclipse.codewind.core.internal.Logger;
import org.eclipse.codewind.core.internal.connection.CodewindConnection;
import org.eclipse.codewind.ui.internal.messages.Messages;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.ui.navigator.CommonDropAdapter;
import org.eclipse.ui.navigator.CommonDropAdapterAssistant;

public class CodewindNavigatorDropAssistant
extends CommonDropAdapterAssistant {
    private CodewindConnection targetConn;
    private CodewindApplication sourceApp;

    public IStatus validateDrop(Object target, int operation, TransferData transferData) {
        IStructuredSelection sel;
        Object obj;
        ISelection s;
        this.targetConn = null;
        this.sourceApp = null;
        if (!(target instanceof CodewindConnection) || !((CodewindConnection)target).isConnected()) {
            return Status.CANCEL_STATUS;
        }
        this.targetConn = (CodewindConnection)target;
        if (LocalSelectionTransfer.getTransfer().isSupportedType(transferData) && !(s = LocalSelectionTransfer.getTransfer().getSelection()).isEmpty() && s instanceof IStructuredSelection && (obj = (sel = (IStructuredSelection)s).getFirstElement()) instanceof CodewindApplication) {
            CodewindApplication app = this.targetConn.getAppByName(((CodewindApplication)obj).name);
            if (app != null) {
                return Status.CANCEL_STATUS;
            }
            this.sourceApp = (CodewindApplication)obj;
            return Status.OK_STATUS;
        }
        return Status.CANCEL_STATUS;
    }

    public IStatus handleDrop(CommonDropAdapter dropAdapter, DropTargetEvent dropTargetEvent, Object target) {
        if (this.targetConn == null || this.sourceApp == null) {
            Logger.logError((String)"Drop handler called but either the target or the source is null");
            return Status.CANCEL_STATUS;
        }
        Job job = new Job(NLS.bind((String)Messages.UnbindActionJobTitle, (Object)this.sourceApp.name)){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    ((CodewindNavigatorDropAssistant)CodewindNavigatorDropAssistant.this).sourceApp.connection.requestProjectUnbind(((CodewindNavigatorDropAssistant)CodewindNavigatorDropAssistant.this).sourceApp.projectID);
                }
                catch (Exception e) {
                    Logger.logError((String)("Error requesting application remove: " + ((CodewindNavigatorDropAssistant)CodewindNavigatorDropAssistant.this).sourceApp.name), (Throwable)e);
                    return new Status(4, "org.eclipse.codewind.ui", NLS.bind((String)Messages.UnbindActionError, (Object)((CodewindNavigatorDropAssistant)CodewindNavigatorDropAssistant.this).sourceApp.name), (Throwable)e);
                }
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                return Status.OK_STATUS;
            }
        };
        job.schedule();
        job = new Job(NLS.bind((String)Messages.BindProjectWizardJobLabel, (Object)this.sourceApp.name)){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    CodewindNavigatorDropAssistant.this.targetConn.requestProjectBind(((CodewindNavigatorDropAssistant)CodewindNavigatorDropAssistant.this).sourceApp.name, ((CodewindNavigatorDropAssistant)CodewindNavigatorDropAssistant.this).sourceApp.fullLocalPath.toOSString(), ((CodewindNavigatorDropAssistant)CodewindNavigatorDropAssistant.this).sourceApp.projectLanguage.getId(), ((CodewindNavigatorDropAssistant)CodewindNavigatorDropAssistant.this).sourceApp.projectType.getId());
                    CodewindNavigatorDropAssistant.this.targetConn.refreshApps(null);
                }
                catch (Exception e) {
                    Logger.logError((String)("An error occured trying to add the project to Codewind: " + ((CodewindNavigatorDropAssistant)CodewindNavigatorDropAssistant.this).sourceApp.fullLocalPath.toOSString()), (Throwable)e);
                    return new Status(4, "org.eclipse.codewind.ui", NLS.bind((String)Messages.BindProjectWizardError, (Object)((CodewindNavigatorDropAssistant)CodewindNavigatorDropAssistant.this).sourceApp.fullLocalPath.toOSString()), (Throwable)e);
                }
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                return Status.OK_STATUS;
            }
        };
        job.schedule();
        return Status.OK_STATUS;
    }
}

