/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.ui.internal.actions;

import org.eclipse.codewind.core.internal.CodewindApplication;
import org.eclipse.codewind.core.internal.CodewindEclipseApplication;
import org.eclipse.codewind.core.internal.Logger;
import org.eclipse.codewind.core.internal.console.CodewindConsoleFactory;
import org.eclipse.codewind.core.internal.console.ProjectLogInfo;
import org.eclipse.codewind.core.internal.console.SocketConsole;
import org.eclipse.jface.action.Action;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.navigator.ICommonViewerSite;

public class LogFileAction
extends Action {
    private final ProjectLogInfo logInfo;
    private final CodewindEclipseApplication app;

    public LogFileAction(CodewindEclipseApplication app, ProjectLogInfo logInfo, ICommonViewerSite viewSite) {
        super(logInfo.logName, 2);
        this.logInfo = logInfo;
        this.app = app;
        this.setChecked(app.getConsole(logInfo) != null);
    }

    public void run() {
        if (this.app == null) {
            Logger.logError((String)"LogFileAction ran but no application was selected");
            return;
        }
        if (this.isChecked()) {
            SocketConsole console = CodewindConsoleFactory.createLogFileConsole((CodewindApplication)this.app, (ProjectLogInfo)this.logInfo);
            ConsolePlugin.getDefault().getConsoleManager().showConsoleView((IConsole)console);
            this.app.addConsole(console);
        } else {
            SocketConsole console = this.app.getConsole(this.logInfo);
            if (console != null) {
                IConsoleManager consoleManager = ConsolePlugin.getDefault().getConsoleManager();
                consoleManager.removeConsoles(new IConsole[]{console});
                this.app.removeConsole(console);
            }
        }
    }
}

