/*******************************************************************************
 * Copyright (c) 2012-2016 Codenvy, S.A.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * Codenvy, S.A. - initial API and implementation
 *******************************************************************************/


// GENERATED SOURCE. DO NOT EDIT.
package org.eclipse.che.api.workspace.server.dto;

import org.eclipse.che.dto.server.JsonSerializable;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;

import java.util.List;
import java.util.Map;


@SuppressWarnings({"unchecked", "cast"})
public class DtoServerImpls implements org.eclipse.che.dto.server.DtoFactoryVisitor {

  private static final Gson gson = new GsonBuilder().disableHtmlEscaping().create();

  @Override
  public void accept(org.eclipse.che.dto.server.DtoFactory dtoFactory) {
    dtoFactory.registerProvider(org.eclipse.che.api.workspace.shared.dto.EnvironmentDto.class, new org.eclipse.che.dto.server.DtoProvider<org.eclipse.che.api.workspace.shared.dto.EnvironmentDto>() {
        public Class<? extends org.eclipse.che.api.workspace.shared.dto.EnvironmentDto> getImplClass() {
            return EnvironmentDtoImpl.class;
        }

        public org.eclipse.che.api.workspace.shared.dto.EnvironmentDto newInstance() {
            return EnvironmentDtoImpl.make();
        }

        public org.eclipse.che.api.workspace.shared.dto.EnvironmentDto fromJson(String json) {
            return EnvironmentDtoImpl.fromJsonString(json);
        }

        public org.eclipse.che.api.workspace.shared.dto.EnvironmentDto fromJson(com.google.gson.JsonElement json) {
            return EnvironmentDtoImpl.fromJsonElement(json);
        }

        public org.eclipse.che.api.workspace.shared.dto.EnvironmentDto clone(org.eclipse.che.api.workspace.shared.dto.EnvironmentDto origin) {
            return new EnvironmentDtoImpl(origin);
        }
    });
    dtoFactory.registerProvider(org.eclipse.che.api.workspace.shared.dto.EnvironmentRecipeDto.class, new org.eclipse.che.dto.server.DtoProvider<org.eclipse.che.api.workspace.shared.dto.EnvironmentRecipeDto>() {
        public Class<? extends org.eclipse.che.api.workspace.shared.dto.EnvironmentRecipeDto> getImplClass() {
            return EnvironmentRecipeDtoImpl.class;
        }

        public org.eclipse.che.api.workspace.shared.dto.EnvironmentRecipeDto newInstance() {
            return EnvironmentRecipeDtoImpl.make();
        }

        public org.eclipse.che.api.workspace.shared.dto.EnvironmentRecipeDto fromJson(String json) {
            return EnvironmentRecipeDtoImpl.fromJsonString(json);
        }

        public org.eclipse.che.api.workspace.shared.dto.EnvironmentRecipeDto fromJson(com.google.gson.JsonElement json) {
            return EnvironmentRecipeDtoImpl.fromJsonElement(json);
        }

        public org.eclipse.che.api.workspace.shared.dto.EnvironmentRecipeDto clone(org.eclipse.che.api.workspace.shared.dto.EnvironmentRecipeDto origin) {
            return new EnvironmentRecipeDtoImpl(origin);
        }
    });
    dtoFactory.registerProvider(org.eclipse.che.api.workspace.shared.dto.ExtendedMachineDto.class, new org.eclipse.che.dto.server.DtoProvider<org.eclipse.che.api.workspace.shared.dto.ExtendedMachineDto>() {
        public Class<? extends org.eclipse.che.api.workspace.shared.dto.ExtendedMachineDto> getImplClass() {
            return ExtendedMachineDtoImpl.class;
        }

        public org.eclipse.che.api.workspace.shared.dto.ExtendedMachineDto newInstance() {
            return ExtendedMachineDtoImpl.make();
        }

        public org.eclipse.che.api.workspace.shared.dto.ExtendedMachineDto fromJson(String json) {
            return ExtendedMachineDtoImpl.fromJsonString(json);
        }

        public org.eclipse.che.api.workspace.shared.dto.ExtendedMachineDto fromJson(com.google.gson.JsonElement json) {
            return ExtendedMachineDtoImpl.fromJsonElement(json);
        }

        public org.eclipse.che.api.workspace.shared.dto.ExtendedMachineDto clone(org.eclipse.che.api.workspace.shared.dto.ExtendedMachineDto origin) {
            return new ExtendedMachineDtoImpl(origin);
        }
    });
    dtoFactory.registerProvider(org.eclipse.che.api.workspace.shared.dto.ProjectConfigDto.class, new org.eclipse.che.dto.server.DtoProvider<org.eclipse.che.api.workspace.shared.dto.ProjectConfigDto>() {
        public Class<? extends org.eclipse.che.api.workspace.shared.dto.ProjectConfigDto> getImplClass() {
            return ProjectConfigDtoImpl.class;
        }

        public org.eclipse.che.api.workspace.shared.dto.ProjectConfigDto newInstance() {
            return ProjectConfigDtoImpl.make();
        }

        public org.eclipse.che.api.workspace.shared.dto.ProjectConfigDto fromJson(String json) {
            return ProjectConfigDtoImpl.fromJsonString(json);
        }

        public org.eclipse.che.api.workspace.shared.dto.ProjectConfigDto fromJson(com.google.gson.JsonElement json) {
            return ProjectConfigDtoImpl.fromJsonElement(json);
        }

        public org.eclipse.che.api.workspace.shared.dto.ProjectConfigDto clone(org.eclipse.che.api.workspace.shared.dto.ProjectConfigDto origin) {
            return new ProjectConfigDtoImpl(origin);
        }
    });
    dtoFactory.registerProvider(org.eclipse.che.api.workspace.shared.dto.ProjectProblemDto.class, new org.eclipse.che.dto.server.DtoProvider<org.eclipse.che.api.workspace.shared.dto.ProjectProblemDto>() {
        public Class<? extends org.eclipse.che.api.workspace.shared.dto.ProjectProblemDto> getImplClass() {
            return ProjectProblemDtoImpl.class;
        }

        public org.eclipse.che.api.workspace.shared.dto.ProjectProblemDto newInstance() {
            return ProjectProblemDtoImpl.make();
        }

        public org.eclipse.che.api.workspace.shared.dto.ProjectProblemDto fromJson(String json) {
            return ProjectProblemDtoImpl.fromJsonString(json);
        }

        public org.eclipse.che.api.workspace.shared.dto.ProjectProblemDto fromJson(com.google.gson.JsonElement json) {
            return ProjectProblemDtoImpl.fromJsonElement(json);
        }

        public org.eclipse.che.api.workspace.shared.dto.ProjectProblemDto clone(org.eclipse.che.api.workspace.shared.dto.ProjectProblemDto origin) {
            return new ProjectProblemDtoImpl(origin);
        }
    });
    dtoFactory.registerProvider(org.eclipse.che.api.workspace.shared.dto.ServerConf2Dto.class, new org.eclipse.che.dto.server.DtoProvider<org.eclipse.che.api.workspace.shared.dto.ServerConf2Dto>() {
        public Class<? extends org.eclipse.che.api.workspace.shared.dto.ServerConf2Dto> getImplClass() {
            return ServerConf2DtoImpl.class;
        }

        public org.eclipse.che.api.workspace.shared.dto.ServerConf2Dto newInstance() {
            return ServerConf2DtoImpl.make();
        }

        public org.eclipse.che.api.workspace.shared.dto.ServerConf2Dto fromJson(String json) {
            return ServerConf2DtoImpl.fromJsonString(json);
        }

        public org.eclipse.che.api.workspace.shared.dto.ServerConf2Dto fromJson(com.google.gson.JsonElement json) {
            return ServerConf2DtoImpl.fromJsonElement(json);
        }

        public org.eclipse.che.api.workspace.shared.dto.ServerConf2Dto clone(org.eclipse.che.api.workspace.shared.dto.ServerConf2Dto origin) {
            return new ServerConf2DtoImpl(origin);
        }
    });
    dtoFactory.registerProvider(org.eclipse.che.api.workspace.shared.dto.SourceStorageDto.class, new org.eclipse.che.dto.server.DtoProvider<org.eclipse.che.api.workspace.shared.dto.SourceStorageDto>() {
        public Class<? extends org.eclipse.che.api.workspace.shared.dto.SourceStorageDto> getImplClass() {
            return SourceStorageDtoImpl.class;
        }

        public org.eclipse.che.api.workspace.shared.dto.SourceStorageDto newInstance() {
            return SourceStorageDtoImpl.make();
        }

        public org.eclipse.che.api.workspace.shared.dto.SourceStorageDto fromJson(String json) {
            return SourceStorageDtoImpl.fromJsonString(json);
        }

        public org.eclipse.che.api.workspace.shared.dto.SourceStorageDto fromJson(com.google.gson.JsonElement json) {
            return SourceStorageDtoImpl.fromJsonElement(json);
        }

        public org.eclipse.che.api.workspace.shared.dto.SourceStorageDto clone(org.eclipse.che.api.workspace.shared.dto.SourceStorageDto origin) {
            return new SourceStorageDtoImpl(origin);
        }
    });
    dtoFactory.registerProvider(org.eclipse.che.api.workspace.shared.dto.WorkspaceConfigDto.class, new org.eclipse.che.dto.server.DtoProvider<org.eclipse.che.api.workspace.shared.dto.WorkspaceConfigDto>() {
        public Class<? extends org.eclipse.che.api.workspace.shared.dto.WorkspaceConfigDto> getImplClass() {
            return WorkspaceConfigDtoImpl.class;
        }

        public org.eclipse.che.api.workspace.shared.dto.WorkspaceConfigDto newInstance() {
            return WorkspaceConfigDtoImpl.make();
        }

        public org.eclipse.che.api.workspace.shared.dto.WorkspaceConfigDto fromJson(String json) {
            return WorkspaceConfigDtoImpl.fromJsonString(json);
        }

        public org.eclipse.che.api.workspace.shared.dto.WorkspaceConfigDto fromJson(com.google.gson.JsonElement json) {
            return WorkspaceConfigDtoImpl.fromJsonElement(json);
        }

        public org.eclipse.che.api.workspace.shared.dto.WorkspaceConfigDto clone(org.eclipse.che.api.workspace.shared.dto.WorkspaceConfigDto origin) {
            return new WorkspaceConfigDtoImpl(origin);
        }
    });
    dtoFactory.registerProvider(org.eclipse.che.api.workspace.shared.dto.WorkspaceDto.class, new org.eclipse.che.dto.server.DtoProvider<org.eclipse.che.api.workspace.shared.dto.WorkspaceDto>() {
        public Class<? extends org.eclipse.che.api.workspace.shared.dto.WorkspaceDto> getImplClass() {
            return WorkspaceDtoImpl.class;
        }

        public org.eclipse.che.api.workspace.shared.dto.WorkspaceDto newInstance() {
            return WorkspaceDtoImpl.make();
        }

        public org.eclipse.che.api.workspace.shared.dto.WorkspaceDto fromJson(String json) {
            return WorkspaceDtoImpl.fromJsonString(json);
        }

        public org.eclipse.che.api.workspace.shared.dto.WorkspaceDto fromJson(com.google.gson.JsonElement json) {
            return WorkspaceDtoImpl.fromJsonElement(json);
        }

        public org.eclipse.che.api.workspace.shared.dto.WorkspaceDto clone(org.eclipse.che.api.workspace.shared.dto.WorkspaceDto origin) {
            return new WorkspaceDtoImpl(origin);
        }
    });
    dtoFactory.registerProvider(org.eclipse.che.api.workspace.shared.dto.WorkspaceRuntimeDto.class, new org.eclipse.che.dto.server.DtoProvider<org.eclipse.che.api.workspace.shared.dto.WorkspaceRuntimeDto>() {
        public Class<? extends org.eclipse.che.api.workspace.shared.dto.WorkspaceRuntimeDto> getImplClass() {
            return WorkspaceRuntimeDtoImpl.class;
        }

        public org.eclipse.che.api.workspace.shared.dto.WorkspaceRuntimeDto newInstance() {
            return WorkspaceRuntimeDtoImpl.make();
        }

        public org.eclipse.che.api.workspace.shared.dto.WorkspaceRuntimeDto fromJson(String json) {
            return WorkspaceRuntimeDtoImpl.fromJsonString(json);
        }

        public org.eclipse.che.api.workspace.shared.dto.WorkspaceRuntimeDto fromJson(com.google.gson.JsonElement json) {
            return WorkspaceRuntimeDtoImpl.fromJsonElement(json);
        }

        public org.eclipse.che.api.workspace.shared.dto.WorkspaceRuntimeDto clone(org.eclipse.che.api.workspace.shared.dto.WorkspaceRuntimeDto origin) {
            return new WorkspaceRuntimeDtoImpl(origin);
        }
    });
    dtoFactory.registerProvider(org.eclipse.che.api.workspace.shared.dto.WsAgentHealthStateDto.class, new org.eclipse.che.dto.server.DtoProvider<org.eclipse.che.api.workspace.shared.dto.WsAgentHealthStateDto>() {
        public Class<? extends org.eclipse.che.api.workspace.shared.dto.WsAgentHealthStateDto> getImplClass() {
            return WsAgentHealthStateDtoImpl.class;
        }

        public org.eclipse.che.api.workspace.shared.dto.WsAgentHealthStateDto newInstance() {
            return WsAgentHealthStateDtoImpl.make();
        }

        public org.eclipse.che.api.workspace.shared.dto.WsAgentHealthStateDto fromJson(String json) {
            return WsAgentHealthStateDtoImpl.fromJsonString(json);
        }

        public org.eclipse.che.api.workspace.shared.dto.WsAgentHealthStateDto fromJson(com.google.gson.JsonElement json) {
            return WsAgentHealthStateDtoImpl.fromJsonElement(json);
        }

        public org.eclipse.che.api.workspace.shared.dto.WsAgentHealthStateDto clone(org.eclipse.che.api.workspace.shared.dto.WsAgentHealthStateDto origin) {
            return new WsAgentHealthStateDtoImpl(origin);
        }
    });
    dtoFactory.registerProvider(org.eclipse.che.api.workspace.shared.dto.event.WorkspaceStatusEvent.class, new org.eclipse.che.dto.server.DtoProvider<org.eclipse.che.api.workspace.shared.dto.event.WorkspaceStatusEvent>() {
        public Class<? extends org.eclipse.che.api.workspace.shared.dto.event.WorkspaceStatusEvent> getImplClass() {
            return WorkspaceStatusEventImpl.class;
        }

        public org.eclipse.che.api.workspace.shared.dto.event.WorkspaceStatusEvent newInstance() {
            return WorkspaceStatusEventImpl.make();
        }

        public org.eclipse.che.api.workspace.shared.dto.event.WorkspaceStatusEvent fromJson(String json) {
            return WorkspaceStatusEventImpl.fromJsonString(json);
        }

        public org.eclipse.che.api.workspace.shared.dto.event.WorkspaceStatusEvent fromJson(com.google.gson.JsonElement json) {
            return WorkspaceStatusEventImpl.fromJsonElement(json);
        }

        public org.eclipse.che.api.workspace.shared.dto.event.WorkspaceStatusEvent clone(org.eclipse.che.api.workspace.shared.dto.event.WorkspaceStatusEvent origin) {
            return new WorkspaceStatusEventImpl(origin);
        }
    });
    dtoFactory.registerProvider(org.eclipse.che.api.workspace.shared.dto.stack.StackComponentDto.class, new org.eclipse.che.dto.server.DtoProvider<org.eclipse.che.api.workspace.shared.dto.stack.StackComponentDto>() {
        public Class<? extends org.eclipse.che.api.workspace.shared.dto.stack.StackComponentDto> getImplClass() {
            return StackComponentDtoImpl.class;
        }

        public org.eclipse.che.api.workspace.shared.dto.stack.StackComponentDto newInstance() {
            return StackComponentDtoImpl.make();
        }

        public org.eclipse.che.api.workspace.shared.dto.stack.StackComponentDto fromJson(String json) {
            return StackComponentDtoImpl.fromJsonString(json);
        }

        public org.eclipse.che.api.workspace.shared.dto.stack.StackComponentDto fromJson(com.google.gson.JsonElement json) {
            return StackComponentDtoImpl.fromJsonElement(json);
        }

        public org.eclipse.che.api.workspace.shared.dto.stack.StackComponentDto clone(org.eclipse.che.api.workspace.shared.dto.stack.StackComponentDto origin) {
            return new StackComponentDtoImpl(origin);
        }
    });
    dtoFactory.registerProvider(org.eclipse.che.api.workspace.shared.dto.stack.StackDto.class, new org.eclipse.che.dto.server.DtoProvider<org.eclipse.che.api.workspace.shared.dto.stack.StackDto>() {
        public Class<? extends org.eclipse.che.api.workspace.shared.dto.stack.StackDto> getImplClass() {
            return StackDtoImpl.class;
        }

        public org.eclipse.che.api.workspace.shared.dto.stack.StackDto newInstance() {
            return StackDtoImpl.make();
        }

        public org.eclipse.che.api.workspace.shared.dto.stack.StackDto fromJson(String json) {
            return StackDtoImpl.fromJsonString(json);
        }

        public org.eclipse.che.api.workspace.shared.dto.stack.StackDto fromJson(com.google.gson.JsonElement json) {
            return StackDtoImpl.fromJsonElement(json);
        }

        public org.eclipse.che.api.workspace.shared.dto.stack.StackDto clone(org.eclipse.che.api.workspace.shared.dto.stack.StackDto origin) {
            return new StackDtoImpl(origin);
        }
    });
    dtoFactory.registerProvider(org.eclipse.che.api.workspace.shared.dto.stack.StackSourceDto.class, new org.eclipse.che.dto.server.DtoProvider<org.eclipse.che.api.workspace.shared.dto.stack.StackSourceDto>() {
        public Class<? extends org.eclipse.che.api.workspace.shared.dto.stack.StackSourceDto> getImplClass() {
            return StackSourceDtoImpl.class;
        }

        public org.eclipse.che.api.workspace.shared.dto.stack.StackSourceDto newInstance() {
            return StackSourceDtoImpl.make();
        }

        public org.eclipse.che.api.workspace.shared.dto.stack.StackSourceDto fromJson(String json) {
            return StackSourceDtoImpl.fromJsonString(json);
        }

        public org.eclipse.che.api.workspace.shared.dto.stack.StackSourceDto fromJson(com.google.gson.JsonElement json) {
            return StackSourceDtoImpl.fromJsonElement(json);
        }

        public org.eclipse.che.api.workspace.shared.dto.stack.StackSourceDto clone(org.eclipse.che.api.workspace.shared.dto.stack.StackSourceDto origin) {
            return new StackSourceDtoImpl(origin);
        }
    });
  }

  @org.eclipse.che.dto.shared.DTOImpl("server")
  public static class EnvironmentDtoImpl implements org.eclipse.che.api.workspace.shared.dto.EnvironmentDto, JsonSerializable  {

    public static EnvironmentDtoImpl make() {
        return new EnvironmentDtoImpl();
    }

    public EnvironmentDtoImpl() {
    }

    protected java.util.Map<java.lang.String, org.eclipse.che.api.workspace.shared.dto.ExtendedMachineDto> machines;
    protected org.eclipse.che.api.workspace.shared.dto.EnvironmentRecipeDto recipe;

    @Override
    public java.util.Map<java.lang.String, org.eclipse.che.api.workspace.shared.dto.ExtendedMachineDto> getMachines() {
      ensureMachines();
      return new org.eclipse.che.dto.server.JsonStringMapImpl(machines);
    }

    public void setMachines(java.util.Map<java.lang.String, org.eclipse.che.api.workspace.shared.dto.ExtendedMachineDto> v) {
      this.machines = v;
    }

    public void putMachines(String k, org.eclipse.che.api.workspace.shared.dto.ExtendedMachineDto v) {
      ensureMachines();
      machines.put(k, v);
    }

    public void clearMachines() {
      ensureMachines();
      machines.clear();
    }

    protected void ensureMachines() {
      if (machines == null) {
        machines = new java.util.HashMap<java.lang.String, org.eclipse.che.api.workspace.shared.dto.ExtendedMachineDto>();
      }
    }
    @Override
    public org.eclipse.che.api.workspace.shared.dto.EnvironmentRecipeDto getRecipe() {
      return recipe;
    }

    public void setRecipe(org.eclipse.che.api.workspace.shared.dto.EnvironmentRecipeDto v) {
      this.recipe = v;
    }

    @Override
    public boolean equals(Object o) {
      if (!(o instanceof EnvironmentDtoImpl)) {
        return false;
      }
      EnvironmentDtoImpl other = (EnvironmentDtoImpl) o;
      this.ensureMachines();
      other.ensureMachines();
      
      if (this.machines != null) {
        if (!this.machines.equals(other.machines)) {
          return false;
        }
      } else {
        if (other.machines != null) {
          return false;
        }
      }
      if (this.recipe != null) {
        if (!this.recipe.equals(other.recipe)) {
          return false;
        }
      } else {
        if (other.recipe != null) {
          return false;
        }
      }
      return true;
    }

    @Override
    public int hashCode() {
      int hash = 7;
      ensureMachines();
      hash = hash * 31 + (machines != null ? machines.hashCode() : 0);
      hash = hash * 31 + (recipe != null ? recipe.hashCode() : 0);
      return hash;
    }

    @Override
    public JsonElement toJsonElement() {
      return toJsonElementInt(true);
    }
    public JsonElement toJsonElementInt(boolean copyJsons) {
      JsonObject result = new JsonObject();

      JsonObject machinesOut = new JsonObject();
      this.ensureMachines();
      for (java.util.Map.Entry<String, org.eclipse.che.api.workspace.shared.dto.ExtendedMachineDto> entry0 : this.machines.entrySet()) {
        org.eclipse.che.api.workspace.shared.dto.ExtendedMachineDto machines_ = entry0.getValue();
        JsonElement machinesOut_ = machines_ == null ? JsonNull.INSTANCE : ((ExtendedMachineDtoImpl)machines_).toJsonElementInt(copyJsons);
        machinesOut.add(entry0.getKey(), machinesOut_);
      }
      result.add("machines", machinesOut);

      JsonElement recipeOut = this.recipe == null ? JsonNull.INSTANCE : ((EnvironmentRecipeDtoImpl)this.recipe).toJsonElementInt(copyJsons);
      result.add("recipe", recipeOut);
      return result;
    }

    @Override
    public String toJson() {
      return gson.toJson(toJsonElementInt(false));
    }

    @Override
    public String toString() {
      return toJson();
    }

    public static EnvironmentDtoImpl fromJsonElement(JsonElement jsonElem) {
      return fromJsonElement(jsonElem, true);
    }
    public static EnvironmentDtoImpl fromJsonElement(JsonElement jsonElem, boolean copyJsons) {
      if (jsonElem == null || jsonElem.isJsonNull()) {
        return null;
      }

      EnvironmentDtoImpl dto = new EnvironmentDtoImpl();
      JsonObject json = jsonElem.getAsJsonObject();

      if (json.has("machines")) {
        JsonElement machinesIn = json.get("machines");
        java.util.Map<java.lang.String, org.eclipse.che.api.workspace.shared.dto.ExtendedMachineDto> machinesOut = null;
        if (machinesIn != null && !machinesIn.isJsonNull()) {
          machinesOut = new java.util.HashMap<java.lang.String, org.eclipse.che.api.workspace.shared.dto.ExtendedMachineDto>();
          java.util.Set<java.util.Map.Entry<String, JsonElement>> entries0 = machinesIn.getAsJsonObject().entrySet();
          for (java.util.Map.Entry<String, JsonElement> entry0 : entries0) {
            JsonElement machinesIn_ = entry0.getValue();
            org.eclipse.che.api.workspace.shared.dto.ExtendedMachineDto machinesOut_ = ExtendedMachineDtoImpl.fromJsonElement(machinesIn_, copyJsons);
            machinesOut.put(entry0.getKey(), machinesOut_);
          }
        }
        dto.setMachines(machinesOut);
      }

      if (json.has("recipe")) {
        JsonElement recipeIn = json.get("recipe");
        org.eclipse.che.api.workspace.shared.dto.EnvironmentRecipeDto recipeOut = EnvironmentRecipeDtoImpl.fromJsonElement(recipeIn, copyJsons);
        dto.setRecipe(recipeOut);
      }

      return dto;
    }

    public static EnvironmentDtoImpl fromJsonString(String jsonString) {
      if (jsonString == null) {
        return null;
      }

      return fromJsonElement(new JsonParser().parse(jsonString), false);
    }

    public EnvironmentDtoImpl(org.eclipse.che.api.workspace.shared.dto.EnvironmentDto origin) {
      java.util.Map<java.lang.String, org.eclipse.che.api.workspace.shared.dto.ExtendedMachineDto> machinesIn = origin.getMachines();
      if (machinesIn != null) {
        java.util.Map<java.lang.String, org.eclipse.che.api.workspace.shared.dto.ExtendedMachineDto> machinesOut = new java.util.HashMap<java.lang.String, org.eclipse.che.api.workspace.shared.dto.ExtendedMachineDto>();
        for (java.util.Map.Entry<String, org.eclipse.che.api.workspace.shared.dto.ExtendedMachineDto> entry0 : machinesIn.entrySet()) {
          org.eclipse.che.api.workspace.shared.dto.ExtendedMachineDto machinesIn_ = entry0.getValue();
            machinesOut.put(entry0.getKey(), machinesIn_ == null ? null : new ExtendedMachineDtoImpl(machinesIn_));
        }
        this.machines = machinesOut;
      }
      org.eclipse.che.api.workspace.shared.dto.EnvironmentRecipeDto recipeIn = origin.getRecipe();
      this.recipe = recipeIn == null ? null : new EnvironmentRecipeDtoImpl(recipeIn);
    }

    public org.eclipse.che.api.workspace.shared.dto.EnvironmentDto withMachines(java.util.Map<java.lang.String, org.eclipse.che.api.workspace.shared.dto.ExtendedMachineDto> v) {
      this.machines = v;
      return this;
    }

    public org.eclipse.che.api.workspace.shared.dto.EnvironmentDto withRecipe(org.eclipse.che.api.workspace.shared.dto.EnvironmentRecipeDto v) {
      this.recipe = v;
      return this;
    }

  }

  @org.eclipse.che.dto.shared.DTOImpl("server")
  public static class EnvironmentRecipeDtoImpl implements org.eclipse.che.api.workspace.shared.dto.EnvironmentRecipeDto, JsonSerializable  {

    public static EnvironmentRecipeDtoImpl make() {
        return new EnvironmentRecipeDtoImpl();
    }

    public EnvironmentRecipeDtoImpl() {
    }

    protected java.lang.String location;
    protected java.lang.String type;
    protected java.lang.String content;
    protected java.lang.String contentType;

    @Override
    public java.lang.String getLocation() {
      return location;
    }

    public void setLocation(java.lang.String v) {
      this.location = v;
    }

    @Override
    public java.lang.String getType() {
      return type;
    }

    public void setType(java.lang.String v) {
      this.type = v;
    }

    @Override
    public java.lang.String getContent() {
      return content;
    }

    public void setContent(java.lang.String v) {
      this.content = v;
    }

    @Override
    public java.lang.String getContentType() {
      return contentType;
    }

    public void setContentType(java.lang.String v) {
      this.contentType = v;
    }

    @Override
    public boolean equals(Object o) {
      if (!(o instanceof EnvironmentRecipeDtoImpl)) {
        return false;
      }
      EnvironmentRecipeDtoImpl other = (EnvironmentRecipeDtoImpl) o;
      if (this.location != null) {
        if (!this.location.equals(other.location)) {
          return false;
        }
      } else {
        if (other.location != null) {
          return false;
        }
      }
      if (this.type != null) {
        if (!this.type.equals(other.type)) {
          return false;
        }
      } else {
        if (other.type != null) {
          return false;
        }
      }
      if (this.content != null) {
        if (!this.content.equals(other.content)) {
          return false;
        }
      } else {
        if (other.content != null) {
          return false;
        }
      }
      if (this.contentType != null) {
        if (!this.contentType.equals(other.contentType)) {
          return false;
        }
      } else {
        if (other.contentType != null) {
          return false;
        }
      }
      return true;
    }

    @Override
    public int hashCode() {
      int hash = 7;
      hash = hash * 31 + (location != null ? location.hashCode() : 0);
      hash = hash * 31 + (type != null ? type.hashCode() : 0);
      hash = hash * 31 + (content != null ? content.hashCode() : 0);
      hash = hash * 31 + (contentType != null ? contentType.hashCode() : 0);
      return hash;
    }

    @Override
    public JsonElement toJsonElement() {
      return toJsonElementInt(true);
    }
    public JsonElement toJsonElementInt(boolean copyJsons) {
      JsonObject result = new JsonObject();

      JsonElement locationOut = (this.location == null) ? JsonNull.INSTANCE : new JsonPrimitive(this.location);
      result.add("location", locationOut);

      JsonElement typeOut = (this.type == null) ? JsonNull.INSTANCE : new JsonPrimitive(this.type);
      result.add("type", typeOut);

      JsonElement contentOut = (this.content == null) ? JsonNull.INSTANCE : new JsonPrimitive(this.content);
      result.add("content", contentOut);

      JsonElement contentTypeOut = (this.contentType == null) ? JsonNull.INSTANCE : new JsonPrimitive(this.contentType);
      result.add("contentType", contentTypeOut);
      return result;
    }

    @Override
    public String toJson() {
      return gson.toJson(toJsonElementInt(false));
    }

    @Override
    public String toString() {
      return toJson();
    }

    public static EnvironmentRecipeDtoImpl fromJsonElement(JsonElement jsonElem) {
      return fromJsonElement(jsonElem, true);
    }
    public static EnvironmentRecipeDtoImpl fromJsonElement(JsonElement jsonElem, boolean copyJsons) {
      if (jsonElem == null || jsonElem.isJsonNull()) {
        return null;
      }

      EnvironmentRecipeDtoImpl dto = new EnvironmentRecipeDtoImpl();
      JsonObject json = jsonElem.getAsJsonObject();

      if (json.has("location")) {
        JsonElement locationIn = json.get("location");
        java.lang.String locationOut = gson.fromJson(locationIn, java.lang.String.class);
        dto.setLocation(locationOut);
      }

      if (json.has("type")) {
        JsonElement typeIn = json.get("type");
        java.lang.String typeOut = gson.fromJson(typeIn, java.lang.String.class);
        dto.setType(typeOut);
      }

      if (json.has("content")) {
        JsonElement contentIn = json.get("content");
        java.lang.String contentOut = gson.fromJson(contentIn, java.lang.String.class);
        dto.setContent(contentOut);
      }

      if (json.has("contentType")) {
        JsonElement contentTypeIn = json.get("contentType");
        java.lang.String contentTypeOut = gson.fromJson(contentTypeIn, java.lang.String.class);
        dto.setContentType(contentTypeOut);
      }

      return dto;
    }

    public static EnvironmentRecipeDtoImpl fromJsonString(String jsonString) {
      if (jsonString == null) {
        return null;
      }

      return fromJsonElement(new JsonParser().parse(jsonString), false);
    }

    public EnvironmentRecipeDtoImpl(org.eclipse.che.api.workspace.shared.dto.EnvironmentRecipeDto origin) {
      this.location = origin.getLocation();
      this.type = origin.getType();
      this.content = origin.getContent();
      this.contentType = origin.getContentType();
    }

    public org.eclipse.che.api.workspace.shared.dto.EnvironmentRecipeDto withLocation(java.lang.String v) {
      this.location = v;
      return this;
    }

    public org.eclipse.che.api.workspace.shared.dto.EnvironmentRecipeDto withType(java.lang.String v) {
      this.type = v;
      return this;
    }

    public org.eclipse.che.api.workspace.shared.dto.EnvironmentRecipeDto withContent(java.lang.String v) {
      this.content = v;
      return this;
    }

    public org.eclipse.che.api.workspace.shared.dto.EnvironmentRecipeDto withContentType(java.lang.String v) {
      this.contentType = v;
      return this;
    }

  }

  @org.eclipse.che.dto.shared.DTOImpl("server")
  public static class ExtendedMachineDtoImpl implements org.eclipse.che.api.workspace.shared.dto.ExtendedMachineDto, JsonSerializable  {

    public static ExtendedMachineDtoImpl make() {
        return new ExtendedMachineDtoImpl();
    }

    public ExtendedMachineDtoImpl() {
    }

    protected java.util.Map<java.lang.String, java.lang.String> attributes;
    protected java.util.Map<java.lang.String, org.eclipse.che.api.workspace.shared.dto.ServerConf2Dto> servers;
    protected java.util.List<java.lang.String> agents;

    @Override
    public java.util.Map<java.lang.String, java.lang.String> getAttributes() {
      ensureAttributes();
      return new org.eclipse.che.dto.server.JsonStringMapImpl(attributes);
    }

    public void setAttributes(java.util.Map<java.lang.String, java.lang.String> v) {
      this.attributes = v;
    }

    public void putAttributes(String k, java.lang.String v) {
      ensureAttributes();
      attributes.put(k, v);
    }

    public void clearAttributes() {
      ensureAttributes();
      attributes.clear();
    }

    protected void ensureAttributes() {
      if (attributes == null) {
        attributes = new java.util.HashMap<java.lang.String, java.lang.String>();
      }
    }
    @Override
    public java.util.Map<java.lang.String, org.eclipse.che.api.workspace.shared.dto.ServerConf2Dto> getServers() {
      ensureServers();
      return new org.eclipse.che.dto.server.JsonStringMapImpl(servers);
    }

    public void setServers(java.util.Map<java.lang.String, org.eclipse.che.api.workspace.shared.dto.ServerConf2Dto> v) {
      this.servers = v;
    }

    public void putServers(String k, org.eclipse.che.api.workspace.shared.dto.ServerConf2Dto v) {
      ensureServers();
      servers.put(k, v);
    }

    public void clearServers() {
      ensureServers();
      servers.clear();
    }

    protected void ensureServers() {
      if (servers == null) {
        servers = new java.util.HashMap<java.lang.String, org.eclipse.che.api.workspace.shared.dto.ServerConf2Dto>();
      }
    }
    @Override
    public java.util.List<java.lang.String> getAgents() {
      ensureAgents();
      return new org.eclipse.che.dto.server.JsonArrayImpl(agents);
    }

    public void setAgents(java.util.List<java.lang.String> v) {
      this.agents = v;
    }

    public void addAgents(java.lang.String v) {
      ensureAgents();
      agents.add(v);
    }

    public void clearAgents() {
      ensureAgents();
      agents.clear();
    }

    protected void ensureAgents() {
      if (agents == null) {
        agents = new java.util.ArrayList<java.lang.String>();
      }
    }
    @Override
    public boolean equals(Object o) {
      if (!(o instanceof ExtendedMachineDtoImpl)) {
        return false;
      }
      ExtendedMachineDtoImpl other = (ExtendedMachineDtoImpl) o;
      this.ensureAttributes();
      other.ensureAttributes();
      
      if (this.attributes != null) {
        if (!this.attributes.equals(other.attributes)) {
          return false;
        }
      } else {
        if (other.attributes != null) {
          return false;
        }
      }
      this.ensureServers();
      other.ensureServers();
      
      if (this.servers != null) {
        if (!this.servers.equals(other.servers)) {
          return false;
        }
      } else {
        if (other.servers != null) {
          return false;
        }
      }
      this.ensureAgents();
      other.ensureAgents();
      
      if (this.agents != null) {
        if (!this.agents.equals(other.agents)) {
          return false;
        }
      } else {
        if (other.agents != null) {
          return false;
        }
      }
      return true;
    }

    @Override
    public int hashCode() {
      int hash = 7;
      ensureAttributes();
      hash = hash * 31 + (attributes != null ? attributes.hashCode() : 0);
      ensureServers();
      hash = hash * 31 + (servers != null ? servers.hashCode() : 0);
      ensureAgents();
      hash = hash * 31 + (agents != null ? agents.hashCode() : 0);
      return hash;
    }

    @Override
    public JsonElement toJsonElement() {
      return toJsonElementInt(true);
    }
    public JsonElement toJsonElementInt(boolean copyJsons) {
      JsonObject result = new JsonObject();

      JsonObject attributesOut = new JsonObject();
      this.ensureAttributes();
      for (java.util.Map.Entry<String, java.lang.String> entry0 : this.attributes.entrySet()) {
        java.lang.String attributes_ = entry0.getValue();
        JsonElement attributesOut_ = (attributes_ == null) ? JsonNull.INSTANCE : new JsonPrimitive(attributes_);
        attributesOut.add(entry0.getKey(), attributesOut_);
      }
      result.add("attributes", attributesOut);

      JsonObject serversOut = new JsonObject();
      this.ensureServers();
      for (java.util.Map.Entry<String, org.eclipse.che.api.workspace.shared.dto.ServerConf2Dto> entry0 : this.servers.entrySet()) {
        org.eclipse.che.api.workspace.shared.dto.ServerConf2Dto servers_ = entry0.getValue();
        JsonElement serversOut_ = servers_ == null ? JsonNull.INSTANCE : ((ServerConf2DtoImpl)servers_).toJsonElementInt(copyJsons);
        serversOut.add(entry0.getKey(), serversOut_);
      }
      result.add("servers", serversOut);

      JsonArray agentsOut = new JsonArray();
      this.ensureAgents();
      for (java.lang.String agents_ : this.agents) {
        JsonElement agentsOut_ = (agents_ == null) ? JsonNull.INSTANCE : new JsonPrimitive(agents_);
        agentsOut.add(agentsOut_);
      }
      result.add("agents", agentsOut);
      return result;
    }

    @Override
    public String toJson() {
      return gson.toJson(toJsonElementInt(false));
    }

    @Override
    public String toString() {
      return toJson();
    }

    public static ExtendedMachineDtoImpl fromJsonElement(JsonElement jsonElem) {
      return fromJsonElement(jsonElem, true);
    }
    public static ExtendedMachineDtoImpl fromJsonElement(JsonElement jsonElem, boolean copyJsons) {
      if (jsonElem == null || jsonElem.isJsonNull()) {
        return null;
      }

      ExtendedMachineDtoImpl dto = new ExtendedMachineDtoImpl();
      JsonObject json = jsonElem.getAsJsonObject();

      if (json.has("attributes")) {
        JsonElement attributesIn = json.get("attributes");
        java.util.Map<java.lang.String, java.lang.String> attributesOut = null;
        if (attributesIn != null && !attributesIn.isJsonNull()) {
          attributesOut = new java.util.HashMap<java.lang.String, java.lang.String>();
          java.util.Set<java.util.Map.Entry<String, JsonElement>> entries0 = attributesIn.getAsJsonObject().entrySet();
          for (java.util.Map.Entry<String, JsonElement> entry0 : entries0) {
            JsonElement attributesIn_ = entry0.getValue();
            java.lang.String attributesOut_ = gson.fromJson(attributesIn_, java.lang.String.class);
            attributesOut.put(entry0.getKey(), attributesOut_);
          }
        }
        dto.setAttributes(attributesOut);
      }

      if (json.has("servers")) {
        JsonElement serversIn = json.get("servers");
        java.util.Map<java.lang.String, org.eclipse.che.api.workspace.shared.dto.ServerConf2Dto> serversOut = null;
        if (serversIn != null && !serversIn.isJsonNull()) {
          serversOut = new java.util.HashMap<java.lang.String, org.eclipse.che.api.workspace.shared.dto.ServerConf2Dto>();
          java.util.Set<java.util.Map.Entry<String, JsonElement>> entries0 = serversIn.getAsJsonObject().entrySet();
          for (java.util.Map.Entry<String, JsonElement> entry0 : entries0) {
            JsonElement serversIn_ = entry0.getValue();
            org.eclipse.che.api.workspace.shared.dto.ServerConf2Dto serversOut_ = ServerConf2DtoImpl.fromJsonElement(serversIn_, copyJsons);
            serversOut.put(entry0.getKey(), serversOut_);
          }
        }
        dto.setServers(serversOut);
      }

      if (json.has("agents")) {
        JsonElement agentsIn = json.get("agents");
        java.util.List<java.lang.String> agentsOut = null;
        if (agentsIn != null && !agentsIn.isJsonNull()) {
          agentsOut = new java.util.ArrayList<java.lang.String>();
          java.util.Iterator<JsonElement> agentsInIterator = agentsIn.getAsJsonArray().iterator();
          while (agentsInIterator.hasNext()) {
            JsonElement agentsIn_ = agentsInIterator.next();
            java.lang.String agentsOut_ = gson.fromJson(agentsIn_, java.lang.String.class);
            agentsOut.add(agentsOut_);
          }
        }
        dto.setAgents(agentsOut);
      }

      return dto;
    }

    public static ExtendedMachineDtoImpl fromJsonString(String jsonString) {
      if (jsonString == null) {
        return null;
      }

      return fromJsonElement(new JsonParser().parse(jsonString), false);
    }

    public ExtendedMachineDtoImpl(org.eclipse.che.api.workspace.shared.dto.ExtendedMachineDto origin) {
      java.util.Map<java.lang.String, java.lang.String> attributesIn = origin.getAttributes();
      if (attributesIn != null) {
        java.util.Map<java.lang.String, java.lang.String> attributesOut = new java.util.HashMap<java.lang.String, java.lang.String>();
        for (java.util.Map.Entry<String, java.lang.String> entry0 : attributesIn.entrySet()) {
          java.lang.String attributesIn_ = entry0.getValue();
            attributesOut.put(entry0.getKey(), attributesIn_);
        }
        this.attributes = attributesOut;
      }
      java.util.Map<java.lang.String, org.eclipse.che.api.workspace.shared.dto.ServerConf2Dto> serversIn = origin.getServers();
      if (serversIn != null) {
        java.util.Map<java.lang.String, org.eclipse.che.api.workspace.shared.dto.ServerConf2Dto> serversOut = new java.util.HashMap<java.lang.String, org.eclipse.che.api.workspace.shared.dto.ServerConf2Dto>();
        for (java.util.Map.Entry<String, org.eclipse.che.api.workspace.shared.dto.ServerConf2Dto> entry0 : serversIn.entrySet()) {
          org.eclipse.che.api.workspace.shared.dto.ServerConf2Dto serversIn_ = entry0.getValue();
            serversOut.put(entry0.getKey(), serversIn_ == null ? null : new ServerConf2DtoImpl(serversIn_));
        }
        this.servers = serversOut;
      }
      java.util.List<java.lang.String> agentsIn = origin.getAgents();
      if (agentsIn != null) {
        java.util.List<java.lang.String> agentsOut = new java.util.ArrayList<java.lang.String>();
        for (java.lang.String agentsIn_ : agentsIn) {
            agentsOut.add(agentsIn_);
        }
        this.agents = agentsOut;
      }
    }

    public org.eclipse.che.api.workspace.shared.dto.ExtendedMachineDto withAttributes(java.util.Map<java.lang.String, java.lang.String> v) {
      this.attributes = v;
      return this;
    }

    public org.eclipse.che.api.workspace.shared.dto.ExtendedMachineDto withServers(java.util.Map<java.lang.String, org.eclipse.che.api.workspace.shared.dto.ServerConf2Dto> v) {
      this.servers = v;
      return this;
    }

    public org.eclipse.che.api.workspace.shared.dto.ExtendedMachineDto withAgents(java.util.List<java.lang.String> v) {
      this.agents = v;
      return this;
    }

  }

  @org.eclipse.che.dto.shared.DTOImpl("server")
  public static class ProjectConfigDtoImpl implements org.eclipse.che.api.workspace.shared.dto.ProjectConfigDto, JsonSerializable  {

    public static ProjectConfigDtoImpl make() {
        return new ProjectConfigDtoImpl();
    }

    public ProjectConfigDtoImpl() {
    }

    protected java.util.List<org.eclipse.che.api.core.rest.shared.dto.Link> links;
    protected java.lang.String name;
    protected java.util.Map<java.lang.String, java.util.List<java.lang.String>> attributes;
    protected java.lang.String type;
    protected org.eclipse.che.api.workspace.shared.dto.SourceStorageDto source;
    protected java.lang.String path;
    protected java.lang.String description;
    protected java.util.List<org.eclipse.che.api.workspace.shared.dto.ProjectProblemDto> problems;
    protected java.util.List<java.lang.String> mixins;

    @Override
    public java.util.List<org.eclipse.che.api.core.rest.shared.dto.Link> getLinks() {
      ensureLinks();
      return new org.eclipse.che.dto.server.JsonArrayImpl(links);
    }

    public void setLinks(java.util.List<org.eclipse.che.api.core.rest.shared.dto.Link> v) {
      this.links = v;
    }

    public void addLinks(org.eclipse.che.api.core.rest.shared.dto.Link v) {
      ensureLinks();
      links.add(v);
    }

    public void clearLinks() {
      ensureLinks();
      links.clear();
    }

    protected void ensureLinks() {
      if (links == null) {
        links = new java.util.ArrayList<org.eclipse.che.api.core.rest.shared.dto.Link>();
      }
    }
    @Override
    public java.lang.String getName() {
      return name;
    }

    public void setName(java.lang.String v) {
      this.name = v;
    }

    @Override
    public java.util.Map<java.lang.String, java.util.List<java.lang.String>> getAttributes() {
      ensureAttributes();
      return new org.eclipse.che.dto.server.JsonStringMapImpl(attributes);
    }

    public void setAttributes(java.util.Map<java.lang.String, java.util.List<java.lang.String>> v) {
      this.attributes = v;
    }

    public void putAttributes(String k, java.util.List<java.lang.String> v) {
      ensureAttributes();
      attributes.put(k, v);
    }

    public void clearAttributes() {
      ensureAttributes();
      attributes.clear();
    }

    protected void ensureAttributes() {
      if (attributes == null) {
        attributes = new java.util.HashMap<java.lang.String, java.util.List<java.lang.String>>();
      }
    }
    @Override
    public java.lang.String getType() {
      return type;
    }

    public void setType(java.lang.String v) {
      this.type = v;
    }

    @Override
    public org.eclipse.che.api.workspace.shared.dto.SourceStorageDto getSource() {
      return source;
    }

    public void setSource(org.eclipse.che.api.workspace.shared.dto.SourceStorageDto v) {
      this.source = v;
    }

    @Override
    public java.lang.String getPath() {
      return path;
    }

    public void setPath(java.lang.String v) {
      this.path = v;
    }

    @Override
    public java.lang.String getDescription() {
      return description;
    }

    public void setDescription(java.lang.String v) {
      this.description = v;
    }

    @Override
    public java.util.List<org.eclipse.che.api.workspace.shared.dto.ProjectProblemDto> getProblems() {
      ensureProblems();
      return new org.eclipse.che.dto.server.JsonArrayImpl(problems);
    }

    public void setProblems(java.util.List<org.eclipse.che.api.workspace.shared.dto.ProjectProblemDto> v) {
      this.problems = v;
    }

    public void addProblems(org.eclipse.che.api.workspace.shared.dto.ProjectProblemDto v) {
      ensureProblems();
      problems.add(v);
    }

    public void clearProblems() {
      ensureProblems();
      problems.clear();
    }

    protected void ensureProblems() {
      if (problems == null) {
        problems = new java.util.ArrayList<org.eclipse.che.api.workspace.shared.dto.ProjectProblemDto>();
      }
    }
    @Override
    public java.util.List<java.lang.String> getMixins() {
      ensureMixins();
      return new org.eclipse.che.dto.server.JsonArrayImpl(mixins);
    }

    public void setMixins(java.util.List<java.lang.String> v) {
      this.mixins = v;
    }

    public void addMixins(java.lang.String v) {
      ensureMixins();
      mixins.add(v);
    }

    public void clearMixins() {
      ensureMixins();
      mixins.clear();
    }

    protected void ensureMixins() {
      if (mixins == null) {
        mixins = new java.util.ArrayList<java.lang.String>();
      }
    }
    @Override
    public boolean equals(Object o) {
      if (!(o instanceof ProjectConfigDtoImpl)) {
        return false;
      }
      ProjectConfigDtoImpl other = (ProjectConfigDtoImpl) o;
      this.ensureLinks();
      other.ensureLinks();
      
      if (this.links != null) {
        if (!this.links.equals(other.links)) {
          return false;
        }
      } else {
        if (other.links != null) {
          return false;
        }
      }
      if (this.name != null) {
        if (!this.name.equals(other.name)) {
          return false;
        }
      } else {
        if (other.name != null) {
          return false;
        }
      }
      this.ensureAttributes();
      other.ensureAttributes();
      
      if (this.attributes != null) {
        if (!this.attributes.equals(other.attributes)) {
          return false;
        }
      } else {
        if (other.attributes != null) {
          return false;
        }
      }
      if (this.type != null) {
        if (!this.type.equals(other.type)) {
          return false;
        }
      } else {
        if (other.type != null) {
          return false;
        }
      }
      if (this.source != null) {
        if (!this.source.equals(other.source)) {
          return false;
        }
      } else {
        if (other.source != null) {
          return false;
        }
      }
      if (this.path != null) {
        if (!this.path.equals(other.path)) {
          return false;
        }
      } else {
        if (other.path != null) {
          return false;
        }
      }
      if (this.description != null) {
        if (!this.description.equals(other.description)) {
          return false;
        }
      } else {
        if (other.description != null) {
          return false;
        }
      }
      this.ensureProblems();
      other.ensureProblems();
      
      if (this.problems != null) {
        if (!this.problems.equals(other.problems)) {
          return false;
        }
      } else {
        if (other.problems != null) {
          return false;
        }
      }
      this.ensureMixins();
      other.ensureMixins();
      
      if (this.mixins != null) {
        if (!this.mixins.equals(other.mixins)) {
          return false;
        }
      } else {
        if (other.mixins != null) {
          return false;
        }
      }
      return true;
    }

    @Override
    public int hashCode() {
      int hash = 7;
      ensureLinks();
      hash = hash * 31 + (links != null ? links.hashCode() : 0);
      hash = hash * 31 + (name != null ? name.hashCode() : 0);
      ensureAttributes();
      hash = hash * 31 + (attributes != null ? attributes.hashCode() : 0);
      hash = hash * 31 + (type != null ? type.hashCode() : 0);
      hash = hash * 31 + (source != null ? source.hashCode() : 0);
      hash = hash * 31 + (path != null ? path.hashCode() : 0);
      hash = hash * 31 + (description != null ? description.hashCode() : 0);
      ensureProblems();
      hash = hash * 31 + (problems != null ? problems.hashCode() : 0);
      ensureMixins();
      hash = hash * 31 + (mixins != null ? mixins.hashCode() : 0);
      return hash;
    }

    @Override
    public JsonElement toJsonElement() {
      return toJsonElementInt(true);
    }
    public JsonElement toJsonElementInt(boolean copyJsons) {
      JsonObject result = new JsonObject();

      JsonArray linksOut = new JsonArray();
      this.ensureLinks();
      for (org.eclipse.che.api.core.rest.shared.dto.Link links_ : this.links) {
        JsonElement linksOut_ = links_ == null ? JsonNull.INSTANCE : ((org.eclipse.che.api.core.server.dto.DtoServerImpls.LinkImpl)links_).toJsonElementInt(copyJsons);
        linksOut.add(linksOut_);
      }
      result.add("links", linksOut);

      JsonElement nameOut = (this.name == null) ? JsonNull.INSTANCE : new JsonPrimitive(this.name);
      result.add("name", nameOut);

      JsonObject attributesOut = new JsonObject();
      this.ensureAttributes();
      for (java.util.Map.Entry<String, java.util.List<java.lang.String>> entry0 : this.attributes.entrySet()) {
        java.util.List<java.lang.String> attributes_ = entry0.getValue();
        JsonArray attributesOut_ = new JsonArray();
        for (java.lang.String attributes__ : attributes_) {
          JsonElement attributesOut__ = (attributes__ == null) ? JsonNull.INSTANCE : new JsonPrimitive(attributes__);
          attributesOut_.add(attributesOut__);
        }
        attributesOut.add(entry0.getKey(), attributesOut_);
      }
      result.add("attributes", attributesOut);

      JsonElement typeOut = (this.type == null) ? JsonNull.INSTANCE : new JsonPrimitive(this.type);
      result.add("type", typeOut);

      JsonElement sourceOut = this.source == null ? JsonNull.INSTANCE : ((SourceStorageDtoImpl)this.source).toJsonElementInt(copyJsons);
      result.add("source", sourceOut);

      JsonElement pathOut = (this.path == null) ? JsonNull.INSTANCE : new JsonPrimitive(this.path);
      result.add("path", pathOut);

      JsonElement descriptionOut = (this.description == null) ? JsonNull.INSTANCE : new JsonPrimitive(this.description);
      result.add("description", descriptionOut);

      JsonArray problemsOut = new JsonArray();
      this.ensureProblems();
      for (org.eclipse.che.api.workspace.shared.dto.ProjectProblemDto problems_ : this.problems) {
        JsonElement problemsOut_ = problems_ == null ? JsonNull.INSTANCE : ((ProjectProblemDtoImpl)problems_).toJsonElementInt(copyJsons);
        problemsOut.add(problemsOut_);
      }
      result.add("problems", problemsOut);

      JsonArray mixinsOut = new JsonArray();
      this.ensureMixins();
      for (java.lang.String mixins_ : this.mixins) {
        JsonElement mixinsOut_ = (mixins_ == null) ? JsonNull.INSTANCE : new JsonPrimitive(mixins_);
        mixinsOut.add(mixinsOut_);
      }
      result.add("mixins", mixinsOut);
      return result;
    }

    @Override
    public String toJson() {
      return gson.toJson(toJsonElementInt(false));
    }

    @Override
    public String toString() {
      return toJson();
    }

    public static ProjectConfigDtoImpl fromJsonElement(JsonElement jsonElem) {
      return fromJsonElement(jsonElem, true);
    }
    public static ProjectConfigDtoImpl fromJsonElement(JsonElement jsonElem, boolean copyJsons) {
      if (jsonElem == null || jsonElem.isJsonNull()) {
        return null;
      }

      ProjectConfigDtoImpl dto = new ProjectConfigDtoImpl();
      JsonObject json = jsonElem.getAsJsonObject();

      if (json.has("links")) {
        JsonElement linksIn = json.get("links");
        java.util.List<org.eclipse.che.api.core.rest.shared.dto.Link> linksOut = null;
        if (linksIn != null && !linksIn.isJsonNull()) {
          linksOut = new java.util.ArrayList<org.eclipse.che.api.core.rest.shared.dto.Link>();
          java.util.Iterator<JsonElement> linksInIterator = linksIn.getAsJsonArray().iterator();
          while (linksInIterator.hasNext()) {
            JsonElement linksIn_ = linksInIterator.next();
            org.eclipse.che.api.core.rest.shared.dto.Link linksOut_ = org.eclipse.che.api.core.server.dto.DtoServerImpls.LinkImpl.fromJsonElement(linksIn_, copyJsons);
            linksOut.add(linksOut_);
          }
        }
        dto.setLinks(linksOut);
      }

      if (json.has("name")) {
        JsonElement nameIn = json.get("name");
        java.lang.String nameOut = gson.fromJson(nameIn, java.lang.String.class);
        dto.setName(nameOut);
      }

      if (json.has("attributes")) {
        JsonElement attributesIn = json.get("attributes");
        java.util.Map<java.lang.String, java.util.List<java.lang.String>> attributesOut = null;
        if (attributesIn != null && !attributesIn.isJsonNull()) {
          attributesOut = new java.util.HashMap<java.lang.String, java.util.List<java.lang.String>>();
          java.util.Set<java.util.Map.Entry<String, JsonElement>> entries0 = attributesIn.getAsJsonObject().entrySet();
          for (java.util.Map.Entry<String, JsonElement> entry0 : entries0) {
            JsonElement attributesIn_ = entry0.getValue();
            java.util.List<java.lang.String> attributesOut_ = null;
            if (attributesIn_ != null && !attributesIn_.isJsonNull()) {
              attributesOut_ = new java.util.ArrayList<java.lang.String>();
              java.util.Iterator<JsonElement> attributesIn_Iterator = attributesIn_.getAsJsonArray().iterator();
              while (attributesIn_Iterator.hasNext()) {
                JsonElement attributesIn__ = attributesIn_Iterator.next();
                java.lang.String attributesOut__ = gson.fromJson(attributesIn__, java.lang.String.class);
                attributesOut_.add(attributesOut__);
              }
            }
            attributesOut.put(entry0.getKey(), attributesOut_);
          }
        }
        dto.setAttributes(attributesOut);
      }

      if (json.has("type")) {
        JsonElement typeIn = json.get("type");
        java.lang.String typeOut = gson.fromJson(typeIn, java.lang.String.class);
        dto.setType(typeOut);
      }

      if (json.has("source")) {
        JsonElement sourceIn = json.get("source");
        org.eclipse.che.api.workspace.shared.dto.SourceStorageDto sourceOut = SourceStorageDtoImpl.fromJsonElement(sourceIn, copyJsons);
        dto.setSource(sourceOut);
      }

      if (json.has("path")) {
        JsonElement pathIn = json.get("path");
        java.lang.String pathOut = gson.fromJson(pathIn, java.lang.String.class);
        dto.setPath(pathOut);
      }

      if (json.has("description")) {
        JsonElement descriptionIn = json.get("description");
        java.lang.String descriptionOut = gson.fromJson(descriptionIn, java.lang.String.class);
        dto.setDescription(descriptionOut);
      }

      if (json.has("problems")) {
        JsonElement problemsIn = json.get("problems");
        java.util.List<org.eclipse.che.api.workspace.shared.dto.ProjectProblemDto> problemsOut = null;
        if (problemsIn != null && !problemsIn.isJsonNull()) {
          problemsOut = new java.util.ArrayList<org.eclipse.che.api.workspace.shared.dto.ProjectProblemDto>();
          java.util.Iterator<JsonElement> problemsInIterator = problemsIn.getAsJsonArray().iterator();
          while (problemsInIterator.hasNext()) {
            JsonElement problemsIn_ = problemsInIterator.next();
            org.eclipse.che.api.workspace.shared.dto.ProjectProblemDto problemsOut_ = ProjectProblemDtoImpl.fromJsonElement(problemsIn_, copyJsons);
            problemsOut.add(problemsOut_);
          }
        }
        dto.setProblems(problemsOut);
      }

      if (json.has("mixins")) {
        JsonElement mixinsIn = json.get("mixins");
        java.util.List<java.lang.String> mixinsOut = null;
        if (mixinsIn != null && !mixinsIn.isJsonNull()) {
          mixinsOut = new java.util.ArrayList<java.lang.String>();
          java.util.Iterator<JsonElement> mixinsInIterator = mixinsIn.getAsJsonArray().iterator();
          while (mixinsInIterator.hasNext()) {
            JsonElement mixinsIn_ = mixinsInIterator.next();
            java.lang.String mixinsOut_ = gson.fromJson(mixinsIn_, java.lang.String.class);
            mixinsOut.add(mixinsOut_);
          }
        }
        dto.setMixins(mixinsOut);
      }

      return dto;
    }

    public static ProjectConfigDtoImpl fromJsonString(String jsonString) {
      if (jsonString == null) {
        return null;
      }

      return fromJsonElement(new JsonParser().parse(jsonString), false);
    }

    public ProjectConfigDtoImpl(org.eclipse.che.api.workspace.shared.dto.ProjectConfigDto origin) {
      java.util.List<org.eclipse.che.api.core.rest.shared.dto.Link> linksIn = origin.getLinks();
      if (linksIn != null) {
        java.util.List<org.eclipse.che.api.core.rest.shared.dto.Link> linksOut = new java.util.ArrayList<org.eclipse.che.api.core.rest.shared.dto.Link>();
        for (org.eclipse.che.api.core.rest.shared.dto.Link linksIn_ : linksIn) {
            linksOut.add(linksIn_);
        }
        this.links = linksOut;
      }
      this.name = origin.getName();
      java.util.Map<java.lang.String, java.util.List<java.lang.String>> attributesIn = origin.getAttributes();
      if (attributesIn != null) {
        java.util.Map<java.lang.String, java.util.List<java.lang.String>> attributesOut = new java.util.HashMap<java.lang.String, java.util.List<java.lang.String>>();
        for (java.util.Map.Entry<String, java.util.List<java.lang.String>> entry0 : attributesIn.entrySet()) {
          java.util.List<java.lang.String> attributesIn_ = entry0.getValue();
          if (attributesIn_ != null) {
            java.util.List<java.lang.String> attributesOut_ = new java.util.ArrayList<java.lang.String>();
            for (java.lang.String attributesIn__ : attributesIn_) {
                attributesOut_.add(attributesIn__);
            }
            attributesOut.put(entry0.getKey(), attributesOut_);
          }
        }
        this.attributes = attributesOut;
      }
      this.type = origin.getType();
      org.eclipse.che.api.workspace.shared.dto.SourceStorageDto sourceIn = origin.getSource();
      this.source = sourceIn == null ? null : new SourceStorageDtoImpl(sourceIn);
      this.path = origin.getPath();
      this.description = origin.getDescription();
      java.util.List<org.eclipse.che.api.workspace.shared.dto.ProjectProblemDto> problemsIn = origin.getProblems();
      if (problemsIn != null) {
        java.util.List<org.eclipse.che.api.workspace.shared.dto.ProjectProblemDto> problemsOut = new java.util.ArrayList<org.eclipse.che.api.workspace.shared.dto.ProjectProblemDto>();
        for (org.eclipse.che.api.workspace.shared.dto.ProjectProblemDto problemsIn_ : problemsIn) {
            problemsOut.add(problemsIn_ == null ? null : new ProjectProblemDtoImpl(problemsIn_));
        }
        this.problems = problemsOut;
      }
      java.util.List<java.lang.String> mixinsIn = origin.getMixins();
      if (mixinsIn != null) {
        java.util.List<java.lang.String> mixinsOut = new java.util.ArrayList<java.lang.String>();
        for (java.lang.String mixinsIn_ : mixinsIn) {
            mixinsOut.add(mixinsIn_);
        }
        this.mixins = mixinsOut;
      }
    }

    public org.eclipse.che.api.workspace.shared.dto.ProjectConfigDto withLinks(java.util.List<org.eclipse.che.api.core.rest.shared.dto.Link> v) {
      this.links = v;
      return this;
    }

    public org.eclipse.che.api.workspace.shared.dto.ProjectConfigDto withName(java.lang.String v) {
      this.name = v;
      return this;
    }

    public org.eclipse.che.api.workspace.shared.dto.ProjectConfigDto withAttributes(java.util.Map<java.lang.String, java.util.List<java.lang.String>> v) {
      this.attributes = v;
      return this;
    }

    public org.eclipse.che.api.workspace.shared.dto.ProjectConfigDto withType(java.lang.String v) {
      this.type = v;
      return this;
    }

    public org.eclipse.che.api.workspace.shared.dto.ProjectConfigDto withSource(org.eclipse.che.api.workspace.shared.dto.SourceStorageDto v) {
      this.source = v;
      return this;
    }

    public org.eclipse.che.api.workspace.shared.dto.ProjectConfigDto withPath(java.lang.String v) {
      this.path = v;
      return this;
    }

    public org.eclipse.che.api.workspace.shared.dto.ProjectConfigDto withDescription(java.lang.String v) {
      this.description = v;
      return this;
    }

    public org.eclipse.che.api.workspace.shared.dto.ProjectConfigDto withProblems(java.util.List<org.eclipse.che.api.workspace.shared.dto.ProjectProblemDto> v) {
      this.problems = v;
      return this;
    }

    public org.eclipse.che.api.workspace.shared.dto.ProjectConfigDto withMixins(java.util.List<java.lang.String> v) {
      this.mixins = v;
      return this;
    }

  }

  @org.eclipse.che.dto.shared.DTOImpl("server")
  public static class ProjectProblemDtoImpl implements org.eclipse.che.api.workspace.shared.dto.ProjectProblemDto, JsonSerializable  {

    public static ProjectProblemDtoImpl make() {
        return new ProjectProblemDtoImpl();
    }

    public ProjectProblemDtoImpl() {
    }

    protected java.lang.String message;
    protected int code;

    @Override
    public java.lang.String getMessage() {
      return message;
    }

    public void setMessage(java.lang.String v) {
      this.message = v;
    }

    @Override
    public int getCode() {
      return code;
    }

    public void setCode(int v) {
      this.code = v;
    }

    @Override
    public boolean equals(Object o) {
      if (!(o instanceof ProjectProblemDtoImpl)) {
        return false;
      }
      ProjectProblemDtoImpl other = (ProjectProblemDtoImpl) o;
      if (this.message != null) {
        if (!this.message.equals(other.message)) {
          return false;
        }
      } else {
        if (other.message != null) {
          return false;
        }
      }
      if (this.code != other.code) {
        return false;
      }
      return true;
    }

    @Override
    public int hashCode() {
      int hash = 7;
      hash = hash * 31 + (message != null ? message.hashCode() : 0);
      hash = hash * 31 + java.lang.Integer.valueOf(code).hashCode();
      return hash;
    }

    @Override
    public JsonElement toJsonElement() {
      return toJsonElementInt(true);
    }
    public JsonElement toJsonElementInt(boolean copyJsons) {
      JsonObject result = new JsonObject();

      JsonElement messageOut = (this.message == null) ? JsonNull.INSTANCE : new JsonPrimitive(this.message);
      result.add("message", messageOut);

      JsonPrimitive codeOut = new JsonPrimitive(this.code);
      result.add("code", codeOut);
      return result;
    }

    @Override
    public String toJson() {
      return gson.toJson(toJsonElementInt(false));
    }

    @Override
    public String toString() {
      return toJson();
    }

    public static ProjectProblemDtoImpl fromJsonElement(JsonElement jsonElem) {
      return fromJsonElement(jsonElem, true);
    }
    public static ProjectProblemDtoImpl fromJsonElement(JsonElement jsonElem, boolean copyJsons) {
      if (jsonElem == null || jsonElem.isJsonNull()) {
        return null;
      }

      ProjectProblemDtoImpl dto = new ProjectProblemDtoImpl();
      JsonObject json = jsonElem.getAsJsonObject();

      if (json.has("message")) {
        JsonElement messageIn = json.get("message");
        java.lang.String messageOut = gson.fromJson(messageIn, java.lang.String.class);
        dto.setMessage(messageOut);
      }

      if (json.has("code")) {
        JsonElement codeIn = json.get("code");
        int codeOut = codeIn.getAsInt();
        dto.setCode(codeOut);
      }

      return dto;
    }

    public static ProjectProblemDtoImpl fromJsonString(String jsonString) {
      if (jsonString == null) {
        return null;
      }

      return fromJsonElement(new JsonParser().parse(jsonString), false);
    }

    public ProjectProblemDtoImpl(org.eclipse.che.api.workspace.shared.dto.ProjectProblemDto origin) {
      this.message = origin.getMessage();
      this.code = origin.getCode();
    }

    public org.eclipse.che.api.workspace.shared.dto.ProjectProblemDto withMessage(java.lang.String v) {
      this.message = v;
      return this;
    }

    public org.eclipse.che.api.workspace.shared.dto.ProjectProblemDto withCode(int v) {
      this.code = v;
      return this;
    }

  }

  @org.eclipse.che.dto.shared.DTOImpl("server")
  public static class ServerConf2DtoImpl implements org.eclipse.che.api.workspace.shared.dto.ServerConf2Dto, JsonSerializable  {

    public static ServerConf2DtoImpl make() {
        return new ServerConf2DtoImpl();
    }

    public ServerConf2DtoImpl() {
    }

    protected java.lang.String port;
    protected java.util.Map<java.lang.String, java.lang.String> properties;
    protected java.lang.String protocol;

    @Override
    public java.lang.String getPort() {
      return port;
    }

    public void setPort(java.lang.String v) {
      this.port = v;
    }

    @Override
    public java.util.Map<java.lang.String, java.lang.String> getProperties() {
      ensureProperties();
      return new org.eclipse.che.dto.server.JsonStringMapImpl(properties);
    }

    public void setProperties(java.util.Map<java.lang.String, java.lang.String> v) {
      this.properties = v;
    }

    public void putProperties(String k, java.lang.String v) {
      ensureProperties();
      properties.put(k, v);
    }

    public void clearProperties() {
      ensureProperties();
      properties.clear();
    }

    protected void ensureProperties() {
      if (properties == null) {
        properties = new java.util.HashMap<java.lang.String, java.lang.String>();
      }
    }
    @Override
    public java.lang.String getProtocol() {
      return protocol;
    }

    public void setProtocol(java.lang.String v) {
      this.protocol = v;
    }

    @Override
    public boolean equals(Object o) {
      if (!(o instanceof ServerConf2DtoImpl)) {
        return false;
      }
      ServerConf2DtoImpl other = (ServerConf2DtoImpl) o;
      if (this.port != null) {
        if (!this.port.equals(other.port)) {
          return false;
        }
      } else {
        if (other.port != null) {
          return false;
        }
      }
      this.ensureProperties();
      other.ensureProperties();
      
      if (this.properties != null) {
        if (!this.properties.equals(other.properties)) {
          return false;
        }
      } else {
        if (other.properties != null) {
          return false;
        }
      }
      if (this.protocol != null) {
        if (!this.protocol.equals(other.protocol)) {
          return false;
        }
      } else {
        if (other.protocol != null) {
          return false;
        }
      }
      return true;
    }

    @Override
    public int hashCode() {
      int hash = 7;
      hash = hash * 31 + (port != null ? port.hashCode() : 0);
      ensureProperties();
      hash = hash * 31 + (properties != null ? properties.hashCode() : 0);
      hash = hash * 31 + (protocol != null ? protocol.hashCode() : 0);
      return hash;
    }

    @Override
    public JsonElement toJsonElement() {
      return toJsonElementInt(true);
    }
    public JsonElement toJsonElementInt(boolean copyJsons) {
      JsonObject result = new JsonObject();

      JsonElement portOut = (this.port == null) ? JsonNull.INSTANCE : new JsonPrimitive(this.port);
      result.add("port", portOut);

      JsonObject propertiesOut = new JsonObject();
      this.ensureProperties();
      for (java.util.Map.Entry<String, java.lang.String> entry0 : this.properties.entrySet()) {
        java.lang.String properties_ = entry0.getValue();
        JsonElement propertiesOut_ = (properties_ == null) ? JsonNull.INSTANCE : new JsonPrimitive(properties_);
        propertiesOut.add(entry0.getKey(), propertiesOut_);
      }
      result.add("properties", propertiesOut);

      JsonElement protocolOut = (this.protocol == null) ? JsonNull.INSTANCE : new JsonPrimitive(this.protocol);
      result.add("protocol", protocolOut);
      return result;
    }

    @Override
    public String toJson() {
      return gson.toJson(toJsonElementInt(false));
    }

    @Override
    public String toString() {
      return toJson();
    }

    public static ServerConf2DtoImpl fromJsonElement(JsonElement jsonElem) {
      return fromJsonElement(jsonElem, true);
    }
    public static ServerConf2DtoImpl fromJsonElement(JsonElement jsonElem, boolean copyJsons) {
      if (jsonElem == null || jsonElem.isJsonNull()) {
        return null;
      }

      ServerConf2DtoImpl dto = new ServerConf2DtoImpl();
      JsonObject json = jsonElem.getAsJsonObject();

      if (json.has("port")) {
        JsonElement portIn = json.get("port");
        java.lang.String portOut = gson.fromJson(portIn, java.lang.String.class);
        dto.setPort(portOut);
      }

      if (json.has("properties")) {
        JsonElement propertiesIn = json.get("properties");
        java.util.Map<java.lang.String, java.lang.String> propertiesOut = null;
        if (propertiesIn != null && !propertiesIn.isJsonNull()) {
          propertiesOut = new java.util.HashMap<java.lang.String, java.lang.String>();
          java.util.Set<java.util.Map.Entry<String, JsonElement>> entries0 = propertiesIn.getAsJsonObject().entrySet();
          for (java.util.Map.Entry<String, JsonElement> entry0 : entries0) {
            JsonElement propertiesIn_ = entry0.getValue();
            java.lang.String propertiesOut_ = gson.fromJson(propertiesIn_, java.lang.String.class);
            propertiesOut.put(entry0.getKey(), propertiesOut_);
          }
        }
        dto.setProperties(propertiesOut);
      }

      if (json.has("protocol")) {
        JsonElement protocolIn = json.get("protocol");
        java.lang.String protocolOut = gson.fromJson(protocolIn, java.lang.String.class);
        dto.setProtocol(protocolOut);
      }

      return dto;
    }

    public static ServerConf2DtoImpl fromJsonString(String jsonString) {
      if (jsonString == null) {
        return null;
      }

      return fromJsonElement(new JsonParser().parse(jsonString), false);
    }

    public ServerConf2DtoImpl(org.eclipse.che.api.workspace.shared.dto.ServerConf2Dto origin) {
      this.port = origin.getPort();
      java.util.Map<java.lang.String, java.lang.String> propertiesIn = origin.getProperties();
      if (propertiesIn != null) {
        java.util.Map<java.lang.String, java.lang.String> propertiesOut = new java.util.HashMap<java.lang.String, java.lang.String>();
        for (java.util.Map.Entry<String, java.lang.String> entry0 : propertiesIn.entrySet()) {
          java.lang.String propertiesIn_ = entry0.getValue();
            propertiesOut.put(entry0.getKey(), propertiesIn_);
        }
        this.properties = propertiesOut;
      }
      this.protocol = origin.getProtocol();
    }

    public org.eclipse.che.api.workspace.shared.dto.ServerConf2Dto withPort(java.lang.String v) {
      this.port = v;
      return this;
    }

    public org.eclipse.che.api.workspace.shared.dto.ServerConf2Dto withProperties(java.util.Map<java.lang.String, java.lang.String> v) {
      this.properties = v;
      return this;
    }

    public org.eclipse.che.api.workspace.shared.dto.ServerConf2Dto withProtocol(java.lang.String v) {
      this.protocol = v;
      return this;
    }

  }

  @org.eclipse.che.dto.shared.DTOImpl("server")
  public static class SourceStorageDtoImpl implements org.eclipse.che.api.workspace.shared.dto.SourceStorageDto, JsonSerializable  {

    public static SourceStorageDtoImpl make() {
        return new SourceStorageDtoImpl();
    }

    public SourceStorageDtoImpl() {
    }

    protected java.lang.String location;
    protected java.lang.String type;
    protected java.util.Map<java.lang.String, java.lang.String> parameters;

    @Override
    public java.lang.String getLocation() {
      return location;
    }

    public void setLocation(java.lang.String v) {
      this.location = v;
    }

    @Override
    public java.lang.String getType() {
      return type;
    }

    public void setType(java.lang.String v) {
      this.type = v;
    }

    @Override
    public java.util.Map<java.lang.String, java.lang.String> getParameters() {
      ensureParameters();
      return new org.eclipse.che.dto.server.JsonStringMapImpl(parameters);
    }

    public void setParameters(java.util.Map<java.lang.String, java.lang.String> v) {
      this.parameters = v;
    }

    public void putParameters(String k, java.lang.String v) {
      ensureParameters();
      parameters.put(k, v);
    }

    public void clearParameters() {
      ensureParameters();
      parameters.clear();
    }

    protected void ensureParameters() {
      if (parameters == null) {
        parameters = new java.util.HashMap<java.lang.String, java.lang.String>();
      }
    }
    @Override
    public boolean equals(Object o) {
      if (!(o instanceof SourceStorageDtoImpl)) {
        return false;
      }
      SourceStorageDtoImpl other = (SourceStorageDtoImpl) o;
      if (this.location != null) {
        if (!this.location.equals(other.location)) {
          return false;
        }
      } else {
        if (other.location != null) {
          return false;
        }
      }
      if (this.type != null) {
        if (!this.type.equals(other.type)) {
          return false;
        }
      } else {
        if (other.type != null) {
          return false;
        }
      }
      this.ensureParameters();
      other.ensureParameters();
      
      if (this.parameters != null) {
        if (!this.parameters.equals(other.parameters)) {
          return false;
        }
      } else {
        if (other.parameters != null) {
          return false;
        }
      }
      return true;
    }

    @Override
    public int hashCode() {
      int hash = 7;
      hash = hash * 31 + (location != null ? location.hashCode() : 0);
      hash = hash * 31 + (type != null ? type.hashCode() : 0);
      ensureParameters();
      hash = hash * 31 + (parameters != null ? parameters.hashCode() : 0);
      return hash;
    }

    @Override
    public JsonElement toJsonElement() {
      return toJsonElementInt(true);
    }
    public JsonElement toJsonElementInt(boolean copyJsons) {
      JsonObject result = new JsonObject();

      JsonElement locationOut = (this.location == null) ? JsonNull.INSTANCE : new JsonPrimitive(this.location);
      result.add("location", locationOut);

      JsonElement typeOut = (this.type == null) ? JsonNull.INSTANCE : new JsonPrimitive(this.type);
      result.add("type", typeOut);

      JsonObject parametersOut = new JsonObject();
      this.ensureParameters();
      for (java.util.Map.Entry<String, java.lang.String> entry0 : this.parameters.entrySet()) {
        java.lang.String parameters_ = entry0.getValue();
        JsonElement parametersOut_ = (parameters_ == null) ? JsonNull.INSTANCE : new JsonPrimitive(parameters_);
        parametersOut.add(entry0.getKey(), parametersOut_);
      }
      result.add("parameters", parametersOut);
      return result;
    }

    @Override
    public String toJson() {
      return gson.toJson(toJsonElementInt(false));
    }

    @Override
    public String toString() {
      return toJson();
    }

    public static SourceStorageDtoImpl fromJsonElement(JsonElement jsonElem) {
      return fromJsonElement(jsonElem, true);
    }
    public static SourceStorageDtoImpl fromJsonElement(JsonElement jsonElem, boolean copyJsons) {
      if (jsonElem == null || jsonElem.isJsonNull()) {
        return null;
      }

      SourceStorageDtoImpl dto = new SourceStorageDtoImpl();
      JsonObject json = jsonElem.getAsJsonObject();

      if (json.has("location")) {
        JsonElement locationIn = json.get("location");
        java.lang.String locationOut = gson.fromJson(locationIn, java.lang.String.class);
        dto.setLocation(locationOut);
      }

      if (json.has("type")) {
        JsonElement typeIn = json.get("type");
        java.lang.String typeOut = gson.fromJson(typeIn, java.lang.String.class);
        dto.setType(typeOut);
      }

      if (json.has("parameters")) {
        JsonElement parametersIn = json.get("parameters");
        java.util.Map<java.lang.String, java.lang.String> parametersOut = null;
        if (parametersIn != null && !parametersIn.isJsonNull()) {
          parametersOut = new java.util.HashMap<java.lang.String, java.lang.String>();
          java.util.Set<java.util.Map.Entry<String, JsonElement>> entries0 = parametersIn.getAsJsonObject().entrySet();
          for (java.util.Map.Entry<String, JsonElement> entry0 : entries0) {
            JsonElement parametersIn_ = entry0.getValue();
            java.lang.String parametersOut_ = gson.fromJson(parametersIn_, java.lang.String.class);
            parametersOut.put(entry0.getKey(), parametersOut_);
          }
        }
        dto.setParameters(parametersOut);
      }

      return dto;
    }

    public static SourceStorageDtoImpl fromJsonString(String jsonString) {
      if (jsonString == null) {
        return null;
      }

      return fromJsonElement(new JsonParser().parse(jsonString), false);
    }

    public SourceStorageDtoImpl(org.eclipse.che.api.workspace.shared.dto.SourceStorageDto origin) {
      this.location = origin.getLocation();
      this.type = origin.getType();
      java.util.Map<java.lang.String, java.lang.String> parametersIn = origin.getParameters();
      if (parametersIn != null) {
        java.util.Map<java.lang.String, java.lang.String> parametersOut = new java.util.HashMap<java.lang.String, java.lang.String>();
        for (java.util.Map.Entry<String, java.lang.String> entry0 : parametersIn.entrySet()) {
          java.lang.String parametersIn_ = entry0.getValue();
            parametersOut.put(entry0.getKey(), parametersIn_);
        }
        this.parameters = parametersOut;
      }
    }

    public org.eclipse.che.api.workspace.shared.dto.SourceStorageDto withLocation(java.lang.String v) {
      this.location = v;
      return this;
    }

    public org.eclipse.che.api.workspace.shared.dto.SourceStorageDto withType(java.lang.String v) {
      this.type = v;
      return this;
    }

    public org.eclipse.che.api.workspace.shared.dto.SourceStorageDto withParameters(java.util.Map<java.lang.String, java.lang.String> v) {
      this.parameters = v;
      return this;
    }

  }

  @org.eclipse.che.dto.shared.DTOImpl("server")
  public static class WorkspaceConfigDtoImpl extends org.eclipse.che.api.core.server.dto.DtoServerImpls.HyperlinksImpl implements org.eclipse.che.api.workspace.shared.dto.WorkspaceConfigDto, JsonSerializable  {

    public static WorkspaceConfigDtoImpl make() {
        return new WorkspaceConfigDtoImpl();
    }

    public WorkspaceConfigDtoImpl() {
    }

    protected java.util.Map<java.lang.String, org.eclipse.che.api.workspace.shared.dto.EnvironmentDto> environments;
    protected java.lang.String defaultEnv;
    protected java.util.List<org.eclipse.che.api.workspace.shared.dto.ProjectConfigDto> projects;
    protected java.lang.String name;
    protected java.lang.String description;
    protected java.util.List<org.eclipse.che.api.machine.shared.dto.CommandDto> commands;

    @Override
    public java.util.Map<java.lang.String, org.eclipse.che.api.workspace.shared.dto.EnvironmentDto> getEnvironments() {
      ensureEnvironments();
      return new org.eclipse.che.dto.server.JsonStringMapImpl(environments);
    }

    public void setEnvironments(java.util.Map<java.lang.String, org.eclipse.che.api.workspace.shared.dto.EnvironmentDto> v) {
      this.environments = v;
    }

    public void putEnvironments(String k, org.eclipse.che.api.workspace.shared.dto.EnvironmentDto v) {
      ensureEnvironments();
      environments.put(k, v);
    }

    public void clearEnvironments() {
      ensureEnvironments();
      environments.clear();
    }

    protected void ensureEnvironments() {
      if (environments == null) {
        environments = new java.util.HashMap<java.lang.String, org.eclipse.che.api.workspace.shared.dto.EnvironmentDto>();
      }
    }
    @Override
    public java.lang.String getDefaultEnv() {
      return defaultEnv;
    }

    public void setDefaultEnv(java.lang.String v) {
      this.defaultEnv = v;
    }

    @Override
    public java.util.List<org.eclipse.che.api.workspace.shared.dto.ProjectConfigDto> getProjects() {
      ensureProjects();
      return new org.eclipse.che.dto.server.JsonArrayImpl(projects);
    }

    public void setProjects(java.util.List<org.eclipse.che.api.workspace.shared.dto.ProjectConfigDto> v) {
      this.projects = v;
    }

    public void addProjects(org.eclipse.che.api.workspace.shared.dto.ProjectConfigDto v) {
      ensureProjects();
      projects.add(v);
    }

    public void clearProjects() {
      ensureProjects();
      projects.clear();
    }

    protected void ensureProjects() {
      if (projects == null) {
        projects = new java.util.ArrayList<org.eclipse.che.api.workspace.shared.dto.ProjectConfigDto>();
      }
    }
    @Override
    public java.lang.String getName() {
      return name;
    }

    public void setName(java.lang.String v) {
      this.name = v;
    }

    @Override
    public java.lang.String getDescription() {
      return description;
    }

    public void setDescription(java.lang.String v) {
      this.description = v;
    }

    @Override
    public java.util.List<org.eclipse.che.api.machine.shared.dto.CommandDto> getCommands() {
      ensureCommands();
      return new org.eclipse.che.dto.server.JsonArrayImpl(commands);
    }

    public void setCommands(java.util.List<org.eclipse.che.api.machine.shared.dto.CommandDto> v) {
      this.commands = v;
    }

    public void addCommands(org.eclipse.che.api.machine.shared.dto.CommandDto v) {
      ensureCommands();
      commands.add(v);
    }

    public void clearCommands() {
      ensureCommands();
      commands.clear();
    }

    protected void ensureCommands() {
      if (commands == null) {
        commands = new java.util.ArrayList<org.eclipse.che.api.machine.shared.dto.CommandDto>();
      }
    }
    @Override
    public boolean equals(Object o) {
      if (!(o instanceof WorkspaceConfigDtoImpl)) {
        return false;
      }
      WorkspaceConfigDtoImpl other = (WorkspaceConfigDtoImpl) o;
      this.ensureEnvironments();
      other.ensureEnvironments();
      
      if (this.environments != null) {
        if (!this.environments.equals(other.environments)) {
          return false;
        }
      } else {
        if (other.environments != null) {
          return false;
        }
      }
      if (this.defaultEnv != null) {
        if (!this.defaultEnv.equals(other.defaultEnv)) {
          return false;
        }
      } else {
        if (other.defaultEnv != null) {
          return false;
        }
      }
      this.ensureProjects();
      other.ensureProjects();
      
      if (this.projects != null) {
        if (!this.projects.equals(other.projects)) {
          return false;
        }
      } else {
        if (other.projects != null) {
          return false;
        }
      }
      if (this.name != null) {
        if (!this.name.equals(other.name)) {
          return false;
        }
      } else {
        if (other.name != null) {
          return false;
        }
      }
      if (this.description != null) {
        if (!this.description.equals(other.description)) {
          return false;
        }
      } else {
        if (other.description != null) {
          return false;
        }
      }
      this.ensureCommands();
      other.ensureCommands();
      
      if (this.commands != null) {
        if (!this.commands.equals(other.commands)) {
          return false;
        }
      } else {
        if (other.commands != null) {
          return false;
        }
      }
      this.ensureLinks();
      other.ensureLinks();
      
      if (this.links != null) {
        if (!this.links.equals(other.links)) {
          return false;
        }
      } else {
        if (other.links != null) {
          return false;
        }
      }
      return true;
    }

    @Override
    public int hashCode() {
      int hash = 7;
      ensureEnvironments();
      hash = hash * 31 + (environments != null ? environments.hashCode() : 0);
      hash = hash * 31 + (defaultEnv != null ? defaultEnv.hashCode() : 0);
      ensureProjects();
      hash = hash * 31 + (projects != null ? projects.hashCode() : 0);
      hash = hash * 31 + (name != null ? name.hashCode() : 0);
      hash = hash * 31 + (description != null ? description.hashCode() : 0);
      ensureCommands();
      hash = hash * 31 + (commands != null ? commands.hashCode() : 0);
      ensureLinks();
      hash = hash * 31 + (links != null ? links.hashCode() : 0);
      return hash;
    }

    @Override
    public JsonElement toJsonElement() {
      return toJsonElementInt(true);
    }
    public JsonElement toJsonElementInt(boolean copyJsons) {
      JsonObject result = new JsonObject();

      JsonObject environmentsOut = new JsonObject();
      this.ensureEnvironments();
      for (java.util.Map.Entry<String, org.eclipse.che.api.workspace.shared.dto.EnvironmentDto> entry0 : this.environments.entrySet()) {
        org.eclipse.che.api.workspace.shared.dto.EnvironmentDto environments_ = entry0.getValue();
        JsonElement environmentsOut_ = environments_ == null ? JsonNull.INSTANCE : ((EnvironmentDtoImpl)environments_).toJsonElementInt(copyJsons);
        environmentsOut.add(entry0.getKey(), environmentsOut_);
      }
      result.add("environments", environmentsOut);

      JsonElement defaultEnvOut = (this.defaultEnv == null) ? JsonNull.INSTANCE : new JsonPrimitive(this.defaultEnv);
      result.add("defaultEnv", defaultEnvOut);

      JsonArray projectsOut = new JsonArray();
      this.ensureProjects();
      for (org.eclipse.che.api.workspace.shared.dto.ProjectConfigDto projects_ : this.projects) {
        JsonElement projectsOut_ = projects_ == null ? JsonNull.INSTANCE : ((ProjectConfigDtoImpl)projects_).toJsonElementInt(copyJsons);
        projectsOut.add(projectsOut_);
      }
      result.add("projects", projectsOut);

      JsonElement nameOut = (this.name == null) ? JsonNull.INSTANCE : new JsonPrimitive(this.name);
      result.add("name", nameOut);

      JsonElement descriptionOut = (this.description == null) ? JsonNull.INSTANCE : new JsonPrimitive(this.description);
      result.add("description", descriptionOut);

      JsonArray commandsOut = new JsonArray();
      this.ensureCommands();
      for (org.eclipse.che.api.machine.shared.dto.CommandDto commands_ : this.commands) {
        JsonElement commandsOut_ = commands_ == null ? JsonNull.INSTANCE : ((org.eclipse.che.api.machine.shared.dto.DtoServerImpls.CommandDtoImpl)commands_).toJsonElementInt(copyJsons);
        commandsOut.add(commandsOut_);
      }
      result.add("commands", commandsOut);

      JsonArray linksOut = new JsonArray();
      this.ensureLinks();
      for (org.eclipse.che.api.core.rest.shared.dto.Link links_ : this.links) {
        JsonElement linksOut_ = links_ == null ? JsonNull.INSTANCE : ((org.eclipse.che.api.core.server.dto.DtoServerImpls.LinkImpl)links_).toJsonElementInt(copyJsons);
        linksOut.add(linksOut_);
      }
      result.add("links", linksOut);
      return result;
    }

    @Override
    public String toJson() {
      return gson.toJson(toJsonElementInt(false));
    }

    @Override
    public String toString() {
      return toJson();
    }

    public static WorkspaceConfigDtoImpl fromJsonElement(JsonElement jsonElem) {
      return fromJsonElement(jsonElem, true);
    }
    public static WorkspaceConfigDtoImpl fromJsonElement(JsonElement jsonElem, boolean copyJsons) {
      if (jsonElem == null || jsonElem.isJsonNull()) {
        return null;
      }

      WorkspaceConfigDtoImpl dto = new WorkspaceConfigDtoImpl();
      JsonObject json = jsonElem.getAsJsonObject();

      if (json.has("environments")) {
        JsonElement environmentsIn = json.get("environments");
        java.util.Map<java.lang.String, org.eclipse.che.api.workspace.shared.dto.EnvironmentDto> environmentsOut = null;
        if (environmentsIn != null && !environmentsIn.isJsonNull()) {
          environmentsOut = new java.util.HashMap<java.lang.String, org.eclipse.che.api.workspace.shared.dto.EnvironmentDto>();
          java.util.Set<java.util.Map.Entry<String, JsonElement>> entries0 = environmentsIn.getAsJsonObject().entrySet();
          for (java.util.Map.Entry<String, JsonElement> entry0 : entries0) {
            JsonElement environmentsIn_ = entry0.getValue();
            org.eclipse.che.api.workspace.shared.dto.EnvironmentDto environmentsOut_ = EnvironmentDtoImpl.fromJsonElement(environmentsIn_, copyJsons);
            environmentsOut.put(entry0.getKey(), environmentsOut_);
          }
        }
        dto.setEnvironments(environmentsOut);
      }

      if (json.has("defaultEnv")) {
        JsonElement defaultEnvIn = json.get("defaultEnv");
        java.lang.String defaultEnvOut = gson.fromJson(defaultEnvIn, java.lang.String.class);
        dto.setDefaultEnv(defaultEnvOut);
      }

      if (json.has("projects")) {
        JsonElement projectsIn = json.get("projects");
        java.util.List<org.eclipse.che.api.workspace.shared.dto.ProjectConfigDto> projectsOut = null;
        if (projectsIn != null && !projectsIn.isJsonNull()) {
          projectsOut = new java.util.ArrayList<org.eclipse.che.api.workspace.shared.dto.ProjectConfigDto>();
          java.util.Iterator<JsonElement> projectsInIterator = projectsIn.getAsJsonArray().iterator();
          while (projectsInIterator.hasNext()) {
            JsonElement projectsIn_ = projectsInIterator.next();
            org.eclipse.che.api.workspace.shared.dto.ProjectConfigDto projectsOut_ = ProjectConfigDtoImpl.fromJsonElement(projectsIn_, copyJsons);
            projectsOut.add(projectsOut_);
          }
        }
        dto.setProjects(projectsOut);
      }

      if (json.has("name")) {
        JsonElement nameIn = json.get("name");
        java.lang.String nameOut = gson.fromJson(nameIn, java.lang.String.class);
        dto.setName(nameOut);
      }

      if (json.has("description")) {
        JsonElement descriptionIn = json.get("description");
        java.lang.String descriptionOut = gson.fromJson(descriptionIn, java.lang.String.class);
        dto.setDescription(descriptionOut);
      }

      if (json.has("commands")) {
        JsonElement commandsIn = json.get("commands");
        java.util.List<org.eclipse.che.api.machine.shared.dto.CommandDto> commandsOut = null;
        if (commandsIn != null && !commandsIn.isJsonNull()) {
          commandsOut = new java.util.ArrayList<org.eclipse.che.api.machine.shared.dto.CommandDto>();
          java.util.Iterator<JsonElement> commandsInIterator = commandsIn.getAsJsonArray().iterator();
          while (commandsInIterator.hasNext()) {
            JsonElement commandsIn_ = commandsInIterator.next();
            org.eclipse.che.api.machine.shared.dto.CommandDto commandsOut_ = org.eclipse.che.api.machine.shared.dto.DtoServerImpls.CommandDtoImpl.fromJsonElement(commandsIn_, copyJsons);
            commandsOut.add(commandsOut_);
          }
        }
        dto.setCommands(commandsOut);
      }

      if (json.has("links")) {
        JsonElement linksIn = json.get("links");
        java.util.List<org.eclipse.che.api.core.rest.shared.dto.Link> linksOut = null;
        if (linksIn != null && !linksIn.isJsonNull()) {
          linksOut = new java.util.ArrayList<org.eclipse.che.api.core.rest.shared.dto.Link>();
          java.util.Iterator<JsonElement> linksInIterator = linksIn.getAsJsonArray().iterator();
          while (linksInIterator.hasNext()) {
            JsonElement linksIn_ = linksInIterator.next();
            org.eclipse.che.api.core.rest.shared.dto.Link linksOut_ = org.eclipse.che.api.core.server.dto.DtoServerImpls.LinkImpl.fromJsonElement(linksIn_, copyJsons);
            linksOut.add(linksOut_);
          }
        }
        dto.setLinks(linksOut);
      }

      return dto;
    }

    public static WorkspaceConfigDtoImpl fromJsonString(String jsonString) {
      if (jsonString == null) {
        return null;
      }

      return fromJsonElement(new JsonParser().parse(jsonString), false);
    }

    public WorkspaceConfigDtoImpl(org.eclipse.che.api.workspace.shared.dto.WorkspaceConfigDto origin) {
      java.util.Map<java.lang.String, org.eclipse.che.api.workspace.shared.dto.EnvironmentDto> environmentsIn = origin.getEnvironments();
      if (environmentsIn != null) {
        java.util.Map<java.lang.String, org.eclipse.che.api.workspace.shared.dto.EnvironmentDto> environmentsOut = new java.util.HashMap<java.lang.String, org.eclipse.che.api.workspace.shared.dto.EnvironmentDto>();
        for (java.util.Map.Entry<String, org.eclipse.che.api.workspace.shared.dto.EnvironmentDto> entry0 : environmentsIn.entrySet()) {
          org.eclipse.che.api.workspace.shared.dto.EnvironmentDto environmentsIn_ = entry0.getValue();
            environmentsOut.put(entry0.getKey(), environmentsIn_ == null ? null : new EnvironmentDtoImpl(environmentsIn_));
        }
        this.environments = environmentsOut;
      }
      this.defaultEnv = origin.getDefaultEnv();
      java.util.List<org.eclipse.che.api.workspace.shared.dto.ProjectConfigDto> projectsIn = origin.getProjects();
      if (projectsIn != null) {
        java.util.List<org.eclipse.che.api.workspace.shared.dto.ProjectConfigDto> projectsOut = new java.util.ArrayList<org.eclipse.che.api.workspace.shared.dto.ProjectConfigDto>();
        for (org.eclipse.che.api.workspace.shared.dto.ProjectConfigDto projectsIn_ : projectsIn) {
            projectsOut.add(projectsIn_ == null ? null : new ProjectConfigDtoImpl(projectsIn_));
        }
        this.projects = projectsOut;
      }
      this.name = origin.getName();
      this.description = origin.getDescription();
      java.util.List<org.eclipse.che.api.machine.shared.dto.CommandDto> commandsIn = origin.getCommands();
      if (commandsIn != null) {
        java.util.List<org.eclipse.che.api.machine.shared.dto.CommandDto> commandsOut = new java.util.ArrayList<org.eclipse.che.api.machine.shared.dto.CommandDto>();
        for (org.eclipse.che.api.machine.shared.dto.CommandDto commandsIn_ : commandsIn) {
            commandsOut.add(commandsIn_);
        }
        this.commands = commandsOut;
      }
      java.util.List<org.eclipse.che.api.core.rest.shared.dto.Link> linksIn = origin.getLinks();
      if (linksIn != null) {
        java.util.List<org.eclipse.che.api.core.rest.shared.dto.Link> linksOut = new java.util.ArrayList<org.eclipse.che.api.core.rest.shared.dto.Link>();
        for (org.eclipse.che.api.core.rest.shared.dto.Link linksIn_ : linksIn) {
            linksOut.add(linksIn_);
        }
        this.links = linksOut;
      }
    }

    public org.eclipse.che.api.workspace.shared.dto.WorkspaceConfigDto withEnvironments(java.util.Map<java.lang.String, org.eclipse.che.api.workspace.shared.dto.EnvironmentDto> v) {
      this.environments = v;
      return this;
    }

    public org.eclipse.che.api.workspace.shared.dto.WorkspaceConfigDto withDefaultEnv(java.lang.String v) {
      this.defaultEnv = v;
      return this;
    }

    public org.eclipse.che.api.workspace.shared.dto.WorkspaceConfigDto withProjects(java.util.List<org.eclipse.che.api.workspace.shared.dto.ProjectConfigDto> v) {
      this.projects = v;
      return this;
    }

    public org.eclipse.che.api.workspace.shared.dto.WorkspaceConfigDto withName(java.lang.String v) {
      this.name = v;
      return this;
    }

    public org.eclipse.che.api.workspace.shared.dto.WorkspaceConfigDto withDescription(java.lang.String v) {
      this.description = v;
      return this;
    }

    public org.eclipse.che.api.workspace.shared.dto.WorkspaceConfigDto withCommands(java.util.List<org.eclipse.che.api.machine.shared.dto.CommandDto> v) {
      this.commands = v;
      return this;
    }

    public org.eclipse.che.api.workspace.shared.dto.WorkspaceConfigDto withLinks(java.util.List<org.eclipse.che.api.core.rest.shared.dto.Link> v) {
      this.links = v;
      return this;
    }

  }

  @org.eclipse.che.dto.shared.DTOImpl("server")
  public static class WorkspaceDtoImpl extends org.eclipse.che.api.core.server.dto.DtoServerImpls.HyperlinksImpl implements org.eclipse.che.api.workspace.shared.dto.WorkspaceDto, JsonSerializable  {

    public static WorkspaceDtoImpl make() {
        return new WorkspaceDtoImpl();
    }

    public WorkspaceDtoImpl() {
    }

    protected java.util.Map<java.lang.String, java.lang.String> attributes;
    protected java.lang.String namespace;
    protected boolean temporary;
    protected java.lang.String id;
    protected org.eclipse.che.api.core.model.workspace.WorkspaceStatus status;
    protected org.eclipse.che.api.workspace.shared.dto.WorkspaceRuntimeDto runtime;
    protected org.eclipse.che.api.workspace.shared.dto.WorkspaceConfigDto config;

    @Override
    public java.util.Map<java.lang.String, java.lang.String> getAttributes() {
      ensureAttributes();
      return new org.eclipse.che.dto.server.JsonStringMapImpl(attributes);
    }

    public void setAttributes(java.util.Map<java.lang.String, java.lang.String> v) {
      this.attributes = v;
    }

    public void putAttributes(String k, java.lang.String v) {
      ensureAttributes();
      attributes.put(k, v);
    }

    public void clearAttributes() {
      ensureAttributes();
      attributes.clear();
    }

    protected void ensureAttributes() {
      if (attributes == null) {
        attributes = new java.util.HashMap<java.lang.String, java.lang.String>();
      }
    }
    @Override
    public java.lang.String getNamespace() {
      return namespace;
    }

    public void setNamespace(java.lang.String v) {
      this.namespace = v;
    }

    @Override
    public boolean isTemporary() {
      return temporary;
    }

    public void setTemporary(boolean v) {
      this.temporary = v;
    }

    @Override
    public java.lang.String getId() {
      return id;
    }

    public void setId(java.lang.String v) {
      this.id = v;
    }

    @Override
    public org.eclipse.che.api.core.model.workspace.WorkspaceStatus getStatus() {
      return status;
    }

    public void setStatus(org.eclipse.che.api.core.model.workspace.WorkspaceStatus v) {
      this.status = v;
    }

    @Override
    public org.eclipse.che.api.workspace.shared.dto.WorkspaceRuntimeDto getRuntime() {
      return runtime;
    }

    public void setRuntime(org.eclipse.che.api.workspace.shared.dto.WorkspaceRuntimeDto v) {
      this.runtime = v;
    }

    @Override
    public org.eclipse.che.api.workspace.shared.dto.WorkspaceConfigDto getConfig() {
      return config;
    }

    public void setConfig(org.eclipse.che.api.workspace.shared.dto.WorkspaceConfigDto v) {
      this.config = v;
    }

    @Override
    public boolean equals(Object o) {
      if (!(o instanceof WorkspaceDtoImpl)) {
        return false;
      }
      WorkspaceDtoImpl other = (WorkspaceDtoImpl) o;
      this.ensureAttributes();
      other.ensureAttributes();
      
      if (this.attributes != null) {
        if (!this.attributes.equals(other.attributes)) {
          return false;
        }
      } else {
        if (other.attributes != null) {
          return false;
        }
      }
      if (this.namespace != null) {
        if (!this.namespace.equals(other.namespace)) {
          return false;
        }
      } else {
        if (other.namespace != null) {
          return false;
        }
      }
      if (this.temporary != other.temporary) {
        return false;
      }
      if (this.id != null) {
        if (!this.id.equals(other.id)) {
          return false;
        }
      } else {
        if (other.id != null) {
          return false;
        }
      }
      if (this.status != null) {
        if (!this.status.equals(other.status)) {
          return false;
        }
      } else {
        if (other.status != null) {
          return false;
        }
      }
      if (this.runtime != null) {
        if (!this.runtime.equals(other.runtime)) {
          return false;
        }
      } else {
        if (other.runtime != null) {
          return false;
        }
      }
      if (this.config != null) {
        if (!this.config.equals(other.config)) {
          return false;
        }
      } else {
        if (other.config != null) {
          return false;
        }
      }
      this.ensureLinks();
      other.ensureLinks();
      
      if (this.links != null) {
        if (!this.links.equals(other.links)) {
          return false;
        }
      } else {
        if (other.links != null) {
          return false;
        }
      }
      return true;
    }

    @Override
    public int hashCode() {
      int hash = 7;
      ensureAttributes();
      hash = hash * 31 + (attributes != null ? attributes.hashCode() : 0);
      hash = hash * 31 + (namespace != null ? namespace.hashCode() : 0);
      hash = hash * 31 + java.lang.Boolean.valueOf(temporary).hashCode();
      hash = hash * 31 + (id != null ? id.hashCode() : 0);
      hash = hash * 31 + (status != null ? status.hashCode() : 0);
      hash = hash * 31 + (runtime != null ? runtime.hashCode() : 0);
      hash = hash * 31 + (config != null ? config.hashCode() : 0);
      ensureLinks();
      hash = hash * 31 + (links != null ? links.hashCode() : 0);
      return hash;
    }

    @Override
    public JsonElement toJsonElement() {
      return toJsonElementInt(true);
    }
    public JsonElement toJsonElementInt(boolean copyJsons) {
      JsonObject result = new JsonObject();

      JsonObject attributesOut = new JsonObject();
      this.ensureAttributes();
      for (java.util.Map.Entry<String, java.lang.String> entry0 : this.attributes.entrySet()) {
        java.lang.String attributes_ = entry0.getValue();
        JsonElement attributesOut_ = (attributes_ == null) ? JsonNull.INSTANCE : new JsonPrimitive(attributes_);
        attributesOut.add(entry0.getKey(), attributesOut_);
      }
      result.add("attributes", attributesOut);

      JsonElement namespaceOut = (this.namespace == null) ? JsonNull.INSTANCE : new JsonPrimitive(this.namespace);
      result.add("namespace", namespaceOut);

      JsonPrimitive temporaryOut = new JsonPrimitive(this.temporary);
      result.add("temporary", temporaryOut);

      JsonElement idOut = (this.id == null) ? JsonNull.INSTANCE : new JsonPrimitive(this.id);
      result.add("id", idOut);

      JsonElement statusOut = (this.status == null) ? JsonNull.INSTANCE : new JsonPrimitive(this.status.name());
      result.add("status", statusOut);

      JsonElement runtimeOut = this.runtime == null ? JsonNull.INSTANCE : ((WorkspaceRuntimeDtoImpl)this.runtime).toJsonElementInt(copyJsons);
      result.add("runtime", runtimeOut);

      JsonElement configOut = this.config == null ? JsonNull.INSTANCE : ((WorkspaceConfigDtoImpl)this.config).toJsonElementInt(copyJsons);
      result.add("config", configOut);

      JsonArray linksOut = new JsonArray();
      this.ensureLinks();
      for (org.eclipse.che.api.core.rest.shared.dto.Link links_ : this.links) {
        JsonElement linksOut_ = links_ == null ? JsonNull.INSTANCE : ((org.eclipse.che.api.core.server.dto.DtoServerImpls.LinkImpl)links_).toJsonElementInt(copyJsons);
        linksOut.add(linksOut_);
      }
      result.add("links", linksOut);
      return result;
    }

    @Override
    public String toJson() {
      return gson.toJson(toJsonElementInt(false));
    }

    @Override
    public String toString() {
      return toJson();
    }

    public static WorkspaceDtoImpl fromJsonElement(JsonElement jsonElem) {
      return fromJsonElement(jsonElem, true);
    }
    public static WorkspaceDtoImpl fromJsonElement(JsonElement jsonElem, boolean copyJsons) {
      if (jsonElem == null || jsonElem.isJsonNull()) {
        return null;
      }

      WorkspaceDtoImpl dto = new WorkspaceDtoImpl();
      JsonObject json = jsonElem.getAsJsonObject();

      if (json.has("attributes")) {
        JsonElement attributesIn = json.get("attributes");
        java.util.Map<java.lang.String, java.lang.String> attributesOut = null;
        if (attributesIn != null && !attributesIn.isJsonNull()) {
          attributesOut = new java.util.HashMap<java.lang.String, java.lang.String>();
          java.util.Set<java.util.Map.Entry<String, JsonElement>> entries0 = attributesIn.getAsJsonObject().entrySet();
          for (java.util.Map.Entry<String, JsonElement> entry0 : entries0) {
            JsonElement attributesIn_ = entry0.getValue();
            java.lang.String attributesOut_ = gson.fromJson(attributesIn_, java.lang.String.class);
            attributesOut.put(entry0.getKey(), attributesOut_);
          }
        }
        dto.setAttributes(attributesOut);
      }

      if (json.has("namespace")) {
        JsonElement namespaceIn = json.get("namespace");
        java.lang.String namespaceOut = gson.fromJson(namespaceIn, java.lang.String.class);
        dto.setNamespace(namespaceOut);
      }

      if (json.has("temporary")) {
        JsonElement temporaryIn = json.get("temporary");
        boolean temporaryOut = temporaryIn.getAsBoolean();
        dto.setTemporary(temporaryOut);
      }

      if (json.has("id")) {
        JsonElement idIn = json.get("id");
        java.lang.String idOut = gson.fromJson(idIn, java.lang.String.class);
        dto.setId(idOut);
      }

      if (json.has("status")) {
        JsonElement statusIn = json.get("status");
        org.eclipse.che.api.core.model.workspace.WorkspaceStatus statusOut = gson.fromJson(statusIn, org.eclipse.che.api.core.model.workspace.WorkspaceStatus.class);
        dto.setStatus(statusOut);
      }

      if (json.has("runtime")) {
        JsonElement runtimeIn = json.get("runtime");
        org.eclipse.che.api.workspace.shared.dto.WorkspaceRuntimeDto runtimeOut = WorkspaceRuntimeDtoImpl.fromJsonElement(runtimeIn, copyJsons);
        dto.setRuntime(runtimeOut);
      }

      if (json.has("config")) {
        JsonElement configIn = json.get("config");
        org.eclipse.che.api.workspace.shared.dto.WorkspaceConfigDto configOut = WorkspaceConfigDtoImpl.fromJsonElement(configIn, copyJsons);
        dto.setConfig(configOut);
      }

      if (json.has("links")) {
        JsonElement linksIn = json.get("links");
        java.util.List<org.eclipse.che.api.core.rest.shared.dto.Link> linksOut = null;
        if (linksIn != null && !linksIn.isJsonNull()) {
          linksOut = new java.util.ArrayList<org.eclipse.che.api.core.rest.shared.dto.Link>();
          java.util.Iterator<JsonElement> linksInIterator = linksIn.getAsJsonArray().iterator();
          while (linksInIterator.hasNext()) {
            JsonElement linksIn_ = linksInIterator.next();
            org.eclipse.che.api.core.rest.shared.dto.Link linksOut_ = org.eclipse.che.api.core.server.dto.DtoServerImpls.LinkImpl.fromJsonElement(linksIn_, copyJsons);
            linksOut.add(linksOut_);
          }
        }
        dto.setLinks(linksOut);
      }

      return dto;
    }

    public static WorkspaceDtoImpl fromJsonString(String jsonString) {
      if (jsonString == null) {
        return null;
      }

      return fromJsonElement(new JsonParser().parse(jsonString), false);
    }

    public WorkspaceDtoImpl(org.eclipse.che.api.workspace.shared.dto.WorkspaceDto origin) {
      java.util.Map<java.lang.String, java.lang.String> attributesIn = origin.getAttributes();
      if (attributesIn != null) {
        java.util.Map<java.lang.String, java.lang.String> attributesOut = new java.util.HashMap<java.lang.String, java.lang.String>();
        for (java.util.Map.Entry<String, java.lang.String> entry0 : attributesIn.entrySet()) {
          java.lang.String attributesIn_ = entry0.getValue();
            attributesOut.put(entry0.getKey(), attributesIn_);
        }
        this.attributes = attributesOut;
      }
      this.namespace = origin.getNamespace();
      this.temporary = origin.isTemporary();
      this.id = origin.getId();
      this.status = origin.getStatus();
      org.eclipse.che.api.workspace.shared.dto.WorkspaceRuntimeDto runtimeIn = origin.getRuntime();
      this.runtime = runtimeIn == null ? null : new WorkspaceRuntimeDtoImpl(runtimeIn);
      org.eclipse.che.api.workspace.shared.dto.WorkspaceConfigDto configIn = origin.getConfig();
      this.config = configIn == null ? null : new WorkspaceConfigDtoImpl(configIn);
      java.util.List<org.eclipse.che.api.core.rest.shared.dto.Link> linksIn = origin.getLinks();
      if (linksIn != null) {
        java.util.List<org.eclipse.che.api.core.rest.shared.dto.Link> linksOut = new java.util.ArrayList<org.eclipse.che.api.core.rest.shared.dto.Link>();
        for (org.eclipse.che.api.core.rest.shared.dto.Link linksIn_ : linksIn) {
            linksOut.add(linksIn_);
        }
        this.links = linksOut;
      }
    }

    public org.eclipse.che.api.workspace.shared.dto.WorkspaceDto withAttributes(java.util.Map<java.lang.String, java.lang.String> v) {
      this.attributes = v;
      return this;
    }

    public org.eclipse.che.api.workspace.shared.dto.WorkspaceDto withNamespace(java.lang.String v) {
      this.namespace = v;
      return this;
    }

    public org.eclipse.che.api.workspace.shared.dto.WorkspaceDto withTemporary(boolean v) {
      this.temporary = v;
      return this;
    }

    public org.eclipse.che.api.workspace.shared.dto.WorkspaceDto withId(java.lang.String v) {
      this.id = v;
      return this;
    }

    public org.eclipse.che.api.workspace.shared.dto.WorkspaceDto withStatus(org.eclipse.che.api.core.model.workspace.WorkspaceStatus v) {
      this.status = v;
      return this;
    }

    public org.eclipse.che.api.workspace.shared.dto.WorkspaceDto withRuntime(org.eclipse.che.api.workspace.shared.dto.WorkspaceRuntimeDto v) {
      this.runtime = v;
      return this;
    }

    public org.eclipse.che.api.workspace.shared.dto.WorkspaceDto withConfig(org.eclipse.che.api.workspace.shared.dto.WorkspaceConfigDto v) {
      this.config = v;
      return this;
    }

    public org.eclipse.che.api.workspace.shared.dto.WorkspaceDto withLinks(java.util.List<org.eclipse.che.api.core.rest.shared.dto.Link> v) {
      this.links = v;
      return this;
    }

  }

  @org.eclipse.che.dto.shared.DTOImpl("server")
  public static class WorkspaceRuntimeDtoImpl extends org.eclipse.che.api.core.server.dto.DtoServerImpls.HyperlinksImpl implements org.eclipse.che.api.workspace.shared.dto.WorkspaceRuntimeDto, JsonSerializable  {

    public static WorkspaceRuntimeDtoImpl make() {
        return new WorkspaceRuntimeDtoImpl();
    }

    public WorkspaceRuntimeDtoImpl() {
    }

    protected java.util.List<org.eclipse.che.api.machine.shared.dto.MachineDto> machines;
    protected java.lang.String activeEnv;
    protected org.eclipse.che.api.machine.shared.dto.MachineDto devMachine;
    protected java.lang.String rootFolder;

    @Override
    public java.util.List<org.eclipse.che.api.machine.shared.dto.MachineDto> getMachines() {
      ensureMachines();
      return new org.eclipse.che.dto.server.JsonArrayImpl(machines);
    }

    public void setMachines(java.util.List<org.eclipse.che.api.machine.shared.dto.MachineDto> v) {
      this.machines = v;
    }

    public void addMachines(org.eclipse.che.api.machine.shared.dto.MachineDto v) {
      ensureMachines();
      machines.add(v);
    }

    public void clearMachines() {
      ensureMachines();
      machines.clear();
    }

    protected void ensureMachines() {
      if (machines == null) {
        machines = new java.util.ArrayList<org.eclipse.che.api.machine.shared.dto.MachineDto>();
      }
    }
    @Override
    public java.lang.String getActiveEnv() {
      return activeEnv;
    }

    public void setActiveEnv(java.lang.String v) {
      this.activeEnv = v;
    }

    @Override
    public org.eclipse.che.api.machine.shared.dto.MachineDto getDevMachine() {
      return devMachine;
    }

    public void setDevMachine(org.eclipse.che.api.machine.shared.dto.MachineDto v) {
      this.devMachine = v;
    }

    @org.eclipse.che.commons.annotation.Nullable
    @Override
    public java.lang.String getRootFolder() {
      return rootFolder;
    }

    public void setRootFolder(java.lang.String v) {
      this.rootFolder = v;
    }

    @Override
    public boolean equals(Object o) {
      if (!(o instanceof WorkspaceRuntimeDtoImpl)) {
        return false;
      }
      WorkspaceRuntimeDtoImpl other = (WorkspaceRuntimeDtoImpl) o;
      this.ensureMachines();
      other.ensureMachines();
      
      if (this.machines != null) {
        if (!this.machines.equals(other.machines)) {
          return false;
        }
      } else {
        if (other.machines != null) {
          return false;
        }
      }
      if (this.activeEnv != null) {
        if (!this.activeEnv.equals(other.activeEnv)) {
          return false;
        }
      } else {
        if (other.activeEnv != null) {
          return false;
        }
      }
      if (this.devMachine != null) {
        if (!this.devMachine.equals(other.devMachine)) {
          return false;
        }
      } else {
        if (other.devMachine != null) {
          return false;
        }
      }
      if (this.rootFolder != null) {
        if (!this.rootFolder.equals(other.rootFolder)) {
          return false;
        }
      } else {
        if (other.rootFolder != null) {
          return false;
        }
      }
      this.ensureLinks();
      other.ensureLinks();
      
      if (this.links != null) {
        if (!this.links.equals(other.links)) {
          return false;
        }
      } else {
        if (other.links != null) {
          return false;
        }
      }
      return true;
    }

    @Override
    public int hashCode() {
      int hash = 7;
      ensureMachines();
      hash = hash * 31 + (machines != null ? machines.hashCode() : 0);
      hash = hash * 31 + (activeEnv != null ? activeEnv.hashCode() : 0);
      hash = hash * 31 + (devMachine != null ? devMachine.hashCode() : 0);
      hash = hash * 31 + (rootFolder != null ? rootFolder.hashCode() : 0);
      ensureLinks();
      hash = hash * 31 + (links != null ? links.hashCode() : 0);
      return hash;
    }

    @Override
    public JsonElement toJsonElement() {
      return toJsonElementInt(true);
    }
    public JsonElement toJsonElementInt(boolean copyJsons) {
      JsonObject result = new JsonObject();

      JsonArray machinesOut = new JsonArray();
      this.ensureMachines();
      for (org.eclipse.che.api.machine.shared.dto.MachineDto machines_ : this.machines) {
        JsonElement machinesOut_ = machines_ == null ? JsonNull.INSTANCE : ((org.eclipse.che.api.machine.shared.dto.DtoServerImpls.MachineDtoImpl)machines_).toJsonElementInt(copyJsons);
        machinesOut.add(machinesOut_);
      }
      result.add("machines", machinesOut);

      JsonElement activeEnvOut = (this.activeEnv == null) ? JsonNull.INSTANCE : new JsonPrimitive(this.activeEnv);
      result.add("activeEnv", activeEnvOut);

      JsonElement devMachineOut = this.devMachine == null ? JsonNull.INSTANCE : ((org.eclipse.che.api.machine.shared.dto.DtoServerImpls.MachineDtoImpl)this.devMachine).toJsonElementInt(copyJsons);
      result.add("devMachine", devMachineOut);

      JsonElement rootFolderOut = (this.rootFolder == null) ? JsonNull.INSTANCE : new JsonPrimitive(this.rootFolder);
      result.add("rootFolder", rootFolderOut);

      JsonArray linksOut = new JsonArray();
      this.ensureLinks();
      for (org.eclipse.che.api.core.rest.shared.dto.Link links_ : this.links) {
        JsonElement linksOut_ = links_ == null ? JsonNull.INSTANCE : ((org.eclipse.che.api.core.server.dto.DtoServerImpls.LinkImpl)links_).toJsonElementInt(copyJsons);
        linksOut.add(linksOut_);
      }
      result.add("links", linksOut);
      return result;
    }

    @Override
    public String toJson() {
      return gson.toJson(toJsonElementInt(false));
    }

    @Override
    public String toString() {
      return toJson();
    }

    public static WorkspaceRuntimeDtoImpl fromJsonElement(JsonElement jsonElem) {
      return fromJsonElement(jsonElem, true);
    }
    public static WorkspaceRuntimeDtoImpl fromJsonElement(JsonElement jsonElem, boolean copyJsons) {
      if (jsonElem == null || jsonElem.isJsonNull()) {
        return null;
      }

      WorkspaceRuntimeDtoImpl dto = new WorkspaceRuntimeDtoImpl();
      JsonObject json = jsonElem.getAsJsonObject();

      if (json.has("machines")) {
        JsonElement machinesIn = json.get("machines");
        java.util.List<org.eclipse.che.api.machine.shared.dto.MachineDto> machinesOut = null;
        if (machinesIn != null && !machinesIn.isJsonNull()) {
          machinesOut = new java.util.ArrayList<org.eclipse.che.api.machine.shared.dto.MachineDto>();
          java.util.Iterator<JsonElement> machinesInIterator = machinesIn.getAsJsonArray().iterator();
          while (machinesInIterator.hasNext()) {
            JsonElement machinesIn_ = machinesInIterator.next();
            org.eclipse.che.api.machine.shared.dto.MachineDto machinesOut_ = org.eclipse.che.api.machine.shared.dto.DtoServerImpls.MachineDtoImpl.fromJsonElement(machinesIn_, copyJsons);
            machinesOut.add(machinesOut_);
          }
        }
        dto.setMachines(machinesOut);
      }

      if (json.has("activeEnv")) {
        JsonElement activeEnvIn = json.get("activeEnv");
        java.lang.String activeEnvOut = gson.fromJson(activeEnvIn, java.lang.String.class);
        dto.setActiveEnv(activeEnvOut);
      }

      if (json.has("devMachine")) {
        JsonElement devMachineIn = json.get("devMachine");
        org.eclipse.che.api.machine.shared.dto.MachineDto devMachineOut = org.eclipse.che.api.machine.shared.dto.DtoServerImpls.MachineDtoImpl.fromJsonElement(devMachineIn, copyJsons);
        dto.setDevMachine(devMachineOut);
      }

      if (json.has("rootFolder")) {
        JsonElement rootFolderIn = json.get("rootFolder");
        java.lang.String rootFolderOut = gson.fromJson(rootFolderIn, java.lang.String.class);
        dto.setRootFolder(rootFolderOut);
      }

      if (json.has("links")) {
        JsonElement linksIn = json.get("links");
        java.util.List<org.eclipse.che.api.core.rest.shared.dto.Link> linksOut = null;
        if (linksIn != null && !linksIn.isJsonNull()) {
          linksOut = new java.util.ArrayList<org.eclipse.che.api.core.rest.shared.dto.Link>();
          java.util.Iterator<JsonElement> linksInIterator = linksIn.getAsJsonArray().iterator();
          while (linksInIterator.hasNext()) {
            JsonElement linksIn_ = linksInIterator.next();
            org.eclipse.che.api.core.rest.shared.dto.Link linksOut_ = org.eclipse.che.api.core.server.dto.DtoServerImpls.LinkImpl.fromJsonElement(linksIn_, copyJsons);
            linksOut.add(linksOut_);
          }
        }
        dto.setLinks(linksOut);
      }

      return dto;
    }

    public static WorkspaceRuntimeDtoImpl fromJsonString(String jsonString) {
      if (jsonString == null) {
        return null;
      }

      return fromJsonElement(new JsonParser().parse(jsonString), false);
    }

    public WorkspaceRuntimeDtoImpl(org.eclipse.che.api.workspace.shared.dto.WorkspaceRuntimeDto origin) {
      java.util.List<org.eclipse.che.api.machine.shared.dto.MachineDto> machinesIn = origin.getMachines();
      if (machinesIn != null) {
        java.util.List<org.eclipse.che.api.machine.shared.dto.MachineDto> machinesOut = new java.util.ArrayList<org.eclipse.che.api.machine.shared.dto.MachineDto>();
        for (org.eclipse.che.api.machine.shared.dto.MachineDto machinesIn_ : machinesIn) {
            machinesOut.add(machinesIn_);
        }
        this.machines = machinesOut;
      }
      this.activeEnv = origin.getActiveEnv();
      this.devMachine = origin.getDevMachine();
      this.rootFolder = origin.getRootFolder();
      java.util.List<org.eclipse.che.api.core.rest.shared.dto.Link> linksIn = origin.getLinks();
      if (linksIn != null) {
        java.util.List<org.eclipse.che.api.core.rest.shared.dto.Link> linksOut = new java.util.ArrayList<org.eclipse.che.api.core.rest.shared.dto.Link>();
        for (org.eclipse.che.api.core.rest.shared.dto.Link linksIn_ : linksIn) {
            linksOut.add(linksIn_);
        }
        this.links = linksOut;
      }
    }

    public org.eclipse.che.api.workspace.shared.dto.WorkspaceRuntimeDto withMachines(java.util.List<org.eclipse.che.api.machine.shared.dto.MachineDto> v) {
      this.machines = v;
      return this;
    }

    public org.eclipse.che.api.workspace.shared.dto.WorkspaceRuntimeDto withActiveEnv(java.lang.String v) {
      this.activeEnv = v;
      return this;
    }

    public org.eclipse.che.api.workspace.shared.dto.WorkspaceRuntimeDto withDevMachine(org.eclipse.che.api.machine.shared.dto.MachineDto v) {
      this.devMachine = v;
      return this;
    }

    public org.eclipse.che.api.workspace.shared.dto.WorkspaceRuntimeDto withRootFolder(java.lang.String v) {
      this.rootFolder = v;
      return this;
    }

    public org.eclipse.che.api.workspace.shared.dto.WorkspaceRuntimeDto withLinks(java.util.List<org.eclipse.che.api.core.rest.shared.dto.Link> v) {
      this.links = v;
      return this;
    }

  }

  @org.eclipse.che.dto.shared.DTOImpl("server")
  public static class WsAgentHealthStateDtoImpl implements org.eclipse.che.api.workspace.shared.dto.WsAgentHealthStateDto, JsonSerializable  {

    public static WsAgentHealthStateDtoImpl make() {
        return new WsAgentHealthStateDtoImpl();
    }

    public WsAgentHealthStateDtoImpl() {
    }

    protected java.lang.String reason;
    protected org.eclipse.che.api.core.model.workspace.WorkspaceStatus workspaceStatus;
    protected int code;

    @Override
    public java.lang.String getReason() {
      return reason;
    }

    public void setReason(java.lang.String v) {
      this.reason = v;
    }

    @Override
    public org.eclipse.che.api.core.model.workspace.WorkspaceStatus getWorkspaceStatus() {
      return workspaceStatus;
    }

    public void setWorkspaceStatus(org.eclipse.che.api.core.model.workspace.WorkspaceStatus v) {
      this.workspaceStatus = v;
    }

    @Override
    public int getCode() {
      return code;
    }

    public void setCode(int v) {
      this.code = v;
    }

    @Override
    public boolean equals(Object o) {
      if (!(o instanceof WsAgentHealthStateDtoImpl)) {
        return false;
      }
      WsAgentHealthStateDtoImpl other = (WsAgentHealthStateDtoImpl) o;
      if (this.reason != null) {
        if (!this.reason.equals(other.reason)) {
          return false;
        }
      } else {
        if (other.reason != null) {
          return false;
        }
      }
      if (this.workspaceStatus != null) {
        if (!this.workspaceStatus.equals(other.workspaceStatus)) {
          return false;
        }
      } else {
        if (other.workspaceStatus != null) {
          return false;
        }
      }
      if (this.code != other.code) {
        return false;
      }
      return true;
    }

    @Override
    public int hashCode() {
      int hash = 7;
      hash = hash * 31 + (reason != null ? reason.hashCode() : 0);
      hash = hash * 31 + (workspaceStatus != null ? workspaceStatus.hashCode() : 0);
      hash = hash * 31 + java.lang.Integer.valueOf(code).hashCode();
      return hash;
    }

    @Override
    public JsonElement toJsonElement() {
      return toJsonElementInt(true);
    }
    public JsonElement toJsonElementInt(boolean copyJsons) {
      JsonObject result = new JsonObject();

      JsonElement reasonOut = (this.reason == null) ? JsonNull.INSTANCE : new JsonPrimitive(this.reason);
      result.add("reason", reasonOut);

      JsonElement workspaceStatusOut = (this.workspaceStatus == null) ? JsonNull.INSTANCE : new JsonPrimitive(this.workspaceStatus.name());
      result.add("workspaceStatus", workspaceStatusOut);

      JsonPrimitive codeOut = new JsonPrimitive(this.code);
      result.add("code", codeOut);
      return result;
    }

    @Override
    public String toJson() {
      return gson.toJson(toJsonElementInt(false));
    }

    @Override
    public String toString() {
      return toJson();
    }

    public static WsAgentHealthStateDtoImpl fromJsonElement(JsonElement jsonElem) {
      return fromJsonElement(jsonElem, true);
    }
    public static WsAgentHealthStateDtoImpl fromJsonElement(JsonElement jsonElem, boolean copyJsons) {
      if (jsonElem == null || jsonElem.isJsonNull()) {
        return null;
      }

      WsAgentHealthStateDtoImpl dto = new WsAgentHealthStateDtoImpl();
      JsonObject json = jsonElem.getAsJsonObject();

      if (json.has("reason")) {
        JsonElement reasonIn = json.get("reason");
        java.lang.String reasonOut = gson.fromJson(reasonIn, java.lang.String.class);
        dto.setReason(reasonOut);
      }

      if (json.has("workspaceStatus")) {
        JsonElement workspaceStatusIn = json.get("workspaceStatus");
        org.eclipse.che.api.core.model.workspace.WorkspaceStatus workspaceStatusOut = gson.fromJson(workspaceStatusIn, org.eclipse.che.api.core.model.workspace.WorkspaceStatus.class);
        dto.setWorkspaceStatus(workspaceStatusOut);
      }

      if (json.has("code")) {
        JsonElement codeIn = json.get("code");
        int codeOut = codeIn.getAsInt();
        dto.setCode(codeOut);
      }

      return dto;
    }

    public static WsAgentHealthStateDtoImpl fromJsonString(String jsonString) {
      if (jsonString == null) {
        return null;
      }

      return fromJsonElement(new JsonParser().parse(jsonString), false);
    }

    public WsAgentHealthStateDtoImpl(org.eclipse.che.api.workspace.shared.dto.WsAgentHealthStateDto origin) {
      this.reason = origin.getReason();
      this.workspaceStatus = origin.getWorkspaceStatus();
      this.code = origin.getCode();
    }

    public org.eclipse.che.api.workspace.shared.dto.WsAgentHealthStateDto withReason(java.lang.String v) {
      this.reason = v;
      return this;
    }

    public org.eclipse.che.api.workspace.shared.dto.WsAgentHealthStateDto withWorkspaceStatus(org.eclipse.che.api.core.model.workspace.WorkspaceStatus v) {
      this.workspaceStatus = v;
      return this;
    }

    public org.eclipse.che.api.workspace.shared.dto.WsAgentHealthStateDto withCode(int v) {
      this.code = v;
      return this;
    }

  }

  @org.eclipse.che.dto.shared.DTOImpl("server")
  public static class WorkspaceStatusEventImpl implements org.eclipse.che.api.workspace.shared.dto.event.WorkspaceStatusEvent, JsonSerializable  {

    public static WorkspaceStatusEventImpl make() {
        return new WorkspaceStatusEventImpl();
    }

    public WorkspaceStatusEventImpl() {
    }

    protected java.lang.String error;
    protected org.eclipse.che.api.workspace.shared.dto.event.WorkspaceStatusEvent.EventType eventType;
    protected java.lang.String workspaceId;

    @Override
    public java.lang.String getError() {
      return error;
    }

    public void setError(java.lang.String v) {
      this.error = v;
    }

    @Override
    public org.eclipse.che.api.workspace.shared.dto.event.WorkspaceStatusEvent.EventType getEventType() {
      return eventType;
    }

    public void setEventType(org.eclipse.che.api.workspace.shared.dto.event.WorkspaceStatusEvent.EventType v) {
      this.eventType = v;
    }

    @Override
    public java.lang.String getWorkspaceId() {
      return workspaceId;
    }

    public void setWorkspaceId(java.lang.String v) {
      this.workspaceId = v;
    }

    @Override
    public boolean equals(Object o) {
      if (!(o instanceof WorkspaceStatusEventImpl)) {
        return false;
      }
      WorkspaceStatusEventImpl other = (WorkspaceStatusEventImpl) o;
      if (this.error != null) {
        if (!this.error.equals(other.error)) {
          return false;
        }
      } else {
        if (other.error != null) {
          return false;
        }
      }
      if (this.eventType != null) {
        if (!this.eventType.equals(other.eventType)) {
          return false;
        }
      } else {
        if (other.eventType != null) {
          return false;
        }
      }
      if (this.workspaceId != null) {
        if (!this.workspaceId.equals(other.workspaceId)) {
          return false;
        }
      } else {
        if (other.workspaceId != null) {
          return false;
        }
      }
      return true;
    }

    @Override
    public int hashCode() {
      int hash = 7;
      hash = hash * 31 + (error != null ? error.hashCode() : 0);
      hash = hash * 31 + (eventType != null ? eventType.hashCode() : 0);
      hash = hash * 31 + (workspaceId != null ? workspaceId.hashCode() : 0);
      return hash;
    }

    @Override
    public JsonElement toJsonElement() {
      return toJsonElementInt(true);
    }
    public JsonElement toJsonElementInt(boolean copyJsons) {
      JsonObject result = new JsonObject();

      JsonElement errorOut = (this.error == null) ? JsonNull.INSTANCE : new JsonPrimitive(this.error);
      result.add("error", errorOut);

      JsonElement eventTypeOut = (this.eventType == null) ? JsonNull.INSTANCE : new JsonPrimitive(this.eventType.name());
      result.add("eventType", eventTypeOut);

      JsonElement workspaceIdOut = (this.workspaceId == null) ? JsonNull.INSTANCE : new JsonPrimitive(this.workspaceId);
      result.add("workspaceId", workspaceIdOut);
      return result;
    }

    @Override
    public String toJson() {
      return gson.toJson(toJsonElementInt(false));
    }

    @Override
    public String toString() {
      return toJson();
    }

    public static WorkspaceStatusEventImpl fromJsonElement(JsonElement jsonElem) {
      return fromJsonElement(jsonElem, true);
    }
    public static WorkspaceStatusEventImpl fromJsonElement(JsonElement jsonElem, boolean copyJsons) {
      if (jsonElem == null || jsonElem.isJsonNull()) {
        return null;
      }

      WorkspaceStatusEventImpl dto = new WorkspaceStatusEventImpl();
      JsonObject json = jsonElem.getAsJsonObject();

      if (json.has("error")) {
        JsonElement errorIn = json.get("error");
        java.lang.String errorOut = gson.fromJson(errorIn, java.lang.String.class);
        dto.setError(errorOut);
      }

      if (json.has("eventType")) {
        JsonElement eventTypeIn = json.get("eventType");
        org.eclipse.che.api.workspace.shared.dto.event.WorkspaceStatusEvent.EventType eventTypeOut = gson.fromJson(eventTypeIn, org.eclipse.che.api.workspace.shared.dto.event.WorkspaceStatusEvent.EventType.class);
        dto.setEventType(eventTypeOut);
      }

      if (json.has("workspaceId")) {
        JsonElement workspaceIdIn = json.get("workspaceId");
        java.lang.String workspaceIdOut = gson.fromJson(workspaceIdIn, java.lang.String.class);
        dto.setWorkspaceId(workspaceIdOut);
      }

      return dto;
    }

    public static WorkspaceStatusEventImpl fromJsonString(String jsonString) {
      if (jsonString == null) {
        return null;
      }

      return fromJsonElement(new JsonParser().parse(jsonString), false);
    }

    public WorkspaceStatusEventImpl(org.eclipse.che.api.workspace.shared.dto.event.WorkspaceStatusEvent origin) {
      this.error = origin.getError();
      this.eventType = origin.getEventType();
      this.workspaceId = origin.getWorkspaceId();
    }

    public org.eclipse.che.api.workspace.shared.dto.event.WorkspaceStatusEvent withError(java.lang.String v) {
      this.error = v;
      return this;
    }

    public org.eclipse.che.api.workspace.shared.dto.event.WorkspaceStatusEvent withEventType(org.eclipse.che.api.workspace.shared.dto.event.WorkspaceStatusEvent.EventType v) {
      this.eventType = v;
      return this;
    }

    public org.eclipse.che.api.workspace.shared.dto.event.WorkspaceStatusEvent withWorkspaceId(java.lang.String v) {
      this.workspaceId = v;
      return this;
    }

  }

  @org.eclipse.che.dto.shared.DTOImpl("server")
  public static class StackComponentDtoImpl implements org.eclipse.che.api.workspace.shared.dto.stack.StackComponentDto, JsonSerializable  {

    public static StackComponentDtoImpl make() {
        return new StackComponentDtoImpl();
    }

    public StackComponentDtoImpl() {
    }

    protected java.lang.String version;
    protected java.lang.String name;

    @Override
    public java.lang.String getVersion() {
      return version;
    }

    public void setVersion(java.lang.String v) {
      this.version = v;
    }

    @Override
    public java.lang.String getName() {
      return name;
    }

    public void setName(java.lang.String v) {
      this.name = v;
    }

    @Override
    public boolean equals(Object o) {
      if (!(o instanceof StackComponentDtoImpl)) {
        return false;
      }
      StackComponentDtoImpl other = (StackComponentDtoImpl) o;
      if (this.version != null) {
        if (!this.version.equals(other.version)) {
          return false;
        }
      } else {
        if (other.version != null) {
          return false;
        }
      }
      if (this.name != null) {
        if (!this.name.equals(other.name)) {
          return false;
        }
      } else {
        if (other.name != null) {
          return false;
        }
      }
      return true;
    }

    @Override
    public int hashCode() {
      int hash = 7;
      hash = hash * 31 + (version != null ? version.hashCode() : 0);
      hash = hash * 31 + (name != null ? name.hashCode() : 0);
      return hash;
    }

    @Override
    public JsonElement toJsonElement() {
      return toJsonElementInt(true);
    }
    public JsonElement toJsonElementInt(boolean copyJsons) {
      JsonObject result = new JsonObject();

      JsonElement versionOut = (this.version == null) ? JsonNull.INSTANCE : new JsonPrimitive(this.version);
      result.add("version", versionOut);

      JsonElement nameOut = (this.name == null) ? JsonNull.INSTANCE : new JsonPrimitive(this.name);
      result.add("name", nameOut);
      return result;
    }

    @Override
    public String toJson() {
      return gson.toJson(toJsonElementInt(false));
    }

    @Override
    public String toString() {
      return toJson();
    }

    public static StackComponentDtoImpl fromJsonElement(JsonElement jsonElem) {
      return fromJsonElement(jsonElem, true);
    }
    public static StackComponentDtoImpl fromJsonElement(JsonElement jsonElem, boolean copyJsons) {
      if (jsonElem == null || jsonElem.isJsonNull()) {
        return null;
      }

      StackComponentDtoImpl dto = new StackComponentDtoImpl();
      JsonObject json = jsonElem.getAsJsonObject();

      if (json.has("version")) {
        JsonElement versionIn = json.get("version");
        java.lang.String versionOut = gson.fromJson(versionIn, java.lang.String.class);
        dto.setVersion(versionOut);
      }

      if (json.has("name")) {
        JsonElement nameIn = json.get("name");
        java.lang.String nameOut = gson.fromJson(nameIn, java.lang.String.class);
        dto.setName(nameOut);
      }

      return dto;
    }

    public static StackComponentDtoImpl fromJsonString(String jsonString) {
      if (jsonString == null) {
        return null;
      }

      return fromJsonElement(new JsonParser().parse(jsonString), false);
    }

    public StackComponentDtoImpl(org.eclipse.che.api.workspace.shared.dto.stack.StackComponentDto origin) {
      this.version = origin.getVersion();
      this.name = origin.getName();
    }

    public org.eclipse.che.api.workspace.shared.dto.stack.StackComponentDto withVersion(java.lang.String v) {
      this.version = v;
      return this;
    }

    public org.eclipse.che.api.workspace.shared.dto.stack.StackComponentDto withName(java.lang.String v) {
      this.name = v;
      return this;
    }

  }

  @org.eclipse.che.dto.shared.DTOImpl("server")
  public static class StackDtoImpl extends org.eclipse.che.api.core.server.dto.DtoServerImpls.HyperlinksImpl implements org.eclipse.che.api.workspace.shared.dto.stack.StackDto, JsonSerializable  {

    public static StackDtoImpl make() {
        return new StackDtoImpl();
    }

    public StackDtoImpl() {
    }

    protected java.lang.String name;
    protected org.eclipse.che.api.workspace.shared.dto.stack.StackSourceDto source;
    protected java.util.List<org.eclipse.che.api.workspace.shared.dto.stack.StackComponentDto> components;
    protected java.util.List<java.lang.String> tags;
    protected java.lang.String id;
    protected org.eclipse.che.api.workspace.shared.dto.WorkspaceConfigDto workspaceConfig;
    protected java.lang.String description;
    protected java.lang.String creator;
    protected java.lang.String scope;

    @Override
    public java.lang.String getName() {
      return name;
    }

    public void setName(java.lang.String v) {
      this.name = v;
    }

    @Override
    public org.eclipse.che.api.workspace.shared.dto.stack.StackSourceDto getSource() {
      return source;
    }

    public void setSource(org.eclipse.che.api.workspace.shared.dto.stack.StackSourceDto v) {
      this.source = v;
    }

    @Override
    public java.util.List<org.eclipse.che.api.workspace.shared.dto.stack.StackComponentDto> getComponents() {
      ensureComponents();
      return new org.eclipse.che.dto.server.JsonArrayImpl(components);
    }

    public void setComponents(java.util.List<org.eclipse.che.api.workspace.shared.dto.stack.StackComponentDto> v) {
      this.components = v;
    }

    public void addComponents(org.eclipse.che.api.workspace.shared.dto.stack.StackComponentDto v) {
      ensureComponents();
      components.add(v);
    }

    public void clearComponents() {
      ensureComponents();
      components.clear();
    }

    protected void ensureComponents() {
      if (components == null) {
        components = new java.util.ArrayList<org.eclipse.che.api.workspace.shared.dto.stack.StackComponentDto>();
      }
    }
    @Override
    public java.util.List<java.lang.String> getTags() {
      ensureTags();
      return new org.eclipse.che.dto.server.JsonArrayImpl(tags);
    }

    public void setTags(java.util.List<java.lang.String> v) {
      this.tags = v;
    }

    public void addTags(java.lang.String v) {
      ensureTags();
      tags.add(v);
    }

    public void clearTags() {
      ensureTags();
      tags.clear();
    }

    protected void ensureTags() {
      if (tags == null) {
        tags = new java.util.ArrayList<java.lang.String>();
      }
    }
    @Override
    public java.lang.String getId() {
      return id;
    }

    public void setId(java.lang.String v) {
      this.id = v;
    }

    @Override
    public org.eclipse.che.api.workspace.shared.dto.WorkspaceConfigDto getWorkspaceConfig() {
      return workspaceConfig;
    }

    public void setWorkspaceConfig(org.eclipse.che.api.workspace.shared.dto.WorkspaceConfigDto v) {
      this.workspaceConfig = v;
    }

    @org.eclipse.che.commons.annotation.Nullable
    @Override
    public java.lang.String getDescription() {
      return description;
    }

    public void setDescription(java.lang.String v) {
      this.description = v;
    }

    @Override
    public java.lang.String getCreator() {
      return creator;
    }

    public void setCreator(java.lang.String v) {
      this.creator = v;
    }

    @Override
    public java.lang.String getScope() {
      return scope;
    }

    public void setScope(java.lang.String v) {
      this.scope = v;
    }

    @Override
    public boolean equals(Object o) {
      if (!(o instanceof StackDtoImpl)) {
        return false;
      }
      StackDtoImpl other = (StackDtoImpl) o;
      if (this.name != null) {
        if (!this.name.equals(other.name)) {
          return false;
        }
      } else {
        if (other.name != null) {
          return false;
        }
      }
      if (this.source != null) {
        if (!this.source.equals(other.source)) {
          return false;
        }
      } else {
        if (other.source != null) {
          return false;
        }
      }
      this.ensureComponents();
      other.ensureComponents();
      
      if (this.components != null) {
        if (!this.components.equals(other.components)) {
          return false;
        }
      } else {
        if (other.components != null) {
          return false;
        }
      }
      this.ensureTags();
      other.ensureTags();
      
      if (this.tags != null) {
        if (!this.tags.equals(other.tags)) {
          return false;
        }
      } else {
        if (other.tags != null) {
          return false;
        }
      }
      if (this.id != null) {
        if (!this.id.equals(other.id)) {
          return false;
        }
      } else {
        if (other.id != null) {
          return false;
        }
      }
      if (this.workspaceConfig != null) {
        if (!this.workspaceConfig.equals(other.workspaceConfig)) {
          return false;
        }
      } else {
        if (other.workspaceConfig != null) {
          return false;
        }
      }
      if (this.description != null) {
        if (!this.description.equals(other.description)) {
          return false;
        }
      } else {
        if (other.description != null) {
          return false;
        }
      }
      if (this.creator != null) {
        if (!this.creator.equals(other.creator)) {
          return false;
        }
      } else {
        if (other.creator != null) {
          return false;
        }
      }
      if (this.scope != null) {
        if (!this.scope.equals(other.scope)) {
          return false;
        }
      } else {
        if (other.scope != null) {
          return false;
        }
      }
      this.ensureLinks();
      other.ensureLinks();
      
      if (this.links != null) {
        if (!this.links.equals(other.links)) {
          return false;
        }
      } else {
        if (other.links != null) {
          return false;
        }
      }
      return true;
    }

    @Override
    public int hashCode() {
      int hash = 7;
      hash = hash * 31 + (name != null ? name.hashCode() : 0);
      hash = hash * 31 + (source != null ? source.hashCode() : 0);
      ensureComponents();
      hash = hash * 31 + (components != null ? components.hashCode() : 0);
      ensureTags();
      hash = hash * 31 + (tags != null ? tags.hashCode() : 0);
      hash = hash * 31 + (id != null ? id.hashCode() : 0);
      hash = hash * 31 + (workspaceConfig != null ? workspaceConfig.hashCode() : 0);
      hash = hash * 31 + (description != null ? description.hashCode() : 0);
      hash = hash * 31 + (creator != null ? creator.hashCode() : 0);
      hash = hash * 31 + (scope != null ? scope.hashCode() : 0);
      ensureLinks();
      hash = hash * 31 + (links != null ? links.hashCode() : 0);
      return hash;
    }

    @Override
    public JsonElement toJsonElement() {
      return toJsonElementInt(true);
    }
    public JsonElement toJsonElementInt(boolean copyJsons) {
      JsonObject result = new JsonObject();

      JsonElement nameOut = (this.name == null) ? JsonNull.INSTANCE : new JsonPrimitive(this.name);
      result.add("name", nameOut);

      JsonElement sourceOut = this.source == null ? JsonNull.INSTANCE : ((StackSourceDtoImpl)this.source).toJsonElementInt(copyJsons);
      result.add("source", sourceOut);

      JsonArray componentsOut = new JsonArray();
      this.ensureComponents();
      for (org.eclipse.che.api.workspace.shared.dto.stack.StackComponentDto components_ : this.components) {
        JsonElement componentsOut_ = components_ == null ? JsonNull.INSTANCE : ((StackComponentDtoImpl)components_).toJsonElementInt(copyJsons);
        componentsOut.add(componentsOut_);
      }
      result.add("components", componentsOut);

      JsonArray tagsOut = new JsonArray();
      this.ensureTags();
      for (java.lang.String tags_ : this.tags) {
        JsonElement tagsOut_ = (tags_ == null) ? JsonNull.INSTANCE : new JsonPrimitive(tags_);
        tagsOut.add(tagsOut_);
      }
      result.add("tags", tagsOut);

      JsonElement idOut = (this.id == null) ? JsonNull.INSTANCE : new JsonPrimitive(this.id);
      result.add("id", idOut);

      JsonElement workspaceConfigOut = this.workspaceConfig == null ? JsonNull.INSTANCE : ((WorkspaceConfigDtoImpl)this.workspaceConfig).toJsonElementInt(copyJsons);
      result.add("workspaceConfig", workspaceConfigOut);

      JsonElement descriptionOut = (this.description == null) ? JsonNull.INSTANCE : new JsonPrimitive(this.description);
      result.add("description", descriptionOut);

      JsonElement creatorOut = (this.creator == null) ? JsonNull.INSTANCE : new JsonPrimitive(this.creator);
      result.add("creator", creatorOut);

      JsonElement scopeOut = (this.scope == null) ? JsonNull.INSTANCE : new JsonPrimitive(this.scope);
      result.add("scope", scopeOut);

      JsonArray linksOut = new JsonArray();
      this.ensureLinks();
      for (org.eclipse.che.api.core.rest.shared.dto.Link links_ : this.links) {
        JsonElement linksOut_ = links_ == null ? JsonNull.INSTANCE : ((org.eclipse.che.api.core.server.dto.DtoServerImpls.LinkImpl)links_).toJsonElementInt(copyJsons);
        linksOut.add(linksOut_);
      }
      result.add("links", linksOut);
      return result;
    }

    @Override
    public String toJson() {
      return gson.toJson(toJsonElementInt(false));
    }

    @Override
    public String toString() {
      return toJson();
    }

    public static StackDtoImpl fromJsonElement(JsonElement jsonElem) {
      return fromJsonElement(jsonElem, true);
    }
    public static StackDtoImpl fromJsonElement(JsonElement jsonElem, boolean copyJsons) {
      if (jsonElem == null || jsonElem.isJsonNull()) {
        return null;
      }

      StackDtoImpl dto = new StackDtoImpl();
      JsonObject json = jsonElem.getAsJsonObject();

      if (json.has("name")) {
        JsonElement nameIn = json.get("name");
        java.lang.String nameOut = gson.fromJson(nameIn, java.lang.String.class);
        dto.setName(nameOut);
      }

      if (json.has("source")) {
        JsonElement sourceIn = json.get("source");
        org.eclipse.che.api.workspace.shared.dto.stack.StackSourceDto sourceOut = StackSourceDtoImpl.fromJsonElement(sourceIn, copyJsons);
        dto.setSource(sourceOut);
      }

      if (json.has("components")) {
        JsonElement componentsIn = json.get("components");
        java.util.List<org.eclipse.che.api.workspace.shared.dto.stack.StackComponentDto> componentsOut = null;
        if (componentsIn != null && !componentsIn.isJsonNull()) {
          componentsOut = new java.util.ArrayList<org.eclipse.che.api.workspace.shared.dto.stack.StackComponentDto>();
          java.util.Iterator<JsonElement> componentsInIterator = componentsIn.getAsJsonArray().iterator();
          while (componentsInIterator.hasNext()) {
            JsonElement componentsIn_ = componentsInIterator.next();
            org.eclipse.che.api.workspace.shared.dto.stack.StackComponentDto componentsOut_ = StackComponentDtoImpl.fromJsonElement(componentsIn_, copyJsons);
            componentsOut.add(componentsOut_);
          }
        }
        dto.setComponents(componentsOut);
      }

      if (json.has("tags")) {
        JsonElement tagsIn = json.get("tags");
        java.util.List<java.lang.String> tagsOut = null;
        if (tagsIn != null && !tagsIn.isJsonNull()) {
          tagsOut = new java.util.ArrayList<java.lang.String>();
          java.util.Iterator<JsonElement> tagsInIterator = tagsIn.getAsJsonArray().iterator();
          while (tagsInIterator.hasNext()) {
            JsonElement tagsIn_ = tagsInIterator.next();
            java.lang.String tagsOut_ = gson.fromJson(tagsIn_, java.lang.String.class);
            tagsOut.add(tagsOut_);
          }
        }
        dto.setTags(tagsOut);
      }

      if (json.has("id")) {
        JsonElement idIn = json.get("id");
        java.lang.String idOut = gson.fromJson(idIn, java.lang.String.class);
        dto.setId(idOut);
      }

      if (json.has("workspaceConfig")) {
        JsonElement workspaceConfigIn = json.get("workspaceConfig");
        org.eclipse.che.api.workspace.shared.dto.WorkspaceConfigDto workspaceConfigOut = WorkspaceConfigDtoImpl.fromJsonElement(workspaceConfigIn, copyJsons);
        dto.setWorkspaceConfig(workspaceConfigOut);
      }

      if (json.has("description")) {
        JsonElement descriptionIn = json.get("description");
        java.lang.String descriptionOut = gson.fromJson(descriptionIn, java.lang.String.class);
        dto.setDescription(descriptionOut);
      }

      if (json.has("creator")) {
        JsonElement creatorIn = json.get("creator");
        java.lang.String creatorOut = gson.fromJson(creatorIn, java.lang.String.class);
        dto.setCreator(creatorOut);
      }

      if (json.has("scope")) {
        JsonElement scopeIn = json.get("scope");
        java.lang.String scopeOut = gson.fromJson(scopeIn, java.lang.String.class);
        dto.setScope(scopeOut);
      }

      if (json.has("links")) {
        JsonElement linksIn = json.get("links");
        java.util.List<org.eclipse.che.api.core.rest.shared.dto.Link> linksOut = null;
        if (linksIn != null && !linksIn.isJsonNull()) {
          linksOut = new java.util.ArrayList<org.eclipse.che.api.core.rest.shared.dto.Link>();
          java.util.Iterator<JsonElement> linksInIterator = linksIn.getAsJsonArray().iterator();
          while (linksInIterator.hasNext()) {
            JsonElement linksIn_ = linksInIterator.next();
            org.eclipse.che.api.core.rest.shared.dto.Link linksOut_ = org.eclipse.che.api.core.server.dto.DtoServerImpls.LinkImpl.fromJsonElement(linksIn_, copyJsons);
            linksOut.add(linksOut_);
          }
        }
        dto.setLinks(linksOut);
      }

      return dto;
    }

    public static StackDtoImpl fromJsonString(String jsonString) {
      if (jsonString == null) {
        return null;
      }

      return fromJsonElement(new JsonParser().parse(jsonString), false);
    }

    public StackDtoImpl(org.eclipse.che.api.workspace.shared.dto.stack.StackDto origin) {
      this.name = origin.getName();
      org.eclipse.che.api.workspace.shared.dto.stack.StackSourceDto sourceIn = origin.getSource();
      this.source = sourceIn == null ? null : new StackSourceDtoImpl(sourceIn);
      java.util.List<org.eclipse.che.api.workspace.shared.dto.stack.StackComponentDto> componentsIn = origin.getComponents();
      if (componentsIn != null) {
        java.util.List<org.eclipse.che.api.workspace.shared.dto.stack.StackComponentDto> componentsOut = new java.util.ArrayList<org.eclipse.che.api.workspace.shared.dto.stack.StackComponentDto>();
        for (org.eclipse.che.api.workspace.shared.dto.stack.StackComponentDto componentsIn_ : componentsIn) {
            componentsOut.add(componentsIn_ == null ? null : new StackComponentDtoImpl(componentsIn_));
        }
        this.components = componentsOut;
      }
      java.util.List<java.lang.String> tagsIn = origin.getTags();
      if (tagsIn != null) {
        java.util.List<java.lang.String> tagsOut = new java.util.ArrayList<java.lang.String>();
        for (java.lang.String tagsIn_ : tagsIn) {
            tagsOut.add(tagsIn_);
        }
        this.tags = tagsOut;
      }
      this.id = origin.getId();
      org.eclipse.che.api.workspace.shared.dto.WorkspaceConfigDto workspaceConfigIn = origin.getWorkspaceConfig();
      this.workspaceConfig = workspaceConfigIn == null ? null : new WorkspaceConfigDtoImpl(workspaceConfigIn);
      this.description = origin.getDescription();
      this.creator = origin.getCreator();
      this.scope = origin.getScope();
      java.util.List<org.eclipse.che.api.core.rest.shared.dto.Link> linksIn = origin.getLinks();
      if (linksIn != null) {
        java.util.List<org.eclipse.che.api.core.rest.shared.dto.Link> linksOut = new java.util.ArrayList<org.eclipse.che.api.core.rest.shared.dto.Link>();
        for (org.eclipse.che.api.core.rest.shared.dto.Link linksIn_ : linksIn) {
            linksOut.add(linksIn_);
        }
        this.links = linksOut;
      }
    }

    public org.eclipse.che.api.workspace.shared.dto.stack.StackDto withName(java.lang.String v) {
      this.name = v;
      return this;
    }

    public org.eclipse.che.api.workspace.shared.dto.stack.StackDto withSource(org.eclipse.che.api.workspace.shared.dto.stack.StackSourceDto v) {
      this.source = v;
      return this;
    }

    public org.eclipse.che.api.workspace.shared.dto.stack.StackDto withComponents(java.util.List<org.eclipse.che.api.workspace.shared.dto.stack.StackComponentDto> v) {
      this.components = v;
      return this;
    }

    public org.eclipse.che.api.workspace.shared.dto.stack.StackDto withTags(java.util.List<java.lang.String> v) {
      this.tags = v;
      return this;
    }

    public org.eclipse.che.api.workspace.shared.dto.stack.StackDto withId(java.lang.String v) {
      this.id = v;
      return this;
    }

    public org.eclipse.che.api.workspace.shared.dto.stack.StackDto withWorkspaceConfig(org.eclipse.che.api.workspace.shared.dto.WorkspaceConfigDto v) {
      this.workspaceConfig = v;
      return this;
    }

    public org.eclipse.che.api.workspace.shared.dto.stack.StackDto withDescription(java.lang.String v) {
      this.description = v;
      return this;
    }

    public org.eclipse.che.api.workspace.shared.dto.stack.StackDto withCreator(java.lang.String v) {
      this.creator = v;
      return this;
    }

    public org.eclipse.che.api.workspace.shared.dto.stack.StackDto withScope(java.lang.String v) {
      this.scope = v;
      return this;
    }

    public org.eclipse.che.api.workspace.shared.dto.stack.StackDto withLinks(java.util.List<org.eclipse.che.api.core.rest.shared.dto.Link> v) {
      this.links = v;
      return this;
    }

  }

  @org.eclipse.che.dto.shared.DTOImpl("server")
  public static class StackSourceDtoImpl implements org.eclipse.che.api.workspace.shared.dto.stack.StackSourceDto, JsonSerializable  {

    public static StackSourceDtoImpl make() {
        return new StackSourceDtoImpl();
    }

    public StackSourceDtoImpl() {
    }

    protected java.lang.String origin;
    protected java.lang.String type;

    @Override
    public java.lang.String getOrigin() {
      return origin;
    }

    public void setOrigin(java.lang.String v) {
      this.origin = v;
    }

    @Override
    public java.lang.String getType() {
      return type;
    }

    public void setType(java.lang.String v) {
      this.type = v;
    }

    @Override
    public boolean equals(Object o) {
      if (!(o instanceof StackSourceDtoImpl)) {
        return false;
      }
      StackSourceDtoImpl other = (StackSourceDtoImpl) o;
      if (this.origin != null) {
        if (!this.origin.equals(other.origin)) {
          return false;
        }
      } else {
        if (other.origin != null) {
          return false;
        }
      }
      if (this.type != null) {
        if (!this.type.equals(other.type)) {
          return false;
        }
      } else {
        if (other.type != null) {
          return false;
        }
      }
      return true;
    }

    @Override
    public int hashCode() {
      int hash = 7;
      hash = hash * 31 + (origin != null ? origin.hashCode() : 0);
      hash = hash * 31 + (type != null ? type.hashCode() : 0);
      return hash;
    }

    @Override
    public JsonElement toJsonElement() {
      return toJsonElementInt(true);
    }
    public JsonElement toJsonElementInt(boolean copyJsons) {
      JsonObject result = new JsonObject();

      JsonElement originOut = (this.origin == null) ? JsonNull.INSTANCE : new JsonPrimitive(this.origin);
      result.add("origin", originOut);

      JsonElement typeOut = (this.type == null) ? JsonNull.INSTANCE : new JsonPrimitive(this.type);
      result.add("type", typeOut);
      return result;
    }

    @Override
    public String toJson() {
      return gson.toJson(toJsonElementInt(false));
    }

    @Override
    public String toString() {
      return toJson();
    }

    public static StackSourceDtoImpl fromJsonElement(JsonElement jsonElem) {
      return fromJsonElement(jsonElem, true);
    }
    public static StackSourceDtoImpl fromJsonElement(JsonElement jsonElem, boolean copyJsons) {
      if (jsonElem == null || jsonElem.isJsonNull()) {
        return null;
      }

      StackSourceDtoImpl dto = new StackSourceDtoImpl();
      JsonObject json = jsonElem.getAsJsonObject();

      if (json.has("origin")) {
        JsonElement originIn = json.get("origin");
        java.lang.String originOut = gson.fromJson(originIn, java.lang.String.class);
        dto.setOrigin(originOut);
      }

      if (json.has("type")) {
        JsonElement typeIn = json.get("type");
        java.lang.String typeOut = gson.fromJson(typeIn, java.lang.String.class);
        dto.setType(typeOut);
      }

      return dto;
    }

    public static StackSourceDtoImpl fromJsonString(String jsonString) {
      if (jsonString == null) {
        return null;
      }

      return fromJsonElement(new JsonParser().parse(jsonString), false);
    }

    public StackSourceDtoImpl(org.eclipse.che.api.workspace.shared.dto.stack.StackSourceDto origin) {
      this.origin = origin.getOrigin();
      this.type = origin.getType();
    }

    public org.eclipse.che.api.workspace.shared.dto.stack.StackSourceDto withOrigin(java.lang.String v) {
      this.origin = v;
      return this;
    }

    public org.eclipse.che.api.workspace.shared.dto.stack.StackSourceDto withType(java.lang.String v) {
      this.type = v;
      return this;
    }

  }


}