/*******************************************************************************
 * Copyright (c) 2012-2016 Codenvy, S.A.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *   Codenvy, S.A. - initial API and implementation
 *******************************************************************************/
package org.eclipse.che.api.agent.server.launcher;

import org.eclipse.che.api.agent.shared.model.Agent;
import org.eclipse.che.api.machine.server.exception.MachineException;
import org.eclipse.che.api.machine.server.spi.Instance;
import org.eclipse.che.api.machine.server.spi.InstanceProcess;

/**
 * Indicates if agent finished working.
 *
 * @author Anatoliy Bazko
 */
@FunctionalInterface
public interface AgentLaunchingChecker {

    /**
     * Indicates if agent finished working.
     *
     * @param agent
     *      the agent is being launched
     * @param process
     *      the process is generated by launching the target agent
     * @param machine
     *      the machine instance
     * @throws MachineException
     *      if unexpected error is occurred
     */
    boolean isLaunched(Agent agent, InstanceProcess process, Instance machine) throws MachineException;

    AgentLaunchingChecker DEFAULT = (agent, process, machine) -> !process.isAlive();
}
